/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.core;

import java.awt.Font;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.diylc.appframework.update.VersionNumber;
import org.diylc.core.IDIYComponent;
import org.diylc.core.ValidationException;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.annotations.MultiLineText;
import org.diylc.core.annotations.PositiveMeasureValidator;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;

public class Project
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static String DEFAULT_TITLE = "New Project";
    public static Size DEFAULT_WIDTH = new Size((Double)29.0, SizeUnit.cm);
    public static Size DEFAULT_HEIGHT = new Size((Double)21.0, SizeUnit.cm);
    public static Size DEFAULT_GRID_SPACING = new Size((Double)0.1, SizeUnit.in);
    public static Font DEFAULT_FONT = new Font("Square721 BT", 0, 14);
    private VersionNumber fileVersion;
    private String title;
    private String author;
    private String description;
    private Size width;
    private Size height;
    private Size gridSpacing;
    private List<IDIYComponent<?>> components;
    private Set<Set<IDIYComponent<?>>> groups;
    private Set<Integer> lockedLayers;
    private Set<Integer> hiddenLayers;
    private Font font = DEFAULT_FONT;

    public Project() {
        this.components = new ArrayList();
        this.groups = new HashSet();
        this.lockedLayers = new HashSet<Integer>();
        this.hiddenLayers = new HashSet<Integer>();
        this.title = DEFAULT_TITLE;
        this.author = System.getProperty("user.name");
        this.width = DEFAULT_WIDTH;
        this.height = DEFAULT_HEIGHT;
        this.gridSpacing = DEFAULT_GRID_SPACING;
    }

    @EditableProperty(defaultable=false, sortOrder=1)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    @EditableProperty(sortOrder=3)
    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String string) {
        this.author = string;
    }

    @MultiLineText
    @EditableProperty(defaultable=false, sortOrder=2)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    @EditableProperty(sortOrder=4)
    public Size getWidth() {
        return this.width;
    }

    public void setWidth(Size size) {
        this.width = size;
    }

    @EditableProperty(sortOrder=5)
    public Size getHeight() {
        return this.height;
    }

    public void setHeight(Size size) {
        this.height = size;
    }

    @EditableProperty(name="Grid Spacing", validatorClass=SpacingValidator.class, sortOrder=6)
    public Size getGridSpacing() {
        return this.gridSpacing;
    }

    public void setGridSpacing(Size size) {
        this.gridSpacing = size;
    }

    public List<IDIYComponent<?>> getComponents() {
        return this.components;
    }

    public Set<Set<IDIYComponent<?>>> getGroups() {
        return this.groups;
    }

    public Set<Integer> getLockedLayers() {
        return this.lockedLayers;
    }

    public Set<Integer> getHiddenLayers() {
        if (this.hiddenLayers == null) {
            this.hiddenLayers = new HashSet<Integer>();
        }
        return this.hiddenLayers;
    }

    public VersionNumber getFileVersion() {
        return this.fileVersion;
    }

    public void setFileVersion(VersionNumber versionNumber) {
        this.fileVersion = versionNumber;
    }

    @EditableProperty(name="Default Font")
    public Font getFont() {
        if (this.font == null) {
            this.font = DEFAULT_FONT;
        }
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    @EditableProperty(name="Default Font Size")
    public int getFontSize() {
        if (this.font == null) {
            this.font = DEFAULT_FONT;
        }
        return this.font.getSize();
    }

    public void setFontSize(int n) {
        this.font = this.font.deriveFont((float)n);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.author == null ? 0 : this.author.hashCode());
        n = 31 * n + (this.components == null ? 0 : ((Object)this.components).hashCode());
        n = 31 * n + (this.description == null ? 0 : this.description.hashCode());
        n = 31 * n + (this.height == null ? 0 : this.height.hashCode());
        n = 31 * n + (this.title == null ? 0 : this.title.hashCode());
        n = 31 * n + (this.width == null ? 0 : this.width.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Project project = (Project)object;
        if (this.author == null ? project.author != null : !this.author.equals(project.author)) {
            return false;
        }
        if (this.components == null) {
            if (project.components != null) {
                return false;
            }
        } else {
            if (this.components.size() != project.components.size()) {
                return false;
            }
            Iterator<IDIYComponent<?>> iterator = this.components.iterator();
            Iterator<IDIYComponent<?>> iterator2 = project.components.iterator();
            while (iterator.hasNext()) {
                IDIYComponent<?> iDIYComponent;
                IDIYComponent<?> iDIYComponent2 = iterator.next();
                if (iDIYComponent2.equalsTo(iDIYComponent = iterator2.next())) continue;
                return false;
            }
        }
        if (this.description == null ? project.description != null : !this.description.equals(project.description)) {
            return false;
        }
        if (this.height == null ? project.height != null : !this.height.equals(project.height)) {
            return false;
        }
        if (this.title == null ? project.title != null : !this.title.equals(project.title)) {
            return false;
        }
        if (this.width == null ? project.width != null : !this.width.equals(project.width)) {
            return false;
        }
        if (this.gridSpacing == null ? project.gridSpacing != null : !this.gridSpacing.equals(project.gridSpacing)) {
            return false;
        }
        if (this.font == null ? project.font != null : !this.font.equals(project.font)) {
            return false;
        }
        if (this.groups == null ? project.groups != null : !((Object)this.groups).equals(project.groups)) {
            return false;
        }
        if (this.lockedLayers == null ? project.lockedLayers != null : !((Object)this.lockedLayers).equals(project.lockedLayers)) {
            return false;
        }
        return !(this.hiddenLayers == null ? project.hiddenLayers != null : !((Object)this.hiddenLayers).equals(project.hiddenLayers));
    }

    public String toString() {
        return this.title;
    }

    public Project clone() {
        Serializable serializable;
        Project project = new Project();
        project.setTitle(this.getTitle());
        project.setAuthor(this.getAuthor());
        project.setDescription(this.getDescription());
        project.setFileVersion(this.getFileVersion());
        project.setGridSpacing(this.getGridSpacing());
        project.setHeight(this.getHeight());
        project.setWidth(this.getWidth());
        project.getLockedLayers().addAll(this.getLockedLayers());
        project.getHiddenLayers().addAll(this.getHiddenLayers());
        project.setFont(this.getFont());
        HashMap hashMap = new HashMap();
        for (IDIYComponent<?> object : this.components) {
            try {
                serializable = object.clone();
                project.getComponents().add((IDIYComponent<?>)serializable);
                hashMap.put(object, serializable);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new RuntimeException(cloneNotSupportedException);
            }
        }
        for (Set set : this.groups) {
            serializable = new HashSet();
            for (IDIYComponent iDIYComponent : set) {
                serializable.add(hashMap.get(iDIYComponent));
            }
            project.groups.add((Set<IDIYComponent<?>>)((Object)serializable));
        }
        return project;
    }

    public static class SpacingValidator
    extends PositiveMeasureValidator {
        @Override
        public void validate(Object object) throws ValidationException {
            super.validate(object);
            Size size = (Size)object;
            if (size.compareTo(new Size((Double)0.1, SizeUnit.mm)) < 0) {
                throw new ValidationException("must be at least 0.1mm");
            }
            if (size.compareTo(new Size((Double)1.0, SizeUnit.in)) > 0) {
                throw new ValidationException("must be less than 1in");
            }
        }
    }
}

