/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.core.measures;

import org.diylc.core.measures.AbstractMeasure;
import org.diylc.core.measures.SizeUnit;

public class Size
extends AbstractMeasure<SizeUnit>
implements Comparable<Size> {
    private static final long serialVersionUID = 1L;

    public Size(Double d, SizeUnit sizeUnit) {
        super(d, sizeUnit);
    }

    public double convertToPixels() {
        return this.getValue() * ((SizeUnit)this.getUnit()).getFactor() / SizeUnit.in.getFactor() * 200.0;
    }

    public Size clone() throws CloneNotSupportedException {
        return new Size(this.value, (SizeUnit)this.unit);
    }

    public static Size parseSize(String string) {
        string = string.replace("*", "");
        for (SizeUnit sizeUnit : SizeUnit.values()) {
            if (!string.toLowerCase().endsWith(sizeUnit.toString().toLowerCase())) continue;
            string = string.substring(0, string.length() - sizeUnit.toString().length()).trim();
            return new Size((Double)Size.parse(string), sizeUnit);
        }
        throw new IllegalArgumentException("Could not parse size: " + string);
    }

    @Override
    public int compareTo(Size size) {
        return new Double(this.value * ((SizeUnit)this.unit).getFactor()).compareTo(size.getValue() * ((SizeUnit)size.getUnit()).getFactor());
    }
}

