/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.presenter;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import org.diylc.common.ComponentType;
import org.diylc.common.IComponentTransformer;
import org.diylc.common.PropertyWrapper;
import org.diylc.core.CreationMethod;
import org.diylc.core.IDIYComponent;
import org.diylc.core.IPropertyValidator;
import org.diylc.core.annotations.BomPolicy;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.annotations.KeywordPolicy;
import org.diylc.presenter.ComparatorFactory;

public class ComponentProcessor {
    private static final Logger LOG = Logger.getLogger(ComponentProcessor.class);
    private static ComponentProcessor instance;
    private Map<String, List<PropertyWrapper>> propertyCache = new HashMap<String, List<PropertyWrapper>>();
    private Map<String, IPropertyValidator> propertyValidatorCache;
    private Map<String, ComponentType> componentTypeMap = new HashMap<String, ComponentType>();
    private Map<String, IComponentTransformer> componentTransformerMap;

    public static ComponentProcessor getInstance() {
        if (instance == null) {
            instance = new ComponentProcessor();
        }
        return instance;
    }

    private ComponentProcessor() {
        this.propertyValidatorCache = new HashMap<String, IPropertyValidator>();
        this.componentTransformerMap = new HashMap<String, IComponentTransformer>();
    }

    public ComponentType extractComponentTypeFrom(Class<? extends IDIYComponent<?>> clazz) {
        if (this.componentTypeMap.containsKey(clazz.getName())) {
            return this.componentTypeMap.get(clazz.getName());
        }
        if (!clazz.isAnnotationPresent(ComponentDescriptor.class)) {
            return null;
        }
        Object object = clazz.getAnnotation(ComponentDescriptor.class);
        String string = object.name();
        String string2 = object.description();
        CreationMethod creationMethod = object.creationMethod();
        String string3 = object.category();
        String string4 = object.instanceNamePrefix();
        String string5 = object.author();
        double d = object.zOrder();
        boolean bl = object.flexibleZOrder();
        BomPolicy bomPolicy = object.bomPolicy();
        boolean bl2 = object.autoEdit();
        IComponentTransformer iComponentTransformer = this.getComponentTransformer(object.transformer());
        KeywordPolicy keywordPolicy = object.keywordPolicy();
        String string6 = object.keywordTag();
        ImageIcon imageIcon = null;
        try {
            object = clazz.newInstance();
            BufferedImage bufferedImage = new BufferedImage(32, 32, 2);
            Graphics2D graphics2D = (Graphics2D)((Image)bufferedImage).getGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            object.drawIcon(graphics2D, 32, 32);
            imageIcon = new ImageIcon(bufferedImage);
        }
        catch (Exception exception) {
            LOG.error((Object)"Error drawing component icon", (Throwable)exception);
        }
        object = new ComponentType(string, string2, creationMethod, string3, string4, string5, imageIcon, clazz, d, bl, bomPolicy, bl2, iComponentTransformer, keywordPolicy, string6);
        this.componentTypeMap.put(clazz.getName(), (ComponentType)object);
        return object;
    }

    public List<PropertyWrapper> extractProperties(Class<?> clazz) {
        if (this.propertyCache.containsKey(clazz.getName())) {
            return this.cloneProperties(this.propertyCache.get(clazz.getName()));
        }
        ArrayList<PropertyWrapper> arrayList = new ArrayList<PropertyWrapper>();
        for (Method method : clazz.getMethods()) {
            if (!method.getName().startsWith("get")) continue;
            try {
                if (!method.isAnnotationPresent(EditableProperty.class) || method.isAnnotationPresent(Deprecated.class)) continue;
                EditableProperty editableProperty = method.getAnnotation(EditableProperty.class);
                String string = editableProperty.name().equals("") ? method.getName().substring(3) : editableProperty.name();
                IPropertyValidator iPropertyValidator = this.getPropertyValidator(editableProperty.validatorClass());
                Method method2 = clazz.getMethod("set" + method.getName().substring(3), method.getReturnType());
                PropertyWrapper propertyWrapper = new PropertyWrapper(string, method.getReturnType(), method.getName(), method2.getName(), editableProperty.defaultable(), iPropertyValidator, editableProperty.sortOrder());
                arrayList.add(propertyWrapper);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                LOG.debug((Object)("No matching setter found for \"" + method.getName() + "\". Skipping..."));
            }
        }
        this.propertyCache.put(clazz.getName(), arrayList);
        return this.cloneProperties(arrayList);
    }

    private List<PropertyWrapper> cloneProperties(List<PropertyWrapper> list) {
        ArrayList<PropertyWrapper> arrayList = new ArrayList<PropertyWrapper>(list.size());
        for (PropertyWrapper propertyWrapper : list) {
            try {
                arrayList.add((PropertyWrapper)propertyWrapper.clone());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new RuntimeException(cloneNotSupportedException);
            }
        }
        return arrayList;
    }

    public List<PropertyWrapper> getMutualSelectionProperties(Collection<IDIYComponent<?>> collection) throws Exception {
        if (collection.isEmpty()) {
            return null;
        }
        ArrayList<PropertyWrapper> arrayList = new ArrayList<PropertyWrapper>();
        ArrayList arrayList2 = new ArrayList(collection);
        IDIYComponent iDIYComponent = (IDIYComponent)arrayList2.get(0);
        arrayList.addAll(this.extractProperties(iDIYComponent.getClass()));
        for (PropertyWrapper object : arrayList) {
            object.readFrom(iDIYComponent);
        }
        for (int i = 1; i < collection.size(); ++i) {
            IDIYComponent iDIYComponent2 = (IDIYComponent)arrayList2.get(i);
            List<PropertyWrapper> list = this.extractProperties(iDIYComponent2.getClass());
            for (PropertyWrapper propertyWrapper : list) {
                propertyWrapper.readFrom(iDIYComponent2);
            }
            arrayList.retainAll(list);
            for (PropertyWrapper propertyWrapper : arrayList) {
                if (!list.contains(propertyWrapper)) continue;
                PropertyWrapper propertyWrapper2 = list.get(list.indexOf(propertyWrapper));
                if (propertyWrapper2.getValue() != null && propertyWrapper2.getValue() != null) {
                    if (propertyWrapper2.getValue().equals(propertyWrapper.getValue())) continue;
                    propertyWrapper.setUnique(false);
                    continue;
                }
                if ((propertyWrapper2.getValue() != null || propertyWrapper.getValue() == null) && (propertyWrapper2.getValue() == null || propertyWrapper.getValue() != null)) continue;
                propertyWrapper.setUnique(false);
            }
        }
        Collections.sort(arrayList, ComparatorFactory.getInstance().getDefaultPropertyComparator());
        return arrayList;
    }

    private IPropertyValidator getPropertyValidator(Class<? extends IPropertyValidator> clazz) {
        IPropertyValidator iPropertyValidator;
        if (this.propertyValidatorCache.containsKey(clazz.getName())) {
            return this.propertyValidatorCache.get(clazz.getName());
        }
        try {
            iPropertyValidator = clazz.newInstance();
        }
        catch (Exception exception) {
            LOG.error((Object)("Could not instantiate validator for " + clazz.getName()), (Throwable)exception);
            return null;
        }
        this.propertyValidatorCache.put(clazz.getName(), iPropertyValidator);
        return iPropertyValidator;
    }

    private IComponentTransformer getComponentTransformer(Class<? extends IComponentTransformer> clazz) {
        IComponentTransformer iComponentTransformer;
        if (clazz == null) {
            return null;
        }
        if (this.componentTransformerMap.containsKey(clazz.getName())) {
            return this.componentTransformerMap.get(clazz.getName());
        }
        try {
            iComponentTransformer = clazz.newInstance();
        }
        catch (Exception exception) {
            LOG.error((Object)("Could not instantiate validator for " + clazz.getName()), (Throwable)exception);
            return null;
        }
        this.componentTransformerMap.put(clazz.getName(), iComponentTransformer);
        return iComponentTransformer;
    }
}

