/*
 * Decompiled with CFR 0.152.
 */
package org.diylc;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.SplashScreen;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.diylc.images.IconLoader;

public class DIYLCSplash {
    private Thread t;
    private ImageIcon resistor = null;
    private ImageIcon film = null;
    private ImageIcon ceramic = null;
    private ImageIcon electrolytic = null;
    private ImageIcon splash = null;
    private Point resistorTarget = new Point(112, 114);
    private Point filmTarget = new Point(233, 113);
    private Point electrolyticTarget = new Point(261, 23);
    private Point ceramicTarget = new Point(352, 22);
    private int pxPerFrame = 3;

    public DIYLCSplash(final SplashScreen splashScreen) {
        if (splashScreen == null) {
            return;
        }
        final Graphics2D graphics2D = splashScreen.createGraphics();
        if (graphics2D == null) {
            return;
        }
        this.t = new Thread(new Runnable(){

            @Override
            public void run() {
                for (int i = 90; i >= 0; --i) {
                    if (!splashScreen.isVisible()) {
                        return;
                    }
                    final int n = i;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DIYLCSplash.this.renderSplashFrame(splashScreen, graphics2D, n);
                            splashScreen.update();
                        }
                    });
                    try {
                        Thread.sleep(10L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public void start() {
        if (this.t != null) {
            this.t.start();
        }
    }

    public ImageIcon getResistor() {
        if (this.resistor == null) {
            this.resistor = (ImageIcon)IconLoader.SplashResistor.getIcon();
        }
        return this.resistor;
    }

    public ImageIcon getFilm() {
        if (this.film == null) {
            this.film = (ImageIcon)IconLoader.SplashFilm.getIcon();
        }
        return this.film;
    }

    public ImageIcon getCeramic() {
        if (this.ceramic == null) {
            this.ceramic = (ImageIcon)IconLoader.SplashCeramic.getIcon();
        }
        return this.ceramic;
    }

    public ImageIcon getElectrolytic() {
        if (this.electrolytic == null) {
            this.electrolytic = (ImageIcon)IconLoader.SplashElectrolytic.getIcon();
        }
        return this.electrolytic;
    }

    public ImageIcon getSplash() {
        if (this.splash == null) {
            this.splash = (ImageIcon)IconLoader.Splash.getIcon();
        }
        return this.splash;
    }

    public void renderSplashFrame(SplashScreen splashScreen, Graphics2D graphics2D, int n) {
        graphics2D.setComposite(AlphaComposite.Clear);
        this.getSplash().paintIcon(null, graphics2D, 0, 0);
        graphics2D.setComposite(AlphaComposite.getInstance(3, 0.7f - (float)n * 0.007f));
        this.getResistor().paintIcon(null, graphics2D, this.resistorTarget.x - this.pxPerFrame * n, this.resistorTarget.y);
        this.getFilm().paintIcon(null, graphics2D, this.filmTarget.x, this.filmTarget.y + this.pxPerFrame * n);
        this.getElectrolytic().paintIcon(null, graphics2D, this.electrolyticTarget.x, this.electrolyticTarget.y - this.pxPerFrame * n);
        this.getCeramic().paintIcon(null, graphics2D, this.ceramicTarget.x + this.pxPerFrame * n, this.ceramicTarget.y);
    }
}

