/*
 * Decompiled with CFR 0.152.
 */
package org.diylc;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.awt.SplashScreen;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.diylc.DIYLCSplash;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.appframework.miscutils.PropertyInjector;
import org.diylc.common.IPlugInPort;
import org.diylc.swing.gui.MainFrame;
import org.diylc.swing.gui.TemplateDialog;
import org.diylc.swingframework.FontChooserComboBox;

public class DIYLCStarter {
    private static final Logger LOG = Logger.getLogger(DIYLCStarter.class);
    private static final String SCRIPT_RUN = "org.diylc.scriptRun";

    public static void main(String[] stringArray) {
        int n;
        SplashScreen splashScreen = SplashScreen.getSplashScreen();
        new DIYLCSplash(splashScreen).start();
        URL uRL = DIYLCStarter.class.getResource("log4j.properties");
        Properties properties = new Properties();
        try {
            properties.load(uRL.openStream());
            PropertyConfigurator.configure((Properties)properties);
        }
        catch (Exception exception) {
            LOG.error((Object)"Could not initialize log4j configuration", (Throwable)exception);
        }
        ConfigurationManager.initialize("diylc");
        LOG.debug((Object)("Java version: " + System.getProperty("java.runtime.version") + " by " + System.getProperty("java.vm.vendor")));
        LOG.debug((Object)("OS: " + System.getProperty("os.name") + " " + System.getProperty("os.version")));
        LOG.info((Object)("Starting DIYLC with working directory " + System.getProperty("user.dir")));
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            LOG.error((Object)"Could not set Look&Feel", (Throwable)exception);
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                Serializable serializable;
                LOG.debug((Object)"Starting font pre-loading");
                File file = new File("fonts");
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    try {
                        LOG.info((Object)("Dynamically loading font: " + fileArray[i].getName()));
                        serializable = Font.createFont(0, new File(fileArray[i].getAbsolutePath())).deriveFont(12.0f);
                        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                        graphicsEnvironment.registerFont((Font)serializable);
                        continue;
                    }
                    catch (IOException iOException) {
                        LOG.error((Object)"Could not load font", (Throwable)iOException);
                        continue;
                    }
                    catch (FontFormatException fontFormatException) {
                        LOG.error((Object)"Font format error", (Throwable)fontFormatException);
                    }
                }
                FontChooserComboBox fontChooserComboBox = new FontChooserComboBox();
                fontChooserComboBox.getPreferredSize();
                serializable = new JPanel();
                fontChooserComboBox.paint(serializable.getGraphics());
                LOG.debug((Object)"Finished font pre-loading");
            }
        });
        thread.start();
        String string = System.getProperty(SCRIPT_RUN);
        if (!"true".equals(string) && (n = JOptionPane.showConfirmDialog(null, "It is not recommended to run DIYLC by clicking on the diylc.jar file.\nPlease use diylc.exe on Windows or run.sh on OSX/Linux to ensure the best\nperformance and reliability. Do you want to continue?", "DIYLC", 0, 2)) != 0) {
            System.exit(0);
        }
        MainFrame mainFrame = new MainFrame();
        mainFrame.setLocationRelativeTo(null);
        mainFrame.setVisible(true);
        if (stringArray.length > 0) {
            mainFrame.getPresenter().loadProjectFromFile(stringArray[0]);
        } else {
            TemplateDialog templateDialog;
            boolean bl = ConfigurationManager.getInstance().readBoolean("showTemplatesAtStartup", false);
            if (bl && !(templateDialog = new TemplateDialog(mainFrame, (IPlugInPort)mainFrame.getPresenter())).getFiles().isEmpty()) {
                templateDialog.setVisible(true);
            }
        }
        properties = new Properties();
        try {
            LOG.info((Object)"Injecting default properties.");
            File file = new File("config.properties");
            if (file.exists()) {
                properties.load(new FileInputStream(file));
                PropertyInjector.injectProperties(properties);
            }
        }
        catch (Exception exception) {
            LOG.error((Object)"Could not read config.properties file", (Throwable)exception);
        }
        if (ConfigurationManager.getInstance().isFileWithErrors()) {
            mainFrame.showMessage("<html>There was an error reading the configuration file and it was replaced by a default configuration.<br>The backup file is created and placed in user directory under '.diylc' sub-directory with '~' at the end.<br>This can happen when running two versions of DIYLC on the same machine at the same time.<br>Replace the main 'config.xml' file with the backup when running the latest version of DIYLC.</html>", "Warning", 2);
        }
    }
}

