/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing.gui;

import java.awt.Window;
import java.io.File;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.common.IPlugInPort;
import org.diylc.common.PropertyWrapper;
import org.diylc.plugins.cloud.model.UserEntity;
import org.diylc.swing.gui.InfoDialog;
import org.diylc.swing.gui.components.OverwritePromptFileChooser;
import org.diylc.swing.gui.editor.PropertyEditorDialog;
import org.diylc.swing.plugins.cloud.view.ChangePasswordDialog;
import org.diylc.swing.plugins.cloud.view.LoginDialog;
import org.diylc.swing.plugins.cloud.view.UploadDialog;
import org.diylc.swing.plugins.cloud.view.UserEditDialog;
import org.diylc.swing.plugins.file.BomDialog;
import org.diylc.swingframework.AboutDialog;
import org.diylc.swingframework.IFileChooserAccessory;
import org.diylc.swingframework.ProgressDialog;
import org.diylc.utils.BomEntry;

public class DialogFactory {
    private static DialogFactory instance;
    private static final String PATH_KEY = "lastPath";
    private JFrame mainFrame;
    private File lastDirectory;

    public static DialogFactory getInstance() {
        if (instance == null) {
            instance = new DialogFactory();
        }
        return instance;
    }

    private DialogFactory() {
    }

    public void initialize(JFrame jFrame) {
        this.mainFrame = jFrame;
        String string = ConfigurationManager.getInstance().readString(PATH_KEY, null);
        if (string != null) {
            this.lastDirectory = new File(string);
        }
    }

    public PropertyEditorDialog createPropertyEditorDialog(List<PropertyWrapper> list, String string, boolean bl) {
        return this.createPropertyEditorDialog(this.mainFrame, list, string, bl);
    }

    public PropertyEditorDialog createPropertyEditorDialog(JFrame jFrame, List<PropertyWrapper> list, String string, boolean bl) {
        PropertyEditorDialog propertyEditorDialog = new PropertyEditorDialog(jFrame, list, string, bl);
        return propertyEditorDialog;
    }

    public InfoDialog createInfoDialog(String string) {
        return new InfoDialog(this.mainFrame, string);
    }

    public BomDialog createBomDialog(List<BomEntry> list, String string) {
        BomDialog bomDialog = new BomDialog(this.mainFrame, list, string);
        return bomDialog;
    }

    public File showOpenDialog(FileFilter fileFilter, File file, String string, IFileChooserAccessory iFileChooserAccessory) {
        JFileChooser jFileChooser = new JFileChooser();
        this.initializeFileChooser(jFileChooser, fileFilter, file, string, iFileChooserAccessory, false);
        int n = jFileChooser.showOpenDialog(this.mainFrame);
        return this.processFileChooserResult(n, jFileChooser, string);
    }

    public File showOpenDialog(FileFilter fileFilter, File file, String string, IFileChooserAccessory iFileChooserAccessory, JFrame jFrame) {
        JFileChooser jFileChooser = new JFileChooser();
        this.initializeFileChooser(jFileChooser, fileFilter, file, string, iFileChooserAccessory, false);
        int n = jFileChooser.showOpenDialog(jFrame);
        return this.processFileChooserResult(n, jFileChooser, string);
    }

    public File[] showOpenMultiDialog(FileFilter fileFilter, File file, String string, IFileChooserAccessory iFileChooserAccessory, JFrame jFrame) {
        JFileChooser jFileChooser = new JFileChooser();
        this.initializeFileChooser(jFileChooser, fileFilter, file, string, iFileChooserAccessory, true);
        int n = jFileChooser.showOpenDialog(jFrame);
        return this.processFileMultiChooserResult(n, jFileChooser, string);
    }

    public File showSaveDialog(Window window, FileFilter fileFilter, File file, String string, IFileChooserAccessory iFileChooserAccessory) {
        OverwritePromptFileChooser overwritePromptFileChooser = new OverwritePromptFileChooser();
        this.initializeFileChooser(overwritePromptFileChooser, fileFilter, file, string, iFileChooserAccessory, false);
        int n = overwritePromptFileChooser.showSaveDialog(window);
        return this.processFileChooserResult(n, overwritePromptFileChooser, string);
    }

    private void initializeFileChooser(JFileChooser jFileChooser, FileFilter fileFilter, File file, String string, IFileChooserAccessory iFileChooserAccessory, boolean bl) {
        if (iFileChooserAccessory != null) {
            iFileChooserAccessory.install(jFileChooser);
        }
        for (FileFilter fileFilter2 : jFileChooser.getChoosableFileFilters()) {
            jFileChooser.removeChoosableFileFilter(fileFilter2);
        }
        if (jFileChooser instanceof OverwritePromptFileChooser) {
            ((OverwritePromptFileChooser)jFileChooser).setFileFilter(fileFilter, string);
        } else {
            jFileChooser.setFileFilter(fileFilter);
        }
        if (this.lastDirectory != null) {
            jFileChooser.setCurrentDirectory(this.lastDirectory);
        }
        jFileChooser.setSelectedFile(file);
        if (bl) {
            jFileChooser.setMultiSelectionEnabled(true);
        }
    }

    private File processFileChooserResult(int n, JFileChooser jFileChooser, String string) {
        jFileChooser.setAccessory(null);
        if (n == 0) {
            this.lastDirectory = jFileChooser.getCurrentDirectory();
            ConfigurationManager.getInstance().writeValue(PATH_KEY, this.lastDirectory.getAbsolutePath());
            if (jFileChooser.getSelectedFile().getName().contains(".")) {
                return jFileChooser.getSelectedFile();
            }
            return new File(jFileChooser.getSelectedFile().getAbsoluteFile() + "." + string);
        }
        return null;
    }

    private File[] processFileMultiChooserResult(int n, JFileChooser jFileChooser, String string) {
        jFileChooser.setAccessory(null);
        if (n == 0) {
            this.lastDirectory = jFileChooser.getCurrentDirectory();
            ConfigurationManager.getInstance().writeValue(PATH_KEY, this.lastDirectory.getAbsolutePath());
            return jFileChooser.getSelectedFiles();
        }
        return null;
    }

    public AboutDialog createAboutDialog(String string, Icon icon, String string2, String string3, String string4, String string5, String string6) {
        AboutDialog aboutDialog = new AboutDialog(this.mainFrame, string, icon, string2, string3, string4, string5, string6);
        return aboutDialog;
    }

    public UserEditDialog createUserEditDialog(UserEntity userEntity) {
        UserEditDialog userEditDialog = new UserEditDialog(this.mainFrame, userEntity);
        return userEditDialog;
    }

    public LoginDialog createLoginDialog() {
        LoginDialog loginDialog = new LoginDialog(this.mainFrame);
        return loginDialog;
    }

    public UploadDialog createUploadDialog(JFrame jFrame, IPlugInPort iPlugInPort, String[] stringArray, boolean bl) {
        UploadDialog uploadDialog = new UploadDialog(jFrame, iPlugInPort, stringArray, bl);
        return uploadDialog;
    }

    public ChangePasswordDialog createChangePasswordDialog() {
        ChangePasswordDialog changePasswordDialog = new ChangePasswordDialog(this.mainFrame);
        return changePasswordDialog;
    }

    public ProgressDialog createProgressDialog(String string, String[] stringArray, String string2, boolean bl) {
        ProgressDialog progressDialog = new ProgressDialog(this.mainFrame, string, stringArray, string2, bl);
        return progressDialog;
    }
}

