/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing.gui.editor;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JButton;
import org.apache.poi.util.IOUtils;
import org.diylc.common.PropertyWrapper;
import org.diylc.swing.gui.DialogFactory;
import org.diylc.swing.plugins.file.FileFilterEnum;

public class ImageEditor
extends JButton {
    private static final long serialVersionUID = 1L;
    private static final String title = "Click to load image file";

    public ImageEditor(final PropertyWrapper propertyWrapper) {
        super(propertyWrapper.isUnique() ? title : "(multi value) Click to load image file");
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file = DialogFactory.getInstance().showOpenDialog(FileFilterEnum.IMAGES.getFilter(), null, FileFilterEnum.IMAGES.getExtensions()[0], null);
                if (file != null) {
                    propertyWrapper.setChanged(true);
                    try {
                        FileInputStream fileInputStream = new FileInputStream(file);
                        byte[] byArray = IOUtils.toByteArray((InputStream)fileInputStream);
                        propertyWrapper.setValue((Object)byArray);
                        fileInputStream.close();
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        fileNotFoundException.printStackTrace();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        });
    }
}

