/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing.plugins.canvas;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.appframework.miscutils.IConfigListener;
import org.diylc.appframework.miscutils.Utils;
import org.diylc.common.BadPositionException;
import org.diylc.common.EventType;
import org.diylc.common.IPlugIn;
import org.diylc.common.IPlugInPort;
import org.diylc.core.ExpansionMode;
import org.diylc.core.IDIYComponent;
import org.diylc.core.Template;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.images.IconLoader;
import org.diylc.swing.ActionFactory;
import org.diylc.swing.ISwingUI;
import org.diylc.swing.plugins.canvas.CanvasPanel;
import org.diylc.swing.plugins.edit.ComponentTransferable;
import org.diylc.swing.plugins.file.ProjectDrawingProvider;
import org.diylc.swingframework.IDrawingProvider;
import org.diylc.swingframework.ruler.IRulerListener;
import org.diylc.swingframework.ruler.RulerScrollPane;

public class CanvasPlugin
implements IPlugIn,
ClipboardOwner {
    private static final Logger LOG = Logger.getLogger(CanvasPlugin.class);
    private RulerScrollPane scrollPane;
    private CanvasPanel canvasPanel;
    private JPopupMenu popupMenu;
    private JMenu selectionMenu;
    private JMenu expandMenu;
    private JMenu transformMenu;
    private JMenu applyTemplateMenu;
    private ActionFactory.CutAction cutAction;
    private ActionFactory.CopyAction copyAction;
    private ActionFactory.PasteAction pasteAction;
    private ActionFactory.DuplicateAction duplicateAction;
    private ActionFactory.EditSelectionAction editSelectionAction;
    private ActionFactory.DeleteSelectionAction deleteSelectionAction;
    private ActionFactory.SaveAsTemplateAction saveAsTemplateAction;
    private ActionFactory.SaveAsBlockAction saveAsBlockAction;
    private ActionFactory.GroupAction groupAction;
    private ActionFactory.UngroupAction ungroupAction;
    private ActionFactory.SendToBackAction sendToBackAction;
    private ActionFactory.BringToFrontAction bringToFrontAction;
    private ActionFactory.NudgeAction nudgeAction;
    private ActionFactory.ExpandSelectionAction expandSelectionAllAction;
    private ActionFactory.ExpandSelectionAction expandSelectionImmediateAction;
    private ActionFactory.ExpandSelectionAction expandSelectionSameTypeAction;
    private ActionFactory.RotateSelectionAction rotateClockwiseAction;
    private ActionFactory.RotateSelectionAction rotateCounterclockwiseAction;
    private ActionFactory.MirrorSelectionAction mirrorHorizontallyAction;
    private ActionFactory.MirrorSelectionAction mirrorVerticallyAction;
    private IPlugInPort plugInPort;
    private ISwingUI swingUI;
    private Clipboard clipboard;
    private double zoomLevel = 1.0;

    public CanvasPlugin(ISwingUI iSwingUI) {
        this.swingUI = iSwingUI;
        this.clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
    }

    public void connect(IPlugInPort iPlugInPort) {
        this.plugInPort = iPlugInPort;
        try {
            this.swingUI.injectGUIComponent((JComponent)this.getScrollPane(), 0);
        }
        catch (BadPositionException badPositionException) {
            LOG.error((Object)"Could not install canvas plugin", (Throwable)badPositionException);
        }
        this.getScrollPane().setRulerVisible(ConfigurationManager.getInstance().readBoolean("showRulers", true));
        if (CanvasPanel.RENDER_VISIBLE_RECT_ONLY) {
            this.getScrollPane().getHorizontalScrollBar().addAdjustmentListener(new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                    CanvasPlugin.this.getCanvasPanel().invalidateCache();
                    CanvasPlugin.this.getCanvasPanel().revalidate();
                }
            });
            this.getScrollPane().getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                    CanvasPlugin.this.getCanvasPanel().invalidateCache();
                    CanvasPlugin.this.getCanvasPanel().revalidate();
                }
            });
        }
        ConfigurationManager.getInstance().addConfigListener("showRulers", new IConfigListener(){

            @Override
            public void valueChanged(String string, Object object) {
                if ("showRulers".equals(string)) {
                    CanvasPlugin.this.getScrollPane().setRulerVisible(((Boolean)object).booleanValue());
                }
            }
        });
        ConfigurationManager.getInstance().addConfigListener("hardwareAcceleration", new IConfigListener(){

            @Override
            public void valueChanged(String string, Object object) {
                CanvasPlugin.this.canvasPanel.setUseHardwareAcceleration((Boolean)object);
                CanvasPlugin.this.scrollPane.setUseHardwareAcceleration(((Boolean)object).booleanValue());
            }
        });
        ConfigurationManager.getInstance().addConfigListener("metric", new IConfigListener(){

            @Override
            public void valueChanged(String string, Object object) {
                CanvasPlugin.this.updateZeroLocation();
            }
        });
        ConfigurationManager.getInstance().addConfigListener("extraSpace", new IConfigListener(){

            @Override
            public void valueChanged(String string, Object object) {
                CanvasPlugin.this.refreshSize();
                Rectangle rectangle = CanvasPlugin.this.canvasPanel.getVisibleRect();
                rectangle.setLocation((CanvasPlugin.this.canvasPanel.getWidth() - rectangle.width) / 2, (CanvasPlugin.this.canvasPanel.getHeight() - rectangle.height) / 2);
                CanvasPlugin.this.canvasPanel.scrollRectToVisible(rectangle);
                CanvasPlugin.this.canvasPanel.revalidate();
                CanvasPlugin.this.updateZeroLocation();
            }
        });
    }

    public CanvasPanel getCanvasPanel() {
        if (this.canvasPanel == null) {
            this.canvasPanel = new CanvasPanel(this.plugInPort);
            this.canvasPanel.addMouseListener(new MouseAdapter(){
                private MouseEvent pressedEvent;

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (CanvasPlugin.this.scrollPane.isMouseScrollMode() || mouseEvent.getButton() == 2) {
                        return;
                    }
                    CanvasPlugin.this.plugInPort.mouseClicked(mouseEvent.getPoint(), mouseEvent.getButton(), Utils.isMac() ? mouseEvent.isMetaDown() : mouseEvent.isControlDown(), mouseEvent.isShiftDown(), mouseEvent.isAltDown(), mouseEvent.getClickCount());
                }

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    LOG.info((Object)("Pressed: " + mouseEvent.isPopupTrigger()));
                    CanvasPlugin.this.canvasPanel.requestFocus();
                    this.pressedEvent = mouseEvent;
                }

                @Override
                public void mouseReleased(final MouseEvent mouseEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (CanvasPlugin.this.plugInPort.getNewComponentTypeSlot() == null && (mouseEvent.isPopupTrigger() || pressedEvent != null && pressedEvent.isPopupTrigger())) {
                                boolean bl = !CanvasPlugin.this.plugInPort.getSelectedComponents().isEmpty();
                                CanvasPlugin.this.getCutAction().setEnabled(bl);
                                CanvasPlugin.this.getCopyAction().setEnabled(bl);
                                CanvasPlugin.this.getDuplicateAction().setEnabled(bl);
                                try {
                                    CanvasPlugin.this.getPasteAction().setEnabled(CanvasPlugin.this.clipboard.isDataFlavorAvailable(ComponentTransferable.listFlavor));
                                }
                                catch (Exception exception) {
                                    CanvasPlugin.this.getPasteAction().setEnabled(false);
                                }
                                CanvasPlugin.this.getEditSelectionAction().setEnabled(bl);
                                CanvasPlugin.this.getDeleteSelectionAction().setEnabled(bl);
                                CanvasPlugin.this.getExpandSelectionAllAction().setEnabled(bl);
                                CanvasPlugin.this.getExpandSelectionImmediateAction().setEnabled(bl);
                                CanvasPlugin.this.getExpandSelectionSameTypeAction().setEnabled(bl);
                                CanvasPlugin.this.getGroupAction().setEnabled(bl);
                                CanvasPlugin.this.getUngroupAction().setEnabled(bl);
                                CanvasPlugin.this.getNudgeAction().setEnabled(bl);
                                CanvasPlugin.this.getSendToBackAction().setEnabled(bl);
                                CanvasPlugin.this.getBringToFrontAction().setEnabled(bl);
                                CanvasPlugin.this.getRotateClockwiseAction().setEnabled(bl);
                                CanvasPlugin.this.getRotateCounterclockwiseAction().setEnabled(bl);
                                CanvasPlugin.this.getMirrorHorizontallyAction().setEnabled(bl);
                                CanvasPlugin.this.getMirrorVerticallyAction().setEnabled(bl);
                                CanvasPlugin.this.getSaveAsTemplateAction().setEnabled(CanvasPlugin.this.plugInPort.getSelectedComponents().size() == 1);
                                CanvasPlugin.this.getSaveAsBlockAction().setEnabled(CanvasPlugin.this.plugInPort.getSelectedComponents().size() > 1);
                                CanvasPlugin.this.showPopupAt(mouseEvent.getX(), mouseEvent.getY());
                            }
                        }
                    });
                }
            });
            this.canvasPanel.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (CanvasPlugin.this.plugInPort.keyPressed(keyEvent.getKeyCode(), Utils.isMac() ? keyEvent.isMetaDown() : keyEvent.isControlDown(), keyEvent.isShiftDown(), keyEvent.isAltDown())) {
                        keyEvent.consume();
                    }
                }
            });
            this.canvasPanel.addMouseMotionListener(new MouseAdapter(){

                @Override
                public void mouseMoved(MouseEvent mouseEvent) {
                    if (CanvasPlugin.this.scrollPane.isMouseScrollMode()) {
                        return;
                    }
                    CanvasPlugin.this.canvasPanel.setCursor(CanvasPlugin.this.plugInPort.getCursorAt(mouseEvent.getPoint()));
                    CanvasPlugin.this.plugInPort.mouseMoved(mouseEvent.getPoint(), Utils.isMac() ? mouseEvent.isMetaDown() : mouseEvent.isControlDown(), mouseEvent.isShiftDown(), mouseEvent.isAltDown());
                }
            });
        }
        return this.canvasPanel;
    }

    private RulerScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new RulerScrollPane((Component)this.getCanvasPanel(), (IDrawingProvider)new ProjectDrawingProvider(this.plugInPort, true, false, true), new Size(Double.valueOf(1.0), SizeUnit.cm).convertToPixels(), new Size(Double.valueOf(1.0), SizeUnit.in).convertToPixels());
            boolean bl = ConfigurationManager.getInstance().readBoolean("metric", true);
            boolean bl2 = ConfigurationManager.getInstance().readBoolean("hardwareAcceleration", false);
            this.scrollPane.setUseHardwareAcceleration(bl2);
            this.scrollPane.setMetric(bl);
            this.scrollPane.setWheelScrollingEnabled(true);
            this.scrollPane.addUnitListener(new IRulerListener(){

                public void unitsChanged(boolean bl) {
                    CanvasPlugin.this.plugInPort.setMetric(bl);
                }
            });
            double d = this.plugInPort.getExtraSpace();
            this.scrollPane.setZeroLocation((Point2D)new Point2D.Double(d, d));
            this.scrollPane.setWheelScrollingEnabled(false);
            this.scrollPane.addMouseWheelListener(new MouseWheelListener(){

                @Override
                public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                    JScrollBar jScrollBar = CanvasPlugin.this.scrollPane.getHorizontalScrollBar();
                    JScrollBar jScrollBar2 = CanvasPlugin.this.scrollPane.getVerticalScrollBar();
                    boolean bl = ConfigurationManager.getInstance().readBoolean("wheelZoom", false);
                    if (bl || (Utils.isMac() ? mouseWheelEvent.isMetaDown() : mouseWheelEvent.isControlDown())) {
                        double d;
                        int n;
                        Point point = CanvasPlugin.this.getCanvasPanel().getMousePosition(true);
                        double d2 = CanvasPlugin.this.plugInPort.getZoomLevel();
                        Double[] doubleArray = CanvasPlugin.this.plugInPort.getAvailableZoomLevels();
                        if (mouseWheelEvent.getWheelRotation() > 0) {
                            for (n = doubleArray.length - 1; n > 0 && doubleArray[n] >= d2; --n) {
                            }
                            d = doubleArray[n];
                            CanvasPlugin.this.plugInPort.setZoomLevel(d);
                        } else {
                            for (n = 0; n < doubleArray.length - 1 && doubleArray[n] <= d2; ++n) {
                            }
                            d = doubleArray[n];
                            CanvasPlugin.this.plugInPort.setZoomLevel(d);
                        }
                        Rectangle2D rectangle2D = CanvasPlugin.this.plugInPort.getSelectionBounds(true);
                        Rectangle rectangle = CanvasPlugin.this.scrollPane.getVisibleRect();
                        JScrollBar jScrollBar3 = CanvasPlugin.this.scrollPane.getHorizontalScrollBar();
                        JScrollBar jScrollBar4 = CanvasPlugin.this.scrollPane.getVerticalScrollBar();
                        if (rectangle2D == null) {
                            Point point2 = new Point((int)(1.0 * (double)point.x / d2 * d), (int)(1.0 * (double)point.y / d2 * d));
                            int n2 = point2.x - point.x;
                            int n3 = point2.y - point.y;
                            jScrollBar3.setValue(jScrollBar3.getValue() + n2);
                            jScrollBar4.setValue(jScrollBar4.getValue() + n3);
                        } else {
                            jScrollBar3.setValue((int)(rectangle2D.getX() + rectangle2D.getWidth() / 2.0 - rectangle.getWidth() / 2.0));
                            jScrollBar4.setValue((int)(rectangle2D.getY() + rectangle2D.getHeight() / 2.0 - rectangle.getHeight() / 2.0));
                        }
                    }
                    if (mouseWheelEvent.isShiftDown()) {
                        int n = mouseWheelEvent.getScrollAmount();
                        int n4 = jScrollBar.getValue() + jScrollBar.getBlockIncrement() * n * mouseWheelEvent.getWheelRotation();
                        if (n4 <= jScrollBar.getMaximum()) {
                            jScrollBar.setValue(n4);
                        }
                    } else {
                        int n = mouseWheelEvent.getScrollAmount();
                        int n5 = jScrollBar2.getValue() + jScrollBar2.getBlockIncrement() * n * mouseWheelEvent.getWheelRotation();
                        if (n5 <= jScrollBar2.getMaximum()) {
                            jScrollBar2.setValue(n5);
                        }
                    }
                }
            });
        }
        return this.scrollPane;
    }

    private void showPopupAt(int n, int n2) {
        this.updateSelectionMenu(n, n2);
        this.updateApplyTemplateMenu();
        this.getPopupMenu().show(this.canvasPanel, n, n2);
    }

    public JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.popupMenu.add(this.getSelectionMenu());
            this.popupMenu.addSeparator();
            this.popupMenu.add(this.getCutAction());
            this.popupMenu.add(this.getCopyAction());
            this.popupMenu.add(this.getPasteAction());
            this.popupMenu.add(this.getDuplicateAction());
            this.popupMenu.addSeparator();
            this.popupMenu.add(this.getEditSelectionAction());
            this.popupMenu.add(this.getDeleteSelectionAction());
            this.popupMenu.add(this.getTransformMenu());
            this.popupMenu.add(this.getSaveAsTemplateAction());
            this.popupMenu.add(this.getApplyTemplateMenu());
            this.popupMenu.add(this.getSaveAsBlockAction());
            this.popupMenu.add(this.getExpandMenu());
            this.popupMenu.addSeparator();
            this.popupMenu.add(ActionFactory.getInstance().createEditProjectAction(this.plugInPort));
        }
        return this.popupMenu;
    }

    public JMenu getSelectionMenu() {
        if (this.selectionMenu == null) {
            this.selectionMenu = new JMenu("Select");
            this.selectionMenu.setIcon(IconLoader.ElementsSelection.getIcon());
        }
        return this.selectionMenu;
    }

    public JMenu getExpandMenu() {
        if (this.expandMenu == null) {
            this.expandMenu = new JMenu("Expand Selection");
            this.expandMenu.setIcon(IconLoader.BranchAdd.getIcon());
            this.expandMenu.add(this.getExpandSelectionAllAction());
            this.expandMenu.add(this.getExpandSelectionImmediateAction());
            this.expandMenu.add(this.getExpandSelectionSameTypeAction());
        }
        return this.expandMenu;
    }

    public JMenu getTransformMenu() {
        if (this.transformMenu == null) {
            this.transformMenu = new JMenu("Transform Selection");
            this.transformMenu.setIcon(IconLoader.MagicWand.getIcon());
            this.transformMenu.add(this.getRotateClockwiseAction());
            this.transformMenu.add(this.getRotateCounterclockwiseAction());
            this.transformMenu.addSeparator();
            this.transformMenu.add(this.getMirrorHorizontallyAction());
            this.transformMenu.add(this.getMirrorVerticallyAction());
            this.transformMenu.addSeparator();
            this.transformMenu.add(this.getNudgeAction());
            this.transformMenu.addSeparator();
            this.transformMenu.add(this.getSendToBackAction());
            this.transformMenu.add(this.getBringToFrontAction());
            this.transformMenu.addSeparator();
            this.transformMenu.add(this.getGroupAction());
            this.transformMenu.add(this.getUngroupAction());
        }
        return this.transformMenu;
    }

    public JMenu getApplyTemplateMenu() {
        if (this.applyTemplateMenu == null) {
            this.applyTemplateMenu = new JMenu("Apply Variant");
            this.applyTemplateMenu.setIcon(IconLoader.BriefcaseInto.getIcon());
        }
        return this.applyTemplateMenu;
    }

    private void updateSelectionMenu(int n, int n2) {
        this.getSelectionMenu().removeAll();
        for (IDIYComponent iDIYComponent : this.plugInPort.findComponentsAt(new Point(n, n2))) {
            JMenuItem jMenuItem = new JMenuItem(iDIYComponent.getName());
            final IDIYComponent iDIYComponent2 = iDIYComponent;
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ArrayList<IDIYComponent> arrayList = new ArrayList<IDIYComponent>();
                    arrayList.add(iDIYComponent2);
                    CanvasPlugin.this.plugInPort.updateSelection(arrayList);
                    CanvasPlugin.this.plugInPort.refresh();
                }
            });
            this.getSelectionMenu().add(jMenuItem);
        }
    }

    private void updateApplyTemplateMenu() {
        this.getApplyTemplateMenu().removeAll();
        List list = null;
        try {
            list = this.plugInPort.getVariantsForSelection();
        }
        catch (Exception exception) {
            LOG.info((Object)"Could not load variants for selection");
            this.getApplyTemplateMenu().setEnabled(false);
        }
        if (list == null) {
            this.getApplyTemplateMenu().setEnabled(false);
            return;
        }
        this.getApplyTemplateMenu().setEnabled(list.size() > 0);
        for (Template template : list) {
            JMenuItem jMenuItem = new JMenuItem(template.getName());
            final Template template2 = template;
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CanvasPlugin.this.plugInPort.applyVariantToSelection(template2);
                }
            });
            this.getApplyTemplateMenu().add(jMenuItem);
        }
    }

    public ActionFactory.CutAction getCutAction() {
        if (this.cutAction == null) {
            this.cutAction = ActionFactory.getInstance().createCutAction(this.plugInPort, this.clipboard, this);
        }
        return this.cutAction;
    }

    public ActionFactory.CopyAction getCopyAction() {
        if (this.copyAction == null) {
            this.copyAction = ActionFactory.getInstance().createCopyAction(this.plugInPort, this.clipboard, this);
        }
        return this.copyAction;
    }

    public ActionFactory.PasteAction getPasteAction() {
        if (this.pasteAction == null) {
            this.pasteAction = ActionFactory.getInstance().createPasteAction(this.plugInPort, this.clipboard);
        }
        return this.pasteAction;
    }

    public ActionFactory.DuplicateAction getDuplicateAction() {
        if (this.duplicateAction == null) {
            this.duplicateAction = ActionFactory.getInstance().createDuplicateAction(this.plugInPort);
        }
        return this.duplicateAction;
    }

    public ActionFactory.EditSelectionAction getEditSelectionAction() {
        if (this.editSelectionAction == null) {
            this.editSelectionAction = ActionFactory.getInstance().createEditSelectionAction(this.plugInPort);
        }
        return this.editSelectionAction;
    }

    public ActionFactory.DeleteSelectionAction getDeleteSelectionAction() {
        if (this.deleteSelectionAction == null) {
            this.deleteSelectionAction = ActionFactory.getInstance().createDeleteSelectionAction(this.plugInPort);
        }
        return this.deleteSelectionAction;
    }

    public ActionFactory.RotateSelectionAction getRotateClockwiseAction() {
        if (this.rotateClockwiseAction == null) {
            this.rotateClockwiseAction = ActionFactory.getInstance().createRotateSelectionAction(this.plugInPort, 1);
        }
        return this.rotateClockwiseAction;
    }

    public ActionFactory.RotateSelectionAction getRotateCounterclockwiseAction() {
        if (this.rotateCounterclockwiseAction == null) {
            this.rotateCounterclockwiseAction = ActionFactory.getInstance().createRotateSelectionAction(this.plugInPort, -1);
        }
        return this.rotateCounterclockwiseAction;
    }

    public ActionFactory.MirrorSelectionAction getMirrorHorizontallyAction() {
        if (this.mirrorHorizontallyAction == null) {
            this.mirrorHorizontallyAction = ActionFactory.getInstance().createMirrorSelectionAction(this.plugInPort, 0);
        }
        return this.mirrorHorizontallyAction;
    }

    public ActionFactory.MirrorSelectionAction getMirrorVerticallyAction() {
        if (this.mirrorVerticallyAction == null) {
            this.mirrorVerticallyAction = ActionFactory.getInstance().createMirrorSelectionAction(this.plugInPort, 1);
        }
        return this.mirrorVerticallyAction;
    }

    public ActionFactory.SaveAsTemplateAction getSaveAsTemplateAction() {
        if (this.saveAsTemplateAction == null) {
            this.saveAsTemplateAction = ActionFactory.getInstance().createSaveAsTemplateAction(this.plugInPort);
        }
        return this.saveAsTemplateAction;
    }

    public ActionFactory.SaveAsBlockAction getSaveAsBlockAction() {
        if (this.saveAsBlockAction == null) {
            this.saveAsBlockAction = ActionFactory.getInstance().createSaveAsBlockAction(this.plugInPort);
        }
        return this.saveAsBlockAction;
    }

    public ActionFactory.GroupAction getGroupAction() {
        if (this.groupAction == null) {
            this.groupAction = ActionFactory.getInstance().createGroupAction(this.plugInPort);
        }
        return this.groupAction;
    }

    public ActionFactory.UngroupAction getUngroupAction() {
        if (this.ungroupAction == null) {
            this.ungroupAction = ActionFactory.getInstance().createUngroupAction(this.plugInPort);
        }
        return this.ungroupAction;
    }

    public ActionFactory.SendToBackAction getSendToBackAction() {
        if (this.sendToBackAction == null) {
            this.sendToBackAction = ActionFactory.getInstance().createSendToBackAction(this.plugInPort);
        }
        return this.sendToBackAction;
    }

    public ActionFactory.BringToFrontAction getBringToFrontAction() {
        if (this.bringToFrontAction == null) {
            this.bringToFrontAction = ActionFactory.getInstance().createBringToFrontAction(this.plugInPort);
        }
        return this.bringToFrontAction;
    }

    public ActionFactory.NudgeAction getNudgeAction() {
        if (this.nudgeAction == null) {
            this.nudgeAction = ActionFactory.getInstance().createNudgeAction(this.plugInPort);
        }
        return this.nudgeAction;
    }

    public ActionFactory.ExpandSelectionAction getExpandSelectionAllAction() {
        if (this.expandSelectionAllAction == null) {
            this.expandSelectionAllAction = ActionFactory.getInstance().createExpandSelectionAction(this.plugInPort, ExpansionMode.ALL);
        }
        return this.expandSelectionAllAction;
    }

    public ActionFactory.ExpandSelectionAction getExpandSelectionImmediateAction() {
        if (this.expandSelectionImmediateAction == null) {
            this.expandSelectionImmediateAction = ActionFactory.getInstance().createExpandSelectionAction(this.plugInPort, ExpansionMode.IMMEDIATE);
        }
        return this.expandSelectionImmediateAction;
    }

    public ActionFactory.ExpandSelectionAction getExpandSelectionSameTypeAction() {
        if (this.expandSelectionSameTypeAction == null) {
            this.expandSelectionSameTypeAction = ActionFactory.getInstance().createExpandSelectionAction(this.plugInPort, ExpansionMode.SAME_TYPE);
        }
        return this.expandSelectionSameTypeAction;
    }

    public EnumSet<EventType> getSubscribedEventTypes() {
        return EnumSet.of(EventType.PROJECT_LOADED, EventType.ZOOM_CHANGED, EventType.REPAINT);
    }

    public void processMessage(EventType eventType, Object ... objectArray) {
        switch (eventType) {
            case PROJECT_LOADED: {
                this.refreshSize();
                if (!((Boolean)objectArray[1]).booleanValue()) break;
                final Rectangle rectangle = this.canvasPanel.getVisibleRect();
                rectangle.setLocation((this.canvasPanel.getWidth() - rectangle.width) / 2, (this.canvasPanel.getHeight() - rectangle.height) / 2);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CanvasPlugin.this.canvasPanel.scrollRectToVisible(rectangle);
                        CanvasPlugin.this.canvasPanel.revalidate();
                    }
                });
                break;
            }
            case ZOOM_CHANGED: {
                Rectangle rectangle = this.canvasPanel.getVisibleRect();
                this.refreshSize();
                double d = (Double)objectArray[0] / this.zoomLevel;
                rectangle.setBounds((int)((double)rectangle.x * d), (int)((double)rectangle.y * d), rectangle.width, rectangle.height);
                this.canvasPanel.scrollRectToVisible(rectangle);
                this.canvasPanel.revalidate();
                this.updateZeroLocation();
                this.zoomLevel = (Double)objectArray[0];
                break;
            }
            case REPAINT: {
                this.canvasPanel.repaint();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (ConfigurationManager.getInstance().readBoolean("showRulers", true)) {
                            CanvasPlugin.this.scrollPane.setSelectionRectangle(CanvasPlugin.this.plugInPort.getSelectionBounds(true));
                        }
                    }
                });
            }
        }
    }

    private void refreshSize() {
        Dimension dimension = this.plugInPort.getCanvasDimensions(true, ConfigurationManager.getInstance().readBoolean("extraSpace", true));
        this.canvasPanel.setSize(dimension);
        this.canvasPanel.setPreferredSize(dimension);
        this.getScrollPane().setZoomLevel(this.plugInPort.getZoomLevel());
    }

    public void refresh() {
        MouseEvent mouseEvent = new MouseEvent(this.canvasPanel, 503, System.currentTimeMillis(), 0, 1, 1, 0, false);
        this.canvasPanel.dispatchEvent(mouseEvent);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    private void updateZeroLocation() {
        double d = this.plugInPort.getExtraSpace();
        this.getScrollPane().setZeroLocation((Point2D)new Point2D.Double(d, d));
    }
}

