/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing.plugins.cloud;

import java.awt.event.ActionEvent;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.ListIterator;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import org.apache.log4j.Logger;
import org.diylc.common.EventType;
import org.diylc.common.IPlugIn;
import org.diylc.common.IPlugInPort;
import org.diylc.common.ITask;
import org.diylc.core.IView;
import org.diylc.images.IconLoader;
import org.diylc.plugins.cloud.presenter.CloudException;
import org.diylc.plugins.cloud.presenter.CloudPresenter;
import org.diylc.presenter.Presenter;
import org.diylc.swing.ISwingUI;
import org.diylc.swing.gui.DialogFactory;
import org.diylc.swing.gui.DummyView;
import org.diylc.swing.plugins.cloud.view.ChangePasswordDialog;
import org.diylc.swing.plugins.cloud.view.LoginDialog;
import org.diylc.swing.plugins.cloud.view.UploadDialog;
import org.diylc.swing.plugins.cloud.view.UserEditDialog;
import org.diylc.swing.plugins.cloud.view.browser.CloudBrowserFrame;
import org.diylc.swing.plugins.cloud.view.browser.UploadManagerFrame;
import org.diylc.swing.plugins.file.FileFilterEnum;

public class CloudPlugIn
implements IPlugIn {
    private static final String ONLINE_TITLE = "Project Cloud";
    private static final Logger LOG = Logger.getLogger(CloudPlugIn.class);
    private ISwingUI swingUI;
    private IPlugInPort plugInPort;
    private IPlugInPort thumbnailPresenter;
    private LibraryAction libraryAction;
    private LoginAction loginAction;
    private LogOutAction logOutAction;
    private CreateAccountAction createAccountAction;
    private ManageAccountAction manageAccountAction;
    private UploadAction uploadAction;
    private ChangePasswordAction changePasswordAction;
    private ManageProjectsAction manageProjectsAction;
    private CloudBrowserFrame cloudBrowser;

    public CloudPlugIn(ISwingUI iSwingUI) {
        this.swingUI = iSwingUI;
        this.thumbnailPresenter = new Presenter((IView)new DummyView());
        iSwingUI.injectMenuAction(this.getLibraryAction(), ONLINE_TITLE);
        iSwingUI.injectMenuAction(null, ONLINE_TITLE);
        iSwingUI.injectMenuAction(this.getLoginAction(), ONLINE_TITLE);
        iSwingUI.injectMenuAction(this.getCreateAccountAction(), ONLINE_TITLE);
        iSwingUI.injectMenuAction(null, ONLINE_TITLE);
        iSwingUI.injectMenuAction(this.getUploadAction(), ONLINE_TITLE);
        iSwingUI.injectMenuAction(this.getManageProjectsAction(), ONLINE_TITLE);
        iSwingUI.injectMenuAction(null, ONLINE_TITLE);
        iSwingUI.injectMenuAction(this.getManageAccountAction(), ONLINE_TITLE);
        iSwingUI.injectMenuAction(this.getChangePasswordAction(), ONLINE_TITLE);
        iSwingUI.injectMenuAction(this.getLogOutAction(), ONLINE_TITLE);
        this.getUploadAction().setEnabled(false);
        this.getManageProjectsAction().setEnabled(false);
        this.getLogOutAction().setEnabled(false);
    }

    public void connect(IPlugInPort iPlugInPort) {
        this.plugInPort = iPlugInPort;
        this.initialize();
    }

    private void initialize() {
        this.swingUI.executeBackgroundTask(new ITask<Boolean>(){

            public Boolean doInBackground() throws Exception {
                return CloudPresenter.Instance.tryLogInWithToken();
            }

            public void failed(Exception exception) {
                LOG.error((Object)"Error while trying to login using token");
            }

            public void complete(Boolean bl) {
                try {
                    if (bl.booleanValue()) {
                        CloudPlugIn.this.loggedIn();
                    }
                }
                catch (Exception exception) {
                    LOG.error((Object)"Error while trying to login with token", (Throwable)exception);
                }
            }
        }, false);
    }

    public CloudBrowserFrame getCloudBrowser() {
        if (this.cloudBrowser == null) {
            this.cloudBrowser = new CloudBrowserFrame(this.swingUI, this.plugInPort);
        }
        return this.cloudBrowser;
    }

    public UploadManagerFrame createUploadManagerFrame() {
        return new UploadManagerFrame(this.swingUI, this.plugInPort);
    }

    public LibraryAction getLibraryAction() {
        if (this.libraryAction == null) {
            this.libraryAction = new LibraryAction();
        }
        return this.libraryAction;
    }

    public LoginAction getLoginAction() {
        if (this.loginAction == null) {
            this.loginAction = new LoginAction();
        }
        return this.loginAction;
    }

    public LogOutAction getLogOutAction() {
        if (this.logOutAction == null) {
            this.logOutAction = new LogOutAction();
        }
        return this.logOutAction;
    }

    public CreateAccountAction getCreateAccountAction() {
        if (this.createAccountAction == null) {
            this.createAccountAction = new CreateAccountAction();
        }
        return this.createAccountAction;
    }

    public ManageAccountAction getManageAccountAction() {
        if (this.manageAccountAction == null) {
            this.manageAccountAction = new ManageAccountAction();
        }
        return this.manageAccountAction;
    }

    public UploadAction getUploadAction() {
        if (this.uploadAction == null) {
            this.uploadAction = new UploadAction();
        }
        return this.uploadAction;
    }

    public ChangePasswordAction getChangePasswordAction() {
        if (this.changePasswordAction == null) {
            this.changePasswordAction = new ChangePasswordAction();
        }
        return this.changePasswordAction;
    }

    public ManageProjectsAction getManageProjectsAction() {
        if (this.manageProjectsAction == null) {
            this.manageProjectsAction = new ManageProjectsAction();
        }
        return this.manageProjectsAction;
    }

    public EnumSet<EventType> getSubscribedEventTypes() {
        return null;
    }

    public void processMessage(EventType eventType, Object ... objectArray) {
    }

    public void loggedIn() {
        this.getLoginAction().setEnabled(false);
        this.getCreateAccountAction().setEnabled(false);
        this.getLogOutAction().setEnabled(true);
        this.getManageAccountAction().setEnabled(true);
        this.getUploadAction().setEnabled(true);
        this.getManageProjectsAction().setEnabled(true);
    }

    public void loggedOut() {
        this.getLoginAction().setEnabled(true);
        this.getCreateAccountAction().setEnabled(true);
        this.getLogOutAction().setEnabled(false);
        this.getManageAccountAction().setEnabled(false);
        this.getUploadAction().setEnabled(false);
        this.getManageProjectsAction().setEnabled(false);
    }

    class ManageProjectsAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public ManageProjectsAction() {
            this.putValue("Name", "Manage My Uploads");
            this.putValue("SmallIcon", IconLoader.CloudGear.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            UploadManagerFrame uploadManagerFrame = CloudPlugIn.this.createUploadManagerFrame();
            uploadManagerFrame.setVisible(true);
        }
    }

    class UploadAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public UploadAction() {
            this.putValue("Name", "Upload A Project");
            this.putValue("SmallIcon", IconLoader.CloudUp.getIcon());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)"UploadAction triggered");
            File[] fileArray = DialogFactory.getInstance().showOpenMultiDialog(FileFilterEnum.DIY.getFilter(), null, FileFilterEnum.DIY.getExtensions()[0], null, CloudPlugIn.this.swingUI.getOwnerFrame());
            if (fileArray != null && fileArray.length > 0) {
                ArrayList arrayList = new ArrayList();
                final ListIterator<1> listIterator = arrayList.listIterator();
                for (final File file : fileArray) {
                    listIterator.add(new ITask<String[]>(){

                        public String[] doInBackground() throws Exception {
                            LOG.debug((Object)("Uploading from " + file.getAbsolutePath()));
                            CloudPlugIn.this.thumbnailPresenter.loadProjectFromFile(file.getAbsolutePath());
                            return CloudPresenter.Instance.getCategories();
                        }

                        public void complete(String[] stringArray) {
                            final UploadDialog uploadDialog = DialogFactory.getInstance().createUploadDialog(CloudPlugIn.this.swingUI.getOwnerFrame(), CloudPlugIn.this.thumbnailPresenter, stringArray, false);
                            uploadDialog.setVisible(true);
                            if ("OK".equals(uploadDialog.getSelectedButtonCaption())) {
                                try {
                                    final File file2 = File.createTempFile("upload-thumbnail", ".png");
                                    if (ImageIO.write((RenderedImage)uploadDialog.getThumbnail(), "png", file2)) {
                                        CloudPlugIn.this.swingUI.executeBackgroundTask(new ITask<Void>(){

                                            public Void doInBackground() throws Exception {
                                                CloudPresenter.Instance.uploadProject(uploadDialog.getName(), uploadDialog.getCategory(), uploadDialog.getDescription(), uploadDialog.getKeywords(), CloudPlugIn.this.plugInPort.getCurrentVersionNumber().toString(), file2, file, null);
                                                return null;
                                            }

                                            public void failed(Exception exception) {
                                                CloudPlugIn.this.swingUI.showMessage(exception.getMessage(), "Upload Error", 0);
                                            }

                                            /*
                                             * WARNING - Removed try catching itself - possible behaviour change.
                                             */
                                            public void complete(Void void_) {
                                                CloudPlugIn.this.swingUI.showMessage("The project has been uploaded to the cloud successfully. Thank you for your contribution!", "Upload Success", 1);
                                                ListIterator listIterator = listIterator;
                                                synchronized (listIterator) {
                                                    if (listIterator.hasPrevious()) {
                                                        CloudPlugIn.this.swingUI.executeBackgroundTask((ITask)listIterator.previous(), true);
                                                    }
                                                }
                                            }
                                        }, true);
                                    } else {
                                        CloudPlugIn.this.swingUI.showMessage("Could not prepare temporary files to be uploaded to the cloud.", "Upload Error", 0);
                                    }
                                }
                                catch (Exception exception) {
                                    CloudPlugIn.this.swingUI.showMessage(exception.getMessage(), "Upload Error", 0);
                                }
                            }
                        }

                        public void failed(Exception exception) {
                            CloudPlugIn.this.swingUI.showMessage("Could not open file. " + exception.getMessage(), "Error", 0);
                        }
                    });
                }
                ListIterator<1> listIterator2 = listIterator;
                synchronized (listIterator2) {
                    if (listIterator.hasPrevious()) {
                        CloudPlugIn.this.swingUI.executeBackgroundTask((ITask)listIterator.previous(), true);
                    }
                }
            }
        }
    }

    class ChangePasswordAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public ChangePasswordAction() {
            this.putValue("Name", "Change Password");
            this.putValue("SmallIcon", IconLoader.KeyEdit.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            final ChangePasswordDialog changePasswordDialog = DialogFactory.getInstance().createChangePasswordDialog();
            changePasswordDialog.setVisible(true);
            if ("OK".equals(changePasswordDialog.getSelectedButtonCaption())) {
                CloudPlugIn.this.swingUI.executeBackgroundTask(new ITask<Void>(){

                    public Void doInBackground() throws Exception {
                        CloudPresenter.Instance.updatePassword(changePasswordDialog.getOldPassword(), changePasswordDialog.getNewPassword());
                        return null;
                    }

                    public void failed(Exception exception) {
                        CloudPlugIn.this.swingUI.showMessage("Failed to update the password. Error: " + exception.getMessage(), "Cloud Error", 0);
                    }

                    public void complete(Void void_) {
                        CloudPlugIn.this.swingUI.showMessage("Password updated.", "Cloud", 1);
                    }
                }, true);
            }
        }
    }

    class ManageAccountAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public ManageAccountAction() {
            this.putValue("Name", "Manage Account");
            this.putValue("SmallIcon", IconLoader.IdCardEdit.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                final UserEditDialog userEditDialog = DialogFactory.getInstance().createUserEditDialog(CloudPresenter.Instance.getUserDetails());
                userEditDialog.setVisible(true);
                if ("OK".equals(userEditDialog.getSelectedButtonCaption())) {
                    CloudPlugIn.this.swingUI.executeBackgroundTask(new ITask<Void>(){

                        public Void doInBackground() throws Exception {
                            CloudPresenter.Instance.updateUserDetails(userEditDialog.getEmail(), userEditDialog.getWebsite(), userEditDialog.getBio());
                            return null;
                        }

                        public void failed(Exception exception) {
                            CloudPlugIn.this.swingUI.showMessage("Failed to update the account. Error: " + exception.getMessage(), "Cloud Error", 0);
                        }

                        public void complete(Void void_) {
                            CloudPlugIn.this.swingUI.showMessage("Cloud account updated successfully.", "Cloud", 1);
                        }
                    }, true);
                }
            }
            catch (CloudException cloudException) {
                CloudPlugIn.this.swingUI.showMessage("Failed to retreive user details from the server. Error: " + cloudException.getMessage(), "Cloud Error", 0);
            }
        }
    }

    class CreateAccountAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CreateAccountAction() {
            this.putValue("Name", "Create New Account");
            this.putValue("SmallIcon", IconLoader.IdCardAdd.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            final UserEditDialog userEditDialog = DialogFactory.getInstance().createUserEditDialog(null);
            userEditDialog.setVisible(true);
            if ("OK".equals(userEditDialog.getSelectedButtonCaption())) {
                CloudPlugIn.this.swingUI.executeBackgroundTask(new ITask<Void>(){

                    public Void doInBackground() throws Exception {
                        CloudPresenter.Instance.createUserAccount(userEditDialog.getUserName(), userEditDialog.getPassword(), userEditDialog.getEmail(), userEditDialog.getWebsite(), userEditDialog.getBio());
                        return null;
                    }

                    public void failed(Exception exception) {
                        CloudPlugIn.this.swingUI.showMessage("Failed to create the account. Error: " + exception.getMessage(), "Cloud Error", 0);
                    }

                    public void complete(Void void_) {
                        CloudPlugIn.this.swingUI.showMessage("Cloud account created successfully.", "Cloud", 1);
                    }
                }, true);
            }
        }
    }

    class LogOutAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public LogOutAction() {
            this.putValue("Name", "Log Out");
            this.putValue("SmallIcon", IconLoader.IdCard.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CloudPresenter.Instance.logOut();
            CloudPlugIn.this.loggedOut();
        }
    }

    class LoginAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public LoginAction() {
            this.putValue("Name", "Log In");
            this.putValue("SmallIcon", IconLoader.IdCard.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LoginDialog loginDialog = DialogFactory.getInstance().createLoginDialog();
            while (true) {
                loginDialog.setVisible(true);
                if (!"OK".equals(loginDialog.getSelectedButtonCaption())) break;
                try {
                    if (CloudPresenter.Instance.logIn(loginDialog.getUserName(), loginDialog.getPassword())) {
                        CloudPlugIn.this.swingUI.showMessage("You have successfully logged into the system. You will remain logged in from this machine until logged out.", "Login Successful", 1);
                        CloudPlugIn.this.loggedIn();
                        break;
                    }
                    CloudPlugIn.this.swingUI.showMessage("Could not login. Possible reasons are wrong credentials or lack of internet connection.", "Login Error", 0);
                }
                catch (CloudException cloudException) {
                    CloudPlugIn.this.swingUI.showMessage("Could not login. Error: " + cloudException.getMessage(), "Login Error", 0);
                }
            }
        }
    }

    class LibraryAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public LibraryAction() {
            this.putValue("Name", "Search The Cloud");
            this.putValue("SmallIcon", IconLoader.Cloud.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CloudPlugIn.this.getCloudBrowser().setVisible(true);
            CloudPlugIn.this.getCloudBrowser().requestFocus();
        }
    }
}

