/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing.plugins.cloud.view.browser;

import java.awt.Dimension;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;
import org.diylc.common.IPlugInPort;
import org.diylc.common.ITask;
import org.diylc.images.IconLoader;
import org.diylc.plugins.cloud.model.ProjectEntity;
import org.diylc.plugins.cloud.presenter.CloudPresenter;
import org.diylc.swing.ISimpleView;
import org.diylc.swing.ISwingUI;
import org.diylc.swing.plugins.cloud.view.browser.ResultsScrollPanel;
import org.diylc.swing.plugins.cloud.view.browser.SimpleCloudGlassPane;

public class UploadManagerFrame
extends JFrame
implements ISimpleView {
    private static final String TITLE = "Manage My Uploads";
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(UploadManagerFrame.class);
    private ResultsScrollPanel resultsScrollPane;
    private IPlugInPort plugInPort;
    private ISwingUI swingUI;

    public UploadManagerFrame(ISwingUI iSwingUI, IPlugInPort iPlugInPort) {
        super(TITLE);
        this.swingUI = iSwingUI;
        this.setIconImage(IconLoader.CloudGear.getImage());
        this.setPreferredSize(new Dimension(700, 640));
        this.plugInPort = iPlugInPort;
        this.setContentPane(this.getResultsScrollPane());
        this.pack();
        this.setLocationRelativeTo(iSwingUI.getOwnerFrame());
        this.setGlassPane(SimpleCloudGlassPane.GLASS_PANE);
        this.search();
    }

    private ResultsScrollPanel getResultsScrollPane() {
        if (this.resultsScrollPane == null) {
            this.resultsScrollPane = new ResultsScrollPanel(this.swingUI, this, this.plugInPort, null, true);
        }
        return this.resultsScrollPane;
    }

    private void search() {
        this.getResultsScrollPane().clearPrevious();
        this.executeBackgroundTask(new ITask<List<ProjectEntity>>(){

            public List<ProjectEntity> doInBackground() throws Exception {
                return CloudPresenter.Instance.fetchUserUploads(null);
            }

            public void failed(Exception exception) {
                UploadManagerFrame.this.showMessage("Search failed! Detailed message is in the logs. Please report to the author.", "Search Failed", 0);
            }

            public void complete(List<ProjectEntity> list) {
                UploadManagerFrame.this.getResultsScrollPane().startSearch(list);
            }
        });
    }

    @Override
    public <T> void executeBackgroundTask(final ITask<T> iTask) {
        this.getGlassPane().setVisible(true);
        SwingWorker swingWorker = new SwingWorker<T, Void>(){

            @Override
            protected T doInBackground() throws Exception {
                return iTask.doInBackground();
            }

            @Override
            protected void done() {
                UploadManagerFrame.this.getGlassPane().setVisible(false);
                try {
                    Object t = this.get();
                    iTask.complete(t);
                }
                catch (ExecutionException executionException) {
                    LOG.error((Object)"Background task execution failed", (Throwable)executionException);
                    iTask.failed((Exception)executionException);
                }
                catch (InterruptedException interruptedException) {
                    LOG.error((Object)"Background task execution interrupted", (Throwable)interruptedException);
                    iTask.failed((Exception)interruptedException);
                }
            }
        };
        swingWorker.execute();
    }

    @Override
    public void showMessage(String string, String string2, int n) {
        JOptionPane.showMessageDialog(this, string, string2, n);
    }

    @Override
    public int showConfirmDialog(String string, String string2, int n, int n2) {
        return JOptionPane.showConfirmDialog(this, string, string2, n, n2);
    }

    @Override
    public JFrame getOwnerFrame() {
        return this;
    }
}

