/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing.plugins.file;

import java.awt.Toolkit;
import java.util.EnumSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.common.EventType;
import org.diylc.common.INetlistAnalyzer;
import org.diylc.common.IPlugIn;
import org.diylc.common.IPlugInPort;
import org.diylc.images.IconLoader;
import org.diylc.swing.ActionFactory;
import org.diylc.swing.IDynamicSubmenuHandler;
import org.diylc.swing.ISwingUI;
import org.diylc.swing.plugins.file.ProjectDrawingProvider;
import org.diylc.swing.plugins.file.TraceMaskDrawingProvider;

public class FileMenuPlugin
implements IPlugIn,
IDynamicSubmenuHandler {
    private static final Logger LOG = Logger.getLogger(FileMenuPlugin.class);
    private static final String FILE_TITLE = "File";
    private static final String TRACE_MASK_TITLE = "Trace Mask";
    private static final String INTEGRATION_TITLE = "Integration";
    private static final String ANALYZE_TITLE = "Analyze";
    private ProjectDrawingProvider drawingProvider;
    private TraceMaskDrawingProvider traceMaskDrawingProvider;
    private ISwingUI swingUI;
    private IPlugInPort plugInPort;

    public FileMenuPlugin(ISwingUI iSwingUI) {
        this.swingUI = iSwingUI;
    }

    public void connect(IPlugInPort iPlugInPort) {
        this.plugInPort = iPlugInPort;
        this.drawingProvider = new ProjectDrawingProvider(iPlugInPort, false, true, false);
        this.traceMaskDrawingProvider = new TraceMaskDrawingProvider(iPlugInPort);
        ActionFactory actionFactory = ActionFactory.getInstance();
        this.swingUI.injectMenuAction(actionFactory.createNewAction(iPlugInPort), FILE_TITLE);
        this.swingUI.injectMenuAction(actionFactory.createOpenAction(iPlugInPort, this.swingUI), FILE_TITLE);
        this.swingUI.injectMenuAction(actionFactory.createImportAction(iPlugInPort, this.swingUI), FILE_TITLE);
        this.swingUI.injectMenuAction(actionFactory.createSaveAction(iPlugInPort, this.swingUI), FILE_TITLE);
        this.swingUI.injectMenuAction(actionFactory.createSaveAsAction(iPlugInPort, this.swingUI), FILE_TITLE);
        this.swingUI.injectDynamicSubmenu("Recent Files", IconLoader.History.getIcon(), FILE_TITLE, this);
        this.swingUI.injectMenuAction(null, FILE_TITLE);
        this.swingUI.injectMenuAction(actionFactory.createExportPDFAction(iPlugInPort, this.drawingProvider, this.swingUI, ""), FILE_TITLE);
        this.swingUI.injectMenuAction(actionFactory.createExportPNGAction(iPlugInPort, this.drawingProvider, this.swingUI, ""), FILE_TITLE);
        this.swingUI.injectMenuAction(actionFactory.createPrintAction(this.drawingProvider, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), FILE_TITLE);
        this.swingUI.injectSubmenu(TRACE_MASK_TITLE, IconLoader.TraceMask.getIcon(), FILE_TITLE);
        this.swingUI.injectMenuAction(actionFactory.createExportPDFAction(iPlugInPort, this.traceMaskDrawingProvider, this.swingUI, " (mask)"), TRACE_MASK_TITLE);
        this.swingUI.injectMenuAction(actionFactory.createExportPNGAction(iPlugInPort, this.traceMaskDrawingProvider, this.swingUI, " (mask)"), TRACE_MASK_TITLE);
        this.swingUI.injectMenuAction(actionFactory.createPrintAction(this.traceMaskDrawingProvider, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x40), TRACE_MASK_TITLE);
        this.swingUI.injectSubmenu(ANALYZE_TITLE, IconLoader.Scientist.getIcon(), FILE_TITLE);
        this.swingUI.injectMenuAction(actionFactory.createBomAction(iPlugInPort), ANALYZE_TITLE);
        this.swingUI.injectMenuAction(actionFactory.createGenerateNetlistAction(iPlugInPort, this.swingUI), ANALYZE_TITLE);
        List list = iPlugInPort.getNetlistAnalyzers();
        if (list != null) {
            for (INetlistAnalyzer iNetlistAnalyzer : list) {
                this.swingUI.injectMenuAction(actionFactory.createSummarizeNetlistAction(iPlugInPort, this.swingUI, iNetlistAnalyzer), ANALYZE_TITLE);
            }
        }
        this.swingUI.injectMenuAction(null, FILE_TITLE);
        this.swingUI.injectSubmenu(INTEGRATION_TITLE, IconLoader.Node.getIcon(), FILE_TITLE);
        this.swingUI.injectMenuAction(actionFactory.createImportBlocksAction(this.swingUI, iPlugInPort), INTEGRATION_TITLE);
        this.swingUI.injectMenuAction(actionFactory.createExportBlocksAction(this.swingUI), INTEGRATION_TITLE);
        this.swingUI.injectMenuAction(null, INTEGRATION_TITLE);
        this.swingUI.injectMenuAction(actionFactory.createImportVariantsAction(this.swingUI, iPlugInPort), INTEGRATION_TITLE);
        this.swingUI.injectMenuAction(actionFactory.createExportVariantsAction(this.swingUI, iPlugInPort), INTEGRATION_TITLE);
        this.swingUI.injectMenuAction(null, FILE_TITLE);
        this.swingUI.injectMenuAction(actionFactory.createExitAction(iPlugInPort), FILE_TITLE);
    }

    public EnumSet<EventType> getSubscribedEventTypes() {
        return null;
    }

    public void processMessage(EventType eventType, Object ... objectArray) {
    }

    @Override
    public void onActionPerformed(String string) {
        LOG.info((Object)("Openning recent file: " + string));
        if (!this.plugInPort.allowFileAction()) {
            LOG.info((Object)"Aborted openning recent file");
            return;
        }
        this.plugInPort.loadProjectFromFile(string);
    }

    @Override
    public List<String> getAvailableItems() {
        return (List)ConfigurationManager.getInstance().readObject("recentFiles", null);
    }
}

