/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing.plugins.help;

import java.awt.event.ActionEvent;
import java.util.EnumSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.apache.log4j.Logger;
import org.diylc.appframework.miscutils.Utils;
import org.diylc.appframework.update.UpdateChecker;
import org.diylc.common.EventType;
import org.diylc.common.IPlugIn;
import org.diylc.common.IPlugInPort;
import org.diylc.images.IconLoader;
import org.diylc.swing.ISwingUI;
import org.diylc.swing.gui.DialogFactory;
import org.diylc.swingframework.AboutDialog;
import org.diylc.swingframework.LinkLabel;
import org.diylc.swingframework.update.UpdateDialog;

public class HelpMenuPlugin
implements IPlugIn {
    private static final String HELP_TITLE = "Help";
    public static String MANUAL_URL = "https://github.com/bancika/diy-layout-creator/blob/wiki/Manual.md";
    public static String FAQ_URL = "https://github.com/bancika/diy-layout-creator/blob/wiki/FAQ.md";
    public static String COMPONENT_URL = "https://github.com/bancika/diy-layout-creator/blob/wiki/ComponentAPI.md";
    public static String PLUGIN_URL = "https://github.com/bancika/diy-layout-creator/blob/wiki/PluginAPI.md";
    public static String BUG_URL = "https://github.com/bancika/diy-layout-creator/issues";
    public static String DONATE_URL = "http://diy-fever.com/donate";
    private IPlugInPort plugInPort;
    private AboutDialog aboutDialog;
    private ISwingUI swingUI;
    private static final String LICENSE_TEXT = "<p>This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.</p><p>This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.</p><p>You should have received a copy of the GNU General Public License along with this program.  If not, see <a href=\"https://www.gnu.org/licenses\">https://www.gnu.org/licenses</a>.</p>";

    public HelpMenuPlugin(ISwingUI iSwingUI) {
        this.swingUI = iSwingUI;
        iSwingUI.injectMenuAction(new NavigateURLAction("User Manual", IconLoader.Manual.getIcon(), MANUAL_URL), HELP_TITLE);
        iSwingUI.injectMenuAction(new NavigateURLAction("FAQ", IconLoader.Faq.getIcon(), FAQ_URL), HELP_TITLE);
        iSwingUI.injectMenuAction(new NavigateURLAction("Component API", IconLoader.CoffeebeanEdit.getIcon(), COMPONENT_URL), HELP_TITLE);
        iSwingUI.injectMenuAction(new NavigateURLAction("Plugin API", IconLoader.ApplicationEdit.getIcon(), PLUGIN_URL), HELP_TITLE);
        iSwingUI.injectMenuAction(new NavigateURLAction("Submit a Bug", IconLoader.Bug.getIcon(), BUG_URL), HELP_TITLE);
        iSwingUI.injectMenuAction(null, HELP_TITLE);
        iSwingUI.injectMenuAction(new RecentUpdatesAction(), HELP_TITLE);
        iSwingUI.injectMenuAction(null, HELP_TITLE);
        iSwingUI.injectMenuAction(new NavigateURLAction("Donate", IconLoader.Donate.getIcon(), DONATE_URL), HELP_TITLE);
        iSwingUI.injectMenuAction(new AboutAction(), HELP_TITLE);
    }

    public void connect(IPlugInPort iPlugInPort) {
        this.plugInPort = iPlugInPort;
    }

    public EnumSet<EventType> getSubscribedEventTypes() {
        return null;
    }

    public void processMessage(EventType eventType, Object ... objectArray) {
    }

    private AboutDialog getAboutDialog() {
        if (this.aboutDialog == null) {
            this.aboutDialog = DialogFactory.getInstance().createAboutDialog("DIY Layout Creator", IconLoader.IconLarge.getIcon(), this.plugInPort.getCurrentVersionNumber().toString(), "Branislav Stojkovic", "github.com/bancika/diy-layout-creator", "bancika@gmail.com", LICENSE_TEXT);
            this.aboutDialog.setSize(this.aboutDialog.getSize().width + 30, this.aboutDialog.getSize().height + 200);
        }
        return this.aboutDialog;
    }

    class NavigateURLAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private String url;

        public NavigateURLAction(String string, Icon icon, String string2) {
            this.url = string2;
            this.putValue("Name", string);
            this.putValue("SmallIcon", icon);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Utils.openURL(this.url);
            }
            catch (Exception exception) {
                Logger.getLogger(LinkLabel.class).error((Object)"Could not launch default browser", (Throwable)exception);
            }
        }
    }

    class RecentUpdatesAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public RecentUpdatesAction() {
            this.putValue("Name", "Recent Updates");
            this.putValue("SmallIcon", IconLoader.ScrollInformation.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            List list = HelpMenuPlugin.this.plugInPort.getRecentUpdates();
            if (list == null) {
                HelpMenuPlugin.this.swingUI.showMessage("Version history is not available.", "Information", 1);
            } else {
                String string = UpdateChecker.createUpdateHTML(list);
                UpdateDialog updateDialog = new UpdateDialog((JComponent)HelpMenuPlugin.this.swingUI.getOwnerFrame().getRootPane(), string, (String)null);
                updateDialog.setVisible(true);
            }
        }
    }

    class AboutAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public AboutAction() {
            this.putValue("Name", "About");
            this.putValue("SmallIcon", IconLoader.About.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            HelpMenuPlugin.this.getAboutDialog().setVisible(true);
        }
    }
}

