/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing.plugins.tree;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.apache.log4j.lf5.viewer.categoryexplorer.TreeModelAdapter;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.appframework.miscutils.IConfigListener;
import org.diylc.common.ComponentType;
import org.diylc.common.Favorite;
import org.diylc.common.IBlockProcessor;
import org.diylc.common.IPlugInPort;
import org.diylc.core.IDIYComponent;
import org.diylc.core.Template;
import org.diylc.images.IconLoader;
import org.diylc.presenter.ComponentProcessor;
import org.diylc.swing.ISwingUI;
import org.diylc.swing.plugins.toolbox.ComponentButtonFactory;
import org.diylc.swing.plugins.tree.TreeGestureListener;
import org.diylc.swing.plugins.tree.TreeTargetListener;

public class TreePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(TreePanel.class);
    public static final String COMPONENT_SHORTCUT_KEY = "componentShortcuts";
    private DefaultTreeModel treeModel;
    private JTree tree;
    private JScrollPane treeScroll;
    private JTextField searchField;
    private DefaultMutableTreeNode recentNode;
    private DefaultMutableTreeNode blocksNode;
    private DefaultMutableTreeNode favoritesNode;
    private List<String> recentComponents;
    private List<Favorite> favorites;
    private List<String> blocks;
    private IPlugInPort plugInPort;
    private ISwingUI swingUI;
    private boolean initializing = false;
    private JPopupMenu popup;

    public TreePanel(IPlugInPort iPlugInPort, ISwingUI iSwingUI) {
        this.plugInPort = iPlugInPort;
        this.swingUI = iSwingUI;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        this.add((Component)this.getSearchField(), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.getTreeScroll(), gridBagConstraints);
        this.setPreferredSize(new Dimension(240, 200));
        ConfigurationManager.getInstance().addConfigListener("recentComponents", new IConfigListener(){

            @Override
            public void valueChanged(String string, Object object) {
                List list = (List)object;
                if (list != null && !new HashSet(list).equals(new HashSet(TreePanel.this.recentComponents))) {
                    LOG.info((Object)"Detected recent component change");
                    TreePanel.this.refreshRecentComponents(list);
                } else {
                    LOG.info((Object)"Detected no recent component change");
                }
                TreePanel.this.recentComponents = new ArrayList(list);
            }
        });
        ConfigurationManager.getInstance().addConfigListener("buildingBlocks", new IConfigListener(){

            @Override
            public void valueChanged(String string, Object object) {
                Map map = (Map)object;
                if (map != null) {
                    ArrayList arrayList = new ArrayList(map.keySet());
                    Collections.sort(arrayList);
                    if (!((Object)arrayList).equals(TreePanel.this.blocks)) {
                        LOG.info((Object)"Detected block change");
                        TreePanel.this.refreshBuildingBlocks(arrayList);
                    } else {
                        LOG.info((Object)"Detected no block change");
                    }
                } else {
                    LOG.info((Object)"Detected no block change");
                }
            }
        });
        ConfigurationManager.getInstance().addConfigListener("templates", new IConfigListener(){

            @Override
            public void valueChanged(String string, Object object) {
                LOG.info((Object)"Detected variants change, repainting the tree");
                TreePanel.this.repaint();
            }
        });
        ConfigurationManager.getInstance().addConfigListener("favorites", new IConfigListener(){

            @Override
            public void valueChanged(String string, Object object) {
                List list = (List)object;
                if (list != null && !((Object)list).equals(TreePanel.this.favorites)) {
                    LOG.info((Object)"Detected favorites change");
                    TreePanel.this.refreshFavorites(list);
                } else {
                    LOG.info((Object)"Detected no favorites change");
                }
            }
        });
        this.getTree().expandRow(0);
        this.initializeDnD();
    }

    private void initializeDnD() {
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this.getTree(), 0x40000003, new TreeGestureListener(this.plugInPort));
        new DropTarget(this.getTree(), 3, new TreeTargetListener(this.plugInPort), true);
    }

    public JScrollPane getTreeScroll() {
        if (this.treeScroll == null) {
            this.treeScroll = new JScrollPane(this.getTree());
            this.treeScroll.setHorizontalScrollBarPolicy(31);
        }
        return this.treeScroll;
    }

    public DefaultMutableTreeNode getRecentNode() {
        if (this.recentNode == null) {
            this.recentNode = new DefaultMutableTreeNode(new Payload("(Recently Used)", null), true);
            List list = (List)ConfigurationManager.getInstance().readObject("recentComponents", null);
            if (list != null) {
                this.recentComponents = new ArrayList<String>(list);
                this.refreshRecentComponents(list);
            } else {
                this.recentComponents = new ArrayList<String>();
            }
        }
        return this.recentNode;
    }

    public DefaultMutableTreeNode getBlocksNode() {
        if (this.blocksNode == null) {
            this.blocksNode = new DefaultMutableTreeNode(new Payload("(Building Blocks)", null), true);
            Map map = (Map)ConfigurationManager.getInstance().readObject("buildingBlocks", null);
            if (map != null) {
                ArrayList<String> arrayList = new ArrayList<String>(map.keySet());
                Collections.sort(arrayList);
                this.refreshBuildingBlocks(arrayList);
            } else {
                this.blocks = new ArrayList<String>();
            }
        }
        return this.blocksNode;
    }

    public DefaultMutableTreeNode getFavoritesNode() {
        if (this.favoritesNode == null) {
            this.favoritesNode = new DefaultMutableTreeNode(new Payload("(Favorites)", null), true);
            List list = (List)ConfigurationManager.getInstance().readObject("favorites", null);
            if (list != null) {
                this.refreshFavorites(list);
            } else {
                this.favorites = new ArrayList<Favorite>();
            }
        }
        return this.favoritesNode;
    }

    private void refreshRecentComponents(List<String> list) {
        this.getRecentNode().removeAllChildren();
        for (String string : list) {
            try {
                final ComponentType componentType = ComponentProcessor.getInstance().extractComponentTypeFrom(Class.forName(string));
                Payload payload = new Payload(componentType, (MouseListener)new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                        if (TreePanel.this.plugInPort.getNewComponentTypeSlot() != componentType) {
                            TreePanel.this.plugInPort.setNewComponentTypeSlot(componentType, null, false);
                        }
                    }
                });
                DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(payload, false);
                String string2 = this.getSearchField().getText();
                boolean bl = string2.trim().length() == 0 || componentType.getName().toLowerCase().contains(string2.toLowerCase()) || componentType.getDescription().toLowerCase().contains(string2.toLowerCase()) || componentType.getCategory().toLowerCase().contains(string2.toLowerCase());
                payload.setVisible(bl);
                this.getRecentNode().add(defaultMutableTreeNode);
            }
            catch (ClassNotFoundException classNotFoundException) {
                LOG.error((Object)("Could not create recent component button for " + string), (Throwable)classNotFoundException);
            }
        }
        if (!this.initializing) {
            this.getTreeModel().nodeStructureChanged(this.getRecentNode());
        }
    }

    private void refreshBuildingBlocks(List<String> list) {
        this.blocks = list;
        this.getBlocksNode().removeAllChildren();
        for (final String string : list) {
            Payload payload = new Payload(string, (MouseListener)new MouseAdapter(){
                long previousActionTime = 0L;

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent == null || SwingUtilities.isLeftMouseButton(mouseEvent) && System.currentTimeMillis() - this.previousActionTime > 100L) {
                        this.previousActionTime = System.currentTimeMillis();
                        try {
                            TreePanel.this.plugInPort.loadBlock(string);
                        }
                        catch (IBlockProcessor.InvalidBlockException invalidBlockException) {
                            invalidBlockException.printStackTrace();
                        }
                    }
                }
            });
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(payload, false);
            String string2 = this.getSearchField().getText();
            boolean bl = string2.trim().length() == 0 || string.toLowerCase().contains(string2.toLowerCase());
            payload.setVisible(bl);
            this.getBlocksNode().add(defaultMutableTreeNode);
        }
        if (!this.initializing) {
            this.getTreeModel().nodeStructureChanged(this.getBlocksNode());
        }
    }

    private void refreshFavorites(List<Favorite> list) {
        this.favorites = new ArrayList<Favorite>(list);
        this.getFavoritesNode().removeAllChildren();
        Map map = this.plugInPort.getComponentTypes();
        HashMap<String, ComponentType> hashMap = new HashMap<String, ComponentType>();
        for (Map.Entry favorite : map.entrySet()) {
            for (Object object2 : (List)favorite.getValue()) {
                hashMap.put(object2.getInstanceClass().getCanonicalName(), (ComponentType)object2);
            }
        }
        for (Favorite favorite : list) {
            Object object;
            Object object2;
            if (favorite.getType() == Favorite.FavoriteType.Component) {
                object = (ComponentType)hashMap.get(favorite.getName());
                if (object == null) continue;
                object2 = new DefaultMutableTreeNode(new Payload((ComponentType)object, (MouseListener)new MouseAdapter((ComponentType)object){
                    final /* synthetic */ ComponentType val$type;
                    {
                        this.val$type = componentType;
                    }

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                        TreePanel.this.plugInPort.setNewComponentTypeSlot(this.val$type, null, false);
                    }
                }), false);
                this.getFavoritesNode().add((MutableTreeNode)object2);
                continue;
            }
            if (favorite.getType() != Favorite.FavoriteType.Block) continue;
            object = favorite.getName();
            object2 = new Payload((String)object, (MouseListener)new MouseAdapter((String)object){
                long previousActionTime = 0L;
                final /* synthetic */ String val$block;
                {
                    this.val$block = string;
                }

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent == null || SwingUtilities.isLeftMouseButton(mouseEvent) && System.currentTimeMillis() - this.previousActionTime > 100L) {
                        this.previousActionTime = System.currentTimeMillis();
                        try {
                            TreePanel.this.plugInPort.loadBlock(this.val$block);
                        }
                        catch (IBlockProcessor.InvalidBlockException invalidBlockException) {
                            invalidBlockException.printStackTrace();
                        }
                    }
                }
            });
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(object2, false);
            String string = this.getSearchField().getText();
            boolean bl = string.trim().length() == 0 || ((String)object).toLowerCase().contains(string.toLowerCase());
            ((Payload)object2).setVisible(bl);
            this.getFavoritesNode().add(defaultMutableTreeNode);
        }
        if (!this.initializing) {
            this.getTreeModel().nodeStructureChanged(this.getFavoritesNode());
        }
    }

    public DefaultTreeModel getTreeModel() {
        if (this.treeModel == null) {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Components", true);
            this.initializing = true;
            defaultMutableTreeNode.add(this.getFavoritesNode());
            defaultMutableTreeNode.add(this.getRecentNode());
            defaultMutableTreeNode.add(this.getBlocksNode());
            this.initializing = false;
            Map map = this.plugInPort.getComponentTypes();
            ArrayList arrayList = new ArrayList(map.keySet());
            Collections.sort(arrayList);
            for (String string : arrayList) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new Payload(string, null));
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
                for (final ComponentType componentType : (List)map.get(string)) {
                    DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new Payload(componentType, (MouseListener)new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent mouseEvent) {
                            TreePanel.this.plugInPort.setNewComponentTypeSlot(componentType, null, false);
                        }
                    }), false);
                    defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                }
            }
            this.treeModel = new DefaultTreeModel(defaultMutableTreeNode);
            this.treeModel.addTreeModelListener((TreeModelListener)new TreeModelAdapter(){

                public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
                    super.treeNodesRemoved(treeModelEvent);
                }

                public void treeNodesChanged(TreeModelEvent treeModelEvent) {
                    super.treeNodesChanged(treeModelEvent);
                }
            });
        }
        return this.treeModel;
    }

    public JTree getTree() {
        if (this.tree == null) {
            this.tree = new JTree(this.getTreeModel());
            this.tree.setRootVisible(false);
            this.tree.setCellRenderer(new ComponentCellRenderer());
            this.tree.getSelectionModel().setSelectionMode(1);
            this.tree.setRowHeight(0);
            ToolTipManager.sharedInstance().registerComponent(this.tree);
            this.tree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    Payload payload;
                    if (!treeSelectionEvent.isAddedPath()) {
                        return;
                    }
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeSelectionEvent.getPath().getLastPathComponent();
                    if (defaultMutableTreeNode != null && defaultMutableTreeNode.getUserObject() != null && (payload = (Payload)defaultMutableTreeNode.getUserObject()).getClickListener() != null) {
                        payload.getClickListener().mouseClicked(null);
                    }
                }
            });
            this.tree.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() != 1) {
                        return;
                    }
                    if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                        int n = TreePanel.this.tree.getClosestRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                        TreePanel.this.tree.setSelectionRow(n);
                        TreePanel.this.getPopup().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    } else {
                        Payload payload;
                        TreePath treePath = TreePanel.this.tree.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                        if (defaultMutableTreeNode != null && defaultMutableTreeNode.getUserObject() != null && (payload = (Payload)defaultMutableTreeNode.getUserObject()).getClickListener() != null) {
                            payload.getClickListener().mouseClicked(mouseEvent);
                        }
                    }
                }
            });
        }
        return this.tree;
    }

    public JPopupMenu getPopup() {
        if (this.popup == null) {
            this.popup = new JPopupMenu();
            this.popup.add("Loading...");
            this.popup.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                    TreePanel.this.popup.removeAll();
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)TreePanel.this.tree.getLastSelectedPathComponent();
                    if (defaultMutableTreeNode == null || defaultMutableTreeNode.getUserObject() == null) {
                        return;
                    }
                    Payload payload = (Payload)defaultMutableTreeNode.getUserObject();
                    ComponentType componentType = payload.getComponentType();
                    final String string = componentType == null ? "block:" + payload.toString() : componentType.getInstanceClass().getCanonicalName();
                    JMenu jMenu = new JMenu("Assign Shortcut");
                    JMenuItem jMenuItem = new JMenuItem("None");
                    jMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            HashMap hashMap = (HashMap)ConfigurationManager.getInstance().readObject(TreePanel.COMPONENT_SHORTCUT_KEY, null);
                            if (hashMap == null) {
                                hashMap = new HashMap();
                            }
                            Iterator iterator = hashMap.entrySet().iterator();
                            while (iterator.hasNext()) {
                                Map.Entry entry = iterator.next();
                                if (!((String)entry.getValue()).equals(string)) continue;
                                iterator.remove();
                            }
                            ConfigurationManager.getInstance().writeValue(TreePanel.COMPONENT_SHORTCUT_KEY, hashMap);
                            TreePanel.this.invalidate();
                            TreePanel.this.repaint();
                        }
                    });
                    jMenu.add(jMenuItem);
                    for (int i = 1; i <= 12; ++i) {
                        final JMenuItem jMenuItem2 = new JMenuItem("F" + i);
                        jMenuItem2.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                HashMap<String, String> hashMap = (HashMap<String, String>)ConfigurationManager.getInstance().readObject(TreePanel.COMPONENT_SHORTCUT_KEY, null);
                                if (hashMap == null) {
                                    hashMap = new HashMap<String, String>();
                                }
                                if (hashMap.containsKey(jMenuItem2.getText())) {
                                    hashMap.remove(jMenuItem2.getText());
                                }
                                Iterator iterator = hashMap.entrySet().iterator();
                                while (iterator.hasNext()) {
                                    Map.Entry entry = iterator.next();
                                    if (!((String)entry.getValue()).equals(string)) continue;
                                    iterator.remove();
                                }
                                hashMap.put(jMenuItem2.getText(), string);
                                ConfigurationManager.getInstance().writeValue(TreePanel.COMPONENT_SHORTCUT_KEY, hashMap);
                                TreePanel.this.invalidate();
                                TreePanel.this.repaint();
                            }
                        });
                        jMenu.add(jMenuItem2);
                    }
                    if (defaultMutableTreeNode.isLeaf()) {
                        final Favorite favorite = new Favorite(componentType == null ? Favorite.FavoriteType.Block : Favorite.FavoriteType.Component, componentType == null ? payload.toString() : componentType.getInstanceClass().getCanonicalName());
                        final boolean bl = TreePanel.this.favorites != null && TreePanel.this.favorites.indexOf(favorite) >= 0;
                        JMenuItem jMenuItem3 = new JMenuItem(bl ? "Remove From Favorites" : "Add To Favorites", bl ? IconLoader.StarBlue.getIcon() : IconLoader.StarGrey.getIcon());
                        jMenuItem3.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                ArrayList<Favorite> arrayList = new ArrayList<Favorite>(TreePanel.this.favorites);
                                if (bl) {
                                    arrayList.remove(favorite);
                                } else {
                                    arrayList.add(favorite);
                                    Collections.sort(arrayList);
                                }
                                ConfigurationManager.getInstance().writeValue("favorites", arrayList);
                            }
                        });
                        TreePanel.this.popup.add(jMenuItem3);
                    }
                    if (componentType != null) {
                        TreePanel.this.popup.add(new SelectAllAction(TreePanel.this.plugInPort, componentType));
                        TreePanel.this.popup.add(jMenu);
                        TreePanel.this.popup.add(new JSeparator());
                        List list = TreePanel.this.plugInPort.getVariantsFor(componentType);
                        if (list == null || list.isEmpty()) {
                            JMenuItem jMenuItem4 = new JMenuItem("<no variants>");
                            jMenuItem4.setEnabled(false);
                            TreePanel.this.popup.add(jMenuItem4);
                        } else {
                            for (JMenuItem jMenuItem3 : list) {
                                JMenuItem jMenuItem5 = ComponentButtonFactory.createVariantItem(TreePanel.this.plugInPort, (Template)jMenuItem3, componentType);
                                TreePanel.this.popup.add(jMenuItem5);
                            }
                        }
                    } else if (defaultMutableTreeNode.isLeaf()) {
                        TreePanel.this.popup.add(jMenu);
                        TreePanel.this.popup.add(new DeleteBlockAction(TreePanel.this.plugInPort, TreePanel.this.swingUI, payload.toString()));
                    }
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                }
            });
        }
        return this.popup;
    }

    public JTextField getSearchField() {
        if (this.searchField == null) {
            this.searchField = new JTextField(){
                private static final long serialVersionUID = 1L;

                @Override
                public void paint(Graphics graphics) {
                    super.paint(graphics);
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
                    Icon icon = IconLoader.SearchBox.getIcon();
                    icon.paintIcon(TreePanel.this.searchField, graphics2D, TreePanel.this.searchField.getWidth() - 18, 3);
                    if (TreePanel.this.searchField.getText().trim().length() == 0 && !TreePanel.this.searchField.hasFocus()) {
                        graphics2D.setColor(Color.gray);
                        graphics2D.setFont(TreePanel.this.searchField.getFont());
                        graphics2D.drawString("Search (press Q to jump here)", 4, 3 + TreePanel.this.searchField.getFont().getSize());
                    }
                }
            };
            this.searchField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    TreePanel.this.searchField.repaint();
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    TreePanel.this.searchField.repaint();
                }
            });
            this.searchField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    this.process();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    this.process();
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    this.process();
                }

                public void process() {
                    int n;
                    String string = TreePanel.this.searchField.getText();
                    DefaultTreeModel defaultTreeModel = TreePanel.this.getTreeModel();
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)defaultTreeModel.getRoot();
                    for (n = 0; n < defaultTreeModel.getChildCount(defaultMutableTreeNode); ++n) {
                        boolean bl;
                        Object object;
                        int n2 = 0;
                        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultTreeModel.getChild(defaultMutableTreeNode, n);
                        for (int i = 0; i < defaultTreeModel.getChildCount(defaultMutableTreeNode2); ++i) {
                            ComponentType componentType;
                            object = (DefaultMutableTreeNode)defaultTreeModel.getChild(defaultMutableTreeNode2, i);
                            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
                            if (object2 == null || !object2.getClass().equals(Payload.class)) continue;
                            Payload payload = (Payload)object2;
                            boolean bl2 = false;
                            bl2 = string.trim().length() == 0 ? true : (payload.getComponentType() != null ? (componentType = payload.getComponentType()).getName().toLowerCase().contains(string.toLowerCase()) || componentType.getDescription().toLowerCase().contains(string.toLowerCase()) || componentType.getCategory().toLowerCase().contains(string.toLowerCase()) : payload.toString().toLowerCase().contains(string.toLowerCase()));
                            if (bl2 != payload.isVisible()) {
                                payload.setVisible(bl2);
                                defaultTreeModel.nodeStructureChanged((TreeNode)object);
                            }
                            if (!bl2) continue;
                            ++n2;
                        }
                        Object object3 = defaultMutableTreeNode2.getUserObject();
                        if (object3 == null || !object3.getClass().equals(Payload.class)) continue;
                        object = (Payload)object3;
                        boolean bl3 = bl = n2 > 0;
                        if (bl != ((Payload)object).isVisible()) {
                            ((Payload)object).setVisible(bl);
                            defaultTreeModel.nodeStructureChanged(defaultMutableTreeNode);
                        }
                        if (!bl || string.trim().length() <= 0) continue;
                        TreePanel.this.getTree().expandPath(new TreePath(defaultMutableTreeNode2.getPath()));
                    }
                    for (n = 0; n < defaultTreeModel.getChildCount(defaultMutableTreeNode); ++n) {
                        DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultTreeModel.getChild(defaultMutableTreeNode, n);
                        TreePanel.this.getTree().expandPath(new TreePath(defaultMutableTreeNode3.getPath()));
                    }
                }
            });
        }
        return this.searchField;
    }

    public static class DeleteBlockAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IPlugInPort plugInPort;
        private ISwingUI swingUI;
        private String blockName;

        public DeleteBlockAction(IPlugInPort iPlugInPort, ISwingUI iSwingUI, String string) {
            this.plugInPort = iPlugInPort;
            this.swingUI = iSwingUI;
            this.blockName = string;
            this.putValue("Name", "Delete Building Block");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)(this.getValue("Name") + " triggered"));
            if (this.swingUI.showConfirmDialog("Are you sure you want to delete building block \"" + this.blockName + "\"?", "Delete Building Block", 0, 3) == 0) {
                this.plugInPort.deleteBlock(this.blockName);
            }
        }
    }

    public static class SelectAllAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IPlugInPort plugInPort;
        private ComponentType componentType;

        public SelectAllAction(IPlugInPort iPlugInPort, ComponentType componentType) {
            this.plugInPort = iPlugInPort;
            this.componentType = componentType;
            this.putValue("Name", "Select All");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)(this.getValue("Name") + " triggered"));
            if (this.componentType != null) {
                this.plugInPort.setNewComponentTypeSlot(null, null, false);
                List list = this.plugInPort.getCurrentProject().getComponents();
                ArrayList<IDIYComponent> arrayList = new ArrayList<IDIYComponent>();
                for (IDIYComponent iDIYComponent : list) {
                    if (!this.componentType.getInstanceClass().equals(iDIYComponent.getClass())) continue;
                    arrayList.add(iDIYComponent);
                }
                this.plugInPort.updateSelection(arrayList);
                this.plugInPort.refresh();
            }
        }
    }

    public class Payload {
        private ComponentType componentType;
        private String category;
        private boolean isVisible;
        private MouseListener clickListener;
        private final Pattern contributedPattern = Pattern.compile("^(.*)\\[(.*)\\]");

        public Payload(ComponentType componentType, MouseListener mouseListener) {
            this.componentType = componentType;
            this.clickListener = mouseListener;
            this.isVisible = true;
        }

        public Payload(String string, MouseListener mouseListener) {
            this.category = string;
            this.clickListener = mouseListener;
            this.isVisible = true;
        }

        public ComponentType getComponentType() {
            return this.componentType;
        }

        public boolean isVisible() {
            return this.isVisible;
        }

        public void setVisible(boolean bl) {
            this.isVisible = bl;
        }

        public MouseListener getClickListener() {
            return this.clickListener;
        }

        public String forDisplay() {
            if (this.componentType == null) {
                String string = this.category;
                Matcher matcher = this.contributedPattern.matcher(string);
                if (matcher.find()) {
                    String string2 = matcher.group(1);
                    String string3 = matcher.group(2);
                    string = string2 + "<font color='gray'>[" + string3 + "]</font>";
                }
                return string;
            }
            return this.componentType.getName();
        }

        public String toString() {
            return this.componentType == null ? this.category : this.componentType.getName();
        }
    }

    public class ComponentCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            if (object2 != null && object2.getClass().equals(Payload.class)) {
                Object object3;
                Payload payload = (Payload)object2;
                if (payload.getComponentType() == null) {
                    this.setToolTipText(null);
                    if (bl3) {
                        this.setIcon(IconLoader.Component.getIcon());
                    }
                    if (payload.isVisible()) {
                        this.setPreferredSize(new Dimension(250, 20));
                    } else {
                        this.setPreferredSize(new Dimension(0, 0));
                    }
                } else {
                    this.setToolTipText("<html><b>" + payload.getComponentType().getName() + "</b><br>" + payload.getComponentType().getDescription() + "<br>Author: " + payload.getComponentType().getAuthor() + "<br><br>Left click to instantiate this component, right click for more options" + "</html>");
                    this.setIcon(payload.getComponentType().getIcon());
                    if (payload.isVisible()) {
                        this.setPreferredSize(new Dimension(250, 32));
                    } else {
                        this.setPreferredSize(new Dimension(0, 0));
                    }
                }
                String string = "";
                String string2 = "";
                if (payload.isVisible()) {
                    String string3;
                    object3 = (HashMap)ConfigurationManager.getInstance().readObject(TreePanel.COMPONENT_SHORTCUT_KEY, null);
                    String string4 = string3 = payload.getComponentType() == null ? "block:" + payload.toString() : payload.getComponentType().getInstanceClass().getCanonicalName();
                    if (object3 != null && ((HashMap)object3).containsValue(string3)) {
                        for (String string5 : ((HashMap)object3).keySet()) {
                            if (!((String)((HashMap)object3).get(string5)).equals(string3)) continue;
                            string = " <a style=\"text-shadow: -1px 0 black, 0 1px black, 1px 0 black, 0 -1px black; background-color: #eeeeee; color: #666666;\">&nbsp;" + string5 + "&nbsp;</a>";
                        }
                    }
                }
                if (payload.getComponentType() != null && (object3 = TreePanel.this.plugInPort.getVariantsFor(payload.getComponentType())) != null && !object3.isEmpty()) {
                    string2 = " <a style=\"text-shadow: -1px 0 black, 0 1px black, 1px 0 black, 0 -1px black; background-color: #D7FFC6; color: #666666;\">[+" + object3.size() + "]</a>";
                }
                this.setText("<html>" + payload.forDisplay() + string + string2 + "</html>");
            }
            return this;
        }
    }
}

