/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.appframework.miscutils;

import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.log4j.Logger;
import org.diylc.appframework.miscutils.ClassLoaderUtil;

public class JarScanner {
    private static final Logger LOG = Logger.getLogger(JarScanner.class);
    private static JarScanner instance;

    public static JarScanner getInstance() {
        if (instance == null) {
            instance = new JarScanner();
        }
        return instance;
    }

    private JarScanner() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> extractClassNames(File jar) {
        ArrayList<String> classes = new ArrayList<String>();
        LOG.debug((Object)("Scanning " + jar.getName()));
        try {
            JarInputStream jarFile = new JarInputStream(new FileInputStream(jar));
            try {
                JarEntry jarEntry;
                while ((jarEntry = jarFile.getNextJarEntry()) != null) {
                    if (!jarEntry.getName().endsWith(".class")) continue;
                    String className = jarEntry.getName().replaceAll("/", "\\.");
                    if ((className = className.substring(0, className.lastIndexOf(46))).contains("$")) continue;
                    LOG.trace((Object)("Found " + className));
                    classes.add(className);
                }
            }
            finally {
                jarFile.close();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error extracting class names from the jar.", (Throwable)e);
        }
        return classes;
    }

    public List<File> getJarFiles(File folder, boolean recursive) {
        File[] listOfFiles = folder.listFiles();
        ArrayList<File> jarFiles = new ArrayList<File>();
        for (int i = 0; i < listOfFiles.length; ++i) {
            if (listOfFiles[i].isFile()) {
                if (!listOfFiles[i].getName().toLowerCase().endsWith(".jar")) continue;
                LOG.debug((Object)("Found JAR file: " + listOfFiles[i].getName()));
                jarFiles.add(listOfFiles[i]);
                continue;
            }
            if (!listOfFiles[i].isDirectory() || !recursive) continue;
            jarFiles.addAll(this.getJarFiles(listOfFiles[i], recursive));
        }
        return jarFiles;
    }

    public List<Class<?>> scanFolder(String folderName, Class<?> baseInterface) {
        List<File> jars = this.getJarFiles(new File(folderName), true);
        ArrayList classes = new ArrayList();
        for (File jar : jars) {
            classes.addAll(this.scanJar(jar, baseInterface));
        }
        return classes;
    }

    public List<Class<?>> scanJar(File jar, Class<?> baseInterface) {
        ArrayList classes = new ArrayList();
        List<String> classNames = this.extractClassNames(jar);
        if (!classNames.isEmpty()) {
            String filePath = jar.getAbsolutePath();
            try {
                ClassLoaderUtil.addFile(filePath);
                filePath = "jar:file://" + filePath + "!/";
                URL url = new File(filePath).toURI().toURL();
                URLClassLoader clazzLoader = new URLClassLoader(new URL[]{url});
                for (String className : classNames) {
                    try {
                        Class<?> clazz = clazzLoader.loadClass(className);
                        if (!baseInterface.isAssignableFrom(clazz) || clazz.isInterface()) continue;
                        LOG.debug((Object)("Loaded class: " + className));
                        classes.add(clazz);
                    }
                    catch (ClassNotFoundException e) {
                        LOG.warn((Object)("Class not found: " + className));
                    }
                    catch (Throwable t) {
                        LOG.warn((Object)("Could not load: " + className));
                    }
                }
            }
            catch (Exception e) {
                LOG.warn((Object)"Could not add JAR to the classpath.", (Throwable)e);
            }
        }
        return classes;
    }
}

