/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.chassis;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import org.diylc.common.ObjectCache;
import org.diylc.common.SimpleComponentTransformer;
import org.diylc.components.shapes.AbstractShape;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.annotations.BomPolicy;
import org.diylc.core.annotations.ComponentDescriptor;

@ComponentDescriptor(name="Elliptical Cutout", author="Branislav Stojkovic", category="Electro-Mechanical", instanceNamePrefix="ELC", description="Elliptical chassis cutout", zOrder=1.1, bomPolicy=BomPolicy.NEVER_SHOW, autoEdit=false, transformer=SimpleComponentTransformer.class)
public class EllipticalCutout
extends AbstractShape {
    private static final long serialVersionUID = 1L;

    public EllipticalCutout() {
        this.borderColor = LIGHT_METAL_COLOR.darker();
    }

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke((float)((int)this.borderThickness.convertToPixels())));
        if (componentState != ComponentState.DRAGGING) {
            Composite oldComposite = g2d.getComposite();
            if (this.alpha < MAX_ALPHA) {
                g2d.setComposite(AlphaComposite.getInstance(3, 1.0f * (float)this.alpha / (float)MAX_ALPHA));
            }
            g2d.setColor(this.color);
            g2d.fillOval(this.firstPoint.x, this.firstPoint.y, this.secondPoint.x - this.firstPoint.x, this.secondPoint.y - this.firstPoint.y);
            g2d.setComposite(oldComposite);
        }
        drawingObserver.stopTracking();
        g2d.setColor(componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : this.borderColor);
        g2d.drawOval(this.firstPoint.x, this.firstPoint.y, this.secondPoint.x - this.firstPoint.x, this.secondPoint.y - this.firstPoint.y);
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        int factor = 32 / width;
        g2d.setColor(COLOR);
        g2d.fillOval(2 / factor, 2 / factor, width - 4 / factor, height - 4 / factor);
        g2d.setColor(LIGHT_METAL_COLOR.darker());
        g2d.drawOval(2 / factor, 2 / factor, width - 4 / factor, height - 4 / factor);
    }
}

