/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.connectivity;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import org.diylc.common.ObjectCache;
import org.diylc.common.OrientationHV;
import org.diylc.common.SimpleComponentTransformer;
import org.diylc.components.AbstractTransparentComponent;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.VisibilityPolicy;
import org.diylc.core.annotations.BomPolicy;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;

@ComponentDescriptor(name="Cut Line", category="Connectivity", author="Branislav Stojkovic", description="Cut line", instanceNamePrefix="CL", zOrder=4.0, bomPolicy=BomPolicy.NEVER_SHOW, autoEdit=false, transformer=SimpleComponentTransformer.class)
public class CutLine
extends AbstractTransparentComponent<Void> {
    private static final long serialVersionUID = 1L;
    public static Size WIDTH = new Size(Double.valueOf(0.125), SizeUnit.in);
    public static Size LENGTH = new Size(Double.valueOf(3.125), SizeUnit.in);
    public static Color COLOR = Color.black;
    private Size width = WIDTH;
    private Size length = LENGTH;
    private Color color = COLOR;
    private Point point = new Point(0, 0);
    private OrientationHV orientation = OrientationHV.VERTICAL;

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        int w = this.getClosestOdd((int)this.getWidth().convertToPixels());
        int l = this.getClosestOdd((int)this.getLength().convertToPixels());
        g2d.setColor(componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : this.color);
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke((float)w));
        Composite oldComposite = g2d.getComposite();
        if (this.alpha < MAX_ALPHA) {
            g2d.setComposite(AlphaComposite.getInstance(3, 1.0f * (float)this.alpha / (float)MAX_ALPHA));
        }
        if (this.getOrientation() == OrientationHV.HORIZONTAL) {
            g2d.drawLine(this.point.x, this.point.y, this.point.x + l, this.point.y);
        } else {
            g2d.drawLine(this.point.x, this.point.y, this.point.x, this.point.y + l);
        }
        g2d.setComposite(oldComposite);
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(2.0f));
        g2d.setColor(COLOR);
        g2d.drawLine(width / 2, height - 2, width / 2, 1);
    }

    @EditableProperty
    public Size getWidth() {
        return this.width;
    }

    public void setWidth(Size width) {
        this.width = width;
    }

    @EditableProperty
    public Size getLength() {
        return this.length;
    }

    public void setLength(Size length) {
        this.length = length;
    }

    @EditableProperty
    public OrientationHV getOrientation() {
        return this.orientation;
    }

    public void setOrientation(OrientationHV orientation) {
        this.orientation = orientation;
    }

    public String getName() {
        return super.getName();
    }

    public int getControlPointCount() {
        return 1;
    }

    public boolean isControlPointSticky(int index) {
        return false;
    }

    public VisibilityPolicy getControlPointVisibilityPolicy(int index) {
        return VisibilityPolicy.NEVER;
    }

    public Point getControlPoint(int index) {
        return this.point;
    }

    public void setControlPoint(Point point, int index) {
        this.point.setLocation(point);
    }

    @EditableProperty(name="Color")
    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Void getValue() {
        return null;
    }

    public void setValue(Void value) {
    }

    public String getControlPointNodeName(int index) {
        return null;
    }
}

