/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.connectivity;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import org.diylc.common.Display;
import org.diylc.common.LineStyle;
import org.diylc.common.ObjectCache;
import org.diylc.common.SimpleComponentTransformer;
import org.diylc.components.AbstractLeadedComponent;
import org.diylc.core.ComponentState;
import org.diylc.core.CreationMethod;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.annotations.BomPolicy;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;

@ComponentDescriptor(name="Line", author="Branislav Stojkovic", category="Shapes", creationMethod=CreationMethod.POINT_BY_POINT, instanceNamePrefix="LN", description="Line with optional arrows", zOrder=4.0, bomPolicy=BomPolicy.NEVER_SHOW, autoEdit=false, transformer=SimpleComponentTransformer.class)
public class Line
extends AbstractLeadedComponent<Void> {
    private static final long serialVersionUID = 1L;
    public static Color COLOR = Color.black;
    private Color color = COLOR;
    protected LineStyle style = LineStyle.SOLID;
    private Size thickness = new Size(Double.valueOf(1.0), SizeUnit.px);
    private Size arrowSize = new Size(Double.valueOf(5.0), SizeUnit.px);
    private Polygon arrow = null;
    private AffineTransform arrowTx = new AffineTransform();
    private boolean arrowStart = false;
    private boolean arrowEnd = false;

    public void drawIcon(Graphics2D g2d, int width, int height) {
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
        g2d.setColor(COLOR);
        g2d.drawLine(1, height - 2, width - 2, 1);
    }

    @Override
    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        double distance;
        AffineTransform oldTx;
        double angle;
        float thickness = (float)this.getThickness().convertToPixels();
        Stroke stroke = null;
        switch (this.getStyle()) {
            case SOLID: {
                stroke = ObjectCache.getInstance().fetchZoomableStroke(thickness);
                break;
            }
            case DASHED: {
                stroke = ObjectCache.getInstance().fetchStroke(thickness, new float[]{thickness * 2.0f, thickness * 4.0f}, thickness * 4.0f, 2);
                break;
            }
            case DOTTED: {
                stroke = ObjectCache.getInstance().fetchStroke(thickness, new float[]{thickness, thickness * 5.0f}, 0.0f, 1);
            }
        }
        g2d.setStroke(stroke);
        g2d.setColor(componentState == ComponentState.SELECTED ? SELECTION_COLOR : this.color);
        Point startPoint = new Point(this.getControlPoint(0));
        Point endPoint = new Point(this.getControlPoint(1));
        if (this.arrowStart) {
            this.arrowTx.setToIdentity();
            angle = Math.atan2(this.getControlPoint((int)1).y - this.getControlPoint((int)0).y, this.getControlPoint((int)1).x - this.getControlPoint((int)0).x);
            this.arrowTx.translate(this.getControlPoint((int)0).x, this.getControlPoint((int)0).y);
            this.arrowTx.rotate(angle + 1.5707963267948966);
            oldTx = g2d.getTransform();
            g2d.transform(this.arrowTx);
            g2d.fill(this.getArrow());
            g2d.setTransform(oldTx);
            distance = this.distance(startPoint, endPoint);
            this.interpolate(startPoint, endPoint, this.getArrowSize().convertToPixels() * 0.9 / distance, startPoint);
        }
        if (this.arrowEnd) {
            this.arrowTx.setToIdentity();
            angle = Math.atan2(this.getControlPoint((int)1).y - this.getControlPoint((int)0).y, this.getControlPoint((int)1).x - this.getControlPoint((int)0).x);
            this.arrowTx.translate(this.getControlPoint((int)1).x, this.getControlPoint((int)1).y);
            this.arrowTx.rotate(angle - 1.5707963267948966);
            oldTx = g2d.getTransform();
            g2d.transform(this.arrowTx);
            g2d.fill(this.getArrow());
            g2d.setTransform(oldTx);
            distance = this.distance(startPoint, endPoint);
            this.interpolate(endPoint, startPoint, this.getArrowSize().convertToPixels() * 0.9 / distance, endPoint);
        }
        g2d.drawLine(startPoint.x, startPoint.y, endPoint.x, endPoint.y);
    }

    private void interpolate(Point p1, Point p2, double t, Point p) {
        p.setLocation((int)Math.round((double)p1.x * (1.0 - t) + (double)p2.x * t), (int)Math.round((double)p1.y * (1.0 - t) + (double)p2.y * t));
    }

    private double distance(Point p1, Point p2) {
        return Math.sqrt((p1.x - p2.x) * (p1.x - p2.x) + (p1.y - p2.y) * (p1.y - p2.y));
    }

    @Override
    public Color getLeadColorForPainting(ComponentState componentState) {
        return componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : this.color;
    }

    public Polygon getArrow() {
        if (this.arrow == null) {
            this.arrow = new Polygon();
            int t = (int)this.getArrowSize().convertToPixels();
            this.arrow.addPoint(0, 0);
            this.arrow.addPoint(-t, -t * 2);
            this.arrow.addPoint(t, -t * 2);
        }
        return this.arrow;
    }

    @EditableProperty
    public Size getThickness() {
        if (this.thickness == null) {
            this.thickness = new Size(Double.valueOf(1.0), SizeUnit.px);
        }
        return this.thickness;
    }

    public void setThickness(Size thickness) {
        this.thickness = thickness;
    }

    @EditableProperty
    public Size getArrowSize() {
        if (this.arrowSize == null) {
            this.arrowSize = this.thickness = new Size(Double.valueOf(1.0), SizeUnit.px);
        }
        return this.arrowSize;
    }

    public void setArrowSize(Size arrowSize) {
        this.arrowSize = arrowSize;
        this.arrow = null;
    }

    @Override
    public Color getLeadColor() {
        return super.getLeadColor();
    }

    @EditableProperty
    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    @EditableProperty(name="Style")
    public LineStyle getStyle() {
        if (this.style == null) {
            this.style = LineStyle.SOLID;
        }
        return this.style;
    }

    public void setStyle(LineStyle style) {
        this.style = style;
    }

    @EditableProperty(name="Start Arrow")
    public boolean getArrowStart() {
        return this.arrowStart;
    }

    public void setArrowStart(boolean arrowStart) {
        this.arrowStart = arrowStart;
    }

    @EditableProperty(name="End Arrow")
    public boolean getArrowEnd() {
        return this.arrowEnd;
    }

    public void setArrowEnd(boolean arrowEnd) {
        this.arrowEnd = arrowEnd;
    }

    @Override
    public Color getBodyColor() {
        return super.getBodyColor();
    }

    @Override
    public Color getBorderColor() {
        return super.getBorderColor();
    }

    public Byte getAlpha() {
        return super.getAlpha();
    }

    @Override
    public Size getLength() {
        return super.getLength();
    }

    @Override
    public Size getWidth() {
        return super.getWidth();
    }

    public Void getValue() {
        return null;
    }

    public void setValue(Void value) {
    }

    @Override
    protected Shape getBodyShape() {
        return null;
    }

    @Override
    protected Size getDefaultWidth() {
        return null;
    }

    @Override
    protected Size getDefaultLength() {
        return null;
    }

    @Override
    public String getControlPointNodeName(int index) {
        return null;
    }

    @Override
    @Deprecated
    public Color getLabelColor() {
        return super.getLabelColor();
    }

    @Deprecated
    public String getName() {
        return super.getName();
    }

    @Override
    @Deprecated
    public Display getDisplay() {
        return super.getDisplay();
    }

    @Override
    @Deprecated
    public AbstractLeadedComponent.LabelOriantation getLabelOriantation() {
        return super.getLabelOriantation();
    }
}

