/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.guitar;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import org.diylc.awt.StringUtils;
import org.diylc.common.HorizontalAlignment;
import org.diylc.common.OrientationHV;
import org.diylc.common.VerticalAlignment;
import org.diylc.components.guitar.AbstractGuitarPickup;
import org.diylc.core.Project;
import org.diylc.core.VisibilityPolicy;

public abstract class AbstractSingleOrHumbuckerPickup
extends AbstractGuitarPickup {
    private static final long serialVersionUID = 1L;

    @Override
    protected void drawlTerminalLabels(Graphics2D g2d, Color color, Project project) {
        Point[] points = this.getControlPoints();
        g2d.setColor(color);
        g2d.setFont(project.getFont().deriveFont(11.0f));
        int dx = 0;
        int dy = 0;
        switch (this.orientation) {
            case DEFAULT: {
                dx = this.getControlPointDirection() == OrientationHV.HORIZONTAL ? 0 : 8;
                dy = this.getControlPointDirection() == OrientationHV.HORIZONTAL ? -11 : 0;
                break;
            }
            case _90: {
                dx = this.getControlPointDirection() == OrientationHV.HORIZONTAL ? 11 : 0;
                dy = this.getControlPointDirection() == OrientationHV.HORIZONTAL ? 0 : 8;
                break;
            }
            case _180: {
                dx = this.getControlPointDirection() == OrientationHV.HORIZONTAL ? 0 : -8;
                dy = this.getControlPointDirection() == OrientationHV.HORIZONTAL ? 11 : 0;
                break;
            }
            case _270: {
                dx = this.getControlPointDirection() == OrientationHV.HORIZONTAL ? -11 : 0;
                int n = dy = this.getControlPointDirection() == OrientationHV.HORIZONTAL ? 0 : -8;
            }
        }
        if (this.getPolarity() == AbstractGuitarPickup.Polarity.North || this.getPolarity() == AbstractGuitarPickup.Polarity.South) {
            StringUtils.drawCenteredText(g2d, this.getPolarity().name().substring(0, 1), (points[1].x + points[2].x) / 2 + dx, (points[1].y + points[2].y) / 2 + dy, HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
        } else {
            StringUtils.drawCenteredText(g2d, "N", (points[0].x + points[1].x) / 2 + dx, (points[0].y + points[1].y) / 2 + dy, HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
            StringUtils.drawCenteredText(g2d, "S", (points[2].x + points[3].x) / 2 + dx, (points[2].y + points[3].y) / 2 + dy, HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
        }
    }

    @Override
    public VisibilityPolicy getControlPointVisibilityPolicy(int index) {
        if (this.getPolarity() != AbstractGuitarPickup.Polarity.Humbucking && (index == 0 || index == 3)) {
            return VisibilityPolicy.NEVER;
        }
        return VisibilityPolicy.ALWAYS;
    }

    public boolean isControlPointSticky(int index) {
        return this.getPolarity() == AbstractGuitarPickup.Polarity.Humbucking || index != 0 && index != 3;
    }

    public String getControlPointNodeName(int index) {
        switch (index) {
            case 0: {
                if (this.getPolarity() != AbstractGuitarPickup.Polarity.Humbucking) {
                    return null;
                }
                return "North Start";
            }
            case 1: {
                if (this.getPolarity() == AbstractGuitarPickup.Polarity.South) {
                    return "South Start";
                }
                if (this.getPolarity() == AbstractGuitarPickup.Polarity.North) {
                    return "North Start";
                }
                return "North Finish";
            }
            case 2: {
                if (this.getPolarity() == AbstractGuitarPickup.Polarity.South) {
                    return "South Finish";
                }
                if (this.getPolarity() == AbstractGuitarPickup.Polarity.North) {
                    return "North Finish";
                }
                return "South Start";
            }
            case 3: {
                if (this.getPolarity() != AbstractGuitarPickup.Polarity.Humbucking) {
                    return null;
                }
                return "South Finish";
            }
        }
        return null;
    }

    public String getInternalLinkName(int index1, int index2) {
        switch (this.getPolarity()) {
            case Humbucking: {
                if (index1 == 0 && index2 == 1) {
                    return AbstractGuitarPickup.Polarity.North.toString() + "->";
                }
                if (index1 == 1 && index2 == 0) {
                    return AbstractGuitarPickup.Polarity.North.toString() + "<-";
                }
                if (index1 == 2 && index2 == 3) {
                    return AbstractGuitarPickup.Polarity.South.toString() + "->";
                }
                if (index1 != 3 || index2 != 2) break;
                return AbstractGuitarPickup.Polarity.South.toString() + "<-";
            }
            case North: 
            case South: {
                if (index1 == 1 && index2 == 2) {
                    return this.getPolarity().toString() + "->";
                }
                if (index1 != 2 || index2 != 1) break;
                return this.getPolarity().toString() + "<-";
            }
        }
        return null;
    }

    @Override
    public boolean isHumbucker() {
        return this.getPolarity() == AbstractGuitarPickup.Polarity.Humbucking;
    }
}

