/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.misc;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import org.diylc.awt.StringUtils;
import org.diylc.common.HorizontalAlignment;
import org.diylc.components.AbstractComponent;
import org.diylc.components.transform.TextTransformer;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.VisibilityPolicy;
import org.diylc.core.annotations.BomPolicy;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.annotations.MultiLineText;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;

@ComponentDescriptor(name="Auto-Wrap Label", author="Branislav Stojkovic", category="Misc", description="User defined label with auto-wrapped text", instanceNamePrefix="L", zOrder=5.0, flexibleZOrder=true, bomPolicy=BomPolicy.NEVER_SHOW, transformer=TextTransformer.class)
public class WrapLabel
extends AbstractComponent<String> {
    private static final long serialVersionUID = 1L;
    public static Size DEFAULT_WIDTH = new Size(Double.valueOf(1.5), SizeUnit.in);
    public static Size DEFAULT_HEIGHT = new Size(Double.valueOf(0.5), SizeUnit.in);
    protected Point[] controlPoints = new Point[]{new Point(0, 0), new Point((int)DEFAULT_WIDTH.convertToPixels(), (int)DEFAULT_HEIGHT.convertToPixels())};
    protected Point firstPoint = new Point();
    protected Point secondPoint = new Point();
    private Font font = LABEL_FONT;
    private Color color = LABEL_COLOR;
    private HorizontalAlignment horizontalAlignment = HorizontalAlignment.LEFT;
    private String value = "The quick brown fox jumped over a lazy dog";

    @MultiLineText
    @EditableProperty
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public int getControlPointCount() {
        return 2;
    }

    public Point getControlPoint(int index) {
        return this.controlPoints[index];
    }

    public void setControlPoint(Point point, int index) {
        this.controlPoints[index].setLocation(point);
        this.firstPoint.setLocation(Math.min(this.controlPoints[0].x, this.controlPoints[1].x), Math.min(this.controlPoints[0].y, this.controlPoints[1].y));
        this.secondPoint.setLocation(Math.max(this.controlPoints[0].x, this.controlPoints[1].x), Math.max(this.controlPoints[0].y, this.controlPoints[1].y));
    }

    public boolean isControlPointSticky(int index) {
        return false;
    }

    public VisibilityPolicy getControlPointVisibilityPolicy(int index) {
        return VisibilityPolicy.WHEN_SELECTED;
    }

    @EditableProperty
    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    @EditableProperty(name="Font Bold")
    public boolean getBold() {
        return this.font.isBold();
    }

    public void setBold(boolean bold) {
        this.font = bold ? (this.font.isItalic() ? this.font.deriveFont(3) : this.font.deriveFont(1)) : (this.font.isItalic() ? this.font.deriveFont(2) : this.font.deriveFont(0));
    }

    @EditableProperty(name="Font Italic")
    public boolean getItalic() {
        return this.font.isItalic();
    }

    public void setItalic(boolean italic) {
        this.font = italic ? (this.font.isBold() ? this.font.deriveFont(3) : this.font.deriveFont(2)) : (this.font.isBold() ? this.font.deriveFont(1) : this.font.deriveFont(0));
    }

    @EditableProperty(name="Font Size")
    public int getFontSize() {
        return this.font.getSize();
    }

    public void setFontSize(int size) {
        this.font = this.font.deriveFont((float)size);
    }

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        g2d.setColor(componentState == ComponentState.SELECTED ? LABEL_COLOR_SELECTED : this.color);
        g2d.setFont(this.font);
        int x = this.firstPoint.x;
        int y = this.firstPoint.y;
        int maxWidth = this.secondPoint.x - this.firstPoint.x;
        StringUtils.drawWrappedText(this.value, g2d, x, y, maxWidth, this.horizontalAlignment);
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        g2d.setColor(LABEL_COLOR);
        g2d.setFont(LABEL_FONT.deriveFont(10.0f * (float)width / 32.0f).deriveFont(0));
        FontMetrics fontMetrics = g2d.getFontMetrics();
        Rectangle2D rect = fontMetrics.getStringBounds("Wrap", g2d);
        int textHeight = (int)rect.getHeight();
        int textWidth = (int)rect.getWidth();
        int x = (width - textWidth) / 2 + 1;
        int y = (int)(4.0f * (float)width / 32.0f) + fontMetrics.getAscent();
        g2d.drawString("Wrap", x, y);
        g2d.drawString("Text", x, y += g2d.getFont().getSize());
    }

    @EditableProperty
    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    @EditableProperty(name="Horizontal Alignment")
    public HorizontalAlignment getHorizontalAlignment() {
        if (this.horizontalAlignment == null) {
            this.horizontalAlignment = HorizontalAlignment.CENTER;
        }
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(HorizontalAlignment alignment) {
        this.horizontalAlignment = alignment;
    }
}

