/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.passive;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import org.diylc.common.ObjectCache;
import org.diylc.common.ResistorColorCode;
import org.diylc.common.SimpleComponentTransformer;
import org.diylc.components.AbstractLeadedComponent;
import org.diylc.components.passive.Power;
import org.diylc.core.CreationMethod;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.annotations.PositiveMeasureValidator;
import org.diylc.core.measures.Resistance;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;

@ComponentDescriptor(name="Resistor", author="Branislav Stojkovic", category="Passive", creationMethod=CreationMethod.POINT_BY_POINT, instanceNamePrefix="R", description="Resistor layout symbol", zOrder=4.0, transformer=SimpleComponentTransformer.class)
public class Resistor
extends AbstractLeadedComponent<Resistance> {
    private static final long serialVersionUID = 1L;
    public static Size DEFAULT_WIDTH = new Size(Double.valueOf(0.5), SizeUnit.in);
    public static Size DEFAULT_HEIGHT = new Size(Double.valueOf(0.125), SizeUnit.in);
    public static Color BODY_COLOR = Color.decode("#82CFFD");
    public static Color BORDER_COLOR = BODY_COLOR.darker();
    public static int BAND_SPACING = 5;
    public static int FIRST_BAND = -4;
    private Resistance value = null;
    @Deprecated
    private Power power = Power.HALF;
    private org.diylc.core.measures.Power powerNew = null;
    private ResistorColorCode colorCode = ResistorColorCode._5_BAND;
    private ResistorShape shape = ResistorShape.Standard;

    public Resistor() {
        this.bodyColor = BODY_COLOR;
        this.borderColor = BORDER_COLOR;
    }

    @Override
    protected boolean supportsStandingMode() {
        return true;
    }

    @EditableProperty(validatorClass=PositiveMeasureValidator.class)
    public Resistance getValue() {
        return this.value;
    }

    public void setValue(Resistance value) {
        this.value = value;
    }

    public String getValueForDisplay() {
        return this.getValue().toString() + (this.getPowerNew() == null ? "" : " " + this.getPowerNew().toString());
    }

    @Deprecated
    public Power getPower() {
        return this.power;
    }

    @Deprecated
    public void setPower(Power power) {
        this.power = power;
    }

    @EditableProperty(name="Power Rating")
    public org.diylc.core.measures.Power getPowerNew() {
        return this.powerNew;
    }

    public void setPowerNew(org.diylc.core.measures.Power powerNew) {
        this.powerNew = powerNew;
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        g2d.rotate(-0.7853981633974483, width / 2, height / 2);
        g2d.setColor(LEAD_COLOR_ICON);
        g2d.drawLine(0, height / 2, width, height / 2);
        g2d.setColor(BODY_COLOR);
        Area a = new Area(new Rectangle2D.Double(6.0, height / 2 - 3, width - 14, 6.0));
        a.add(new Area(new Ellipse2D.Double(4.0, height / 2 - 4, 8.0, 8.0)));
        a.add(new Area(new Ellipse2D.Double(width - 12, height / 2 - 4, 8.0, 8.0)));
        g2d.fill(a);
        g2d.setColor(Color.red);
        g2d.drawLine(11, height / 2 - 3, 11, height / 2 + 3);
        g2d.setColor(Color.orange);
        g2d.drawLine(14, height / 2 - 3, 14, height / 2 + 3);
        g2d.setColor(Color.black);
        g2d.drawLine(17, height / 2 - 3, 17, height / 2 + 3);
        g2d.setColor(BORDER_COLOR);
        g2d.draw(a);
    }

    @Override
    protected Size getDefaultWidth() {
        return DEFAULT_HEIGHT;
    }

    @Override
    protected Size getDefaultLength() {
        return DEFAULT_WIDTH;
    }

    @EditableProperty(name="Color code")
    public ResistorColorCode getColorCode() {
        return this.colorCode;
    }

    public void setColorCode(ResistorColorCode colorCode) {
        this.colorCode = colorCode;
    }

    @EditableProperty
    public ResistorShape getShape() {
        if (this.shape == null) {
            this.shape = ResistorShape.Standard;
        }
        return this.shape;
    }

    public void setShape(ResistorShape shape) {
        this.shape = shape;
    }

    @Override
    protected Shape getBodyShape() {
        if (this.getShape() == ResistorShape.Standard) {
            double length = this.getLength().convertToPixels();
            double width = this.getClosestOdd(this.getWidth().convertToPixels());
            Rectangle2D.Double rect = new Rectangle2D.Double(width / 2.0, width / 10.0, length - width, width * 8.0 / 10.0);
            Area a = new Area(rect);
            a.add(new Area(new Ellipse2D.Double(0.0, 0.0, width, width)));
            a.add(new Area(new Ellipse2D.Double(length - width, 0.0, width, width)));
            return a;
        }
        return new Rectangle2D.Double(0.0, 0.0, this.getLength().convertToPixels(), this.getClosestOdd(this.getWidth().convertToPixels()));
    }

    @Override
    protected void decorateComponentBody(Graphics2D g2d, boolean outlineMode) {
        if (this.colorCode == ResistorColorCode.NONE || outlineMode || this.value == null) {
            return;
        }
        Area body = new Area(this.getBodyShape());
        Stroke stroke = ObjectCache.getInstance().fetchZoomableStroke(2.0f);
        int width = this.getClosestOdd(this.getWidth().convertToPixels());
        int x = this.getShape() == ResistorShape.Standard ? width + FIRST_BAND : -FIRST_BAND;
        Color[] bands = this.value.getColorCode(this.colorCode);
        for (int i = 0; i < bands.length; ++i) {
            g2d.setColor(bands[i]);
            Area line = new Area(stroke.createStrokedShape(new Line2D.Double(x, 0.0, x, width)));
            line.intersect(body);
            g2d.fill(line);
            x += BAND_SPACING;
        }
    }

    @Override
    protected int getLabelOffset(int bodyLength, int bodyWidth, int labelLength) {
        if (this.value == null || this.getColorCode() == ResistorColorCode.NONE || this.getLabelOriantation() != AbstractLeadedComponent.LabelOriantation.Directional) {
            return 0;
        }
        Color[] bands = this.value.getColorCode(this.colorCode);
        int bandLenght = FIRST_BAND + BAND_SPACING * (bands.length - 1);
        if (this.getShape() == ResistorShape.Standard ? labelLength < bodyLength - 2 * bodyWidth - bandLenght : labelLength < bodyLength - bandLenght) {
            return bandLenght;
        }
        int bandArea = this.getShape() == ResistorShape.Standard ? bodyWidth + bandLenght : -bandLenght;
        return bandArea / 2;
    }

    @Override
    @EditableProperty(name="Reverse (standing)")
    public boolean getFlipStanding() {
        return super.getFlipStanding();
    }

    public static enum ResistorShape {
        Tubular,
        Standard;

    }
}

