/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.semiconductors;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.awt.StringUtils;
import org.diylc.common.Display;
import org.diylc.common.HorizontalAlignment;
import org.diylc.common.ObjectCache;
import org.diylc.common.Orientation;
import org.diylc.common.VerticalAlignment;
import org.diylc.components.AbstractLeadedComponent;
import org.diylc.components.AbstractTransparentComponent;
import org.diylc.components.RoundedPolygon;
import org.diylc.components.transform.DIL_ICTransformer;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.Theme;
import org.diylc.core.VisibilityPolicy;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.annotations.KeywordPolicy;
import org.diylc.core.measures.Current;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.core.measures.Voltage;
import org.diylc.utils.Constants;

@ComponentDescriptor(name="Bridge Rectifier", author="Branislav Stojkovic", category="Semiconductors", instanceNamePrefix="BR", description="Few variations of bridge rectifier chips", zOrder=4.0, keywordPolicy=KeywordPolicy.SHOW_VALUE, transformer=DIL_ICTransformer.class)
public class BridgeRectifier
extends AbstractTransparentComponent<String> {
    private static final long serialVersionUID = 1L;
    private static Size MINI_LENGTH = new Size(Double.valueOf(6.7), SizeUnit.mm);
    private static Size MINI_WIDTH = new Size(Double.valueOf(8.3), SizeUnit.mm);
    private static Size MINI_HORIZONTAL_SPACING = new Size(Double.valueOf(0.3), SizeUnit.in);
    private static Size MINI_VERTICAL_SPACING = new Size(Double.valueOf(0.2), SizeUnit.in);
    private static int[] MINI1_LABEL_SPACING_X = new int[]{1, -1, -1, 1};
    private static int[] MINI2_LABEL_SPACING_X = new int[]{1, -1, 1, -1};
    private static Size MINI_ROUND_DIAMETER = new Size(Double.valueOf(9.1), SizeUnit.mm);
    private static Size MINI_ROUND_SPACING = new Size(Double.valueOf(0.2), SizeUnit.in);
    private static int[] MINI_ROUND_LABEL_SPACING_Y = new int[]{1, 1, -1, -1};
    private static Size INLINE_LENGTH = new Size(Double.valueOf(23.2), SizeUnit.mm);
    private static Size INLINE_WIDTH = new Size(Double.valueOf(2.7), SizeUnit.mm);
    private static Size INLINE_SPACING = new Size(Double.valueOf(0.2), SizeUnit.in);
    private static int[] INLINE_LABEL_SPACING_Y = new int[]{-1, -1, 1, 1};
    private static Size BR3_LENGTH = new Size(Double.valueOf(0.6), SizeUnit.in);
    private static Size BR3_SPACING = new Size(Double.valueOf(0.425), SizeUnit.in);
    private static Size BR3_HOLE_SIZE = new Size(Double.valueOf(3.0), SizeUnit.mm);
    private static int[] BR3_LABEL_SPACING_Y = new int[]{1, 1, -1, -1};
    public static Color BODY_COLOR = Color.gray;
    public static Color BORDER_COLOR = Color.gray.darker();
    public static Color PIN_COLOR = Color.decode("#00B2EE");
    public static Color PIN_BORDER_COLOR = PIN_COLOR.darker();
    public static Color LABEL_COLOR = Color.white;
    public static int EDGE_RADIUS = 6;
    public static Size SQUARE_PIN_SIZE = new Size(Double.valueOf(0.04), SizeUnit.in);
    public static Size ROUND_PIN_SIZE = new Size(Double.valueOf(0.032), SizeUnit.in);
    public static Size INDENT_SIZE = new Size(Double.valueOf(0.07), SizeUnit.in);
    private String value = "";
    private Orientation orientation = Orientation.DEFAULT;
    private Point[] controlPoints = new Point[]{new Point(0, 0), new Point(0, 0), new Point(0, 0), new Point(0, 0)};
    private String[] pointLabels = new String[]{"+", "~", "~", "-"};
    protected Display display = Display.BOTH;
    private Color bodyColor = BODY_COLOR;
    private Color borderColor = BORDER_COLOR;
    private Color labelColor = LABEL_COLOR;
    private RectifierType rectifierType = RectifierType.MiniDIP1;
    private Voltage voltage;
    private Current current;
    private transient Area[] body;
    private AbstractLeadedComponent.LabelOriantation labelOriantation = AbstractLeadedComponent.LabelOriantation.Directional;

    public BridgeRectifier() {
        this.updateControlPoints();
        this.alpha = (byte)100;
    }

    @EditableProperty
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @EditableProperty
    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
        this.updateControlPoints();
        this.body = null;
    }

    @EditableProperty
    public Display getDisplay() {
        if (this.display == null) {
            this.display = Display.VALUE;
        }
        return this.display;
    }

    public void setDisplay(Display display) {
        this.display = display;
    }

    public int getControlPointCount() {
        return this.controlPoints.length;
    }

    public Point getControlPoint(int index) {
        return this.controlPoints[index];
    }

    public boolean isControlPointSticky(int index) {
        return true;
    }

    public VisibilityPolicy getControlPointVisibilityPolicy(int index) {
        return VisibilityPolicy.NEVER;
    }

    public void setControlPoint(Point point, int index) {
        this.controlPoints[index].setLocation(point);
        this.body = null;
    }

    private void updateControlPoints() {
        Point firstPoint = this.controlPoints[0];
        switch (this.rectifierType) {
            case MiniDIP1: {
                int hSpacing = (int)MINI_HORIZONTAL_SPACING.convertToPixels();
                int vSpacing = (int)MINI_VERTICAL_SPACING.convertToPixels();
                this.controlPoints[1].setLocation(firstPoint.x + hSpacing, firstPoint.y);
                this.controlPoints[2].setLocation(firstPoint.x + hSpacing, firstPoint.y + vSpacing);
                this.controlPoints[3].setLocation(firstPoint.x, firstPoint.y + vSpacing);
                break;
            }
            case MiniDIP2: {
                int hSpacing = (int)MINI_HORIZONTAL_SPACING.convertToPixels();
                int vSpacing = (int)MINI_VERTICAL_SPACING.convertToPixels();
                this.controlPoints[1].setLocation(firstPoint.x + hSpacing, firstPoint.y);
                this.controlPoints[2].setLocation(firstPoint.x, firstPoint.y + vSpacing);
                this.controlPoints[3].setLocation(firstPoint.x + hSpacing, firstPoint.y + vSpacing);
                break;
            }
            case MiniRound1: {
                int vSpacing;
                int hSpacing = vSpacing = (int)MINI_ROUND_SPACING.convertToPixels();
                this.controlPoints[1].setLocation(firstPoint.x + hSpacing, firstPoint.y);
                this.controlPoints[2].setLocation(firstPoint.x + hSpacing, firstPoint.y + vSpacing);
                this.controlPoints[3].setLocation(firstPoint.x, firstPoint.y + vSpacing);
                break;
            }
            case MiniRound2: {
                int vSpacing;
                int hSpacing = vSpacing = (int)MINI_ROUND_SPACING.convertToPixels();
                this.controlPoints[1].setLocation(firstPoint.x + hSpacing, firstPoint.y);
                this.controlPoints[2].setLocation(firstPoint.x, firstPoint.y + vSpacing);
                this.controlPoints[3].setLocation(firstPoint.x + hSpacing, firstPoint.y + vSpacing);
                break;
            }
            case InLine: {
                int vSpacing = (int)INLINE_SPACING.convertToPixels();
                this.controlPoints[1].setLocation(firstPoint.x, firstPoint.y + vSpacing);
                this.controlPoints[2].setLocation(firstPoint.x, firstPoint.y + 2 * vSpacing);
                this.controlPoints[3].setLocation(firstPoint.x, firstPoint.y + 3 * vSpacing);
                break;
            }
            case SquareBR3: {
                int vSpacing;
                int hSpacing = vSpacing = (int)BR3_SPACING.convertToPixels();
                this.controlPoints[1].setLocation(firstPoint.x + hSpacing, firstPoint.y);
                this.controlPoints[2].setLocation(firstPoint.x, firstPoint.y + vSpacing);
                this.controlPoints[3].setLocation(firstPoint.x + hSpacing, firstPoint.y + vSpacing);
            }
        }
        if (this.orientation != Orientation.DEFAULT) {
            double theta = 0.0;
            switch (this.orientation) {
                case _90: {
                    theta = 1.5707963267948966;
                    break;
                }
                case _180: {
                    theta = Math.PI;
                    break;
                }
                case _270: {
                    theta = 4.71238898038469;
                }
            }
            AffineTransform rotation = AffineTransform.getRotateInstance(theta, firstPoint.x, firstPoint.y);
            for (int i = 1; i < this.controlPoints.length; ++i) {
                rotation.transform(this.controlPoints[i], this.controlPoints[i]);
            }
        }
    }

    public Area[] getBody() {
        if (this.body == null) {
            this.body = new Area[2];
            int centerX = (this.controlPoints[0].x + this.controlPoints[1].x + this.controlPoints[2].x + this.controlPoints[3].x) / 4;
            int centerY = (this.controlPoints[0].y + this.controlPoints[1].y + this.controlPoints[2].y + this.controlPoints[3].y) / 4;
            int width = 0;
            int length = 0;
            switch (this.rectifierType) {
                case MiniDIP1: 
                case MiniDIP2: {
                    length = (int)MINI_LENGTH.convertToPixels();
                    width = (int)MINI_WIDTH.convertToPixels();
                    break;
                }
                case MiniRound1: 
                case MiniRound2: {
                    length = width = (int)MINI_ROUND_DIAMETER.convertToPixels();
                    break;
                }
                case InLine: {
                    length = (int)INLINE_WIDTH.convertToPixels();
                    width = (int)INLINE_LENGTH.convertToPixels();
                    break;
                }
                case SquareBR3: {
                    length = width = (int)BR3_LENGTH.convertToPixels();
                }
            }
            if (this.orientation == Orientation._90 || this.orientation == Orientation._270) {
                int p = length;
                length = width;
                width = p;
            }
            switch (this.rectifierType) {
                case MiniDIP1: 
                case MiniDIP2: 
                case InLine: {
                    this.body[0] = new Area(new RoundRectangle2D.Double(centerX - length / 2, centerY - width / 2, length, width, EDGE_RADIUS, EDGE_RADIUS));
                    break;
                }
                case MiniRound1: 
                case MiniRound2: {
                    this.body[0] = new Area(new Ellipse2D.Double(centerX - length / 2, centerY - width / 2, length, width));
                    break;
                }
                case SquareBR3: {
                    double margin = (BR3_LENGTH.convertToPixels() - BR3_SPACING.convertToPixels()) / 2.0;
                    double holeSize = BR3_HOLE_SIZE.convertToPixels();
                    RoundedPolygon poly = new RoundedPolygon(new Point[]{new Point(centerX, centerY - width / 2), new Point(centerX + width / 2, centerY - width / 2), new Point(centerX + width / 2, centerY + width / 2), new Point(centerX - width / 2, centerY + width / 2), new Point(centerX - width / 2, (int)((double)(centerY - width / 2) + margin)), new Point((int)((double)(centerX - width / 2) + margin), centerY - width / 2)}, new double[]{EDGE_RADIUS, EDGE_RADIUS, EDGE_RADIUS, EDGE_RADIUS / 2, EDGE_RADIUS / 2});
                    this.body[0] = new Area(poly);
                    this.body[0].subtract(new Area(new Ellipse2D.Double((double)centerX - holeSize / 2.0, (double)centerY - holeSize / 2.0, holeSize, holeSize)));
                    if (this.orientation == Orientation.DEFAULT) break;
                    double theta = 0.0;
                    switch (this.orientation) {
                        case _90: {
                            theta = 1.5707963267948966;
                            break;
                        }
                        case _180: {
                            theta = Math.PI;
                            break;
                        }
                        case _270: {
                            theta = 4.71238898038469;
                        }
                    }
                    AffineTransform rotation = AffineTransform.getRotateInstance(theta, centerX, centerY);
                    this.body[0].transform(rotation);
                }
            }
        }
        return this.body;
    }

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        Color finalLabelColor;
        Color finalBorderColor;
        if (this.checkPointsClipped(g2d.getClip())) {
            return;
        }
        Area mainArea = this.getBody()[0];
        PinShape pinShape = this.rectifierType.getPinShape();
        int pinSize = (int)(pinShape == PinShape.Round ? ROUND_PIN_SIZE.convertToPixels() : SQUARE_PIN_SIZE.convertToPixels()) / 2 * 2;
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
        if (!outlineMode) {
            for (Point point : this.controlPoints) {
                g2d.setColor(PIN_COLOR);
                if (pinShape == PinShape.Round) {
                    g2d.fillOval(point.x - pinSize / 2, point.y - pinSize / 2, pinSize, pinSize);
                } else {
                    g2d.fillRect(point.x - pinSize / 2, point.y - pinSize / 2, pinSize, pinSize);
                }
                g2d.setColor(PIN_BORDER_COLOR);
                if (pinShape == PinShape.Round) {
                    g2d.drawOval(point.x - pinSize / 2, point.y - pinSize / 2, pinSize, pinSize);
                    continue;
                }
                g2d.drawRect(point.x - pinSize / 2, point.y - pinSize / 2, pinSize, pinSize);
            }
        }
        Composite oldComposite = g2d.getComposite();
        if (this.alpha < MAX_ALPHA) {
            g2d.setComposite(AlphaComposite.getInstance(3, 1.0f * (float)this.alpha / (float)MAX_ALPHA));
        }
        g2d.setColor(outlineMode ? Constants.TRANSPARENT_COLOR : this.getBodyColor());
        g2d.fill(mainArea);
        g2d.setComposite(oldComposite);
        if (outlineMode) {
            Theme theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
            finalBorderColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : theme.getOutlineColor();
        } else {
            finalBorderColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : this.getBorderColor();
        }
        g2d.setColor(finalBorderColor);
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
        if (outlineMode) {
            Area area = new Area(mainArea);
            area.subtract(this.getBody()[1]);
            g2d.draw(area);
        } else {
            g2d.draw(mainArea);
        }
        drawingObserver.stopTracking();
        g2d.setFont(project.getFont());
        if (outlineMode) {
            Theme theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
            finalLabelColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? LABEL_COLOR_SELECTED : theme.getOutlineColor();
        } else {
            finalLabelColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? LABEL_COLOR_SELECTED : this.getLabelColor();
        }
        g2d.setColor(finalLabelColor);
        FontMetrics fontMetrics = g2d.getFontMetrics(g2d.getFont());
        String[] label = null;
        if (this.getDisplay() == Display.NAME) {
            label = new String[]{this.getName()};
        } else if (this.getDisplay() == Display.VALUE) {
            label = new String[]{this.getValue().toString()};
        } else if (this.getDisplay() == Display.BOTH) {
            String[] stringArray;
            String value = this.getValue().toString();
            if (value.isEmpty()) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = this.getName();
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = this.getName();
                stringArray = stringArray3;
                stringArray3[1] = value;
            }
            label = stringArray;
        }
        if (label != null) {
            for (int i = 0; i < label.length; ++i) {
                String l = label[i];
                Rectangle2D rect = fontMetrics.getStringBounds(l, g2d);
                int textHeight = (int)rect.getHeight();
                int textWidth = (int)rect.getWidth();
                Rectangle bounds = mainArea.getBounds();
                int x = bounds.x + (bounds.width - textWidth) / 2;
                int y = bounds.y + (bounds.height - textHeight) / 2 + fontMetrics.getAscent();
                AffineTransform oldTransform = g2d.getTransform();
                if (this.getLabelOriantation() == AbstractLeadedComponent.LabelOriantation.Directional && (this.getOrientation() == Orientation.DEFAULT || this.getOrientation() == Orientation._180)) {
                    int centerX = bounds.x + bounds.width / 2;
                    int centerY = bounds.y + bounds.height / 2;
                    g2d.rotate(-1.5707963267948966, centerX, centerY);
                }
                if (label.length == 2) {
                    if (i == 0) {
                        g2d.translate(0, -textHeight / 2);
                    } else if (i == 1) {
                        g2d.translate(0, textHeight / 2);
                    }
                }
                if (this.rectifierType == RectifierType.SquareBR3) {
                    y = (int)((double)y - BR3_HOLE_SIZE.convertToPixels());
                }
                g2d.drawString(l, x, y);
                g2d.setTransform(oldTransform);
            }
        }
        g2d.setFont(project.getFont().deriveFont((float)((double)project.getFont().getSize2D() * 0.8)));
        g2d.setColor(finalLabelColor);
        for (int i = 0; i < this.controlPoints.length; ++i) {
            Point point = this.controlPoints[i];
            int dx = 0;
            int dy = 0;
            switch (this.rectifierType) {
                case MiniDIP1: {
                    dx = pinSize * MINI1_LABEL_SPACING_X[i];
                    break;
                }
                case MiniDIP2: {
                    dx = pinSize * MINI2_LABEL_SPACING_X[i];
                    break;
                }
                case MiniRound1: 
                case MiniRound2: {
                    dy = pinSize * MINI_ROUND_LABEL_SPACING_Y[i];
                    break;
                }
                case InLine: {
                    dy = pinSize * INLINE_LABEL_SPACING_Y[i];
                    break;
                }
                case SquareBR3: {
                    dy = pinSize * BR3_LABEL_SPACING_Y[i];
                }
            }
            dx = (int)(1.5 * (double)dx);
            dy = (int)(1.5 * (double)dy);
            block7 : switch (this.rectifierType) {
                case MiniDIP1: 
                case MiniDIP2: {
                    int p2;
                    int p1;
                    switch (this.orientation) {
                        case _90: {
                            p1 = dx;
                            dx = dy;
                            dy = p1;
                            break;
                        }
                        case _180: {
                            dx = -dx;
                            dy = -dy;
                            break;
                        }
                        case _270: {
                            p2 = dx;
                            dx = -dy;
                            dy = -p2;
                        }
                    }
                    break;
                }
                case MiniRound1: 
                case MiniRound2: 
                case SquareBR3: {
                    int p2;
                    int p1;
                    switch (this.orientation) {
                        case _90: {
                            p1 = dx;
                            dx = -dy;
                            dy = -p1;
                            break;
                        }
                        case _180: {
                            dx = -dx;
                            dy = -dy;
                            break;
                        }
                        case _270: {
                            p2 = dx;
                            dx = dy;
                            dy = p2;
                        }
                    }
                    break;
                }
                case InLine: {
                    int p2;
                    int p1;
                    switch (this.orientation) {
                        case _90: {
                            p1 = dx;
                            dx = -dy;
                            dy = -p1;
                            break block7;
                        }
                        case _180: {
                            dx = -dx;
                            dy = -dy;
                            break block7;
                        }
                        case _270: {
                            p2 = dx;
                            dx = dy;
                            dy = p2;
                        }
                    }
                }
            }
            StringUtils.drawCenteredText(g2d, this.pointLabels[i], point.x + dx, point.y + dy, HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
        }
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        int margin = (int)(2.0f * (float)width / 32.0f);
        Area area = new Area(new Ellipse2D.Double(margin / 2, margin, width - 2 * margin, width - 2 * margin));
        g2d.setColor(BODY_COLOR);
        g2d.fill(area);
        g2d.setColor(BORDER_COLOR);
        g2d.draw(area);
        g2d.setColor(PIN_COLOR);
        int pinSize = 2 * width / 32;
        g2d.fillOval(width * 2 / 8, height * 2 / 8, pinSize, pinSize);
        g2d.fillOval(width * 6 / 8 - pinSize, height * 2 / 8, pinSize, pinSize);
        g2d.fillOval(width * 6 / 8 - pinSize, height * 6 / 8 - pinSize, pinSize, pinSize);
        g2d.fillOval(width * 2 / 8, height * 6 / 8 - pinSize, pinSize, pinSize);
        g2d.setColor(LABEL_COLOR);
        g2d.setFont(LABEL_FONT.deriveFont(8.0f * (float)width / 32.0f));
        StringUtils.drawCenteredText(g2d, "+", width * 2 / 8 + 1, height * 2 / 8 + 4 * width / 32, HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
        StringUtils.drawCenteredText(g2d, "-", width * 2 / 8 + 1, height * 6 / 8 - 5 * width / 32, HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
        StringUtils.drawCenteredText(g2d, "~", width * 6 / 8 - 2 * width / 32, height * 2 / 8 + 5 * width / 32, HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
        StringUtils.drawCenteredText(g2d, "~", width * 6 / 8 - 2 * width / 32, height * 6 / 8 - 5 * width / 32, HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
    }

    @EditableProperty(name="Body")
    public Color getBodyColor() {
        if (this.bodyColor == null) {
            this.bodyColor = BODY_COLOR;
        }
        return this.bodyColor;
    }

    public void setBodyColor(Color bodyColor) {
        this.bodyColor = bodyColor;
    }

    @EditableProperty(name="Border")
    public Color getBorderColor() {
        if (this.borderColor == null) {
            this.borderColor = BORDER_COLOR;
        }
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    @EditableProperty(name="Label")
    public Color getLabelColor() {
        if (this.labelColor == null) {
            this.labelColor = LABEL_COLOR;
        }
        return this.labelColor;
    }

    public void setLabelColor(Color labelColor) {
        this.labelColor = labelColor;
    }

    @EditableProperty(name="Type")
    public RectifierType getRectifierType() {
        return this.rectifierType;
    }

    public void setRectifierType(RectifierType rectifierType) {
        this.rectifierType = rectifierType;
        this.updateControlPoints();
        this.body = null;
    }

    @EditableProperty
    public Current getCurrent() {
        return this.current;
    }

    public void setCurrent(Current current) {
        this.current = current;
    }

    @EditableProperty
    public Voltage getVoltage() {
        return this.voltage;
    }

    public void setVoltage(Voltage voltage) {
        this.voltage = voltage;
    }

    @EditableProperty(name="Label Orientation")
    public AbstractLeadedComponent.LabelOriantation getLabelOriantation() {
        if (this.labelOriantation == null) {
            this.labelOriantation = AbstractLeadedComponent.LabelOriantation.Directional;
        }
        return this.labelOriantation;
    }

    public void setLabelOriantation(AbstractLeadedComponent.LabelOriantation labelOriantation) {
        this.labelOriantation = labelOriantation;
    }

    public boolean canPointMoveFreely(int pointIndex) {
        return false;
    }

    private static enum PinShape {
        Square,
        Round;

    }

    public static enum RectifierType {
        MiniDIP1("DFM A", PinShape.Square),
        MiniDIP2("DFM B", PinShape.Square),
        MiniRound1("Round WOG A", PinShape.Round),
        MiniRound2("Round WOG B", PinShape.Round),
        InLine("In-Line D-44", PinShape.Round),
        SquareBR3("Square BR-3", PinShape.Round);

        private String label;
        private PinShape pinShape;

        private RectifierType(String label, PinShape pinShape) {
            this.label = label;
            this.pinShape = pinShape;
        }

        public String toString() {
            return this.label;
        }

        public PinShape getPinShape() {
            return this.pinShape;
        }
    }
}

