/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.semiconductors;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import org.diylc.common.ObjectCache;
import org.diylc.components.Abstract3LegSymbol;
import org.diylc.components.semiconductors.FETPolarity;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.annotations.KeywordPolicy;

@ComponentDescriptor(name="JFET", author="Branislav Stojkovic", category="Schematic Symbols", instanceNamePrefix="Q", description="JFET transistor schematic symbol", zOrder=4.0, keywordPolicy=KeywordPolicy.SHOW_TAG_AND_VALUE, keywordTag="Schematic")
public class JFETSymbol
extends Abstract3LegSymbol {
    private static final long serialVersionUID = 1L;
    protected FETPolarity polarity = FETPolarity.NEGATIVE;

    @Override
    public Shape[] getBody() {
        Shape[] body = new Shape[3];
        Point[] controlPoints = this.getControlPoints();
        int x = controlPoints[0].x;
        int y = controlPoints[0].y;
        int pinSpacing = (int)PIN_SPACING.convertToPixels();
        GeneralPath polyline = new GeneralPath();
        polyline.moveTo(x + pinSpacing, y - pinSpacing);
        polyline.lineTo(x + pinSpacing, y + pinSpacing);
        body[0] = polyline;
        polyline = new GeneralPath();
        polyline.moveTo(x, y);
        polyline.lineTo(x + pinSpacing, y);
        polyline.moveTo(x + pinSpacing, y - pinSpacing * 7 / 8);
        polyline.lineTo(x + pinSpacing * 2, y - pinSpacing * 7 / 8);
        polyline.lineTo(x + pinSpacing * 2, y - pinSpacing * 2);
        polyline.moveTo(x + pinSpacing, y + pinSpacing * 7 / 8);
        polyline.lineTo(x + pinSpacing * 2, y + pinSpacing * 7 / 8);
        polyline.lineTo(x + pinSpacing * 2, y + pinSpacing * 2);
        body[1] = polyline;
        Polygon arrow = this.polarity == FETPolarity.NEGATIVE ? new Polygon(new int[]{x + pinSpacing * 2 / 6, x + pinSpacing * 2 / 6, x + pinSpacing * 6 / 6}, new int[]{y - pinSpacing / 5, y + pinSpacing / 5, y}, 3) : new Polygon(new int[]{x + pinSpacing / 6, x + pinSpacing * 5 / 6, x + pinSpacing * 5 / 6}, new int[]{y, y + pinSpacing / 5, y - pinSpacing / 5}, 3);
        body[2] = arrow;
        return body;
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        g2d.setColor(COLOR);
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(2.0f));
        g2d.drawLine(width / 2, height / 5, width / 2, height * 4 / 5);
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
        g2d.drawLine(width / 5, height / 2, width / 2, height / 2);
        g2d.drawLine(width * 3 / 4, 1, width * 3 / 4, height / 4);
        g2d.drawLine(width / 2, height / 4, width * 3 / 4, height / 4);
        g2d.drawLine(width * 3 / 4, height - 1, width * 3 / 4, height * 3 / 4);
        g2d.drawLine(width / 2, height * 3 / 4, width * 3 / 4, height * 3 / 4);
    }

    @EditableProperty(name="Channel")
    public FETPolarity getPolarity() {
        return this.polarity;
    }

    public void setPolarity(FETPolarity polarity) {
        this.polarity = polarity;
        this.body = null;
    }
}

