/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.shapes;

import java.awt.Color;
import java.awt.Point;
import org.diylc.components.AbstractTransparentComponent;
import org.diylc.core.VisibilityPolicy;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.annotations.PositiveMeasureValidator;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;

public abstract class AbstractShape
extends AbstractTransparentComponent<Void> {
    private static final long serialVersionUID = 1L;
    public static Color COLOR = Color.white;
    public static Color BORDER_COLOR = Color.black;
    public static Size DEFAULT_WIDTH = new Size(Double.valueOf(0.6), SizeUnit.in);
    public static Size DEFAULT_HEIGHT = new Size(Double.valueOf(0.4), SizeUnit.in);
    protected String value = "";
    protected Point[] controlPoints = new Point[]{new Point(0, 0), new Point((int)DEFAULT_WIDTH.convertToPixels(), (int)DEFAULT_HEIGHT.convertToPixels())};
    protected Point firstPoint = new Point();
    protected Point secondPoint = new Point();
    protected Color color = COLOR;
    protected Color borderColor = BORDER_COLOR;
    protected Size borderThickness = new Size(Double.valueOf(0.2), SizeUnit.mm);

    @EditableProperty(name="Color")
    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    @EditableProperty(name="Border")
    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    @EditableProperty(name="Border Thickness", validatorClass=PositiveMeasureValidator.class)
    public Size getBorderThickness() {
        return this.borderThickness;
    }

    public void setBorderThickness(Size borderThickness) {
        this.borderThickness = borderThickness;
    }

    public int getControlPointCount() {
        return this.controlPoints.length;
    }

    public Point getControlPoint(int index) {
        return this.controlPoints[index];
    }

    public boolean isControlPointSticky(int index) {
        return false;
    }

    public VisibilityPolicy getControlPointVisibilityPolicy(int index) {
        return VisibilityPolicy.WHEN_SELECTED;
    }

    public void setControlPoint(Point point, int index) {
        this.controlPoints[index].setLocation(point);
        this.firstPoint.setLocation(Math.min(this.controlPoints[0].x, this.controlPoints[1].x), Math.min(this.controlPoints[0].y, this.controlPoints[1].y));
        this.secondPoint.setLocation(Math.max(this.controlPoints[0].x, this.controlPoints[1].x), Math.max(this.controlPoints[0].y, this.controlPoints[1].y));
    }

    public String getControlPointNodeName(int index) {
        return null;
    }

    @Deprecated
    public Void getValue() {
        return null;
    }

    @Deprecated
    public void setValue(Void value) {
    }
}

