/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.transform;

import java.awt.Point;
import java.awt.geom.AffineTransform;
import org.diylc.common.IComponentTransformer;
import org.diylc.common.Orientation;
import org.diylc.components.semiconductors.DIL_IC;
import org.diylc.core.IDIYComponent;

public class DIL_ICTransformer
implements IComponentTransformer {
    public boolean canRotate(IDIYComponent<?> component) {
        return component.getClass().equals(DIL_IC.class);
    }

    public boolean canMirror(IDIYComponent<?> component) {
        return component.getClass().equals(DIL_IC.class);
    }

    public boolean mirroringChangesCircuit() {
        return true;
    }

    public void rotate(IDIYComponent<?> component, Point center, int direction) {
        AffineTransform rotate = AffineTransform.getRotateInstance(1.5707963267948966 * (double)direction, center.x, center.y);
        for (int index = 0; index < component.getControlPointCount(); ++index) {
            Point p = new Point(component.getControlPoint(index));
            rotate.transform(p, p);
            component.setControlPoint(p, index);
        }
        DIL_IC ic = (DIL_IC)component;
        Orientation o = ic.getOrientation();
        int oValue = o.ordinal();
        if ((oValue += direction) < 0) {
            oValue = Orientation.values().length - 1;
        }
        if (oValue >= Orientation.values().length) {
            oValue = 0;
        }
        o = Orientation.values()[oValue];
        ic.setOrientation(o);
    }

    public void mirror(IDIYComponent<?> component, Point center, int direction) {
        DIL_IC ic = (DIL_IC)component;
        if (direction == 0) {
            int dx = 2 * (center.x - ic.getControlPoint((int)1).x);
            int dy = 0;
            Orientation o = ic.getOrientation();
            switch (o) {
                case DEFAULT: {
                    dx += ic.getControlPoint((int)0).x - ic.getControlPoint((int)(ic.getControlPointCount() - 1)).x;
                    break;
                }
                case _90: {
                    o = Orientation._270;
                    dx -= 2 * (ic.getControlPoint((int)0).x - ic.getControlPoint((int)1).x);
                    dy -= ic.getControlPoint((int)0).y - ic.getControlPoint((int)(ic.getControlPointCount() - 1)).y;
                    break;
                }
                case _180: {
                    dx += ic.getControlPoint((int)0).x - ic.getControlPoint((int)(ic.getControlPointCount() - 1)).x;
                    break;
                }
                case _270: {
                    dx -= 2 * (ic.getControlPoint((int)0).x - ic.getControlPoint((int)1).x);
                    dy -= ic.getControlPoint((int)0).y - ic.getControlPoint((int)(ic.getControlPointCount() - 1)).y;
                    o = Orientation._90;
                }
            }
            for (int i = 0; i < ic.getControlPointCount(); ++i) {
                Point p = ic.getControlPoint(i);
                ic.setControlPoint(new Point(p.x + dx, p.y + dy), i);
            }
            ic.setOrientation(o);
        } else {
            int dx = 0;
            int dy = 2 * (center.y - ic.getControlPoint((int)1).y);
            Orientation o = ic.getOrientation();
            switch (o) {
                case DEFAULT: {
                    dx -= ic.getControlPoint((int)0).x - ic.getControlPoint((int)(ic.getControlPointCount() - 1)).x;
                    dy -= 2 * (ic.getControlPoint((int)0).y - ic.getControlPoint((int)1).y);
                    o = Orientation._180;
                    break;
                }
                case _90: {
                    dy += ic.getControlPoint((int)0).y - ic.getControlPoint((int)(ic.getControlPointCount() - 1)).y;
                    break;
                }
                case _180: {
                    dx -= ic.getControlPoint((int)0).x - ic.getControlPoint((int)(ic.getControlPointCount() - 1)).x;
                    dy -= 2 * (ic.getControlPoint((int)0).y - ic.getControlPoint((int)1).y);
                    o = Orientation.DEFAULT;
                    break;
                }
                case _270: {
                    dy += ic.getControlPoint((int)0).y - ic.getControlPoint((int)(ic.getControlPointCount() - 1)).y;
                }
            }
            for (int i = 0; i < ic.getControlPointCount(); ++i) {
                Point p = ic.getControlPoint(i);
                ic.setControlPoint(new Point(p.x + dx, p.y + dy), i);
            }
            ic.setOrientation(o);
        }
    }
}

