/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.tube;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.awt.StringUtils;
import org.diylc.common.HorizontalAlignment;
import org.diylc.common.ObjectCache;
import org.diylc.common.Orientation;
import org.diylc.common.VerticalAlignment;
import org.diylc.components.AbstractTransparentComponent;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.Theme;
import org.diylc.core.VisibilityPolicy;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.annotations.KeywordPolicy;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.utils.Constants;

@ComponentDescriptor(name="Tube Socket", author="Branislav Stojkovic", category="Tubes", instanceNamePrefix="V", description="Various types of tube/valve sockets", zOrder=4.0, keywordPolicy=KeywordPolicy.SHOW_VALUE)
public class TubeSocket
extends AbstractTransparentComponent<String> {
    private static final Size B9A_PIN_SPACING_CHASSIS = new Size(Double.valueOf(12.5), SizeUnit.mm);
    private static final Size B9A_PIN_SPACING_PCB = new Size(Double.valueOf(21.0), SizeUnit.mm);
    private static final Size OCTAL_PIN_SPACING = new Size(Double.valueOf(17.5), SizeUnit.mm);
    private static final Size B7G_PIN_SPACING = new Size(Double.valueOf(12.0), SizeUnit.mm);
    private static final Size B7G_CUTOUT_DIAMETER = new Size(Double.valueOf(4.0), SizeUnit.mm);
    private static final Size B9A_CUTOUT_DIAMETER = new Size(Double.valueOf(5.5), SizeUnit.mm);
    private static final Size OCTAL_DIAMETER = new Size(Double.valueOf(25.0), SizeUnit.mm);
    private static final Size B9A_DIAMETER = new Size(Double.valueOf(0.75), SizeUnit.in);
    private static final Size B7G_DIAMETER = new Size(Double.valueOf(17.0), SizeUnit.mm);
    private static final long serialVersionUID = 1L;
    private static Color BODY_COLOR = Color.decode("#F7F7EF");
    private static Color LABEL_COLOR = BODY_COLOR.darker();
    public static Color PIN_COLOR = Color.decode("#00B2EE");
    public static Color PIN_BORDER_COLOR = PIN_COLOR.darker();
    public static Size PIN_DIAMETER = new Size(Double.valueOf(1.0), SizeUnit.mm);
    private static Size PIN_WIDTH = new Size(Double.valueOf(0.08), SizeUnit.in);
    private static Size PIN_THICKNESS = new Size(Double.valueOf(0.02), SizeUnit.in);
    public static Size HOLE_SIZE = new Size(Double.valueOf(5.0), SizeUnit.mm);
    public static Size OCTAL_TICK_SIZE = new Size(Double.valueOf(2.0), SizeUnit.mm);
    private Base base = Base.B9A;
    private String type = "";
    @Deprecated
    private Orientation orientation;
    private int angle;
    private Color color = BODY_COLOR;
    private String electrodeLabels = null;
    private Mount mount = null;
    private Color labelColor = LABEL_COLOR;
    private Point[] controlPoints = new Point[]{new Point(0, 0)};
    private transient Shape body;

    public TubeSocket() {
        this.updateControlPoints();
    }

    @EditableProperty
    public Base getBase() {
        return this.base;
    }

    public void setBase(Base base) {
        this.base = base;
        this.updateControlPoints();
        this.body = null;
    }

    @EditableProperty
    public int getAngle() {
        if (this.orientation != null) {
            switch (this.orientation) {
                case _90: {
                    this.angle = 90;
                    break;
                }
                case _180: {
                    this.angle = 180;
                    break;
                }
                case _270: {
                    this.angle = 270;
                }
            }
            this.orientation = null;
        }
        return this.angle;
    }

    public void setAngle(int angle) {
        this.angle = angle;
        this.updateControlPoints();
        this.body = null;
    }

    @EditableProperty
    public Color getColor() {
        if (this.color == null) {
            this.color = BODY_COLOR;
        }
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    private void updateControlPoints() {
        boolean hasEmptySpace;
        int pinSpacing;
        int pinCount;
        Point firstPoint = this.controlPoints[0];
        switch (this.base) {
            case B7G: {
                pinCount = 7;
                pinSpacing = this.getClosestOdd(B7G_PIN_SPACING.convertToPixels());
                hasEmptySpace = true;
                break;
            }
            case OCTAL: {
                pinCount = 8;
                pinSpacing = this.getClosestOdd(OCTAL_PIN_SPACING.convertToPixels());
                hasEmptySpace = false;
                break;
            }
            case B9A: {
                pinCount = 9;
                pinSpacing = this.getClosestOdd(this.getMount() == Mount.PCB ? B9A_PIN_SPACING_PCB.convertToPixels() : B9A_PIN_SPACING_CHASSIS.convertToPixels());
                hasEmptySpace = true;
                break;
            }
            default: {
                throw new RuntimeException("Unexpected base: " + (Object)((Object)this.base));
            }
        }
        double angleIncrement = Math.PI * 2 / (double)(hasEmptySpace ? pinCount + 1 : pinCount);
        double initialAngleOffset = hasEmptySpace ? angleIncrement : angleIncrement / 2.0;
        this.controlPoints = new Point[pinCount + 1];
        double theta = initialAngleOffset + Math.toRadians(this.getAngle());
        this.controlPoints[0] = firstPoint;
        for (int i = 0; i < pinCount; ++i) {
            this.controlPoints[i + 1] = new Point((int)(firstPoint.getX() + Math.cos(theta) * (double)pinSpacing / 2.0), (int)(firstPoint.getY() + Math.sin(theta) * (double)pinSpacing / 2.0));
            theta += angleIncrement;
        }
    }

    public Shape getBody() {
        if (this.body == null) {
            int bodyDiameter;
            switch (this.base) {
                case B7G: {
                    bodyDiameter = this.getClosestOdd(B7G_DIAMETER.convertToPixels());
                    break;
                }
                case B9A: {
                    bodyDiameter = this.getClosestOdd(B9A_DIAMETER.convertToPixels());
                    break;
                }
                case OCTAL: {
                    bodyDiameter = this.getClosestOdd(OCTAL_DIAMETER.convertToPixels());
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected base: " + (Object)((Object)this.base));
                }
            }
            this.body = new Ellipse2D.Double(this.controlPoints[0].x - bodyDiameter / 2, this.controlPoints[0].y - bodyDiameter / 2, bodyDiameter, bodyDiameter);
            Area bodyArea = new Area(this.body);
            int holeSize = this.getClosestOdd(HOLE_SIZE.convertToPixels());
            bodyArea.subtract(new Area(new Ellipse2D.Double(this.controlPoints[0].x - holeSize / 2, this.controlPoints[0].y - holeSize / 2, holeSize, holeSize)));
            if (this.base == Base.OCTAL) {
                int tickSize = this.getClosestOdd(OCTAL_TICK_SIZE.convertToPixels());
                double theta = Math.toRadians(this.getAngle());
                int centerX = (int)((double)this.controlPoints[0].x + Math.cos(theta) * (double)holeSize / 2.0);
                int centerY = (int)((double)this.controlPoints[0].y + Math.sin(theta) * (double)holeSize / 2.0);
                bodyArea.subtract(new Area(new Ellipse2D.Double(centerX - tickSize / 2, centerY - tickSize / 2, tickSize, tickSize)));
            } else if (this.base == Base.B9A && this.getMount() == Mount.CHASSIS) {
                double cutoutDiameter = this.getClosestOdd(B9A_CUTOUT_DIAMETER.convertToPixels());
                bodyArea.subtract(new Area(new Ellipse2D.Double((double)this.controlPoints[0].x - cutoutDiameter / 2.0, (double)(this.controlPoints[0].y - bodyDiameter / 2) - cutoutDiameter * 3.0 / 4.0, cutoutDiameter, cutoutDiameter)));
                bodyArea.subtract(new Area(new Ellipse2D.Double((double)this.controlPoints[0].x - cutoutDiameter / 2.0, (double)(this.controlPoints[0].y + bodyDiameter / 2) - cutoutDiameter / 4.0, cutoutDiameter, cutoutDiameter)));
            } else if (this.base == Base.B7G && this.getMount() == Mount.CHASSIS) {
                double cutoutDiameter = this.getClosestOdd(B7G_CUTOUT_DIAMETER.convertToPixels());
                bodyArea.subtract(new Area(new Ellipse2D.Double((double)this.controlPoints[0].x - cutoutDiameter / 2.0, (double)(this.controlPoints[0].y - bodyDiameter / 2) - cutoutDiameter * 3.0 / 4.0, cutoutDiameter, cutoutDiameter)));
                bodyArea.subtract(new Area(new Ellipse2D.Double((double)this.controlPoints[0].x - cutoutDiameter / 2.0, (double)(this.controlPoints[0].y + bodyDiameter / 2) - cutoutDiameter / 4.0, cutoutDiameter, cutoutDiameter)));
            }
            this.body = bodyArea;
        }
        return this.body;
    }

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        Color finalBorderColor;
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
        Shape body = this.getBody();
        Composite oldComposite = g2d.getComposite();
        if (this.alpha < MAX_ALPHA) {
            g2d.setComposite(AlphaComposite.getInstance(3, 1.0f * (float)this.alpha / (float)MAX_ALPHA));
        }
        if (componentState != ComponentState.DRAGGING) {
            g2d.setColor(outlineMode ? Constants.TRANSPARENT_COLOR : this.getColor());
            g2d.fill(body);
        }
        g2d.setComposite(oldComposite);
        if (outlineMode) {
            Theme theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
            finalBorderColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : theme.getOutlineColor();
        } else {
            finalBorderColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : this.getColor().darker();
        }
        g2d.setColor(finalBorderColor);
        g2d.draw(body);
        drawingObserver.stopTracking();
        if (!outlineMode) {
            for (int i = 1; i < this.controlPoints.length; ++i) {
                Shape pinShape;
                if (this.getMount() == Mount.PCB) {
                    int pinSize = this.getClosestOdd(PIN_DIAMETER.convertToPixels());
                    pinShape = new Ellipse2D.Double(this.controlPoints[i].x - pinSize / 2, this.controlPoints[i].y - pinSize / 2, pinSize, pinSize);
                } else {
                    int pinWidth = this.getClosestOdd(PIN_WIDTH.convertToPixels());
                    int pinThickness = this.getClosestOdd(PIN_THICKNESS.convertToPixels());
                    pinShape = new Rectangle2D.Double(this.controlPoints[i].x - pinWidth / 2, this.controlPoints[i].y - pinThickness / 2, pinWidth, pinThickness);
                    double theta = Math.atan2(this.controlPoints[i].y - this.controlPoints[0].y, this.controlPoints[i].x - this.controlPoints[0].x) + 1.5707963267948966;
                    Area rotatedPin = new Area(pinShape);
                    rotatedPin.transform(AffineTransform.getRotateInstance(theta, this.controlPoints[i].x, this.controlPoints[i].y));
                    pinShape = rotatedPin;
                }
                g2d.setColor(PIN_COLOR);
                g2d.fill(pinShape);
                g2d.setColor(PIN_BORDER_COLOR);
                g2d.fill(pinShape);
            }
        }
        if (this.electrodeLabels != null) {
            g2d.setColor(this.getLabelColor());
            g2d.setFont(project.getFont().deriveFont((float)((double)project.getFont().getSize2D() * 0.8)));
            String[] labels = this.electrodeLabels.split(",");
            double electrodeLabelOffset = (double)project.getFont().getSize2D() * (this.getBase() == Base.B9A && this.getMount() == Mount.PCB ? 1.5 : 1.0);
            for (int i = 0; i < labels.length; ++i) {
                if (i >= this.controlPoints.length - 1) continue;
                String label = labels[i];
                double theta = Math.atan2(this.controlPoints[i + 1].y - this.controlPoints[0].y, this.controlPoints[i + 1].x - this.controlPoints[0].x);
                double x = (double)this.controlPoints[i + 1].x - Math.cos(theta) * electrodeLabelOffset;
                double y = (double)this.controlPoints[i + 1].y - Math.sin(theta) * electrodeLabelOffset;
                StringUtils.drawCenteredText(g2d, label, (int)x, (int)y, HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
            }
        }
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        Area area = new Area(new Ellipse2D.Double(1.0, 1.0, width - 2, width - 2));
        int center = width / 2;
        area.subtract(new Area(new Ellipse2D.Double(center - 2, center - 2, 5.0, 5.0)));
        g2d.setColor(this.getColor());
        g2d.fill(area);
        g2d.setColor(this.getColor().darker());
        g2d.draw(area);
        int radius = width / 2 - 6;
        for (int i = 0; i < 8; ++i) {
            int x = (int)((double)center + Math.cos((double)i * Math.PI / 4.0) * (double)radius);
            int y = (int)((double)center + Math.sin((double)i * Math.PI / 4.0) * (double)radius);
            g2d.setColor(PIN_COLOR);
            g2d.fillOval(x - 1, y - 1, 3, 3);
            g2d.setColor(PIN_BORDER_COLOR);
            g2d.drawOval(x - 1, y - 1, 3, 3);
        }
    }

    public Point getControlPoint(int index) {
        return this.controlPoints[index];
    }

    public int getControlPointCount() {
        return this.controlPoints.length;
    }

    public VisibilityPolicy getControlPointVisibilityPolicy(int index) {
        return VisibilityPolicy.NEVER;
    }

    @EditableProperty(name="Type")
    public String getValue() {
        return this.type;
    }

    public void setValue(String value) {
        this.type = value;
    }

    public boolean isControlPointSticky(int index) {
        return index > 0;
    }

    public void setControlPoint(Point point, int index) {
        this.controlPoints[index].setLocation(point);
        this.body = null;
    }

    @EditableProperty(name="Electrode Labels")
    public String getElectrodeLabels() {
        if (this.electrodeLabels == null) {
            this.electrodeLabels = "1,2,3,4,5,6,7,8,9";
        }
        return this.electrodeLabels;
    }

    public void setElectrodeLabels(String electrodeLabels) {
        this.electrodeLabels = electrodeLabels;
    }

    @EditableProperty(name="Label")
    public Color getLabelColor() {
        if (this.labelColor == null) {
            this.labelColor = LABEL_COLOR;
        }
        return this.labelColor;
    }

    public void setLabelColor(Color labelColor) {
        this.labelColor = labelColor;
    }

    @EditableProperty(name="Mount")
    public Mount getMount() {
        if (this.mount == null) {
            this.mount = Mount.PCB;
        }
        return this.mount;
    }

    public void setMount(Mount mount) {
        this.mount = mount;
        this.updateControlPoints();
        this.body = null;
    }

    static enum Mount {
        CHASSIS("Chassis"),
        PCB("PCB");

        String name;

        private Mount(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum Base {
        B9A("Noval B9A"),
        OCTAL("Octal"),
        B7G("Small-button B7G");

        String name;

        private Base(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

