/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.netlist;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JLabel;
import org.diylc.common.INetlistAnalyzer;
import org.diylc.components.electromechanical.ClosedJack1_4;
import org.diylc.components.electromechanical.OpenJack1_4;
import org.diylc.components.guitar.AbstractGuitarPickup;
import org.diylc.components.guitar.HumbuckerPickup;
import org.diylc.components.guitar.JazzBassPickup;
import org.diylc.components.guitar.P90Pickup;
import org.diylc.components.guitar.PBassPickup;
import org.diylc.components.guitar.SingleCoilPickup;
import org.diylc.components.passive.AxialFilmCapacitor;
import org.diylc.components.passive.PotentiometerPanel;
import org.diylc.components.passive.RadialCeramicDiskCapacitor;
import org.diylc.components.passive.RadialFilmCapacitor;
import org.diylc.core.IDIYComponent;
import org.diylc.netlist.Netlist;
import org.diylc.netlist.NetlistAnalyzer;
import org.diylc.netlist.Node;
import org.diylc.netlist.Summary;
import org.diylc.netlist.Tree;
import org.diylc.netlist.TreeConnectionType;
import org.diylc.netlist.TreeException;
import org.diylc.netlist.TreeLeaf;

public class GuitarDiagramAnalyzer
extends NetlistAnalyzer
implements INetlistAnalyzer {
    private static Set<String> JACK_TYPES = new HashSet<String>();
    private static Set<String> POT_TYPES = new HashSet<String>();
    private static Set<String> PICKUP_TYPES = new HashSet<String>();
    private static Set<String> CAP_TYPES = new HashSet<String>();
    private int positiveCount;
    private int negativeCount;
    private int noiseCount;

    public String getName() {
        return "Analyze Guitar Diagrams (beta)";
    }

    public String getIconName() {
        return "Guitar";
    }

    public String getFontName() {
        return new JLabel().getFont().getName();
    }

    protected Summary summarize(Netlist netlist, Node preferredOutput) throws TreeException {
        ArrayList<String> notes = new ArrayList<String>();
        Tree tree = this.constructTree(netlist);
        Tree pickupTree = tree.filter(PICKUP_TYPES);
        if (pickupTree == null || pickupTree.getChildren().isEmpty()) {
            notes.add("No pickups are detected in this switch configuration");
        } else {
            StringBuilder sb;
            boolean humCancelling;
            this.positiveCount = 0;
            this.negativeCount = 0;
            this.noiseCount = 0;
            pickupTree.walk(new Tree.ITreeWalker(){

                public void visit(Tree t) {
                }

                public void visit(TreeLeaf l) {
                    if (l.toString().toLowerCase().contains("north") && l.toString().toLowerCase().contains("->") || l.toString().toLowerCase().contains("south") && l.toString().toLowerCase().contains("<-")) {
                        GuitarDiagramAnalyzer.this.noiseCount++;
                    }
                    if (l.toString().toLowerCase().contains("north") && l.toString().toLowerCase().contains("<-") || l.toString().toLowerCase().contains("south") && l.toString().toLowerCase().contains("->")) {
                        GuitarDiagramAnalyzer.this.noiseCount--;
                    }
                    if (l.toString().toLowerCase().contains("->")) {
                        GuitarDiagramAnalyzer.this.positiveCount++;
                    }
                    if (l.toString().toLowerCase().contains("<-")) {
                        GuitarDiagramAnalyzer.this.negativeCount++;
                    }
                }
            });
            Set pickups = tree.extractComponents(PICKUP_TYPES);
            HashMap<AbstractGuitarPickup, Tree> pickupRoots = new HashMap<AbstractGuitarPickup, Tree>();
            for (IDIYComponent c : pickups) {
                if (!(c instanceof AbstractGuitarPickup)) continue;
                AbstractGuitarPickup pickup = (AbstractGuitarPickup)c;
                if (((AbstractGuitarPickup)c).isHumbucker()) {
                    Tree sTree;
                    TreeLeaf nLeaf = new TreeLeaf((IDIYComponent)pickup, 0, 1);
                    TreeLeaf sLeaf = new TreeLeaf((IDIYComponent)pickup, 2, 3);
                    Tree nTree = tree.locate(nLeaf, false);
                    Tree tree2 = tree.findCommonParent(nTree, sTree = tree.locate(sLeaf, false));
                    if (tree2 != null) {
                        pickupRoots.put(pickup, tree2);
                    }
                    if (nTree != null && sTree != null && tree2 != null) {
                        notes.add("'" + pickup.getName() + "' pickup wired in humbucking mode with " + tree2.getConnectionType().name().toLowerCase() + " coils");
                        continue;
                    }
                    if ((nTree != null || sTree == null) && (nTree == null || sTree != null)) continue;
                    notes.add("'" + pickup.getName() + "' pickup wired in coil-split mode");
                    continue;
                }
                TreeLeaf leaf = new TreeLeaf((IDIYComponent)pickup, 1, 2);
                Tree t = tree.locate(leaf, false);
                if (t == null) continue;
                pickupRoots.put(pickup, t);
            }
            if (pickupRoots.size() > 1) {
                Tree root = tree.findCommonParent(new ArrayList(pickupRoots.values()));
                StringBuilder sb2 = new StringBuilder();
                boolean first = true;
                for (IDIYComponent c : pickupRoots.keySet()) {
                    if (!first) {
                        sb2.append(pickupRoots.size() == 2 ? " and " : ", ");
                    }
                    first = false;
                    sb2.append("'").append(c.getName()).append("'");
                }
                sb2.append(" pickups engaged, wired in ").append(root.getConnectionType().name().toLowerCase());
                notes.add(sb2.toString());
            } else if (pickupRoots.size() == 1) {
                AbstractGuitarPickup pickup = (AbstractGuitarPickup)((Object)pickupRoots.keySet().iterator().next());
                notes.add("'" + pickup.getName() + "' is the only engaged pickup");
            }
            boolean bl = humCancelling = this.noiseCount == 0;
            if (humCancelling) {
                notes.add("This configuration is hum-cancelling");
            } else {
                notes.add("This configuration is NOT hum-cancelling");
            }
            if (this.positiveCount > 1 || this.negativeCount > 1 || this.positiveCount == 1 && this.negativeCount == 1) {
                boolean inPhase;
                boolean bl2 = inPhase = this.positiveCount == 0 && this.negativeCount > 0 || this.positiveCount > 0 && this.negativeCount == 0;
                if (inPhase) {
                    notes.add("All pickup coils are wired in-phase");
                } else {
                    notes.add("Some pickup coils are wired OUT-of-phase");
                }
            }
            HashMap volPotPickupMap = new HashMap();
            HashMap tonePotPickupMap = new HashMap();
            HashMap tonePotPickupReverseMap = new HashMap();
            HashMap volPotPickupReverseMap = new HashMap();
            Set pots = tree.extractComponents(POT_TYPES);
            for (IDIYComponent iDIYComponent : pots) {
                TreeLeaf leaf1 = new TreeLeaf(iDIYComponent, 0, 1);
                TreeLeaf leaf2 = new TreeLeaf(iDIYComponent, 1, 2);
                Tree tree1 = tree.locate(leaf1, false);
                Tree tree2 = tree.locate(leaf2, false);
                if (tree1 == null && tree2 != null || tree1 != null && tree2 == null) {
                    Set caps;
                    boolean tonePotReversed = tree1 != null;
                    Tree t = tree1 == null ? tree2 : tree1;
                    Tree p = tree.findParent(t);
                    if (p != null && p.getChildren().size() == 2 && (caps = p.extractComponents(CAP_TYPES)) != null && caps.size() == 1) {
                        for (Map.Entry r : pickupRoots.entrySet()) {
                            List<Object> pickupList;
                            Tree toneParent = tree.findCommonParent(p, (Tree)r.getValue());
                            if (toneParent == null || toneParent.getConnectionType() != TreeConnectionType.Parallel) continue;
                            if (tonePotReversed) {
                                pickupList = (ArrayList)tonePotPickupReverseMap.get(iDIYComponent);
                                if (pickupList == null) {
                                    pickupList = new ArrayList();
                                    tonePotPickupReverseMap.put(iDIYComponent, pickupList);
                                }
                                pickupList.add(r.getKey());
                                continue;
                            }
                            pickupList = (List)tonePotPickupMap.get(iDIYComponent);
                            if (pickupList == null) {
                                pickupList = new ArrayList();
                                tonePotPickupMap.put(iDIYComponent, pickupList);
                            }
                            pickupList.add(r.getKey());
                        }
                    }
                }
                if (tree1 == null || tree2 == null) continue;
                for (Map.Entry r : pickupRoots.entrySet()) {
                    List<Object> pickupList;
                    Tree parent1 = tree.findCommonParent(tree1, (Tree)r.getValue());
                    Tree parent2 = tree.findCommonParent(tree2, (Tree)r.getValue());
                    if (parent1 != null && parent2 != null && parent1.getConnectionType() == TreeConnectionType.Series && parent2.getConnectionType() == TreeConnectionType.Parallel) {
                        pickupList = (ArrayList)volPotPickupMap.get(iDIYComponent);
                        if (pickupList == null) {
                            pickupList = new ArrayList();
                            volPotPickupMap.put(iDIYComponent, pickupList);
                        }
                        pickupList.add(r.getKey());
                        continue;
                    }
                    if (parent1 == null || parent2 == null || parent1.getConnectionType() != TreeConnectionType.Parallel || parent2.getConnectionType() != TreeConnectionType.Series) continue;
                    pickupList = (List)volPotPickupReverseMap.get(iDIYComponent);
                    if (pickupList == null) {
                        pickupList = new ArrayList();
                        volPotPickupReverseMap.put(iDIYComponent, pickupList);
                    }
                    pickupList.add(r.getKey());
                }
            }
            for (Map.Entry entry : volPotPickupMap.entrySet()) {
                sb = new StringBuilder("'" + ((IDIYComponent)entry.getKey()).getName() + "' potentiometer acts as a volume control for ");
                boolean first = true;
                for (IDIYComponent c : (List)entry.getValue()) {
                    if (!first) {
                        sb.append(((List)entry.getValue()).size() == 2 ? " and " : ", ");
                    }
                    first = false;
                    sb.append("'").append(c.getName()).append("'");
                }
                notes.add(sb.toString());
            }
            for (Map.Entry entry : volPotPickupReverseMap.entrySet()) {
                sb = new StringBuilder("'" + ((IDIYComponent)entry.getKey()).getName() + "' potentiometer acts as a volume control for ");
                boolean first = true;
                for (IDIYComponent c : (List)entry.getValue()) {
                    if (!first) {
                        sb.append(((List)entry.getValue()).size() == 2 ? " and " : ", ");
                    }
                    first = false;
                    sb.append("'").append(c.getName()).append("'");
                }
                sb.append(", but is wired in REVERSE!");
                notes.add(sb.toString());
            }
            for (Map.Entry entry : tonePotPickupMap.entrySet()) {
                sb = new StringBuilder("'" + ((IDIYComponent)entry.getKey()).getName() + "' potentiometer acts as a tone control for ");
                boolean first = true;
                for (IDIYComponent c : (List)entry.getValue()) {
                    if (!first) {
                        sb.append(((List)entry.getValue()).size() == 2 ? " and " : ", ");
                    }
                    first = false;
                    sb.append("'").append(c.getName()).append("'");
                }
                notes.add(sb.toString());
            }
            for (Map.Entry entry : tonePotPickupReverseMap.entrySet()) {
                sb = new StringBuilder("'" + ((IDIYComponent)entry.getKey()).getName() + "' potentiometer acts as a tone control for ");
                boolean first = true;
                for (IDIYComponent c : (List)entry.getValue()) {
                    if (!first) {
                        sb.append(((List)entry.getValue()).size() == 2 ? " and " : ", ");
                    }
                    first = false;
                    sb.append("'").append(c.getName()).append("'");
                }
                sb.append(", but is wired in REVERSE!");
                notes.add(sb.toString());
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Parallel/Series connectivity tree:<br><br>").append(tree.toHTML(0));
        if (!notes.isEmpty()) {
            sb.append("<br><br>Notes:<br>");
        }
        for (String v : notes) {
            sb.append("&nbsp;&nbsp;").append(v).append("<br>");
        }
        return new Summary(netlist, sb.toString());
    }

    public Tree constructTree(Netlist netlist) throws TreeException {
        List jackTipNodes = this.find(JACK_TYPES, "Tip", netlist);
        List jackSleeveNodes = this.find(JACK_TYPES, "Sleeve", netlist);
        if (jackTipNodes.size() == 0 || jackSleeveNodes.size() == 0) {
            throw new TreeException("Could not find anything connected to a jack tip terminal.");
        }
        if (jackTipNodes.size() > 1 || jackSleeveNodes.size() > 1) {
            throw new TreeException("Multiple jacks found, could not proceed.");
        }
        Node jackTip = (Node)jackTipNodes.get(0);
        Node jackSleeve = (Node)jackSleeveNodes.get(0);
        return this.constructTreeBetween(netlist, jackTip, jackSleeve);
    }

    static {
        JACK_TYPES.add(OpenJack1_4.class.getCanonicalName());
        JACK_TYPES.add(ClosedJack1_4.class.getCanonicalName());
        POT_TYPES.add(PotentiometerPanel.class.getCanonicalName());
        PICKUP_TYPES.add(SingleCoilPickup.class.getCanonicalName());
        PICKUP_TYPES.add(HumbuckerPickup.class.getCanonicalName());
        PICKUP_TYPES.add(P90Pickup.class.getCanonicalName());
        PICKUP_TYPES.add(JazzBassPickup.class.getCanonicalName());
        PICKUP_TYPES.add(PBassPickup.class.getCanonicalName());
        CAP_TYPES.add(RadialCeramicDiskCapacitor.class.getCanonicalName());
        CAP_TYPES.add(RadialFilmCapacitor.class.getCanonicalName());
        CAP_TYPES.add(AxialFilmCapacitor.class.getCanonicalName());
    }
}

