/*
 * Decompiled with CFR 0.152.
 */
package com.diyfever.httpproxy;

import com.diyfever.httpproxy.IFlatProxy;
import com.diyfever.httpproxy.ParamName;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;
import org.codehaus.commons.compiler.ISimpleCompiler;
import org.codehaus.janino.CompilerFactory;

public class ProxyFactory {
    private static final Logger LOG = Logger.getLogger(ProxyFactory.class);
    private IFlatProxy flatProxy;

    public ProxyFactory(IFlatProxy iFlatProxy) {
        this.flatProxy = iFlatProxy;
    }

    public <T> T createProxy(Class<? extends T> clazz, String string) {
        if (!clazz.isInterface()) {
            LOG.error((Object)("Specified class is not an interface: " + clazz.getName()));
            return null;
        }
        String string2 = clazz.getName();
        String string3 = string2.substring(string2.lastIndexOf(".") + 1) + "Impl";
        try {
            LOG.info((Object)"Creating temp class code");
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.println("public class " + string3 + " implements " + string2 + " {\n");
            printWriter.println("  private " + IFlatProxy.class.getName() + " proxy;\n");
            printWriter.println("  public " + string3 + "(" + IFlatProxy.class.getName() + " proxy) { this.proxy = proxy; }\n");
            for (Method method : clazz.getDeclaredMethods()) {
                int n;
                printWriter.print("  public " + method.getReturnType().getName() + " " + method.getName() + "(");
                for (n = 0; n < method.getParameterTypes().length; ++n) {
                    if (n > 0) {
                        printWriter.print(", ");
                    }
                    printWriter.print(method.getParameterTypes()[n].getName() + " " + this.extractParameterName(method, n));
                }
                printWriter.print(") {\n");
                printWriter.println("    java.util.Map<String, Object> params = new java.util.HashMap<String, Object>();");
                for (n = 0; n < method.getParameterTypes().length; ++n) {
                    String string4 = this.extractParameterName(method, n);
                    printWriter.println("    params.put(\"" + string4 + "\", " + string4 + ");");
                }
                String n2 = InputStream.class.equals(method.getReturnType()) ? "invoke" : "invokeAndDeserialize";
                printWriter.println("    return (" + method.getReturnType().getName() + ") proxy." + n2 + "(\"" + string + "\", \"" + method.getName() + "\", params);");
                printWriter.println("  }\n");
            }
            printWriter.print("}\n");
            String string5 = stringWriter.toString();
            ISimpleCompiler iSimpleCompiler = new CompilerFactory().newSimpleCompiler();
            iSimpleCompiler.cook(string5);
            Object obj = iSimpleCompiler.getClassLoader().loadClass(string3).getConstructors()[0].newInstance(this.flatProxy);
            LOG.info((Object)"Successfully instantiated proxy");
            return (T)obj;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            LOG.error((Object)("Could not create proxy: " + exception.getMessage()));
            return null;
        }
    }

    private String extractParameterName(Method method, int n) {
        Annotation[] annotationArray;
        for (Annotation annotation : annotationArray = method.getParameterAnnotations()[n]) {
            if (!(annotation instanceof ParamName)) continue;
            return ((ParamName)annotation).value();
        }
        LOG.warn((Object)("@" + ParamName.class.getSimpleName() + " annotation not present for method " + method.getName() + ", at index " + n));
        return "param" + n;
    }

    public static File createTempDirectory() throws IOException {
        File file = File.createTempFile("temp", Long.toString(System.nanoTime()));
        if (!file.delete()) {
            throw new IOException("Could not delete temp file: " + file.getAbsolutePath());
        }
        if (!file.mkdir()) {
            throw new IOException("Could not create temp directory: " + file.getAbsolutePath());
        }
        return file;
    }
}

