/*
 * Decompiled with CFR 0.152.
 */
package circuit;

import circuit.controllers.ContinuosMoveActions;
import circuit.controllers.CopyPasteActions;
import circuit.controllers.EditorActions;
import circuit.controllers.HandleActions;
import circuit.controllers.ParserActions;
import circuit.controllers.PrimitivesParInterface;
import circuit.controllers.UndoActions;
import circuit.model.DrawingModel;
import circuit.views.Drawing;
import clipboard.TextTransfer;
import dialogs.DialogParameters;
import dialogs.DialogSymbolize;
import dialogs.LayerInfo;
import dialogs.ParameterDescription;
import export.ExportGraphic;
import geom.MapCoordinates;
import globals.Globals;
import globals.LibUtils;
import graphic.DimensionG;
import graphic.PointG;
import graphic.swing.ColorSwing;
import graphic.swing.Graphics2DSwing;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import primitives.GraphicPrimitive;
import primitives.PrimitiveComplexCurve;
import primitives.PrimitivePolygon;
import timer.MyTimer;
import toolbars.ChangeGridState;
import toolbars.ChangeSelectedLayer;
import toolbars.ChangeSelectionListener;
import toolbars.ChangeZoomListener;

public class CircuitPanel
extends JPanel
implements ActionListener,
MouseMotionListener,
MouseListener,
ChangeSelectedLayer,
ChangeGridState,
ChangeZoomListener,
ChangeSelectionListener,
PrimitivesParInterface {
    Graphics2DSwing graphicSwing;
    private transient MapCoordinates cs;
    public boolean antiAlias;
    private boolean isGridVisible;
    private Color backgroundColor = Color.white;
    private Rectangle evidenceRect;
    public static final int MARGIN = 20;
    static final ColorSwing editingColor = new ColorSwing(Color.green);
    private static final String rulerFont = "Lucida Sans Regular";
    public transient DrawingModel P = new DrawingModel();
    public JScrollPane father;
    public Drawing drawingAgent;
    private final EditorActions edt;
    private final CopyPasteActions cpa;
    private final HandleActions haa;
    private final ParserActions pa = new ParserActions(this.P);
    private final UndoActions ua = new UndoActions(this.pa);
    private final ContinuosMoveActions eea;
    public boolean profileTime;
    private double average;
    private double record;
    private double runs;
    private double record_c;
    private double record_d;
    private int oldx;
    private int oldy;
    private Rectangle scrollRectangle;
    public boolean extStrict;
    private boolean ruler;
    private int rulerStartX;
    private int rulerStartY;
    private int rulerEndX;
    private int rulerEndY;
    JPopupMenu popup;
    JMenuItem editProperties;
    JMenuItem editCut;
    JMenuItem editCopy;
    JMenuItem editPaste;
    JMenuItem editSelectAll;
    JMenuItem editRotate;
    JMenuItem editMirror;
    JMenuItem editSymbolize;
    JMenuItem editUSymbolize;
    JMenuItem editAddNode;
    JMenuItem editRemoveNode;
    int menux;
    int menuy;
    private ChangeZoomListener zoomListener;
    private ChangeSelectionListener selectionListener;
    private ChangeSelectionListener scrollGestureSelectionListener;

    public CircuitPanel(boolean isEditable) {
        this.edt = new EditorActions(this.P, this.ua);
        this.eea = new ContinuosMoveActions(this.P, this.ua, this.edt);
        this.eea.setPrimitivesParListener(this);
        this.haa = new HandleActions(this.P, this.edt, this.ua);
        this.cpa = new CopyPasteActions(this.P, this.edt, this.pa, this.ua, new TextTransfer());
        this.graphicSwing = new Graphics2DSwing();
        this.drawingAgent = new Drawing(this.P);
        this.isGridVisible = true;
        this.zoomListener = null;
        this.antiAlias = true;
        this.record_c = this.record = 1.0E100;
        this.record_d = this.record;
        this.evidenceRect = new Rectangle(0, 0, -1, -1);
        this.cs = new MapCoordinates();
        this.cs.setXCenter(0.0);
        this.cs.setYCenter(0.0);
        this.cs.setXMagnitude(4.0);
        this.cs.setYMagnitude(4.0);
        this.cs.setOrientation(0);
        this.setOpaque(true);
        this.runs = 0.0;
        this.average = 0.0;
        if (isEditable) {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.setFocusable(true);
            this.registerActiveKeys();
            this.popup = new JPopupMenu();
            this.editProperties = new JMenuItem(Globals.messages.getString("Param_opt"));
            this.editCut = new JMenuItem(Globals.messages.getString("Cut"));
            this.editCopy = new JMenuItem(Globals.messages.getString("Copy"));
            this.editSelectAll = new JMenuItem(Globals.messages.getString("SelectAll"));
            this.editPaste = new JMenuItem(Globals.messages.getString("Paste"));
            this.editRotate = new JMenuItem(Globals.messages.getString("Rotate"));
            this.editMirror = new JMenuItem(Globals.messages.getString("Mirror_E"));
            this.editSymbolize = new JMenuItem(Globals.messages.getString("Symbolize"));
            this.editUSymbolize = new JMenuItem(Globals.messages.getString("Unsymbolize"));
            this.editAddNode = new JMenuItem(Globals.messages.getString("Add_node"));
            this.editRemoveNode = new JMenuItem(Globals.messages.getString("Remove_node"));
            this.popup.add(this.editProperties);
            this.popup.addSeparator();
            this.popup.add(this.editCut);
            this.popup.add(this.editCopy);
            this.popup.add(this.editPaste);
            this.popup.addSeparator();
            this.popup.add(this.editSelectAll);
            this.popup.addSeparator();
            this.popup.add(this.editRotate);
            this.popup.add(this.editMirror);
            this.popup.add(this.editAddNode);
            this.popup.add(this.editRemoveNode);
            this.popup.addSeparator();
            this.popup.add(this.editSymbolize);
            this.popup.add(this.editUSymbolize);
            this.editProperties.addActionListener(this);
            this.editCut.addActionListener(this);
            this.editCopy.addActionListener(this);
            this.editSelectAll.addActionListener(this);
            this.editPaste.addActionListener(this);
            this.editRotate.addActionListener(this);
            this.editMirror.addActionListener(this);
            this.editAddNode.addActionListener(this);
            this.editRemoveNode.addActionListener(this);
            this.editSymbolize.addActionListener(this);
            this.editUSymbolize.addActionListener(this);
        }
    }

    private void registerAction(String actionString, char key, final int state) {
        this.getInputMap(2).put(KeyStroke.getKeyStroke(Character.toUpperCase(key)), actionString);
        this.getInputMap(2).put(KeyStroke.getKeyStroke(Character.toLowerCase(key)), actionString);
        this.getActionMap().put(actionString, new AbstractAction(){

            public void actionPerformed(ActionEvent ignored) {
                CircuitPanel.this.setSelectionState(state, "");
                ((CircuitPanel)CircuitPanel.this).eea.primEdit = null;
                CircuitPanel.this.repaint();
            }
        });
    }

    public final void registerActiveKeys() {
        this.registerAction("selection", 'a', 1);
        this.getInputMap(2).put(KeyStroke.getKeyStroke(32, 0, false), "selection");
        this.registerAction("line", 'l', 4);
        this.registerAction("text", 't', 5);
        this.registerAction("bezier", 'b', 6);
        this.registerAction("polygon", 'p', 7);
        this.registerAction("complexcurve", 'o', 14);
        this.registerAction("ellipse", 'e', 8);
        this.registerAction("rectangle", 'g', 9);
        this.registerAction("connection", 'c', 10);
        this.registerAction("pcbline", 'i', 11);
        this.registerAction("pcbpad", 'z', 12);
        String delete = "delete";
        this.getInputMap(2).put(KeyStroke.getKeyStroke("DELETE"), "delete");
        this.getInputMap(2).put(KeyStroke.getKeyStroke("BACK_SPACE"), "delete");
        this.getActionMap().put("delete", new AbstractAction(){

            public void actionPerformed(ActionEvent ignored) {
                CircuitPanel.this.edt.deleteAllSelected(true);
                CircuitPanel.this.repaint();
            }
        });
        String escape = "escape";
        this.getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "escape");
        this.getActionMap().put("escape", new AbstractAction(){

            public void actionPerformed(ActionEvent ignored) {
                if (((CircuitPanel)CircuitPanel.this).eea.clickNumber > 0) {
                    ((CircuitPanel)CircuitPanel.this).eea.successiveMove = false;
                    ((CircuitPanel)CircuitPanel.this).eea.clickNumber = 0;
                    ((CircuitPanel)CircuitPanel.this).eea.primEdit = null;
                    CircuitPanel.this.repaint();
                }
            }
        });
        String left = "lleft";
        this.getInputMap(2).put(KeyStroke.getKeyStroke(37, 8, false), "lleft");
        this.getActionMap().put("lleft", new AbstractAction(){

            public void actionPerformed(ActionEvent ignored) {
                CircuitPanel.this.edt.moveAllSelected(-1, 0);
                CircuitPanel.this.repaint();
            }
        });
        String right = "lright";
        this.getInputMap(2).put(KeyStroke.getKeyStroke(39, 8, false), "lright");
        this.getActionMap().put("lright", new AbstractAction(){

            public void actionPerformed(ActionEvent ignored) {
                CircuitPanel.this.edt.moveAllSelected(1, 0);
                CircuitPanel.this.repaint();
            }
        });
        String up = "lup";
        this.getInputMap(2).put(KeyStroke.getKeyStroke(38, 8, false), "lup");
        this.getActionMap().put("lup", new AbstractAction(){

            public void actionPerformed(ActionEvent ignored) {
                CircuitPanel.this.edt.moveAllSelected(0, -1);
                CircuitPanel.this.repaint();
            }
        });
        String down = "ldown";
        this.getInputMap(2).put(KeyStroke.getKeyStroke(40, 8, false), "ldown");
        this.getActionMap().put("ldown", new AbstractAction(){

            public void actionPerformed(ActionEvent ignored) {
                CircuitPanel.this.edt.moveAllSelected(0, 1);
                CircuitPanel.this.repaint();
            }
        });
    }

    public void getFocus() {
        this.requestFocusInWindow();
    }

    public void setSelectionState(int s, String macro) {
        if (this.selectionListener != null && s != this.eea.actionSelected) {
            this.selectionListener.setSelectionState(s, macro);
            this.selectionListener.setStrictCompatibility(this.extStrict);
        }
        if (this.scrollGestureSelectionListener != null) {
            this.scrollGestureSelectionListener.setSelectionState(s, macro);
        }
        this.eea.setState(s, macro);
        this.selectCursor();
    }

    public void setScrollRectangle(Rectangle r) {
        this.scrollRectangle = r;
        this.repaint();
    }

    public void addChangeZoomListener(ChangeZoomListener c) {
        this.zoomListener = c;
    }

    public void addChangeSelectionListener(ChangeSelectionListener c) {
        this.selectionListener = c;
    }

    public void addScrollGestureSelectionListener(ChangeSelectionListener c) {
        this.scrollGestureSelectionListener = c;
    }

    public int getCurrentLayer() {
        return this.eea.currentLayer;
    }

    public void setCurrentLayer(int cl) {
        int l = cl;
        if (l < 0) {
            l = 0;
        }
        if (l >= this.P.getLayers().size()) {
            l = this.P.getLayers().size() - 1;
        }
        this.eea.currentLayer = l;
    }

    public void setCirc(StringBuffer c) {
        this.pa.parseString(c);
    }

    public StringBuffer getCirc(boolean extensions) {
        return this.pa.getText(extensions);
    }

    public void changeSelectedLayer(int s) {
        this.eea.currentLayer = s;
        if (this.edt.setLayerForSelectedPrimitives(s)) {
            this.repaint();
        }
    }

    public void setGridVisibility(boolean v) {
        this.isGridVisible = v;
        this.repaint();
    }

    public void setSnapState(boolean v) {
        this.cs.setSnap(v);
    }

    public void changeZoomByStep(boolean increase, int x, int y) {
        double ys;
        int xpos = this.cs.unmapXnosnap(x);
        int ypos = this.cs.unmapYnosnap(y);
        double z = this.cs.getXMagnitude();
        PointG origin = new PointG();
        DimensionG d = ExportGraphic.getImageSize(this.P, 1.0, false, origin);
        double xs = (double)xpos / (double)(d.width + 20);
        if (xs < 0.0) {
            xs = 0.0;
        }
        if ((ys = (double)ypos / (double)(d.height + 20)) < 0.0) {
            ys = 0.0;
        }
        double oldz = z;
        z = increase ? z * 3.0 / 2.0 : z * 2.0 / 3.0;
        if (z > 20.0) {
            z = 20.0;
        }
        if (z < 0.25) {
            z = 0.25;
        }
        z = (double)Math.round(z * 100.0) / 100.0;
        this.cs.setMagnitudes(z, z);
        int width = this.father.getViewport().getExtentSize().width;
        int height = this.father.getViewport().getExtentSize().height;
        Rectangle r = new Rectangle((int)((double)xpos * z - (double)(width / 2)), (int)((double)ypos * z - (double)(height / 2)), width, height);
        this.setScrollRectangle(r);
    }

    public void showPopUpMenu(int x, int y) {
        this.menux = x;
        this.menuy = y;
        boolean s = false;
        boolean somethingSelected = this.edt.getFirstSelectedPrimitive() != null;
        GraphicPrimitive g = this.edt.getFirstSelectedPrimitive();
        s = somethingSelected;
        this.editProperties.setEnabled(s);
        this.editCut.setEnabled(s);
        this.editCopy.setEnabled(s);
        this.editRotate.setEnabled(s);
        this.editMirror.setEnabled(s);
        s = g instanceof PrimitiveComplexCurve || g instanceof PrimitivePolygon;
        if (!this.edt.isUniquePrimitiveSelected()) {
            s = false;
        }
        this.editAddNode.setEnabled(s);
        this.editRemoveNode.setEnabled(s);
        this.editAddNode.setVisible(s);
        this.editRemoveNode.setVisible(s);
        TextTransfer textTransfer = new TextTransfer();
        if (textTransfer.getClipboardContents().equals("")) {
            this.editPaste.setEnabled(false);
        } else {
            this.editPaste.setEnabled(true);
        }
        this.editSymbolize.setEnabled(somethingSelected);
        this.editUSymbolize.setEnabled(this.edt.selectionCanBeSplitted());
        this.popup.show(this, x, y);
    }

    public void mouseClicked(MouseEvent evt) {
        this.requestFocusInWindow();
    }

    public int getSelectionState() {
        return this.eea.getSelectionState();
    }

    public void mouseMoved(MouseEvent evt) {
        int xa = evt.getX();
        int ya = evt.getY();
        int x = this.cs.mapX(this.cs.unmapXsnap(xa), 0.0);
        int y = this.cs.mapY(0.0, this.cs.unmapYsnap(ya));
        if (x == this.oldx && y == this.oldy) {
            return;
        }
        if (this.eea.continuosMove(this.cs, x, y, xa, ya, evt.isControlDown())) {
            this.repaint();
        }
        this.oldx = x;
        this.oldy = y;
    }

    public void mousePressed(MouseEvent evt) {
        MyTimer mt = new MyTimer();
        int px = evt.getX();
        int py = evt.getY();
        this.ruler = false;
        this.rulerStartX = px;
        this.rulerStartY = py;
        this.rulerEndX = px;
        this.rulerEndY = py;
        boolean toggle = false;
        toggle = Globals.useMetaForMultipleSelection ? evt.isMetaDown() : evt.isControlDown();
        if (this.eea.actionSelected == 1 && (evt.getModifiers() & 4) == 0 && !evt.isShiftDown()) {
            this.haa.dragHandleStart(px, py, 10, toggle, this.cs);
        } else if (this.eea.actionSelected == 1) {
            this.ruler = true;
        }
        if (this.profileTime) {
            double elapsed = mt.getElapsed();
            if (elapsed < this.record_c) {
                this.record_c = elapsed;
            }
            System.out.println("MP: Time elapsed: " + elapsed + "; record: " + this.record_c + " ms");
        }
    }

    public void mouseDragged(MouseEvent evt) {
        MyTimer mt = new MyTimer();
        int px = evt.getX();
        int py = evt.getY();
        if ((evt.getModifiers() & 4) != 0 || evt.isShiftDown()) {
            this.rulerEndX = px;
            this.rulerEndY = py;
            this.repaint();
            return;
        }
        this.haa.dragHandleDrag(this, px, py, this.cs);
        if (this.profileTime) {
            double elapsed = mt.getElapsed();
            if (elapsed < this.record_d) {
                this.record_d = elapsed;
            }
            System.out.println("MD: Time elapsed: " + elapsed + "; record: " + this.record_d + " ms");
        }
    }

    public void mouseReleased(MouseEvent evt) {
        MyTimer mt = new MyTimer();
        int px = evt.getX();
        int py = evt.getY();
        boolean toRepaint = false;
        boolean toggle = false;
        toggle = Globals.useMetaForMultipleSelection ? evt.isMetaDown() : evt.isControlDown();
        if (this.eea.actionSelected == 1) {
            if (this.rulerStartX != px || this.rulerStartY != py) {
                this.haa.dragHandleEnd(this, px, py, toggle, this.cs);
            } else {
                this.ruler = false;
                this.requestFocusInWindow();
                toRepaint = this.eea.handleClick(this.cs, evt.getX(), evt.getY(), (evt.getModifiers() & 4) == 4, toggle, evt.getClickCount() >= 2, evt.isControlDown());
            }
            this.repaint();
        } else {
            this.requestFocusInWindow();
            toRepaint = this.eea.handleClick(this.cs, evt.getX(), evt.getY(), (evt.getModifiers() & 4) == 4, toggle, evt.getClickCount() >= 2, evt.isControlDown());
        }
        if (toRepaint) {
            this.repaint();
        }
        if (this.profileTime) {
            double elapsed = mt.getElapsed();
            if (elapsed < this.record_d) {
                this.record_d = elapsed;
            }
            System.out.println("MR: Time elapsed: " + elapsed + "; record: " + this.record_d + " ms");
        }
    }

    public void mouseEntered(MouseEvent evt) {
        this.selectCursor();
    }

    public void selectCursor() {
        switch (this.eea.actionSelected) {
            case 0: 
            case 2: 
            case 3: {
                this.setCursor(Cursor.getPredefinedCursor(12));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                this.setCursor(Cursor.getPredefinedCursor(1));
                break;
            }
            default: {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    public void mouseExited(MouseEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(0));
        if (this.eea.successiveMove) {
            this.eea.successiveMove = false;
            this.repaint();
        }
    }

    public void changeZoom(double tz) {
        double z = (double)Math.round(tz * 100.0) / 100.0;
        this.cs.setMagnitudes(z, z);
        this.eea.successiveMove = false;
        this.repaint();
    }

    public void setBackground(Color sfondo) {
        this.backgroundColor = sfondo;
    }

    public void setEvidenceRect(int lx, int ly, int w, int h) {
        this.evidenceRect = new Rectangle();
        this.evidenceRect.x = lx;
        this.evidenceRect.y = ly;
        this.evidenceRect.height = h;
        this.evidenceRect.width = w;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        MyTimer mt = new MyTimer();
        Graphics2D g2 = (Graphics2D)g;
        this.graphicSwing.setGraphicContext(g2);
        if (this.antiAlias) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        } else {
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            g2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
            g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
            g2.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        }
        g.setColor(this.backgroundColor);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.isGridVisible) {
            this.graphicSwing.drawGrid(this.cs, 0, 0, this.getWidth(), this.getHeight());
        }
        g.setColor(Color.black);
        this.drawingAgent.draw(this.graphicSwing, this.cs);
        if (this.zoomListener != null) {
            this.zoomListener.changeZoom(this.cs.getXMagnitude());
        }
        this.drawingAgent.drawSelectedHandles(this.graphicSwing, this.cs);
        g.setColor(editingColor.getColorSwing());
        g2.setStroke(new BasicStroke(1.0f));
        if (this.evidenceRect != null && this.eea.actionSelected == 1) {
            g.drawRect(this.evidenceRect.x, this.evidenceRect.y, this.evidenceRect.width, this.evidenceRect.height);
        } else {
            this.evidenceRect = null;
        }
        this.eea.drawPrimEdit(this.graphicSwing, this.cs);
        if (this.ruler) {
            this.drawRuler(g, this.rulerStartX, this.rulerStartY, this.rulerEndX, this.rulerEndY);
        }
        if (this.cs.getXMax() > 0 && this.cs.getYMax() > 0) {
            this.setPreferredSize(new Dimension(this.cs.getXMax() + 20, this.cs.getYMax() + 20));
            this.revalidate();
        }
        if (this.scrollRectangle != null) {
            Rectangle r = this.scrollRectangle;
            this.scrollRectangle = null;
            this.scrollRectToVisible(r);
        }
        if (this.profileTime) {
            double elapsed = mt.getElapsed();
            g2.drawString("Version: 0.24.4", 0, 100);
            g.drawString("Time elapsed: " + elapsed + " ms", 0, 50);
            this.runs += 1.0;
            this.average += elapsed;
            if (elapsed < this.record) {
                this.record = elapsed;
            }
            System.out.println("R: Time elapsed: " + elapsed + " averaging " + this.average / this.runs + "ms in " + this.runs + " redraws; record: " + this.record + " ms");
        }
    }

    public void validate() {
        if (this.cs.getXMax() > 0 && this.cs.getYMax() > 0) {
            this.setPreferredSize(new Dimension(this.cs.getXMax() + 20, this.cs.getYMax() + 20));
        }
        super.validate();
    }

    private void drawRuler(Graphics g, int sx, int sy, int ex, int ey) {
        int xa = this.cs.unmapXnosnap(sx);
        int ya = this.cs.unmapYnosnap(sy);
        int xb = this.cs.unmapXnosnap(ex);
        int yb = this.cs.unmapYnosnap(ey);
        double length = Math.sqrt((double)(xa - xb) * (double)(xa - xb) + (double)((ya - yb) * (ya - yb)));
        g.drawLine(sx, sy, ex, ey);
        double alpha = sx == ex ? 1.5707963267948966 + (ey - sy < 0 ? 0.0 : Math.PI) : Math.atan((double)(ey - sy) / (double)(ex - sx));
        alpha += ex - sx > 0 ? 0.0 : Math.PI;
        double l = 5.0;
        l = this.cs.getXMagnitude() < 1.0 ? 10.0 : (this.cs.getXMagnitude() > 5.0 ? 1.0 : 5.0);
        double ll = 0.0;
        double ld = 5.0;
        int m = 5;
        int j = 0;
        double dex = (double)sx + length * Math.cos(alpha) * this.cs.getXMagnitude();
        double dey = (double)sy + length * Math.sin(alpha) * this.cs.getYMagnitude();
        alpha += 1.5707963267948966;
        boolean debut = true;
        for (double i = 0.0; i <= length; i += l) {
            if (j++ == m || debut) {
                j = 1;
                ll = 2.0 * ld;
                debut = false;
            } else {
                ll = ld;
            }
            double x = dex * i / length + (double)sx * (length - i) / length;
            double y = dey * i / length + (double)sy * (length - i) / length;
            int x1 = (int)(x - ll * Math.cos(alpha));
            int x2 = (int)(x + ll * Math.cos(alpha));
            int y1 = (int)(y - ll * Math.sin(alpha));
            int y2 = (int)(y + ll * Math.sin(alpha));
            g.drawLine(x1, y1, x2, y2);
        }
        Font f = new Font(rulerFont, 0, 10);
        g.setFont(f);
        String t1 = Globals.roundTo(length, 2);
        String t2 = Globals.roundTo(length * 0.127, 2) + " mm";
        FontMetrics fm = g.getFontMetrics(f);
        g.setColor(Color.white);
        g.fillRect(ex + 10, ey, Math.max(fm.stringWidth(t1), fm.stringWidth(t2)) + 1, 24);
        g.setColor(editingColor.getColorSwing());
        g.drawRect(ex + 9, ey - 1, Math.max(fm.stringWidth(t1), fm.stringWidth(t2)) + 2, 25);
        g.setColor(editingColor.getColorSwing().darker().darker());
        g.drawString(t1, ex + 10, ey + 10);
        g.drawString(t2, ex + 10, ey + 20);
    }

    public EditorActions getEditorActions() {
        return this.edt;
    }

    public CopyPasteActions getCopyPasteActions() {
        return this.cpa;
    }

    public ParserActions getParserActions() {
        return this.pa;
    }

    public UndoActions getUndoActions() {
        return this.ua;
    }

    public ContinuosMoveActions getContinuosMoveActions() {
        return this.eea;
    }

    public void setPropertiesForPrimitive() {
        Vector<ParameterDescription> v;
        GraphicPrimitive gp = this.edt.getFirstSelectedPrimitive();
        if (gp == null) {
            return;
        }
        if (this.edt.isUniquePrimitiveSelected()) {
            v = gp.getControls();
        } else {
            v = new Vector(1);
            ParameterDescription pd = new ParameterDescription();
            pd.parameter = new LayerInfo(gp.getLayer());
            pd.description = Globals.messages.getString("ctrl_layer");
            v.add(pd);
        }
        DialogParameters dp = new DialogParameters((JFrame)Globals.activeWindow, v, this.extStrict, this.P.getLayers());
        dp.setVisible(true);
        if (dp.active) {
            if (this.edt.isUniquePrimitiveSelected()) {
                gp.setControls(dp.getCharacteristics());
            } else {
                ParameterDescription pd = v.get(0);
                v = dp.getCharacteristics();
                if (pd.parameter instanceof LayerInfo) {
                    int l = ((LayerInfo)pd.parameter).getLayer();
                    this.edt.setLayerForSelectedPrimitives(l);
                } else {
                    System.out.println("Warning: unexpected parameter! (layer)");
                }
            }
            this.P.setChanged(true);
            this.P.sortPrimitiveLayers();
            this.ua.saveUndoState();
            this.repaint();
        }
    }

    public void selectAndSetProperties(int x, int y) {
        this.edt.setSelectionAll(false);
        this.edt.handleSelection(this.cs, x, y, false);
        this.repaint();
        this.setPropertiesForPrimitive();
    }

    public boolean getStrictCompatibility() {
        return this.extStrict;
    }

    public void setStrictCompatibility(boolean strict) {
        this.extStrict = strict;
    }

    public void setMapCoordinates(MapCoordinates m) {
        this.cs = m;
        this.P.setChanged(true);
    }

    public MapCoordinates getMapCoordinates() {
        return this.cs;
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() instanceof JMenuItem) {
            String arg = evt.getActionCommand();
            if (arg.equals(Globals.messages.getString("Param_opt"))) {
                this.setPropertiesForPrimitive();
            } else if (arg.equals(Globals.messages.getString("Copy"))) {
                this.cpa.copySelected(!this.extStrict, false, this.getMapCoordinates().getXGridStep(), this.getMapCoordinates().getYGridStep());
            } else if (arg.equals(Globals.messages.getString("Cut"))) {
                this.cpa.copySelected(!this.extStrict, false, this.getMapCoordinates().getXGridStep(), this.getMapCoordinates().getYGridStep());
                this.edt.deleteAllSelected(true);
                this.repaint();
            } else if (arg.equals(Globals.messages.getString("Paste"))) {
                this.cpa.paste(this.getMapCoordinates().getXGridStep(), this.getMapCoordinates().getYGridStep());
                this.repaint();
            } else if (arg.equals(Globals.messages.getString("SelectAll"))) {
                this.edt.setSelectionAll(true);
                this.repaint();
            } else if (arg.equals(Globals.messages.getString("Rotate"))) {
                if (this.eea.isEnteringMacro()) {
                    this.eea.rotateMacro();
                } else {
                    this.edt.rotateAllSelected();
                }
                this.repaint();
            } else if (arg.equals(Globals.messages.getString("Mirror_E"))) {
                if (this.eea.isEnteringMacro()) {
                    this.eea.mirrorMacro();
                } else {
                    this.edt.mirrorAllSelected();
                }
                this.repaint();
            } else if (arg.equals(Globals.messages.getString("Symbolize"))) {
                if (this.edt.getFirstSelectedPrimitive() == null) {
                    return;
                }
                DialogSymbolize s = new DialogSymbolize(this, this.P);
                s.setModal(true);
                s.setVisible(true);
                try {
                    LibUtils.saveLibraryState(this.ua);
                }
                catch (IOException e) {
                    System.out.println("Exception: " + e);
                }
                this.repaint();
            } else if (arg.equals(Globals.messages.getString("Unsymbolize"))) {
                StringBuffer s = this.edt.getSelectedString(true, this.pa);
                this.edt.deleteAllSelected(false);
                this.pa.addString(this.pa.splitMacros(s, true), true);
                this.ua.saveUndoState();
                this.repaint();
            } else if (arg.equals(Globals.messages.getString("Remove_node"))) {
                if (this.edt.getFirstSelectedPrimitive() instanceof PrimitivePolygon) {
                    PrimitivePolygon poly = (PrimitivePolygon)this.edt.getFirstSelectedPrimitive();
                    poly.removePoint(this.getMapCoordinates().unmapXnosnap(this.menux), this.getMapCoordinates().unmapYnosnap(this.menuy), 1.0);
                    this.ua.saveUndoState();
                    this.repaint();
                } else if (this.edt.getFirstSelectedPrimitive() instanceof PrimitiveComplexCurve) {
                    PrimitiveComplexCurve curve = (PrimitiveComplexCurve)this.edt.getFirstSelectedPrimitive();
                    curve.removePoint(this.getMapCoordinates().unmapXnosnap(this.menux), this.getMapCoordinates().unmapYnosnap(this.menuy), 1.0);
                    this.ua.saveUndoState();
                    this.repaint();
                }
            } else if (arg.equals(Globals.messages.getString("Add_node"))) {
                if (this.edt.getFirstSelectedPrimitive() instanceof PrimitivePolygon) {
                    PrimitivePolygon poly = (PrimitivePolygon)this.edt.getFirstSelectedPrimitive();
                    poly.addPointClosest(this.getMapCoordinates().unmapXsnap(this.menux), this.getMapCoordinates().unmapYsnap(this.menuy));
                    this.ua.saveUndoState();
                    this.repaint();
                } else if (this.edt.getFirstSelectedPrimitive() instanceof PrimitiveComplexCurve) {
                    PrimitiveComplexCurve poly = (PrimitiveComplexCurve)this.edt.getFirstSelectedPrimitive();
                    poly.addPointClosest(this.getMapCoordinates().unmapXsnap(this.menux), this.getMapCoordinates().unmapYsnap(this.menuy));
                    this.ua.saveUndoState();
                    this.repaint();
                }
            }
        }
    }

    public void forcesRepaint() {
        this.repaint();
    }

    public void forcesRepaint(int a, int b, int c, int d) {
        this.repaint(a, b, c, d);
    }
}

