/*
 * Decompiled with CFR 0.152.
 */
package circuit.controllers;

import circuit.controllers.EditorActions;
import circuit.controllers.ElementsEdtActions;
import circuit.controllers.UndoActions;
import circuit.model.DrawingModel;
import geom.ChangeCoordinatesListener;
import geom.MapCoordinates;
import globals.Globals;
import java.io.IOException;
import layers.StandardLayers;
import primitives.PrimitiveComplexCurve;
import primitives.PrimitiveLine;
import primitives.PrimitiveMacro;
import primitives.PrimitiveOval;
import primitives.PrimitivePCBLine;
import primitives.PrimitivePolygon;
import primitives.PrimitiveRectangle;

public class ContinuosMoveActions
extends ElementsEdtActions {
    private ChangeCoordinatesListener coordinatesListener = null;

    public ContinuosMoveActions(DrawingModel pp, UndoActions u, EditorActions e) {
        super(pp, u, e);
    }

    public void addChangeCoordinatesListener(ChangeCoordinatesListener c) {
        this.coordinatesListener = c;
    }

    public boolean continuosMove(MapCoordinates cs, int x, int y, int xa, int ya, boolean isControl) {
        if (this.coordinatesListener != null) {
            this.coordinatesListener.changeCoordinates(cs.unmapXsnap(xa), cs.unmapYsnap(ya));
        }
        boolean toRepaint = false;
        if (this.actionSelected != 13) {
            this.primEdit = null;
        }
        if (this.actionSelected == 13) {
            try {
                int orientation = 0;
                boolean mirror = false;
                if (this.primEdit instanceof PrimitiveMacro) {
                    orientation = ((PrimitiveMacro)this.primEdit).getOrientation();
                    mirror = ((PrimitiveMacro)this.primEdit).isMirrored();
                }
                PrimitiveMacro n = new PrimitiveMacro(this.P.getLibrary(), StandardLayers.createEditingLayerArray(), cs.unmapXsnap(x), cs.unmapYsnap(y), this.macroKey, "", cs.unmapXsnap(x) + 10, cs.unmapYsnap(y) + 5, "", cs.unmapXsnap(x) + 10, cs.unmapYsnap(y) + 10, this.P.getTextFont(), this.P.getTextFontSize(), orientation, mirror);
                n.setDrawOnlyLayer(-1);
                this.primEdit = n;
                toRepaint = true;
                this.successiveMove = true;
            }
            catch (IOException E) {
                System.out.println("Warning: exception while handling macro: " + E);
            }
        }
        if (this.clickNumber == 0) {
            return toRepaint;
        }
        if (this.actionSelected == 4) {
            this.primEdit = new PrimitiveLine(this.xpoly[1], this.ypoly[1], cs.unmapXsnap(x), cs.unmapYsnap(y), 0, false, false, 0, 3, 2, 0, this.P.getTextFont(), this.P.getTextFontSize());
            toRepaint = true;
            this.successiveMove = true;
            if (this.coordinatesListener != null) {
                double w = Math.sqrt((this.xpoly[1] - cs.unmapXsnap(xa)) * (this.xpoly[1] - cs.unmapXsnap(xa)) + (this.ypoly[1] - cs.unmapYsnap(ya)) * (this.ypoly[1] - cs.unmapYsnap(ya)));
                double wmm = w * 127.0 / 1000.0;
                this.coordinatesListener.changeInfos(Globals.messages.getString("length") + Globals.roundTo(w, 2) + " (" + Globals.roundTo(wmm, 2) + " mm)");
            }
        }
        if (this.actionSelected == 11) {
            this.primEdit = new PrimitivePCBLine(this.xpoly[1], this.ypoly[1], cs.unmapXsnap(x), cs.unmapYsnap(y), this.PCB_thickness, 0, this.P.getTextFont(), this.P.getTextFontSize());
            toRepaint = true;
            this.successiveMove = true;
            if (this.coordinatesListener != null) {
                double w = Math.sqrt((this.xpoly[1] - cs.unmapXsnap(xa)) * (this.xpoly[1] - cs.unmapXsnap(xa)) + (this.ypoly[1] - cs.unmapYsnap(ya)) * (this.ypoly[1] - cs.unmapYsnap(ya)));
                this.coordinatesListener.changeInfos(Globals.messages.getString("length") + Globals.roundTo(w, 2));
            }
        }
        if (this.actionSelected == 6) {
            this.primEdit = new PrimitivePolygon(false, 0, 0, this.P.getTextFont(), this.P.getTextFontSize());
            for (int i = 1; i <= this.clickNumber; ++i) {
                ((PrimitivePolygon)this.primEdit).addPoint(this.xpoly[i], this.ypoly[i]);
            }
            ((PrimitivePolygon)this.primEdit).addPoint(cs.unmapXsnap(x), cs.unmapYsnap(y));
            toRepaint = true;
            this.successiveMove = true;
        }
        if (this.actionSelected == 7) {
            this.primEdit = new PrimitivePolygon(false, 0, 0, this.P.getTextFont(), this.P.getTextFontSize());
            for (int i = 1; i <= this.clickNumber && i < 256; ++i) {
                ((PrimitivePolygon)this.primEdit).addPoint(this.xpoly[i], this.ypoly[i]);
            }
            ((PrimitivePolygon)this.primEdit).addPoint(cs.unmapXsnap(x), cs.unmapYsnap(y));
            toRepaint = true;
            this.successiveMove = true;
        }
        if (this.actionSelected == 14) {
            this.primEdit = new PrimitiveComplexCurve(false, false, 0, false, false, 0, 3, 2, 0, this.P.getTextFont(), this.P.getTextFontSize());
            for (int i = 1; i <= this.clickNumber && i < 256; ++i) {
                ((PrimitiveComplexCurve)this.primEdit).addPoint(this.xpoly[i], this.ypoly[i]);
            }
            ((PrimitiveComplexCurve)this.primEdit).addPoint(cs.unmapXsnap(x), cs.unmapYsnap(y));
            toRepaint = true;
            this.successiveMove = true;
        }
        if (this.actionSelected == 9) {
            int ymm = isControl && this.clickNumber > 0 ? cs.mapY(this.xpoly[1], this.ypoly[1]) + x - cs.mapX(this.xpoly[1], this.ypoly[1]) : y;
            this.primEdit = new PrimitiveRectangle(this.xpoly[1], this.ypoly[1], cs.unmapXsnap(x), cs.unmapYsnap(ymm), false, 0, 0, this.P.getTextFont(), this.P.getTextFontSize());
            toRepaint = true;
            this.successiveMove = true;
        }
        if (this.actionSelected == 8) {
            int ymm = isControl && this.clickNumber > 0 ? cs.mapY(this.xpoly[1], this.ypoly[1]) + x - cs.mapX(this.xpoly[1], this.ypoly[1]) : y;
            this.primEdit = new PrimitiveOval(this.xpoly[1], this.ypoly[1], cs.unmapXsnap(x), cs.unmapYsnap(ymm), false, 0, 0, this.P.getTextFont(), this.P.getTextFontSize());
            toRepaint = true;
            this.successiveMove = true;
        }
        return toRepaint;
    }
}

