/*
 * Decompiled with CFR 0.152.
 */
package geom;

import java.util.Stack;

public class MapCoordinates {
    private double xCenter = 0.0;
    private double yCenter = 0.0;
    private double xMagnitude = 1.0;
    private double yMagnitude = 1.0;
    private int orientation = 0;
    public boolean mirror;
    public boolean isMacro = false;
    public boolean snapActive = true;
    public static final double MIN_MAGNITUDE = 0.25;
    public static final double MAX_MAGNITUDE = 20.0;
    private double vx;
    private int ivx;
    private double vy;
    private int ivy;
    private int xMin;
    private int xMax;
    private int yMin;
    private int yMax;
    private int xGridStep = 5;
    private int yGridStep = 5;
    private final Stack<MapCoordinates> stack;

    public MapCoordinates() {
        this.resetMinMax();
        this.stack = new Stack();
    }

    public void setOrientation(int o) {
        this.orientation = o;
        if (this.orientation < 0) {
            this.orientation = 0;
        }
        if (this.orientation > 3) {
            this.orientation = 3;
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public boolean getMirror() {
        return this.mirror;
    }

    public void push() {
        MapCoordinates m = new MapCoordinates();
        m.xCenter = this.xCenter;
        m.yCenter = this.yCenter;
        m.xMagnitude = this.xMagnitude;
        m.yMagnitude = this.yMagnitude;
        m.orientation = this.orientation;
        m.mirror = this.mirror;
        m.isMacro = this.isMacro;
        m.snapActive = this.snapActive;
        m.xMin = this.xMin;
        m.xMax = this.xMax;
        m.yMin = this.yMin;
        m.yMax = this.yMax;
        m.xGridStep = this.xGridStep;
        m.yGridStep = this.yGridStep;
        this.stack.push(m);
    }

    public void pop() {
        if (this.stack.empty()) {
            System.out.println("Warning: I can not pop the coordinate state out of an empty stack!");
        } else {
            MapCoordinates m = this.stack.pop();
            this.xCenter = m.xCenter;
            this.yCenter = m.yCenter;
            this.xMagnitude = m.xMagnitude;
            this.yMagnitude = m.yMagnitude;
            this.orientation = m.orientation;
            this.mirror = m.mirror;
            this.isMacro = m.isMacro;
            this.snapActive = m.snapActive;
            this.xMin = m.xMin;
            this.xMax = m.xMax;
            this.yMin = m.yMin;
            this.yMax = m.yMax;
            this.xGridStep = m.xGridStep;
            this.yGridStep = m.yGridStep;
        }
    }

    public final void setSnap(boolean s) {
        this.snapActive = s;
    }

    public final boolean getSnap() {
        return this.snapActive;
    }

    public final void setXGridStep(int xg) {
        if (xg > 0) {
            this.xGridStep = xg;
        }
    }

    public final void setYGridStep(int yg) {
        if (yg > 0) {
            this.yGridStep = yg;
        }
    }

    public final int getXGridStep() {
        return this.xGridStep;
    }

    public final int getYGridStep() {
        return this.yGridStep;
    }

    public final double getXMagnitude() {
        return this.xMagnitude;
    }

    public final double getYMagnitude() {
        return this.yMagnitude;
    }

    public final void setXMagnitude(double txm) {
        double xm = txm;
        if (Math.abs(xm) < 0.25) {
            xm = 0.25;
        }
        if (Math.abs(xm) > 20.0) {
            xm = 20.0;
        }
        this.xMagnitude = xm;
    }

    public final void setYMagnitude(double tym) {
        double ym = tym;
        if (Math.abs(ym) < 0.25) {
            ym = 0.25;
        }
        if (Math.abs(ym) > 20.0) {
            ym = 20.0;
        }
        this.yMagnitude = ym;
    }

    public final double getXCenter() {
        return this.xCenter;
    }

    public final double getYCenter() {
        return this.yCenter;
    }

    public final void setXCenter(double xm) {
        this.xCenter = xm;
    }

    public final void setYCenter(double ym) {
        this.yCenter = ym;
    }

    public final void setMagnitudes(double xm, double ym) {
        this.setXMagnitude(xm);
        this.setYMagnitude(ym);
    }

    public final int getXMax() {
        return this.xMax;
    }

    public final int getYMax() {
        return this.yMax;
    }

    public final int getXMin() {
        return this.xMin;
    }

    public final int getYMin() {
        return this.yMin;
    }

    public final void resetMinMax() {
        this.yMin = Integer.MAX_VALUE;
        this.xMin = Integer.MAX_VALUE;
        this.yMax = Integer.MIN_VALUE;
        this.xMax = Integer.MIN_VALUE;
    }

    public final int mapX(double xc, double yc) {
        return this.mapXi(xc, yc, true);
    }

    public final int mapXi(double xc, double yc, boolean track) {
        this.ivx = (int)Math.round(this.mapXr(xc, yc));
        if (track) {
            if (this.ivx < this.xMin) {
                this.xMin = this.ivx;
            }
            if (this.ivx > this.xMax) {
                this.xMax = this.ivx;
            }
        }
        return this.ivx;
    }

    public final double mapXr(double txc, double tyc) {
        double xc = txc;
        double yc = tyc;
        if (this.isMacro) {
            xc -= 100.0;
            yc -= 100.0;
            if (this.mirror) {
                switch (this.orientation) {
                    case 0: {
                        this.vx = -xc * this.xMagnitude;
                        break;
                    }
                    case 1: {
                        this.vx = yc * this.yMagnitude;
                        break;
                    }
                    case 2: {
                        this.vx = xc * this.xMagnitude;
                        break;
                    }
                    case 3: {
                        this.vx = -yc * this.yMagnitude;
                        break;
                    }
                    default: {
                        this.vx = -xc * this.xMagnitude;
                        break;
                    }
                }
            } else {
                switch (this.orientation) {
                    case 0: {
                        this.vx = xc * this.xMagnitude;
                        break;
                    }
                    case 1: {
                        this.vx = -yc * this.yMagnitude;
                        break;
                    }
                    case 2: {
                        this.vx = -xc * this.xMagnitude;
                        break;
                    }
                    case 3: {
                        this.vx = yc * this.yMagnitude;
                        break;
                    }
                    default: {
                        this.vx = xc * this.xMagnitude;
                        break;
                    }
                }
            }
        } else {
            this.vx = xc * this.xMagnitude;
        }
        return this.vx + this.xCenter;
    }

    public final int mapY(double xc, double yc) {
        return this.mapYi(xc, yc, true);
    }

    public final int mapYi(double xc, double yc, boolean track) {
        this.ivy = (int)Math.round(this.mapYr(xc, yc));
        if (track) {
            if (this.ivy < this.yMin) {
                this.yMin = this.ivy;
            }
            if (this.ivy > this.yMax) {
                this.yMax = this.ivy;
            }
        }
        return this.ivy;
    }

    public final double mapYr(double txc, double tyc) {
        double xc = txc;
        double yc = tyc;
        if (this.isMacro) {
            xc -= 100.0;
            yc -= 100.0;
            switch (this.orientation) {
                case 0: {
                    this.vy = yc * this.yMagnitude;
                    break;
                }
                case 1: {
                    this.vy = xc * this.xMagnitude;
                    break;
                }
                case 2: {
                    this.vy = -yc * this.yMagnitude;
                    break;
                }
                case 3: {
                    this.vy = -xc * this.xMagnitude;
                    break;
                }
                default: {
                    this.vy = 0.0;
                    break;
                }
            }
        } else {
            this.vy = yc * this.yMagnitude;
        }
        return this.vy + this.yCenter;
    }

    public final void trackPoint(double xp, double yp) {
        if (yp < (double)this.yMin) {
            this.yMin = (int)yp;
        }
        if (yp > (double)this.yMax) {
            this.yMax = (int)yp;
        }
        if (xp < (double)this.xMin) {
            this.xMin = (int)xp;
        }
        if (xp > (double)this.xMax) {
            this.xMax = (int)xp;
        }
    }

    public int unmapXnosnap(int X) {
        int xc = (int)(((double)X - this.xCenter) / this.xMagnitude);
        return xc;
    }

    public int unmapYnosnap(int Y) {
        int yc = (int)(((double)Y - this.yCenter) / this.yMagnitude);
        return yc;
    }

    public int unmapXsnap(int X) {
        int xc = (int)(((double)X - this.xCenter) / this.xMagnitude);
        if (this.snapActive) {
            xc = (int)((double)xc / (double)this.xGridStep + 0.5);
            xc *= this.xGridStep;
        }
        return xc;
    }

    public int unmapYsnap(int Y) {
        int yc = (int)(((double)Y - this.yCenter) / this.yMagnitude);
        if (this.snapActive) {
            yc = (int)((double)yc / (double)this.yGridStep + 0.5);
            yc *= this.yGridStep;
        }
        return yc;
    }

    public String toString() {
        String s = "";
        s = s + "[xCenter=" + this.xCenter;
        s = s + "|yCenter=" + this.yCenter;
        s = s + "|xMagnitude=" + this.xMagnitude;
        s = s + "|yMagnitude=" + this.yMagnitude;
        s = s + "|orientation=" + this.orientation;
        s = s + "|mirror=" + this.mirror;
        s = s + "|isMacro=" + this.isMacro;
        s = s + "|snapActive=" + this.snapActive;
        s = s + "|xMin=" + this.xMin;
        s = s + "|xMax=" + this.xMax;
        s = s + "|yMin=" + this.yMin;
        s = s + "|yMax=" + this.yMax;
        s = s + "|xGridStep=" + this.xGridStep;
        s = s + "|yGridStep=" + this.yGridStep + "]";
        return s;
    }
}

