/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj;

import globals.AccessResources;
import globals.Globals;
import globals.Utf8ResourceBundle;
import java.awt.Button;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JApplet;
import javax.swing.JOptionPane;
import net.sourceforge.fidocadj.FidoFrame;

public class FidoCadApplet
extends JApplet
implements ActionListener {
    private static final long serialVersionUID = 10L;
    private FidoFrame popFrame;

    public void init() {
        Button fidoButton = new Button("Launch FidoCadJapplet");
        fidoButton.addActionListener(this);
        this.getContentPane().add(fidoButton);
        this.popFrame = new FidoFrame(false, null);
        this.popFrame.currentLocale = Locale.getDefault();
        try {
            Globals.messages = new AccessResources(Utf8ResourceBundle.getBundle("MessagesBundle", this.popFrame.currentLocale));
        }
        catch (MissingResourceException mre) {
            try {
                Globals.messages = new AccessResources(ResourceBundle.getBundle("MessagesBundle", new Locale("en", "US")));
                System.out.println("No locale available, sorry... interface will be in English");
            }
            catch (MissingResourceException mre1) {
                JOptionPane.showMessageDialog(null, "Unable to find language localization files: " + mre1);
                System.exit(1);
            }
        }
        Globals.useNativeFileDialogs = false;
        Globals.useMetaForMultipleSelection = false;
        if (System.getProperty("os.name").startsWith("Mac")) {
            Globals.shortcutKey = 4;
            Globals.useMetaForMultipleSelection = true;
            Globals.useNativeFileDialogs = true;
        } else {
            Globals.shortcutKey = 2;
        }
        this.popFrame.init();
    }

    public void actionPerformed(ActionEvent evt) {
        if (this.popFrame.isVisible()) {
            this.popFrame.setVisible(false);
        } else {
            this.popFrame.setVisible(true);
        }
    }
}

