/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj;

import circuit.controllers.ParserActions;
import circuit.model.DrawingModel;
import export.ExportGraphic;
import globals.Globals;
import graphic.DimensionG;
import graphic.PointG;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Locale;
import javax.swing.SwingUtilities;
import layers.StandardLayers;
import net.sourceforge.fidocadj.CreateSwingInterface;
import net.sourceforge.fidocadj.FidoFrame;
import timer.MyTimer;

public class FidoMain {
    private static String loadFile = "";
    private static String libDirectory = "";
    private static Locale currentLocale = null;
    private static boolean commandLineOnly = false;
    private static boolean stripOptimization = false;
    private static boolean convertFile = false;
    private static int totx = 0;
    private static int toty = 0;
    private static String exportFormat = "";
    private static String outputFile = "";
    private static boolean headlessMode = false;
    private static boolean resolutionBasedExport = false;
    private static boolean printSize = false;
    private static boolean printTime = false;
    private static double resolution = 1.0;

    public static void main(String[] args) {
        if (args.length >= 1) {
            FidoMain.processArguments(args);
        }
        if (!stripOptimization && System.getProperty("os.name").startsWith("Mac")) {
            System.setProperty("apple.awt.graphics.UseQuartz", "true");
        }
        if (headlessMode) {
            DrawingModel P = new DrawingModel();
            if ("".equals(loadFile)) {
                System.err.println("You should specify a FidoCadJ file toread");
                System.exit(1);
            }
            FidoMain.readLibrariesProbeDirectory(P, false, libDirectory);
            StringBuffer txt = new StringBuffer();
            MyTimer mt = new MyTimer();
            try {
                FileReader input = new FileReader(loadFile);
                BufferedReader bufRead = new BufferedReader(input);
                String line = "";
                txt = new StringBuffer(bufRead.readLine());
                txt.append("\n");
                while (line != null) {
                    line = bufRead.readLine();
                    txt.append(line);
                    txt.append("\n");
                }
                bufRead.close();
                P.setLayers(StandardLayers.createStandardLayers());
                ParserActions pa = new ParserActions(P);
                pa.parseString(new StringBuffer(txt.toString()));
            }
            catch (IllegalArgumentException iae) {
                System.err.println("Illegal filename");
            }
            catch (Exception e) {
                System.err.println("Unable to export: " + e);
            }
            if (convertFile) {
                try {
                    if (resolutionBasedExport) {
                        ExportGraphic.export(new File(outputFile), P, exportFormat, resolution, true, false, true, true);
                    } else {
                        ExportGraphic.exportSize(new File(outputFile), P, exportFormat, totx, toty, true, false, true, true);
                    }
                    System.out.println("Export completed");
                }
                catch (IOException ioe) {
                    System.err.println("Export error: " + ioe);
                }
            }
            if (printSize) {
                PointG o = new PointG(0, 0);
                DimensionG d = ExportGraphic.getImageSize(P, 1.0, true, o);
                System.out.println("" + d.width + " " + d.height);
            }
            if (printTime) {
                System.out.println("Elapsed time: " + mt.getElapsed() + " ms.");
            }
        }
        if (!commandLineOnly) {
            SwingUtilities.invokeLater(new CreateSwingInterface(libDirectory, loadFile, currentLocale));
        }
    }

    private static void processArguments(String[] orArgs) {
        boolean loaded = false;
        boolean nextLib = false;
        String[] args = orArgs;
        if (args[0].equalsIgnoreCase("-print")) {
            String filename = args[1].toLowerCase().replace(".fcd", "");
            if (filename.lastIndexOf(System.getProperty("file.separator")) > 0) {
                filename = filename.substring(filename.lastIndexOf(System.getProperty("file.separator")) + 1);
            }
            args = ("-n -c r72 pdf " + filename + ".pdf " + args[1]).split(" ");
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                if (args[i].trim().equalsIgnoreCase("-open")) continue;
                if (args[i].startsWith("-n")) {
                    commandLineOnly = true;
                    System.setProperty("java.awt.headless", "true");
                    continue;
                }
                if (args[i].startsWith("-d")) {
                    nextLib = true;
                    continue;
                }
                if (args[i].startsWith("-c")) {
                    try {
                        if (args[++i].startsWith("r")) {
                            resolution = Double.parseDouble(args[i].substring(1));
                            resolutionBasedExport = true;
                            if (resolution <= 0.0) {
                                System.err.println("Resolution should bea positive real number");
                                System.exit(1);
                            }
                        } else {
                            totx = Integer.parseInt(args[i]);
                            toty = Integer.parseInt(args[++i]);
                        }
                        exportFormat = args[++i];
                        outputFile = args[++i];
                        convertFile = true;
                        headlessMode = true;
                    }
                    catch (Exception E) {
                        System.err.println("Unable to read the parameters given to -c");
                        System.exit(1);
                    }
                    convertFile = true;
                    continue;
                }
                if (args[i].startsWith("-h")) {
                    FidoMain.showCommandLineHelp();
                    System.exit(0);
                    continue;
                }
                if (args[i].startsWith("-s")) {
                    headlessMode = true;
                    printSize = true;
                    continue;
                }
                if (args[i].startsWith("-t")) {
                    printTime = true;
                    continue;
                }
                if (args[i].startsWith("-p")) {
                    stripOptimization = true;
                    continue;
                }
                if (args[i].startsWith("-l")) {
                    String loc;
                    if (args[i].length() == 2) {
                        if (i == args.length - 1 || args[i + 1].startsWith("-")) {
                            System.err.println("-l option requires a locale language code.");
                            System.exit(1);
                        }
                        loc = args[++i];
                    } else {
                        loc = args[i].substring(2);
                    }
                    currentLocale = new Locale(loc);
                    continue;
                }
                System.err.println("Unrecognized option: " + args[i]);
                FidoMain.showCommandLineHelp();
                System.exit(1);
                continue;
            }
            if (nextLib) {
                libDirectory = args[i];
                System.out.println("Changed the library directory: " + args[i]);
            } else {
                if (loaded) {
                    System.err.println("Only one file can be specified in the command line");
                }
                loadFile = args[i];
                loaded = true;
            }
            nextLib = false;
        }
    }

    private static void showCommandLineHelp() {
        String help = "\nThis is FidoCadJ, version 0.24.4.\nBy Davide Bucci, 2007-2013.\n\nUse: java -jar fidocadj.jar [-options] [file] \nwhere options include:\n\n -n     Do not start the graphical user interface (headless mode)\n\n -d     Set the extern library directory\n        Usage: -d dir\n        where 'dir' is the path of the directory you want to use.\n\n -c     Convert the given file to a graphical format.\n        Usage: -c sx sy eps|pdf|svg|png|jpg|fcd|sch outfile\n        If you use this command line option, you *must* specify a FidoCadJ\n        file to convert.\n        An alternative is to specify the resolution in pixels per logical unit\n        by preceding it by the letter 'r' (without spaces), instead of giving\n        sx and sy.\n\n -s     Print the size  of the specified file in logical coordinates.\n\n -h     Print this help and exit.\n\n -t     Print the time used by FidoCadJ for the specified operation.\n\n -p     Do not activate some platform-dependent optimizations. You might try\n        this option if FidoCadJ hangs or is painfully slow.\n\n -l     Force FidoCadJ to use a certain locale (the code might follow\n        immediately or be separated by an optional space).\n\n [file] The optional (except if you use the -d or -s options) FidoCadJ file to\n        load at startup time.\n\nExample: load and convert a FidoCadJ drawing to a 800x600 pixel png file\n        without using the GUI.\n  java -jar fidocadj.jar -n -c 800 600 png out1.png test1.fcd\n\nExample: load and convert a FidoCadJ drawing to a png file without using the\n        graphic user interface (the so called headless mode).\n        Each FidoCadJ logical unit will be converted in 2 pixels on the image.\n  java -jar fidocadj.jar -n -c r2 png out2.png test2.fcd\n\nExample: load FidoCadJ forcing the locale to simplified chinese (zh).\n  java -jar fidocadj.jar -l zh\n\n";
        System.out.println(help);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readLibrariesProbeDirectory(DrawingModel P, boolean englishLibraries, String libDirectoryO) {
        String libDirectory = libDirectoryO;
        ParserActions pa = new ParserActions(P);
        DrawingModel drawingModel = P;
        synchronized (drawingModel) {
            if (libDirectory == null || libDirectory.length() < 3) {
                libDirectory = System.getProperty("user.home");
            }
            pa.loadLibraryDirectory(libDirectory);
            if (new File(Globals.createCompleteFileName(libDirectory, "IHRAM.FCL")).exists()) {
                System.out.println("IHRAM library got from external file");
            } else if (englishLibraries) {
                pa.loadLibraryInJar(FidoFrame.class.getResource("lib/IHRAM_en.FCL"), "ihram");
            } else {
                pa.loadLibraryInJar(FidoFrame.class.getResource("lib/IHRAM.FCL"), "ihram");
            }
            if (new File(Globals.createCompleteFileName(libDirectory, "FCDstdlib.fcl")).exists()) {
                System.out.println("Standard library got from external file");
            } else if (englishLibraries) {
                pa.loadLibraryInJar(FidoFrame.class.getResource("lib/FCDstdlib_en.fcl"), "");
            } else {
                pa.loadLibraryInJar(FidoFrame.class.getResource("lib/FCDstdlib.fcl"), "");
            }
            if (new File(Globals.createCompleteFileName(libDirectory, "PCB.fcl")).exists()) {
                System.out.println("Standard PCB library got from external file");
            } else if (englishLibraries) {
                pa.loadLibraryInJar(FidoFrame.class.getResource("lib/PCB_en.fcl"), "pcb");
            } else {
                pa.loadLibraryInJar(FidoFrame.class.getResource("lib/PCB.fcl"), "pcb");
            }
            if (new File(Globals.createCompleteFileName(libDirectory, "elettrotecnica.fcl")).exists()) {
                System.out.println("Electrotechnics library got from external file");
            } else if (englishLibraries) {
                pa.loadLibraryInJar(FidoFrame.class.getResource("lib/elettrotecnica_en.fcl"), "elettrotecnica");
            } else {
                pa.loadLibraryInJar(FidoFrame.class.getResource("lib/elettrotecnica.fcl"), "elettrotecnica");
            }
        }
    }
}

