/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.librarymodel;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.fidocadj.librarymodel.Library;
import net.sourceforge.fidocadj.librarymodel.LibraryModel;
import primitives.MacroDesc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Category {
    String name;
    Library parentLibrary;
    List<MacroDesc> macros = new ArrayList<MacroDesc>();
    boolean isHidden;

    Category(String name, Library parentLibrary, boolean isHidden) {
        this.name = name;
        this.parentLibrary = parentLibrary;
        this.isHidden = isHidden;
    }

    public Library getParentLibrary() {
        return this.parentLibrary;
    }

    public void setParentLibrary(Library parentLibrary) {
        this.parentLibrary = parentLibrary;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addMacro(MacroDesc macroDesc) {
        this.macros.add(macroDesc);
    }

    public void removeMacro(MacroDesc macroDesc) {
        this.macros.remove(macroDesc);
    }

    public List<MacroDesc> getAllMacros() {
        return this.macros;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public static boolean isValidName(String name) {
        return true;
    }

    public boolean containsMacroKey(String key) {
        if (key == null) {
            return true;
        }
        for (MacroDesc macro : this.macros) {
            if (!LibraryModel.getPlainMacroKey(macro).equals(key)) continue;
            return true;
        }
        return false;
    }
}

