/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.macropicker;

import java.awt.Graphics;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class ExpandableJTree
extends JTree {
    private boolean runOnce = false;
    private boolean direction = false;

    private void fillExpandState(boolean expand) {
        for (int row = 1; row < this.getRowCount(); ++row) {
            TreePath path = this.getPathForRow(row);
            if (this.getModel().isLeaf(path.getLastPathComponent())) continue;
            this.setExpandedState(path, expand);
        }
    }

    public void expandOnce() {
        this.runOnce = true;
        this.direction = true;
    }

    public void collapseOnce() {
        this.runOnce = true;
        this.direction = false;
    }

    public void selectNextLeaf() {
        int nextRow = this.searchNextLeaf(true);
        if (0 <= nextRow && nextRow < this.getRowCount()) {
            this.setSelectionRow(nextRow);
            this.scrollRowToVisible(nextRow);
        }
    }

    public void selectPrevLeaf() {
        int nextRow = this.searchNextLeaf(false);
        if (0 <= nextRow && nextRow < this.getRowCount()) {
            this.setSelectionRow(nextRow);
            this.scrollRowToVisible(nextRow);
        }
    }

    private int getSelectedRow() {
        int selectedRow = -1;
        int[] selectedRows = this.getSelectionRows();
        selectedRow = selectedRows == null || selectedRows.length == 0 ? -1 : selectedRows[0];
        return selectedRow;
    }

    private int searchNextLeaf(boolean searchForward) {
        int nextRow = this.getSelectedRow();
        for (int i = 0; i < this.getRowCount(); ++i) {
            nextRow = searchForward ? ++nextRow : --nextRow;
            if (nextRow < 0) {
                nextRow = this.getRowCount();
                continue;
            }
            if (this.getRowCount() <= nextRow) {
                nextRow = -1;
                continue;
            }
            if (!this.getModel().isLeaf(this.getPathForRow(nextRow).getLastPathComponent())) continue;
            return nextRow;
        }
        return -1;
    }

    public void paint(Graphics g) {
        if (this.runOnce) {
            this.fillExpandState(this.direction);
            this.runOnce = false;
        }
        super.paint(g);
    }
}

