/*
 * Decompiled with CFR 0.152.
 */
package primitives;

import dialogs.ArrowInfo;
import dialogs.DashInfo;
import dialogs.ParameterDescription;
import export.ExportInterface;
import geom.GeometricDistances;
import geom.MapCoordinates;
import globals.Globals;
import graphic.GraphicsInterface;
import graphic.PointG;
import java.io.IOException;
import java.util.Vector;
import primitives.Arrow;
import primitives.GraphicPrimitive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PrimitiveLine
extends GraphicPrimitive {
    static final int N_POINTS = 4;
    private boolean arrowStart;
    private boolean arrowEnd;
    private int arrowLength;
    private int arrowHalfWidth;
    private int arrowStyle;
    private int dashStyle;
    private int xa;
    private int ya;
    private int xb;
    private int yb;
    private int x1;
    private int y1;
    private int x2;
    private int y2;
    private int h;
    private int l;
    private float w;
    private int length2;
    private int xbpap1;
    private int ybpap1;
    private boolean arrows;

    public PrimitiveLine(int x1, int y1, int x2, int y2, int layer, boolean arrowS, boolean arrowE, int arrowSt, int arrowLe, int arrowWi, int dashSt, String f, int size) {
        this.arrowLength = arrowLe;
        this.arrowHalfWidth = arrowWi;
        this.arrowStart = arrowS;
        this.arrowEnd = arrowE;
        this.arrowStyle = arrowSt;
        this.dashStyle = dashSt;
        this.initPrimitive(-1, f, size);
        this.virtualPoint[0].x = x1;
        this.virtualPoint[0].y = y1;
        this.virtualPoint[1].x = x2;
        this.virtualPoint[1].y = y2;
        this.virtualPoint[this.getNameVirtualPointNumber()].x = x1 + 5;
        this.virtualPoint[this.getNameVirtualPointNumber()].y = y1 + 5;
        this.virtualPoint[this.getValueVirtualPointNumber()].x = x1 + 5;
        this.virtualPoint[this.getValueVirtualPointNumber()].y = y1 + 10;
        this.setLayer(layer);
    }

    public PrimitiveLine(String f, int size) {
        this.arrowLength = 3;
        this.arrowHalfWidth = 1;
        this.initPrimitive(-1, f, size);
    }

    @Override
    public int getControlPointNumber() {
        return 4;
    }

    @Override
    public Vector<ParameterDescription> getControls() {
        Vector<ParameterDescription> v = super.getControls();
        ParameterDescription pd = new ParameterDescription();
        pd = new ParameterDescription();
        pd.parameter = this.arrowStart;
        pd.description = Globals.messages.getString("ctrl_arrow_start");
        pd.isExtension = true;
        v.add(pd);
        pd = new ParameterDescription();
        pd.parameter = this.arrowEnd;
        pd.description = Globals.messages.getString("ctrl_arrow_end");
        pd.isExtension = true;
        v.add(pd);
        pd = new ParameterDescription();
        pd.parameter = this.arrowLength;
        pd.description = Globals.messages.getString("ctrl_arrow_length");
        pd.isExtension = true;
        v.add(pd);
        pd = new ParameterDescription();
        pd.parameter = this.arrowHalfWidth;
        pd.description = Globals.messages.getString("ctrl_arrow_half_width");
        pd.isExtension = true;
        v.add(pd);
        pd = new ParameterDescription();
        pd.parameter = new ArrowInfo(this.arrowStyle);
        pd.description = Globals.messages.getString("ctrl_arrow_style");
        pd.isExtension = true;
        v.add(pd);
        pd = new ParameterDescription();
        pd.parameter = new DashInfo(this.dashStyle);
        pd.description = Globals.messages.getString("ctrl_dash_style");
        pd.isExtension = true;
        v.add(pd);
        return v;
    }

    @Override
    public int setControls(Vector<ParameterDescription> v) {
        int i = super.setControls(v);
        ParameterDescription pd = v.get(i++);
        if (pd.parameter instanceof Boolean) {
            this.arrowStart = (Boolean)pd.parameter;
        } else {
            System.out.println("Warning: 1-unexpected parameter!" + pd);
        }
        pd = v.get(i++);
        if (pd.parameter instanceof Boolean) {
            this.arrowEnd = (Boolean)pd.parameter;
        } else {
            System.out.println("Warning: 2-unexpected parameter!" + pd);
        }
        pd = v.get(i++);
        if (pd.parameter instanceof Integer) {
            this.arrowLength = (Integer)pd.parameter;
        } else {
            System.out.println("Warning: 3-unexpected parameter!" + pd);
        }
        pd = v.get(i++);
        if (pd.parameter instanceof Integer) {
            this.arrowHalfWidth = (Integer)pd.parameter;
        } else {
            System.out.println("Warning: 4-unexpected parameter!" + pd);
        }
        pd = v.get(i++);
        if (pd.parameter instanceof ArrowInfo) {
            this.arrowStyle = ((ArrowInfo)pd.parameter).style;
        } else {
            System.out.println("Warning: 5-unexpected parameter!" + pd);
        }
        pd = v.get(i++);
        if (pd.parameter instanceof DashInfo) {
            this.dashStyle = ((DashInfo)pd.parameter).style;
        } else {
            System.out.println("Warning: 6-unexpected parameter!" + pd);
        }
        if (this.dashStyle >= 5) {
            this.dashStyle = 4;
        }
        if (this.dashStyle < 0) {
            this.dashStyle = 0;
        }
        return i;
    }

    @Override
    public void draw(GraphicsInterface g, MapCoordinates coordSys, Vector layerV) {
        if (!this.selectLayer(g, layerV)) {
            return;
        }
        this.drawText(g, coordSys, layerV, -1);
        if (this.changed) {
            this.changed = false;
            this.x1 = coordSys.mapX(this.virtualPoint[0].x, this.virtualPoint[0].y);
            this.y1 = coordSys.mapY(this.virtualPoint[0].x, this.virtualPoint[0].y);
            this.x2 = coordSys.mapX(this.virtualPoint[1].x, this.virtualPoint[1].y);
            this.y2 = coordSys.mapY(this.virtualPoint[1].x, this.virtualPoint[1].y);
            if (this.x1 > this.x2) {
                this.xa = this.x2;
                this.xb = this.x1;
            } else {
                this.xa = this.x1;
                this.xb = this.x2;
            }
            if (this.y1 > this.y2) {
                this.ya = this.y2;
                this.yb = this.y1;
            } else {
                this.ya = this.y1;
                this.yb = this.y2;
            }
            this.h = Math.abs(coordSys.mapXi(this.arrowHalfWidth, this.arrowHalfWidth, false) - coordSys.mapXi(0.0, 0.0, false));
            this.l = Math.abs(coordSys.mapXi(this.arrowLength, this.arrowLength, false) - coordSys.mapXi(0.0, 0.0, false));
            this.w = (float)(Globals.lineWidth * coordSys.getXMagnitude());
            if (this.w < 0.5f) {
                this.w = 0.5f;
            }
            this.length2 = (this.xa - this.xb) * (this.xa - this.xb) + (this.ya - this.yb) * (this.ya - this.yb);
            boolean bl = this.arrows = this.arrowStart || this.arrowEnd;
            if (this.arrows) {
                this.xa -= this.h;
                this.ya -= this.h;
                this.xb += this.h;
                this.yb += this.h;
            }
            this.xbpap1 = this.xb - this.xa + 1;
            this.ybpap1 = this.yb - this.ya + 1;
        }
        if (this.length2 > 2) {
            if (!g.hitClip(this.xa, this.ya, this.xbpap1, this.ybpap1)) {
                return;
            }
            g.applyStroke(this.w, this.dashStyle);
            int x1_corr = this.x1;
            int y1_corr = this.y1;
            int x2_corr = this.x2;
            int y2_corr = this.y2;
            if (this.arrows) {
                PointG Pc;
                if (this.arrowStart) {
                    Pc = Arrow.drawArrow(g, this.x1, this.y1, this.x2, this.y2, this.l, this.h, this.arrowStyle);
                    x1_corr = Pc.x;
                    y1_corr = Pc.y;
                }
                if (this.arrowEnd) {
                    Pc = Arrow.drawArrow(g, this.x2, this.y2, this.x1, this.y1, this.l, this.h, this.arrowStyle);
                    x2_corr = Pc.x;
                    y2_corr = Pc.y;
                }
            }
            g.drawLine(x1_corr, y1_corr, x2_corr, y2_corr);
        }
    }

    @Override
    public void parseTokens(String[] tokens, int N) throws IOException {
        this.changed = true;
        if (tokens[0].equals("LI")) {
            if (N < 5) {
                IOException E = new IOException("bad arguments on LI");
                throw E;
            }
            int x1 = this.virtualPoint[0].x = Integer.parseInt(tokens[1]);
            int y1 = this.virtualPoint[0].y = Integer.parseInt(tokens[2]);
            this.virtualPoint[1].x = Integer.parseInt(tokens[3]);
            this.virtualPoint[1].y = Integer.parseInt(tokens[4]);
            this.virtualPoint[this.getNameVirtualPointNumber()].x = x1 + 5;
            this.virtualPoint[this.getNameVirtualPointNumber()].y = y1 + 5;
            this.virtualPoint[this.getValueVirtualPointNumber()].x = x1 + 5;
            this.virtualPoint[this.getValueVirtualPointNumber()].y = y1 + 10;
            if (N > 5) {
                this.parseLayer(tokens[5]);
            }
            if (N > 6 && tokens[6].equals("FCJ")) {
                int arrows = Integer.parseInt(tokens[7]);
                this.arrowStart = (arrows & 1) != 0;
                this.arrowEnd = (arrows & 2) != 0;
                this.arrowStyle = Integer.parseInt(tokens[8]);
                this.arrowLength = Integer.parseInt(tokens[9]);
                this.arrowHalfWidth = Integer.parseInt(tokens[10]);
                this.dashStyle = Integer.parseInt(tokens[11]);
                if (this.dashStyle >= 5) {
                    this.dashStyle = 4;
                }
                if (this.dashStyle < 0) {
                    this.dashStyle = 0;
                }
            }
        } else {
            IOException E = new IOException("LI: Invalid primitive:" + tokens[0] + " programming error?");
            throw E;
        }
    }

    @Override
    public int getDistanceToPoint(int px, int py) {
        if (this.checkText(px, py)) {
            return 0;
        }
        return GeometricDistances.pointToSegment(this.virtualPoint[0].x, this.virtualPoint[0].y, this.virtualPoint[1].x, this.virtualPoint[1].y, px, py);
    }

    @Override
    public String toString(boolean extensions) {
        int arrows;
        String s = "LI " + this.virtualPoint[0].x + " " + this.virtualPoint[0].y + " " + this.virtualPoint[1].x + " " + this.virtualPoint[1].y + " " + this.getLayer() + "\n";
        if (extensions && ((arrows = (this.arrowStart ? 1 : 0) | (this.arrowEnd ? 2 : 0)) > 0 || this.dashStyle > 0 || this.name != null && this.name.length() != 0 || this.value != null && this.value.length() != 0)) {
            String text = "0";
            if (this.hasName() || this.hasValue()) {
                text = "1";
            }
            s = s + "FCJ " + arrows + " " + this.arrowStyle + " " + this.arrowLength + " " + this.arrowHalfWidth + " " + this.dashStyle + " " + text + "\n";
        }
        s = s + this.saveText(false);
        return s;
    }

    @Override
    public void export(ExportInterface exp, MapCoordinates cs) throws IOException {
        this.exportText(exp, cs, -1);
        exp.exportLine(cs.mapX(this.virtualPoint[0].x, this.virtualPoint[0].y), cs.mapY(this.virtualPoint[0].x, this.virtualPoint[0].y), cs.mapX(this.virtualPoint[1].x, this.virtualPoint[1].y), cs.mapY(this.virtualPoint[1].x, this.virtualPoint[1].y), this.getLayer(), this.arrowStart, this.arrowEnd, this.arrowStyle, (int)((double)this.arrowLength * cs.getXMagnitude()), (int)((double)this.arrowHalfWidth * cs.getXMagnitude()), this.dashStyle, Globals.lineWidth * cs.getXMagnitude());
    }

    @Override
    public int getNameVirtualPointNumber() {
        return 2;
    }

    @Override
    public int getValueVirtualPointNumber() {
        return 3;
    }
}

