/*
 * Decompiled with CFR 0.152.
 */
package primitives;

import dialogs.DashInfo;
import dialogs.ParameterDescription;
import export.ExportInterface;
import geom.GeometricDistances;
import geom.MapCoordinates;
import globals.Globals;
import graphic.GraphicsInterface;
import java.io.IOException;
import java.util.Vector;
import primitives.GraphicPrimitive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PrimitiveOval
extends GraphicPrimitive {
    static final int N_POINTS = 4;
    private boolean isFilled;
    private int dashStyle;
    private int xa;
    private int ya;
    private int xb;
    private int yb;
    private int x1;
    private int x2;
    private int y1;
    private int y2;
    private float w;

    @Override
    public int getControlPointNumber() {
        return 4;
    }

    public PrimitiveOval(String f, int size) {
        this.isFilled = false;
        this.initPrimitive(-1, f, size);
    }

    public PrimitiveOval(int x1, int y1, int x2, int y2, boolean f, int layer, int dashSt, String font, int size) {
        this.initPrimitive(-1, font, size);
        this.virtualPoint[0].x = x1;
        this.virtualPoint[0].y = y1;
        this.virtualPoint[1].x = x2;
        this.virtualPoint[1].y = y2;
        this.virtualPoint[this.getNameVirtualPointNumber()].x = x1 + 5;
        this.virtualPoint[this.getNameVirtualPointNumber()].y = y1 + 5;
        this.virtualPoint[this.getValueVirtualPointNumber()].x = x1 + 5;
        this.virtualPoint[this.getValueVirtualPointNumber()].y = y1 + 10;
        this.isFilled = f;
        this.dashStyle = dashSt;
        this.setLayer(layer);
    }

    @Override
    public void draw(GraphicsInterface g, MapCoordinates coordSys, Vector layerV) {
        if (!this.selectLayer(g, layerV)) {
            return;
        }
        this.drawText(g, coordSys, layerV, -1);
        if (this.changed) {
            this.changed = false;
            this.x1 = coordSys.mapX(this.virtualPoint[0].x, this.virtualPoint[0].y);
            this.y1 = coordSys.mapY(this.virtualPoint[0].x, this.virtualPoint[0].y);
            this.x2 = coordSys.mapX(this.virtualPoint[1].x, this.virtualPoint[1].y);
            this.y2 = coordSys.mapY(this.virtualPoint[1].x, this.virtualPoint[1].y);
            if (this.x1 > this.x2) {
                this.xa = this.x2;
                this.xb = this.x1;
            } else {
                this.xa = this.x1;
                this.xb = this.x2;
            }
            if (this.y1 > this.y2) {
                this.ya = this.y2;
                this.yb = this.y1;
            } else {
                this.ya = this.y1;
                this.yb = this.y2;
            }
            coordSys.trackPoint(this.xa, this.ya);
            coordSys.trackPoint(this.xb, this.yb);
            this.w = (float)(Globals.lineWidth * coordSys.getXMagnitude());
            if (this.w < 0.5f) {
                this.w = 0.5f;
            }
        }
        if (!g.hitClip(this.xa, this.ya, this.xb - this.xa, this.yb - this.ya)) {
            return;
        }
        g.applyStroke(this.w, this.dashStyle);
        if (this.isFilled) {
            g.fillOval(this.xa, this.ya, this.xb - this.xa, this.yb - this.ya);
        } else {
            g.drawOval(this.xa, this.ya, this.xb - this.xa, this.yb - this.ya);
        }
    }

    @Override
    public void parseTokens(String[] tokens, int N) throws IOException {
        this.changed = true;
        if (tokens[0].equals("EV") || tokens[0].equals("EP")) {
            if (N < 5) {
                IOException E = new IOException("bad arguments on EV/EP");
                throw E;
            }
            int x1 = this.virtualPoint[0].x = Integer.parseInt(tokens[1]);
            int y1 = this.virtualPoint[0].y = Integer.parseInt(tokens[2]);
            this.virtualPoint[1].x = Integer.parseInt(tokens[3]);
            this.virtualPoint[1].y = Integer.parseInt(tokens[4]);
            this.virtualPoint[this.getNameVirtualPointNumber()].x = x1 + 5;
            this.virtualPoint[this.getNameVirtualPointNumber()].y = y1 + 5;
            this.virtualPoint[this.getValueVirtualPointNumber()].x = x1 + 5;
            this.virtualPoint[this.getValueVirtualPointNumber()].y = y1 + 10;
            if (N > 5) {
                this.parseLayer(tokens[5]);
            }
            this.isFilled = tokens[0].equals("EP");
            if (N > 6 && tokens[6].equals("FCJ")) {
                this.dashStyle = Integer.parseInt(tokens[7]);
                if (this.dashStyle >= 5) {
                    this.dashStyle = 4;
                }
                if (this.dashStyle < 0) {
                    this.dashStyle = 0;
                }
            }
        } else {
            IOException E = new IOException("EV/EP: Invalid primitive:" + tokens[0] + " programming error?");
            throw E;
        }
    }

    @Override
    public Vector<ParameterDescription> getControls() {
        Vector<ParameterDescription> v = super.getControls();
        ParameterDescription pd = new ParameterDescription();
        pd.parameter = this.isFilled;
        pd.description = Globals.messages.getString("ctrl_filled");
        v.add(pd);
        pd = new ParameterDescription();
        pd.parameter = new DashInfo(this.dashStyle);
        pd.description = Globals.messages.getString("ctrl_dash_style");
        pd.isExtension = true;
        v.add(pd);
        return v;
    }

    @Override
    public int setControls(Vector<ParameterDescription> v) {
        int i = super.setControls(v);
        ParameterDescription pd = v.get(i);
        ++i;
        if (pd.parameter instanceof Boolean) {
            this.isFilled = (Boolean)pd.parameter;
        } else {
            System.out.println("Warning: unexpected parameter!" + pd);
        }
        pd = v.get(i++);
        if (pd.parameter instanceof DashInfo) {
            this.dashStyle = ((DashInfo)pd.parameter).style;
        } else {
            System.out.println("Warning: unexpected parameter!" + pd);
        }
        if (this.dashStyle >= 5) {
            this.dashStyle = 4;
        }
        if (this.dashStyle < 0) {
            this.dashStyle = 0;
        }
        return i;
    }

    @Override
    public int getDistanceToPoint(int px, int py) {
        if (this.checkText(px, py)) {
            return 0;
        }
        int xa = Math.min(this.virtualPoint[0].x, this.virtualPoint[1].x);
        int ya = Math.min(this.virtualPoint[0].y, this.virtualPoint[1].y);
        int xb = Math.max(this.virtualPoint[0].x, this.virtualPoint[1].x);
        int yb = Math.max(this.virtualPoint[0].y, this.virtualPoint[1].y);
        if (this.isFilled) {
            if (GeometricDistances.pointInEllipse(xa, ya, xb - xa, yb - ya, px, py)) {
                return 0;
            }
            return 1000;
        }
        return GeometricDistances.pointToEllipse(xa, ya, xb - xa, yb - ya, px, py);
    }

    @Override
    public String toString(boolean extensions) {
        String cmd = this.isFilled ? "EP " : "EV ";
        cmd = cmd + this.virtualPoint[0].x + " " + this.virtualPoint[0].y + " " + this.virtualPoint[1].x + " " + this.virtualPoint[1].y + " " + this.getLayer() + "\n";
        if (extensions && (this.dashStyle > 0 || this.hasName() || this.hasValue())) {
            String text = "0";
            if (this.name.length() != 0 || this.value.length() != 0) {
                text = "1";
            }
            cmd = cmd + "FCJ " + this.dashStyle + " " + text + "\n";
        }
        cmd = cmd + this.saveText(false);
        return cmd;
    }

    @Override
    public void export(ExportInterface exp, MapCoordinates cs) throws IOException {
        this.exportText(exp, cs, -1);
        exp.exportOval(cs.mapX(this.virtualPoint[0].x, this.virtualPoint[0].y), cs.mapY(this.virtualPoint[0].x, this.virtualPoint[0].y), cs.mapX(this.virtualPoint[1].x, this.virtualPoint[1].y), cs.mapY(this.virtualPoint[1].x, this.virtualPoint[1].y), this.isFilled, this.getLayer(), this.dashStyle, Globals.lineWidth * cs.getXMagnitude());
    }

    @Override
    public int getNameVirtualPointNumber() {
        return 2;
    }

    @Override
    public int getValueVirtualPointNumber() {
        return 3;
    }
}

