/*
 * Decompiled with CFR 0.152.
 */
import gnu.io.CommPortIdentifier;
import gnu.io.ParallelPort;
import gnu.io.ParallelPortEvent;
import gnu.io.ParallelPortEventListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class _dev_LPT
extends JMCADObject
implements ParallelPortEventListener {
    private final Image img = new ImageIcon(this.getClass().getResource("_dev_LPT.gif")).getImage();
    private JComboBox cb_port = new JComboBox();
    private String PortName = "";
    private boolean PortChacked = false;
    private ParallelPort PPort = null;
    private InputStream ins;
    private OutputStream outs;

    @Override
    public void write(RandomAccessFile randomAccessFile) throws IOException {
        super.write(randomAccessFile);
        randomAccessFile.writeBytes("PortName = " + this.PortName + "\n");
    }

    @Override
    public void parse(String string) {
        Object object;
        Object object2;
        super.parse(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            try {
                String string2;
                object2 = stringTokenizer.nextToken();
                if (((String)(object2 = ((String)object2).trim())).length() == 0 || !(string2 = ((StringTokenizer)(object = new StringTokenizer((String)object2, " =,\t"))).nextToken()).equalsIgnoreCase("PORTNAME")) continue;
                try {
                    this.PortName = ((StringTokenizer)object).nextToken();
                }
                catch (Exception exception) {
                    this.error(exception);
                }
            }
            catch (Exception exception) {
                this.error(exception);
            }
        }
        try {
            this.init();
        }
        catch (Exception exception) {
            this.error(exception);
        }
        object2 = new JPanel();
        object = new JPanel();
        ((JComponent)object2).setBackground(Color.YELLOW);
        ((JComponent)object).setBackground(Color.GREEN);
        this.panel_c.setLayout(new GridLayout(1, 2));
        this.panel_c.add((Component)object2);
        this.panel_c.add((Component)object);
    }

    public _dev_LPT() {
        this.ToolTipText = "Parallel Port (IEEE 1284)";
        this.in = new double[1];
        this.in[0] = Double.NaN;
        this.in_text = new String[1];
        this.in_text[0] = "IN";
        this.out = new double[1];
        this.out[0] = Double.NaN;
        this.out_text = new String[1];
        this.out_text[0] = "OUT";
        this.out_obj = new Object[1];
        this.out_obj_index = new int[1];
        this.w = 76;
        this.h = 36;
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel.setBackground(Color.YELLOW);
        jPanel2.setBackground(Color.GREEN);
        this.panel_c.setLayout(new GridLayout(1, 2));
        this.panel_c.add(jPanel);
        this.panel_c.add(jPanel2);
    }

    @Override
    public void paint_info(Graphics graphics) {
        graphics.drawImage(this.img, 0, 0, this);
    }

    @Override
    public void calc_pre() {
        try {
            CommPortIdentifier commPortIdentifier = CommPortIdentifier.getPortIdentifier(this.PortName);
            this.PPort = (ParallelPort)commPortIdentifier.open(this.PortName, 2000);
            this.ins = this.PPort.getInputStream();
            this.outs = this.PPort.getOutputStream();
            this.PPort.removeEventListener();
            this.PPort.addEventListener(this);
            this.PPort.notifyOnBuffer(true);
        }
        catch (Exception exception) {
            this.error(exception);
        }
    }

    @Override
    public void calc() {
        try {
            if (!Double.isInfinite(this.in[0])) {
                this.outs.write((byte)this.in[0]);
                this.in[0] = Double.NaN;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void calc_post() {
        try {
            this.ins.close();
            this.outs.close();
            this.PPort.close();
        }
        catch (Exception exception) {
            this.error(exception);
        }
    }

    @Override
    public void edit_pre() {
        if (!this.PortChacked) {
            String[] stringArray;
            Vector<String> vector = new Vector<String>();
            Enumeration enumeration = CommPortIdentifier.getPortIdentifiers();
            while (enumeration.hasMoreElements()) {
                stringArray = (String[])enumeration.nextElement();
                if (stringArray.getPortType() != 2) continue;
                vector.addElement(stringArray.getName());
            }
            stringArray = new String[vector.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = vector.elementAt(i) + "";
            }
            this.cb_port.setModel(new DefaultComboBoxModel<String>(stringArray));
            this.PortChacked = true;
        }
        this.cb_port.setSelectedItem(this.PortName);
        this.edit_panel = new JPanel(new BorderLayout());
        this.edit_panel.add((Component)new JLabel(ResourceBundle.getBundle("JMCAD_Internationalize").getString("Port") + ": "), "East");
        this.edit_panel.add((Component)this.cb_port, "Center");
    }

    @Override
    public void edit_post() {
        try {
            this.PortName = this.cb_port.getSelectedItem() + "";
        }
        catch (Exception exception) {
            this.error(exception);
        }
    }

    @Override
    public void parallelEvent(ParallelPortEvent parallelPortEvent) {
        switch (parallelPortEvent.getEventType()) {
            case 1: {
                break;
            }
            case 2: {
                try {
                    int n;
                    while ((n = this.ins.read()) > -1) {
                        if (Double.isInfinite(n) || Double.isNaN(n)) continue;
                        ((JMCADObject)this.out_obj[0]).set(n, this.out_obj_index[0]);
                    }
                    break;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }
}

