/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.j3d;

import com.eteks.sweethome3d.j3d.ModelManager;
import com.eteks.sweethome3d.j3d.Object3DBranchFactory;
import com.eteks.sweethome3d.j3d.PhotoRenderer;
import com.eteks.sweethome3d.j3d.Room3D;
import com.eteks.sweethome3d.j3d.YafarayRenderer;
import com.eteks.sweethome3d.model.Camera;
import com.eteks.sweethome3d.model.Compass;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.ObserverCamera;
import com.eteks.sweethome3d.model.Room;
import com.eteks.sweethome3d.model.Selectable;
import com.eteks.sweethome3d.model.Transformation;
import com.eteks.sweethome3d.viewcontroller.Object3DFactory;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.media.j3d.Bounds;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Group;
import javax.media.j3d.IndexedGeometryArray;
import javax.media.j3d.Node;
import javax.media.j3d.Texture;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.TexCoord2f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPhotoRenderer {
    private final Quality quality;
    private final Home home;

    public AbstractPhotoRenderer(Home home, Quality quality) {
        this.home = home;
        this.quality = quality;
    }

    public static AbstractPhotoRenderer createInstance(String string, Home home, Object3DFactory object3DFactory, Quality quality) {
        if (string != null) {
            try {
                Constructor<?> constructor = Class.forName(string).getConstructor(Home.class, Object3DFactory.class, Quality.class);
                AbstractPhotoRenderer abstractPhotoRenderer = (AbstractPhotoRenderer)constructor.newInstance(new Object[]{home, object3DFactory, quality});
                if (abstractPhotoRenderer.isAvailable()) {
                    return abstractPhotoRenderer;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            return new PhotoRenderer(home, object3DFactory, quality);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static List<String> getAvailableRenderers() {
        String string = System.getProperty("com.eteks.sweethome3d.j3d.rendererClassNames", PhotoRenderer.class.getName() + "," + YafarayRenderer.class.getName());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : string.split(",")) {
            string2 = string2.trim();
            if (!PhotoRenderer.class.getName().equals(string2) && PhotoRenderer.class.getName().equals(AbstractPhotoRenderer.createInstance(string2, new Home(), null, Quality.LOW).getClass().getName())) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public boolean isAvailable() {
        return true;
    }

    public abstract String getName();

    public Home getHome() {
        return this.home;
    }

    public Quality getQuality() {
        return this.quality;
    }

    public void render(BufferedImage bufferedImage, Camera camera, ImageObserver imageObserver) throws IOException {
        this.render(bufferedImage, camera, null, imageObserver);
    }

    public abstract void render(BufferedImage var1, Camera var2, List<? extends Selectable> var3, ImageObserver var4) throws IOException;

    public abstract void stop();

    public abstract void dispose();

    protected String getRenderingParameterValue(String string) {
        String string2 = this.quality.name().toLowerCase(Locale.ENGLISH) + "Quality." + string;
        String string3 = this.getClass().getName();
        String string4 = System.getProperty(string3 + '.' + string2);
        if (string4 != null) {
            return string4;
        }
        return ResourceBundle.getBundle(string3).getString(string2);
    }

    void updateModelTransformations(Node node, Transformation[] transformationArray) {
        for (Transformation transformation : transformationArray) {
            String string = transformation.getName() + "_transformation";
            this.updateTransformation(node, string, transformation.getMatrix());
        }
    }

    private void updateTransformation(Node node, String string, float[][] fArray) {
        if (node instanceof Group) {
            if (node instanceof TransformGroup && string.equals(node.getUserData())) {
                Matrix4f matrix4f = new Matrix4f();
                matrix4f.setRow(0, fArray[0]);
                matrix4f.setRow(1, fArray[1]);
                matrix4f.setRow(2, fArray[2]);
                matrix4f.setRow(3, new float[]{0.0f, 0.0f, 0.0f, 1.0f});
                ((TransformGroup)node).setTransform(new Transform3D(matrix4f));
            } else {
                Enumeration enumeration = ((Group)node).getAllChildren();
                while (enumeration.hasMoreElements()) {
                    this.updateTransformation((Node)enumeration.nextElement(), string, fArray);
                }
            }
        }
    }

    boolean intersectsDeformedNode(Node node, Bounds bounds, String string) {
        if (node instanceof Group) {
            if (node instanceof TransformGroup && string.equals(node.getUserData()) && ModelManager.getInstance().getBounds(node).intersect(bounds)) {
                return true;
            }
            Enumeration enumeration = ((Group)node).getAllChildren();
            while (enumeration.hasMoreElements()) {
                if (!this.intersectsDeformedNode((Node)enumeration.nextElement(), bounds, string)) continue;
                return true;
            }
        }
        return false;
    }

    Transform3D getDeformation(Node node, Transform3D transform3D, String string) {
        if (node instanceof Group) {
            Enumeration enumeration;
            if (node instanceof TransformGroup) {
                transform3D = new Transform3D(transform3D);
                enumeration = new Transform3D();
                ((TransformGroup)node).getTransform((Transform3D)enumeration);
                transform3D.mul((Transform3D)enumeration);
                if (string.equals(node.getUserData())) {
                    return transform3D;
                }
            }
            enumeration = ((Group)node).getAllChildren();
            while (enumeration.hasMoreElements()) {
                Transform3D transform3D2 = this.getDeformation((Node)enumeration.nextElement(), transform3D, string);
                if (transform3D2 == null) continue;
                return transform3D2;
            }
        }
        return null;
    }

    float[] getSunDirection(Compass compass, long l) {
        float f = compass.getSunElevation(l);
        float f2 = compass.getSunAzimuth(l);
        f2 = (float)((double)f2 + ((double)compass.getNorthDirection() - 1.5707963267948966));
        return new float[]{(float)(Math.cos(f2) * Math.cos(f)), (float)Math.sin(f), (float)(Math.sin(f2) * Math.cos(f))};
    }

    TexCoord2f generateTextureCoordinates(float f, float f2, float f3, Vector4f vector4f, Vector4f vector4f2) {
        return new TexCoord2f(f * vector4f.x + f2 * vector4f.y + f3 * vector4f.z + vector4f.w, f * vector4f2.x + f2 * vector4f2.y + f3 * vector4f2.z + vector4f2.w);
    }

    int getLineCount(int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n += nArray[i] - 1;
        }
        return n;
    }

    int getTriangleCount(int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n += nArray[i] - 2;
        }
        return n;
    }

    void exportVertex(Transform3D transform3D, Point3f point3f, int n, float[] fArray) {
        transform3D.transform(point3f);
        n *= 3;
        fArray[n++] = point3f.x;
        fArray[n++] = point3f.y;
        fArray[n] = point3f.z;
    }

    void exportNormal(Transform3D transform3D, Vector3f vector3f, int n, float[] fArray, boolean bl) {
        if (bl) {
            vector3f.negate();
        }
        transform3D.transform(vector3f);
        int n2 = n * 3;
        fArray[n2++] = vector3f.x;
        fArray[n2++] = vector3f.y;
        fArray[n2] = vector3f.z;
    }

    void exportTextureCoordinates(TexCoord2f texCoord2f, Transform3D transform3D, int n, float[] fArray) {
        n *= 2;
        if (transform3D.getBestType() != 2) {
            Point3f point3f = new Point3f(texCoord2f.x, texCoord2f.y, 0.0f);
            transform3D.transform(point3f);
            fArray[n++] = point3f.x;
            fArray[n] = point3f.y;
        } else {
            fArray[n++] = texCoord2f.x;
            fArray[n] = texCoord2f.y;
        }
    }

    void exportIndexedLine(IndexedGeometryArray indexedGeometryArray, int n, int n2, int[] nArray, int n3) {
        nArray[n3++] = indexedGeometryArray.getCoordinateIndex(n);
        nArray[n3] = indexedGeometryArray.getCoordinateIndex(n2);
    }

    int exportIndexedTriangle(IndexedGeometryArray indexedGeometryArray, int n, int n2, int n3, int[] nArray, int[] nArray2, int[] nArray3, int n4, float[] fArray, Set<Triangle> set, int n5) {
        int n6;
        int n7;
        Triangle triangle;
        int n8;
        if (n5 == 2) {
            n8 = n;
            n = n3;
            n3 = n8;
        }
        if (!set.contains(triangle = new Triangle(fArray, n8 = indexedGeometryArray.getCoordinateIndex(n), n7 = indexedGeometryArray.getCoordinateIndex(n2), n6 = indexedGeometryArray.getCoordinateIndex(n3)))) {
            set.add(triangle);
            nArray[n4] = n8;
            nArray[n4 + 1] = n7;
            nArray[n4 + 2] = n6;
            if (nArray2 != null) {
                nArray2[n4] = indexedGeometryArray.getNormalIndex(n);
                nArray2[n4 + 1] = indexedGeometryArray.getNormalIndex(n2);
                nArray2[n4 + 2] = indexedGeometryArray.getNormalIndex(n3);
            }
            if (nArray3 != null) {
                nArray3[n4] = indexedGeometryArray.getTextureCoordinateIndex(0, n);
                nArray3[n4 + 1] = indexedGeometryArray.getTextureCoordinateIndex(0, n2);
                nArray3[n4 + 2] = indexedGeometryArray.getTextureCoordinateIndex(0, n3);
            }
            return n4 + 3;
        }
        return n4;
    }

    void exportLine(GeometryArray geometryArray, int n, int n2, int[] nArray, int n3) {
        nArray[n3++] = n;
        nArray[n3] = n2;
    }

    int exportTriangle(GeometryArray geometryArray, int n, int n2, int n3, int[] nArray, int n4, float[] fArray, Set<Triangle> set, int n5) {
        Triangle triangle;
        if (n5 == 2) {
            int n6 = n;
            n = n3;
            n3 = n6;
        }
        if (!set.contains(triangle = new Triangle(fArray, n, n2, n3))) {
            set.add(triangle);
            nArray[n4++] = n;
            nArray[n4++] = n2;
            nArray[n4++] = n3;
        }
        return n4;
    }

    static class PhotoObject3DFactory
    extends Object3DBranchFactory {
        PhotoObject3DFactory() {
        }

        public boolean isDrawingModeEnabled() {
            return false;
        }

        public Object createObject3D(Home home, Selectable selectable, boolean bl) {
            if (selectable instanceof Room) {
                return new Room3D((Room)selectable, home, !(home.getCamera() instanceof ObserverCamera), bl);
            }
            return super.createObject3D(home, selectable, bl);
        }
    }

    static class TransparentTextureKey {
        private Texture texture;
        private float transparency;

        public TransparentTextureKey(Texture texture, float f) {
            this.texture = texture;
            this.transparency = f;
        }

        public boolean equals(Object object) {
            return ((TransparentTextureKey)object).texture.equals(this.texture) && ((TransparentTextureKey)object).transparency == this.transparency;
        }

        public int hashCode() {
            return this.texture.hashCode() + Float.floatToIntBits(this.transparency);
        }
    }

    static class Triangle {
        private float[] point1;
        private float[] point2;
        private float[] point3;
        private int hashCode;
        private boolean hashCodeSet;

        public Triangle(float[] fArray, int n, int n2, int n3) {
            this.point1 = new float[]{fArray[n * 3], fArray[n * 3 + 1], fArray[n * 3 + 2]};
            this.point2 = new float[]{fArray[n2 * 3], fArray[n2 * 3 + 1], fArray[n2 * 3 + 2]};
            this.point3 = new float[]{fArray[n3 * 3], fArray[n3 * 3 + 1], fArray[n3 * 3 + 2]};
        }

        public int hashCode() {
            if (!this.hashCodeSet) {
                this.hashCode = 31 * Arrays.hashCode(this.point1) + 31 * Arrays.hashCode(this.point2) + 31 * Arrays.hashCode(this.point3);
                this.hashCodeSet = true;
            }
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Triangle) {
                Triangle triangle = (Triangle)object;
                return Arrays.equals(this.point1, triangle.point3) && Arrays.equals(this.point2, triangle.point2) && Arrays.equals(this.point3, triangle.point1) || Arrays.equals(this.point1, triangle.point2) && Arrays.equals(this.point2, triangle.point1) && Arrays.equals(this.point3, triangle.point3) || Arrays.equals(this.point1, triangle.point1) && Arrays.equals(this.point2, triangle.point3) && Arrays.equals(this.point3, triangle.point2) || Arrays.equals(this.point1, triangle.point1) && Arrays.equals(this.point2, triangle.point2) && Arrays.equals(this.point3, triangle.point3);
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Quality {
        LOW,
        HIGH;

    }
}

