/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.viewcontroller.ThreadedTaskController;
import com.eteks.sweethome3d.viewcontroller.ThreadedTaskView;
import com.eteks.sweethome3d.viewcontroller.View;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class ThreadedTaskPanel
extends JPanel
implements ThreadedTaskView {
    private final UserPreferences preferences;
    private final ThreadedTaskController controller;
    private JLabel taskLabel;
    private JProgressBar taskProgressBar;
    private JDialog dialog;
    private boolean taskRunning;

    public ThreadedTaskPanel(String string, UserPreferences userPreferences, ThreadedTaskController threadedTaskController) {
        super(new BorderLayout(5, (int)(5.0f * SwingTools.getResolutionScale())));
        this.preferences = userPreferences;
        this.controller = threadedTaskController;
        this.createComponents(string);
        this.layoutComponents();
    }

    private void createComponents(String string) {
        this.taskLabel = new JLabel(string);
        this.taskProgressBar = new JProgressBar();
        this.taskProgressBar.setIndeterminate(true);
    }

    private void layoutComponents() {
        this.add((Component)this.taskLabel, "North");
        this.add((Component)this.taskProgressBar, "South");
    }

    public void setIndeterminateProgress() {
        if (EventQueue.isDispatchThread()) {
            this.taskProgressBar.setIndeterminate(true);
        } else {
            this.invokeLater(new Runnable(){

                public void run() {
                    ThreadedTaskPanel.this.setIndeterminateProgress();
                }
            });
        }
    }

    public void setProgress(final int n, final int n2, final int n3) {
        if (EventQueue.isDispatchThread()) {
            this.taskProgressBar.setIndeterminate(false);
            this.taskProgressBar.setValue(n);
            this.taskProgressBar.setMinimum(n2);
            this.taskProgressBar.setMaximum(n3);
        } else {
            this.invokeLater(new Runnable(){

                public void run() {
                    ThreadedTaskPanel.this.setProgress(n, n2, n3);
                }
            });
        }
    }

    public void invokeLater(Runnable runnable) {
        EventQueue.invokeLater(runnable);
    }

    public void setTaskRunning(boolean bl, View view) {
        this.taskRunning = bl;
        if (bl && this.dialog == null) {
            String string = this.preferences.getLocalizedString(ThreadedTaskPanel.class, "threadedTask.title", new Object[0]);
            final JButton jButton = new JButton(this.preferences.getLocalizedString(ThreadedTaskPanel.class, "cancelButton.text", new Object[0]));
            final JOptionPane jOptionPane = new JOptionPane(this, -1, -1, null, new Object[]{jButton});
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    jOptionPane.setValue(jButton);
                }
            });
            this.dialog = jOptionPane.createDialog(SwingUtilities.getRootPane((JComponent)((Object)view)), string);
            new Timer(200, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ((Timer)actionEvent.getSource()).stop();
                    if (ThreadedTaskPanel.this.controller.isTaskRunning()) {
                        ThreadedTaskPanel.this.dialog.setVisible(true);
                        ThreadedTaskPanel.this.dialog.dispose();
                        if (ThreadedTaskPanel.this.taskRunning && (jButton == jOptionPane.getValue() || new Integer(-1).equals(jOptionPane.getValue()))) {
                            ThreadedTaskPanel.this.dialog = null;
                            ThreadedTaskPanel.this.controller.cancelTask();
                        }
                    }
                }
            }).start();
        } else if (!bl && this.dialog != null) {
            this.dialog.setVisible(false);
        }
    }
}

