/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.viewcontroller;

import com.eteks.sweethome3d.model.Compass;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.viewcontroller.Controller;
import com.eteks.sweethome3d.viewcontroller.DialogView;
import com.eteks.sweethome3d.viewcontroller.LocalizedUndoableEdit;
import com.eteks.sweethome3d.viewcontroller.View;
import com.eteks.sweethome3d.viewcontroller.ViewFactory;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEditSupport;

public class CompassController
implements Controller {
    private final Home home;
    private final UserPreferences preferences;
    private final ViewFactory viewFactory;
    private final UndoableEditSupport undoSupport;
    private final PropertyChangeSupport propertyChangeSupport;
    private DialogView compassView;
    private float x;
    private float y;
    private float diameter;
    private boolean visible;
    private float northDirectionInDegrees;
    private float latitudeInDegrees;
    private float longitudeInDegrees;
    private String timeZone;

    public CompassController(Home home, UserPreferences userPreferences, ViewFactory viewFactory, UndoableEditSupport undoableEditSupport) {
        this.home = home;
        this.preferences = userPreferences;
        this.viewFactory = viewFactory;
        this.undoSupport = undoableEditSupport;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.updateProperties();
    }

    public DialogView getView() {
        if (this.compassView == null) {
            this.compassView = this.viewFactory.createCompassView(this.preferences, this);
        }
        return this.compassView;
    }

    public void displayView(View view) {
        this.getView().displayView(view);
    }

    public void addPropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(property.name(), propertyChangeListener);
    }

    public void removePropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(property.name(), propertyChangeListener);
    }

    protected void updateProperties() {
        Compass compass = this.home.getCompass();
        this.setX(compass.getX());
        this.setY(compass.getY());
        this.setDiameter(compass.getDiameter());
        this.setVisible(compass.isVisible());
        this.setNorthDirectionInDegrees((float)Math.toDegrees(compass.getNorthDirection()));
        this.setLatitudeInDegrees((float)Math.toDegrees(compass.getLatitude()));
        this.setLongitudeInDegrees((float)Math.toDegrees(compass.getLongitude()));
        this.setTimeZone(compass.getTimeZone());
    }

    public float getX() {
        return this.x;
    }

    public void setX(float f) {
        if (f != this.x) {
            float f2 = this.x;
            this.x = f;
            this.propertyChangeSupport.firePropertyChange(Property.X.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getY() {
        return this.y;
    }

    public void setY(float f) {
        if (f != this.y) {
            float f2 = this.y;
            this.y = f;
            this.propertyChangeSupport.firePropertyChange(Property.Y.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getDiameter() {
        return this.diameter;
    }

    public void setDiameter(float f) {
        if (f != this.diameter) {
            float f2 = this.diameter;
            this.diameter = f;
            this.propertyChangeSupport.firePropertyChange(Property.DIAMETER.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        if (bl != this.visible) {
            this.visible = bl;
            this.propertyChangeSupport.firePropertyChange(Property.VISIBLE.name(), !bl, bl);
        }
    }

    public float getNorthDirectionInDegrees() {
        return this.northDirectionInDegrees;
    }

    public void setNorthDirectionInDegrees(float f) {
        if (f != this.northDirectionInDegrees) {
            float f2 = this.northDirectionInDegrees;
            this.northDirectionInDegrees = f;
            this.propertyChangeSupport.firePropertyChange(Property.NORTH_DIRECTION_IN_DEGREES.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public final float getLatitudeInDegrees() {
        return this.latitudeInDegrees;
    }

    public void setLatitudeInDegrees(float f) {
        if (f != this.latitudeInDegrees) {
            float f2 = this.latitudeInDegrees;
            this.latitudeInDegrees = f;
            this.propertyChangeSupport.firePropertyChange(Property.LATITUDE_IN_DEGREES.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public final float getLongitudeInDegrees() {
        return this.longitudeInDegrees;
    }

    public void setLongitudeInDegrees(float f) {
        if (f != this.longitudeInDegrees) {
            float f2 = this.longitudeInDegrees;
            this.longitudeInDegrees = f;
            this.propertyChangeSupport.firePropertyChange(Property.LONGITUDE_IN_DEGREES.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String string) {
        if (!string.equals(this.timeZone)) {
            String string2 = this.timeZone;
            this.timeZone = string;
            this.propertyChangeSupport.firePropertyChange(Property.TIME_ZONE.name(), string2, string);
        }
    }

    public void modifyCompass() {
        float f = this.getX();
        float f2 = this.getY();
        float f3 = this.getDiameter();
        boolean bl = this.isVisible();
        float f4 = (float)Math.toRadians(this.getNorthDirectionInDegrees());
        float f5 = (float)Math.toRadians(this.getLatitudeInDegrees());
        float f6 = (float)Math.toRadians(this.getLongitudeInDegrees());
        String string = this.getTimeZone();
        CompassUndoableEdit compassUndoableEdit = new CompassUndoableEdit(this.home.getCompass(), this.preferences, f, f2, f3, bl, f4, f5, f6, string);
        CompassController.doModifyCompass(this.home.getCompass(), f, f2, f3, bl, f4, f5, f6, string);
        this.undoSupport.postEdit(compassUndoableEdit);
    }

    private static void doModifyCompass(Compass compass, float f, float f2, float f3, boolean bl, float f4, float f5, float f6, String string) {
        compass.setX(f);
        compass.setY(f2);
        compass.setDiameter(f3);
        compass.setVisible(bl);
        compass.setNorthDirection(f4);
        compass.setLatitude(f5);
        compass.setLongitude(f6);
        compass.setTimeZone(string);
    }

    private static class CompassUndoableEdit
    extends LocalizedUndoableEdit {
        private final Compass compass;
        private final float oldX;
        private final float oldY;
        private final float oldDiameter;
        private final float oldNorthDirection;
        private final float oldLatitude;
        private final float oldLongitude;
        private final String oldTimeZone;
        private final boolean oldVisible;
        private final float newX;
        private final float newY;
        private final float newDiameter;
        private final float newNorthDirection;
        private final float newLatitude;
        private final float newLongitude;
        private final String newTimeZone;
        private final boolean newVisible;

        public CompassUndoableEdit(Compass compass, UserPreferences userPreferences, float f, float f2, float f3, boolean bl, float f4, float f5, float f6, String string) {
            super(userPreferences, CompassController.class, "undoModifyCompassName");
            this.compass = compass;
            this.oldX = compass.getX();
            this.oldY = compass.getY();
            this.oldDiameter = compass.getDiameter();
            this.oldVisible = compass.isVisible();
            this.oldNorthDirection = compass.getNorthDirection();
            this.oldLatitude = compass.getLatitude();
            this.oldLongitude = compass.getLongitude();
            this.oldTimeZone = compass.getTimeZone();
            this.newX = f;
            this.newY = f2;
            this.newDiameter = f3;
            this.newVisible = bl;
            this.newNorthDirection = f4;
            this.newLatitude = f5;
            this.newLongitude = f6;
            this.newTimeZone = string;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            CompassController.doModifyCompass(this.compass, this.oldX, this.oldY, this.oldDiameter, this.oldVisible, this.oldNorthDirection, this.oldLatitude, this.oldLongitude, this.oldTimeZone);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            CompassController.doModifyCompass(this.compass, this.newX, this.newY, this.newDiameter, this.newVisible, this.newNorthDirection, this.newLatitude, this.newLongitude, this.newTimeZone);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        X,
        Y,
        DIAMETER,
        VISIBLE,
        NORTH_DIRECTION_IN_DEGREES,
        LATITUDE_IN_DEGREES,
        LONGITUDE_IN_DEGREES,
        TIME_ZONE;

    }
}

