/*
 * Decompiled with CFR 0.152.
 */
package heuser.simpleLogger;

import heuser.simpleLogger.SimpleLoggerListener;
import heuser.simpleLogger.SimpleLoggerPrintStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.LinkedList;

public abstract class SimpleLogger {
    private static String log = "";
    private static String errors = "";
    private static String logFull = "";
    private static String errorsFull = "";
    private static String errorPrefix = "";
    private static String crlf = System.getProperty("line.separator");
    private static boolean success = true;
    private static boolean incrementalLog = true;
    private static boolean incrementalErr = true;
    private static boolean append = false;
    private static SimpleLoggerPrintStream out = new SimpleLoggerPrintStream(System.out);
    private static LinkedList loggerListenersError = new LinkedList();
    private static LinkedList loggerListenersMessage = new LinkedList();

    public static void addLoggerListenerError(SimpleLoggerListener simpleLoggerListener) {
        loggerListenersError.add(simpleLoggerListener);
    }

    public static void removeLoggerListenerError(SimpleLoggerListener simpleLoggerListener) {
        loggerListenersError.remove(simpleLoggerListener);
    }

    public static void addLoggerListenerMessage(SimpleLoggerListener simpleLoggerListener) {
        loggerListenersMessage.add(simpleLoggerListener);
    }

    public static void removeLoggerListenerMessage(SimpleLoggerListener simpleLoggerListener) {
        loggerListenersMessage.remove(simpleLoggerListener);
    }

    public static void logIncremental(boolean bl, boolean bl2) {
        incrementalLog = bl;
        incrementalErr = bl2;
    }

    public static void setErrorPrefix(String string) {
        errorPrefix = string;
    }

    public static void setConsoleOutput(boolean bl) {
        out.enableStream(1, bl);
    }

    public boolean getConsoleOutput() {
        return out.isEnabledStream(1);
    }

    public static void logMsg(String string) {
        log = log + string;
        if (incrementalLog) {
            logFull = logFull + string + crlf;
        }
        if (append) {
            out.print(SimpleLogger.printLog());
        } else {
            out.print(SimpleLogger.printLog());
        }
        append = false;
        log = log + crlf;
        if (loggerListenersMessage.size() > 0) {
            SimpleLogger.notifyMessageListeners(string);
        }
    }

    public static void logMsgAppend(String string) {
        if (log.endsWith(crlf)) {
            log = log.substring(0, log.length() - 2);
        }
        append = true;
        SimpleLogger.logMsg(string);
    }

    public static void logError(String string) {
        success = false;
        errors = errors + errorPrefix + string;
        if (incrementalErr) {
            errorsFull = errorsFull + errorPrefix + string + crlf;
        }
        if (append) {
            out.print(errorPrefix + string);
        } else {
            out.println(crlf + errorPrefix + string);
        }
        append = false;
        errors = errors + crlf;
        if (loggerListenersError.size() > 0) {
            SimpleLogger.notifyErrorListeners(string);
        }
    }

    public static void logErrorAppend(String string) {
        if (errors.endsWith(crlf)) {
            errors = errors.substring(0, errors.length() - 2);
        }
        append = true;
        SimpleLogger.logError(string);
    }

    public static boolean success() {
        return success;
    }

    public static String printLog() {
        String string = log;
        if (incrementalLog) {
            log = "";
        }
        return string;
    }

    public static String printErrors() {
        String string = errors;
        if (incrementalErr) {
            errors = "";
        }
        return string;
    }

    public static String printAllErrors() {
        return errorsFull;
    }

    public static String printAllLog() {
        return logFull;
    }

    public void resetLog(boolean bl, boolean bl2) {
        if (bl) {
            log = "";
            logFull = "";
        }
        if (bl2) {
            errors = "";
            errorsFull = "";
        }
    }

    public static void logToFile(File file, boolean bl) {
        try {
            out.add(new FileOutputStream(file));
            if (bl) {
                out.enableStream(1, false);
                out.print(SimpleLogger.printAllLog());
                out.enableStream(1, true);
            }
        }
        catch (Exception exception) {
            SimpleLogger.setConsoleOutput(true);
            SimpleLogger.logError("Error logging to file '" + file.getName() + "'");
        }
    }

    public static void notifyMessageListeners(String string) {
        for (int i = loggerListenersMessage.size() - 1; i >= 0; --i) {
            ((SimpleLoggerListener)loggerListenersMessage.get(i)).errorLogged(string);
        }
    }

    public static void notifyErrorListeners(String string) {
        for (int i = loggerListenersError.size() - 1; i >= 0; --i) {
            ((SimpleLoggerListener)loggerListenersError.get(i)).errorLogged(string);
        }
    }

    public void finalize() {
        try {
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

