/*
 * Decompiled with CFR 0.152.
 */
package retypar.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import retypar.converter.Converter;
import retypar.gui.MainFrame;
import retypar.gui.OnlineAlEntry;
import retypar.retypar;

public class OptionsFrame
extends JFrame
implements ActionListener,
ItemListener {
    private Container c = this.getContentPane();
    private ButtonGroup bg = new ButtonGroup();
    private Box plaf;
    private JRadioButton plafMetal;
    private JRadioButton plafMotif;
    private JRadioButton plafWin;
    private JCheckBox checkUpd;
    private String plafStr = UIManager.getLookAndFeel().getClass().getName();
    private Box optionsBox;
    private Box algoBox;
    private JTextPane changeLogText;
    private JScrollPane clgScroll;
    private JComboBox onlineAl;
    private JComboBox offlineAl;
    private JButton deleteButton;
    private JButton installButton;
    private MainFrame parent;

    public OptionsFrame(MainFrame mainFrame) {
        this.parent = mainFrame;
        this.setTitle(mainFrame.l.pr("Options"));
        this.c.setLayout(new BorderLayout());
        this.optionsBox = Box.createVerticalBox();
        this.plafMetal = new JRadioButton("Metal");
        this.plafMetal.addActionListener(this);
        this.plafMetal.setActionCommand("metal");
        if (mainFrame.plaf.substring(mainFrame.plaf.lastIndexOf(".") + 1).startsWith("Metal")) {
            this.plafMetal.setSelected(true);
        }
        this.plafMotif = new JRadioButton("Motif");
        this.plafMotif.addActionListener(this);
        this.plafMotif.setActionCommand("motif");
        if (mainFrame.plaf.substring(mainFrame.plaf.lastIndexOf(".") + 1).startsWith("Motif")) {
            this.plafMotif.setSelected(true);
        }
        this.plafWin = new JRadioButton("Windows");
        this.plafWin.addActionListener(this);
        this.plafWin.setActionCommand("win");
        if (mainFrame.plaf.substring(mainFrame.plaf.lastIndexOf(".") + 1).startsWith("Windows")) {
            this.plafWin.setSelected(true);
        }
        this.bg.add(this.plafMetal);
        this.bg.add(this.plafMotif);
        this.bg.add(this.plafWin);
        this.plaf = Box.createHorizontalBox();
        this.plaf.add(this.plafMetal);
        this.plaf.add(this.plafMotif);
        this.plaf.add(this.plafWin);
        this.plaf.setBorder(new TitledBorder("\"Look-and-feel\":"));
        this.optionsBox.add(this.plaf);
        this.optionsBox.add(Box.createVerticalStrut(10));
        this.checkUpd = new JCheckBox(mainFrame.l.pr("Check for new version on startup"));
        this.checkUpd.setSelected(retypar.checkUpd);
        this.checkUpd.addActionListener(this);
        this.checkUpd.setActionCommand("checkUpd");
        this.checkUpd.setAlignmentX(0.5f);
        this.optionsBox.add(this.checkUpd);
        this.optionsBox.add(Box.createHorizontalStrut(10));
        this.changeLogText = new JTextPane();
        this.changeLogText.setBackground(new Color(192, 192, 192));
        this.changeLogText.setText(this.getChangeLog());
        this.changeLogText.setCaretPosition(0);
        this.changeLogText.setEditable(false);
        this.changeLogText.setVisible(true);
        this.clgScroll = new JScrollPane();
        this.clgScroll.setVerticalScrollBarPolicy(20);
        this.clgScroll.setHorizontalScrollBarPolicy(31);
        this.clgScroll.setViewportView(this.changeLogText);
        this.algoBox = Box.createVerticalBox();
        this.algoBox.setBorder(new TitledBorder(mainFrame.l.pr("Algorithms")));
        JLabel jLabel = new JLabel(mainFrame.l.pr("Online:"));
        this.onlineAl = new JComboBox();
        this.installButton = new JButton(mainFrame.l.pr("Install"));
        this.installButton.addActionListener(this);
        this.installButton.setActionCommand("install");
        Box box = Box.createHorizontalBox();
        this.onlineAl.setAlignmentX(0.0f);
        this.fillOnlineAlgoCombo();
        box.add(this.onlineAl);
        box.add(this.installButton);
        this.algoBox.add(jLabel);
        this.algoBox.add(box);
        this.algoBox.add(Box.createHorizontalStrut(10));
        JLabel jLabel2 = new JLabel(mainFrame.l.pr("Installed:"));
        this.offlineAl = new JComboBox();
        this.offlineAl.addItemListener(this);
        this.deleteButton = new JButton(mainFrame.l.pr("Delete"));
        this.deleteButton.addActionListener(this);
        this.deleteButton.setActionCommand("delete");
        Box box2 = Box.createHorizontalBox();
        this.offlineAl.setAlignmentX(0.0f);
        this.fillOfflineAlgoCombo();
        box2.add(this.offlineAl);
        box2.add(this.deleteButton);
        this.algoBox.add(jLabel2);
        this.algoBox.add(box2);
        this.optionsBox.add(this.algoBox);
        this.optionsBox.add(new JLabel(" "));
        this.c.add((Component)this.optionsBox, "West");
        this.c.add((Component)this.clgScroll, "Center");
        int n = 510;
        int n2 = 250;
        int n3 = mainFrame.getX() + (mainFrame.getWidth() - n) / 2;
        int n4 = mainFrame.getY() + (mainFrame.getHeight() - n2) / 2;
        this.setBounds(n3, n4, n, n2);
        this.setPlaf(mainFrame.plaf);
        this.setResizable(false);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("win")) {
            this.setPlaf("win");
        }
        if (actionEvent.getActionCommand().equals("metal")) {
            this.setPlaf("metal");
        }
        if (actionEvent.getActionCommand().equals("motif")) {
            this.setPlaf("motif");
        }
        if (actionEvent.getActionCommand().equals("checkUpd")) {
            this.writeINI();
        }
        if (actionEvent.getActionCommand().equals("delete")) {
            this.deleteAlgo((Converter)this.offlineAl.getSelectedItem());
        }
        if (actionEvent.getActionCommand().equals("install")) {
            this.installAlgo((OnlineAlEntry)this.onlineAl.getSelectedItem());
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.deleteButton.setEnabled(true);
        if (this.offlineAl.getItemCount() == 0) {
            return;
        }
        if (((Converter)this.offlineAl.getSelectedItem()).getShortName().equals("mr")) {
            this.deleteButton.setEnabled(false);
        }
        if (((Converter)this.offlineAl.getSelectedItem()).getShortName().equals("ns")) {
            this.deleteButton.setEnabled(false);
        }
    }

    private void fillOnlineAlgoCombo() {
        this.onlineAl.removeAllItems();
        LinkedList linkedList = retypar.getOnlineAlgos();
        for (int i = 0; i < linkedList.size(); i += 2) {
            OnlineAlEntry onlineAlEntry = new OnlineAlEntry((String)linkedList.get(i), (String)linkedList.get(i + 1));
            this.onlineAl.addItem(onlineAlEntry);
        }
        if (this.onlineAl.getItemCount() == 0) {
            this.installButton.setEnabled(false);
        } else {
            this.installButton.setEnabled(true);
        }
        this.onlineAl.invalidate();
    }

    private void fillOfflineAlgoCombo() {
        this.offlineAl.removeAllItems();
        for (int i = 0; i < retypar.converters.size(); ++i) {
            this.offlineAl.addItem(retypar.converters.get(i));
        }
        this.offlineAl.invalidate();
    }

    private void deleteAlgo(Converter converter) {
        retypar.deleteAlgo(converter);
        this.offlineAl.removeItem(converter);
        this.offlineAl.invalidate();
        this.parent.renderCombo.removeItem(converter);
        this.parent.renderCombo.invalidate();
    }

    private void installAlgo(OnlineAlEntry onlineAlEntry) {
        if (onlineAlEntry == null) {
            return;
        }
        if (retypar.downloadAndInstallAlgo(onlineAlEntry.getLocation())) {
            this.fillOnlineAlgoCombo();
            this.fillOfflineAlgoCombo();
            this.parent.fillRenderCombo();
        } else {
            String string = "\n\nError:\n" + retypar.printErrors();
            this.popUpError(this.parent.l.pr("Error installing Algorithm!"), "Could not install the algorithm.\nCheck Your internet connection and permissions or space." + string);
        }
    }

    private void popUpError(String string, String string2) {
        JOptionPane.showMessageDialog(this, string2, string, 0);
    }

    private void setPlaf(String string) {
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        if (string.indexOf(".") > -1) {
            string = string.substring(string.lastIndexOf(".") + 1);
        }
        for (int i = 0; i < lookAndFeelInfoArray.length; ++i) {
            if (lookAndFeelInfoArray[i].getName().toLowerCase().indexOf(string) <= -1) continue;
            try {
                UIManager.setLookAndFeel(lookAndFeelInfoArray[i].getClassName());
                SwingUtilities.updateComponentTreeUI(this.parent);
                SwingUtilities.updateComponentTreeUI(this);
                retypar.plaf = this.plafStr = lookAndFeelInfoArray[i].getClassName();
                this.parent.setPlaf();
                this.writeINI();
                break;
            }
            catch (Exception exception) {
                retypar.logError("Failure setting LookAndFeel");
            }
        }
    }

    private String getChangeLog() {
        String string = "";
        String string2 = "";
        try {
            InputStream inputStream = this.getClass().getResourceAsStream("/changelog.txt");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((string2 = bufferedReader.readLine()) != null) {
                string = string + string2 + "\n";
            }
            inputStream.close();
        }
        catch (Exception exception) {
            retypar.logError("Error reading changelog");
        }
        return string;
    }

    private void writeINI() {
        retypar.plaf = this.plafStr;
        retypar.checkUpd = this.checkUpd.isSelected();
        retypar.writeINI();
    }
}

