package heuser.simpleLogger;

import java.io.PrintStream;
import java.io.OutputStream;

/**
 * @author Jens Heuser, heuserjens@users.sourceforge.net
 */
public class SimpleLoggerPrintStream extends PrintStream{

    private PrintStream secondStream;

    private boolean stream1 = true;
    private boolean stream2 = false;

    /**
     * A {@link PrintStream} that writes into two {@link OutputStream}s simultaneously.<BR>
     * To add a second stream call {@link #add(java.io.OutputStream)}. Only {@link PrintStream#print(java.lang.String)} and {@link PrintStream#println(java.lang.String)} are overridden.
     * @param out1 The first OutputStream.
     */
    public SimpleLoggerPrintStream(OutputStream out1){
        super(out1, true);
    }

    public void add(OutputStream stream){
        secondStream = new PrintStream(stream, true);
        stream2 = true;
    }

    /**
     * @see PrintStream#print(java.lang.String)
     * @param s Write this String to two OutputStreams.
     */
    public void print(String s){
        if (stream1) super.print(s);
        if (stream2) secondStream.print(s);
    }

    /**
     * @see PrintStream#println(java.lang.String)
     * @param s Write this String to two OutputStreams.
     */
    public void println(String s){
        if (stream1) super.println(s);
        if (stream2) secondStream.println(s);
    }


    /**
     * En- or disables the stream number <code>str</code>.
     * @param str <code>1</code> or <code>2</code>, because only two streams are supported.
     * @param state
     */
    public void enableStream(int str, boolean state){
        switch(str){
            case 1:
                stream1 = state;
                break;
            case 2:
                stream2 = state;
        }
    }
    

    /**
     * Checks whether the stream of the given number is enabled.
     * @param str Number of the stream to check.
     */
    public boolean isEnabledStream(int str){
        switch(str){
            case 1:
                return stream1;
            case 2:
                return stream2;
        }
        return false;
    }
}
