/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.gui;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import net.sf.jaxodraw.graph.JaxoGraph;
import net.sf.jaxodraw.graph.JaxoSaveGraph;
import net.sf.jaxodraw.gui.JaxoDrawingArea;
import net.sf.jaxodraw.gui.grid.JaxoDefaultGrid;
import net.sf.jaxodraw.gui.grid.JaxoPaintableGrid;
import net.sf.jaxodraw.object.JaxoList;
import net.sf.jaxodraw.object.JaxoObject;
import net.sf.jaxodraw.object.JaxoObjectList;
import net.sf.jaxodraw.util.JaxoGeometry;
import net.sf.jaxodraw.util.JaxoPrefs;

public class JaxoTab {
    private EventListenerList listeners;
    private ChangeEvent event;
    private final JScrollPane root;
    private JaxoGraph tabGraph;
    private String tabTitle = "";
    private final JaxoPaintableGrid tabGrid;
    private int tabMode = 0;
    private boolean saved = true;
    private boolean isUsed;
    private final JaxoDrawingArea theCanvas;
    private List<JaxoSaveGraph> backupList;
    private int repeatCount;
    private int undoCounter = 0;
    private int backupPointer = 0;
    private boolean redoFlag = false;

    public JaxoTab(JaxoDrawingArea canvas) {
        this(canvas, new JaxoGraph());
    }

    public JaxoTab(JaxoDrawingArea canvas, JaxoGraph g) {
        this(canvas, g, JaxoDefaultGrid.newDefaultGrid());
    }

    public JaxoTab(JaxoDrawingArea canvas, JaxoPaintableGrid g) {
        this(canvas, new JaxoGraph(), g);
    }

    public JaxoTab(JaxoDrawingArea canvas, JaxoGraph g, JaxoPaintableGrid grid) {
        if (canvas == null) {
            throw new IllegalArgumentException("Canvas cannot be null!");
        }
        if (g == null) {
            throw new IllegalArgumentException("Graph cannot be null!");
        }
        if (grid == null) {
            throw new IllegalArgumentException("Grid cannot be null!");
        }
        this.listeners = new EventListenerList();
        this.root = new JScrollPane();
        this.root.putClientProperty("JaxoDraw.JaxoTab", this);
        this.theCanvas = canvas;
        this.tabGraph = g;
        this.tabGrid = grid;
        this.backupList = new ArrayList<JaxoSaveGraph>(JaxoPrefs.getIntPref("prefUNDODEPTH"));
        this.backupList.add(0, this.tabGraph.getSaveGraph().copyOf());
        this.incrementBackupPointer();
        this.revalidate();
    }

    public static JaxoTab asJaxoTab(Component c) {
        return c instanceof JComponent ? (JaxoTab)((JComponent)c).getClientProperty("JaxoDraw.JaxoTab") : null;
    }

    public final JComponent getRoot() {
        return this.root;
    }

    public final JaxoGraph getTabGraph() {
        return this.tabGraph;
    }

    private void setTabGraph(JaxoGraph theGraph) {
        this.tabGraph = theGraph;
        this.theCanvas.setCanvasGraph(this.tabGraph);
    }

    public final String getTabTitle() {
        return this.tabTitle;
    }

    public final void setTabTitle(String theTitle) {
        this.tabTitle = theTitle;
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(ChangeListener.class, l);
    }

    protected void fireStateChanged() {
        Object[] pairs = this.listeners.getListenerList();
        for (int i = pairs.length - 2; i >= 0; i -= 2) {
            if (pairs[i] != ChangeListener.class) continue;
            if (this.event == null) {
                this.event = new ChangeEvent(this);
            }
            ((ChangeListener)pairs[i + 1]).stateChanged(this.event);
        }
    }

    public final void revalidate() {
        this.theCanvas.setCanvasGraph(this.tabGraph);
        this.theCanvas.setGrid(this.tabGrid);
        this.root.setViewportView(this.theCanvas.asComponent());
        this.root.revalidate();
    }

    public JaxoPaintableGrid getGrid() {
        return this.tabGrid;
    }

    public final void setSnappingToGrid(boolean value) {
        if (value != this.tabGrid.isSnapping()) {
            this.tabGrid.setSnapping(value);
            this.theCanvas.setGrid(this.tabGrid);
        }
    }

    public final boolean isSnappingToGrid() {
        return this.tabGrid.isSnapping();
    }

    public void setGridPainted(boolean on) {
        this.tabGrid.setPainted(on);
        if (on) {
            this.theCanvas.setGrid(this.tabGrid);
        } else {
            this.theCanvas.setGrid(null);
        }
    }

    public boolean isGridPainted() {
        return this.tabGrid.isPainted();
    }

    public final void setGridSize(int gs) {
        this.tabGrid.setGridSize(gs);
    }

    public final int getGridSize() {
        return this.tabGrid.getGridSize();
    }

    public final void setGridType(int type) {
        switch (type) {
            case 3165: {
                this.tabGrid.setGridType(0);
                break;
            }
            case 3166: {
                this.tabGrid.setGridType(1);
                break;
            }
        }
    }

    public final int getGridType() {
        return this.tabGrid.getGridType();
    }

    public final void setGridStyle(int style) {
        switch (style) {
            case 3167: {
                this.tabGrid.setGridStyle(0);
                break;
            }
            case 3168: {
                this.tabGrid.setGridStyle(1);
                break;
            }
            case 3169: {
                this.tabGrid.setGridStyle(2);
                break;
            }
            case 3170: {
                this.tabGrid.setGridStyle(3);
                break;
            }
        }
    }

    public final int getGridStyle() {
        return this.tabGrid.getGridStyle();
    }

    public final void setGridColor(Color color) {
        this.tabGrid.setGridColor(color);
    }

    public final Color getGridColor() {
        return this.tabGrid.getGridColor();
    }

    public void commitGraphChanges() {
        this.commitGraph(0);
    }

    public void commitRepeatableGraphChanges() {
        this.commitRepeatableGraphChanges(1);
    }

    public void commitRepeatableGraphChanges(int count) {
        this.commitGraph(count);
    }

    private void commitGraph(int count) {
        this.setRedoFlag(false);
        this.repeatCount = count;
        int pos = this.getBackupPointer();
        if (pos < this.backupList.size()) {
            this.backupList.subList(pos, this.backupList.size()).clear();
        }
        int maxSize = JaxoPrefs.getIntPref("prefUNDODEPTH");
        if (this.backupList.size() >= maxSize) {
            this.backupList.subList(0, this.backupList.size() - maxSize + 1).clear();
        }
        this.backupList.add(this.tabGraph.getSaveGraph().copyOf());
        this.resetUndoCounter();
        this.incrementBackupPointer();
        this.setUnsaved();
        this.fireStateChanged();
    }

    public void setSaveFileName(String value) {
        this.tabGraph.setSaveFileName(value);
        this.fireStateChanged();
    }

    public final String getSaveFileName() {
        return this.tabGraph.getSaveFileName();
    }

    public void clearBackupList() {
        boolean wasSaved = this.isSaved();
        this.backupList.clear();
        this.backupList.add(this.tabGraph.getSaveGraph().copyOf());
        this.resetUndoCounter();
        this.setBackupPointer(1);
        this.setRedoFlag(false);
        this.repeatCount = 0;
        this.setUnsaved();
        this.setSaved(wasSaved);
        this.fireStateChanged();
    }

    public void newGraph() {
        this.setTabGraph(new JaxoGraph());
        this.commitGraphChanges();
        this.setSaved(true);
        this.clearBackupList();
    }

    public void undoMove() {
        this.repeatCount = 0;
        this.incrementUndoCounter();
        this.setRedoFlag(true);
        int lastGraphPosition = this.backupList.size() - this.undoCounter;
        this.setBackupPointer(lastGraphPosition);
        this.setSaveGraph(this.backupList.get(lastGraphPosition - 1).copyOf());
        this.setUnsaved();
        this.fireStateChanged();
    }

    private void setSaveGraph(JaxoSaveGraph g) {
        this.tabGraph.setSaveGraph(g);
        this.theCanvas.markImageInvalid(null);
    }

    public void redoMove() {
        if (this.isRedoFlag()) {
            this.decrementUndoCounter();
            int lastGraphPosition = this.backupList.size() - this.undoCounter;
            this.setBackupPointer(lastGraphPosition);
            this.setSaveGraph(this.backupList.get(lastGraphPosition - 1).copyOf());
            if (lastGraphPosition > this.backupList.size() - 1) {
                this.setRedoFlag(false);
            }
            this.setUnsaved();
            this.fireStateChanged();
        } else {
            this.repeatChange();
        }
    }

    private void repeatChange() {
        int size = this.tabGraph.getObjectList().size();
        JaxoList<JaxoObject> l = JaxoGraph.copyFrom(new JaxoObjectList<JaxoObject>(this.tabGraph.getObjectList().subList(size - this.repeatCount, size)));
        Iterator i = l.iterator();
        while (i.hasNext()) {
            this.tabGraph.addObject((JaxoObject)i.next());
        }
        this.theCanvas.markImageInvalid(JaxoGeometry.getBounds(l));
        this.commitRepeatableGraphChanges(this.repeatCount);
        this.setUnsaved();
        this.fireStateChanged();
    }

    public void setTabMode(int mode) {
        this.tabMode = mode;
    }

    public int getTabMode() {
        return this.tabMode;
    }

    public boolean hasBeenUsed() {
        return this.isUsed;
    }

    public void setSaved(boolean value) {
        if (this.saved != value) {
            this.saved = value;
            this.fireStateChanged();
        }
    }

    public boolean isSaved() {
        return this.saved;
    }

    private void setUnsaved() {
        this.isUsed = true;
        this.saved = false;
    }

    private void incrementUndoCounter() {
        ++this.undoCounter;
    }

    private void decrementUndoCounter() {
        --this.undoCounter;
    }

    private void resetUndoCounter() {
        this.undoCounter = 0;
    }

    private int getBackupPointer() {
        return this.backupPointer;
    }

    private void setBackupPointer(int fup) {
        this.backupPointer = fup;
    }

    private void incrementBackupPointer() {
        ++this.backupPointer;
    }

    private void setRedoFlag(boolean bool) {
        this.redoFlag = bool;
    }

    private boolean isRedoFlag() {
        return this.redoFlag;
    }

    public boolean canUndo() {
        return this.backupList.size() - this.undoCounter > 1;
    }

    public boolean canRedo() {
        return this.backupPointer < this.backupList.size() || !this.redoFlag && this.repeatCount != 0;
    }
}

