/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.gui.handle;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Stroke;
import net.sf.jaxodraw.object.JaxoHandle;
import net.sf.jaxodraw.util.JaxoColor;
import net.sf.jaxodraw.util.graphics.JaxoGraphics2D;

public abstract class AbstractJaxoHandle
implements JaxoHandle {
    public static final int DEFAULT_SIZE = 8;
    public static final Stroke DEFAULT_STROKE = new BasicStroke(1.0f);
    public static final Color DEFAULT_COLOR = JaxoColor.RED;
    public static final Color DEFAULT_SECONDARY_COLOR = JaxoColor.NAVY_BLUE;
    public static final Color DEFAULT_FILL_COLOR = JaxoColor.GRAYSCALE150;
    private int size = 8;
    private Stroke stroke = DEFAULT_STROKE;
    private Color color = DEFAULT_COLOR;
    private Color secondaryColor = DEFAULT_SECONDARY_COLOR;
    private Color fillColor = DEFAULT_FILL_COLOR;

    public final Color getColor() {
        return this.color;
    }

    public final void setColor(Color c) {
        this.color = c;
    }

    public final Color getFillColor() {
        return this.fillColor;
    }

    public final void setFillColor(Color c) {
        this.fillColor = c;
    }

    public final Color getSecondaryColor() {
        return this.secondaryColor;
    }

    public final void setSecondaryColor(Color c) {
        this.secondaryColor = c;
    }

    public final int getSize() {
        return this.size;
    }

    public void setSize(int value) {
        this.size = value;
    }

    public final Stroke getStroke() {
        return this.stroke;
    }

    public final void setStroke(Stroke newStroke) {
        this.stroke = newStroke;
    }

    public void paint(JaxoGraphics2D g2, int x, int y) {
        this.paint(g2, x, y, false, this.color);
    }

    public void paint(JaxoGraphics2D g2, int x, int y, boolean marked) {
        this.paint(g2, x, y, marked, this.color);
    }

    public void paint(JaxoGraphics2D g2, int x, int y, boolean marked, boolean secondary) {
        if (secondary) {
            this.paint(g2, x, y, marked, this.secondaryColor);
        } else {
            this.paint(g2, x, y, marked, this.color);
        }
    }

    public void paintSecondary(JaxoGraphics2D g2, int x, int y) {
        this.paint(g2, x, y, false, this.secondaryColor);
    }

    public void paintSecondary(JaxoGraphics2D g2, int x, int y, boolean marked) {
        this.paint(g2, x, y, marked, this.secondaryColor);
    }

    public abstract void paint(JaxoGraphics2D var1, int var2, int var3, boolean var4, Color var5);

    public Rectangle getBounds(int x, int y) {
        return new Rectangle(x - this.getSize() / 2, y - this.getSize() / 2, x + this.getSize() / 2 + 1, y + this.getSize() / 2 + 1);
    }
}

