/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.gui.panel;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JWindow;
import net.sf.jaxodraw.graph.JaxoGraph;
import net.sf.jaxodraw.object.JaxoObject;
import net.sf.jaxodraw.object.text.JaxoLatexText;
import net.sf.jaxodraw.util.JaxoDictionary;

public class JaxoLatexTextToolTip
extends MouseAdapter {
    private final JaxoDictionary language = new JaxoDictionary(JaxoLatexTextToolTip.class);
    private final JWindow window;
    private final JLabel label = new JLabel();
    private boolean isActive = true;
    private JaxoGraph theGraph;

    public JaxoLatexTextToolTip() {
        this.label.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.label.setBackground(new Color(250, 250, 200));
        this.label.setOpaque(true);
        this.window = new JWindow();
        this.window.setContentPane(this.label);
    }

    public void setGraph(JaxoGraph graph) {
        this.theGraph = graph;
    }

    public void setActive(boolean active) {
        this.isActive = active;
        if (!this.isActive) {
            this.window.setVisible(false);
        }
    }

    public final void mouseEntered(MouseEvent e) {
        this.mouseMoved(e);
    }

    public final void mouseMoved(MouseEvent e) {
        if (!this.isActive || this.theGraph == null) {
            return;
        }
        for (int i = 0; i < this.theGraph.listSize(); ++i) {
            JaxoLatexText text;
            JaxoObject o = this.theGraph.listElementAt(i);
            if (!(o instanceof JaxoLatexText) || !(text = (JaxoLatexText)o).isRolledOver(e.getX(), e.getY())) continue;
            this.label.setText(this.language.message("texString%0", text.getTextString()));
            Point p = e.getComponent().getLocationOnScreen();
            p.x += e.getX();
            p.y += e.getY();
            Dimension d = this.window.getPreferredSize();
            p.x -= d.width / 3;
            p.y -= d.height * 4;
            this.window.setBounds(p.x, p.y, d.width, d.height);
            this.window.setVisible(true);
            return;
        }
        this.window.setVisible(false);
    }

    public final void mouseExited(MouseEvent e) {
        this.window.setVisible(false);
    }

    public final void mousePressed(MouseEvent e) {
        this.window.setVisible(false);
    }
}

