/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.gui.panel;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import net.sf.jaxodraw.util.JaxoLog;
import net.sf.jaxodraw.util.JaxoLooknFeel;

public class JaxoLookAndFeelPanel {
    private final JScrollPane root;
    private final JList list;
    private final LookAndFeelListModel lookAndFeels = new LookAndFeelListModel();

    public JaxoLookAndFeelPanel() {
        LookAndFeel currentLookAndFeel = UIManager.getLookAndFeel();
        UIManager.LookAndFeelInfo[] ll = UIManager.getInstalledLookAndFeels();
        for (int i = 0; i < ll.length; ++i) {
            boolean supported = true;
            try {
                JaxoLooknFeel.setLookAndFeel(ll[i].getClassName());
            }
            catch (Exception x) {
                JaxoLog.debug(x);
                supported = false;
            }
            this.lookAndFeels.add(ll[i], supported);
        }
        try {
            JaxoLooknFeel.setLookAndFeel(currentLookAndFeel);
        }
        catch (Exception x) {
            JaxoLog.debug(x);
        }
        this.list = new JList(this.lookAndFeels);
        this.list.setVisibleRowCount(5);
        this.list.setPrototypeCellValue(new UIManager.LookAndFeelInfo("LookAndFeel with a very long name", null));
        this.root = new JScrollPane(this.list);
        this.list.setSelectionModel(new DefaultListSelectionModel(){
            private static final long serialVersionUID = 7526475622776147L;

            public void addSelectionInterval(int index0, int index1) {
                this.setSelectionInterval(index0, index1);
            }

            public void setSelectionInterval(int index, int index1) {
                int index0 = index;
                if (index0 != index1) {
                    index0 = index1;
                }
                if (JaxoLookAndFeelPanel.this.lookAndFeels.isSupported(index0)) {
                    super.setSelectionInterval(index0, index1);
                } else {
                    this.setLeadAnchor(index0, index1);
                }
            }

            public void removeSelectionInterval(int index0, int index1) {
            }

            public void clearSelection() {
            }

            private void setLeadAnchor(int anchor, int lead) {
                if (this.isSelectedIndex(lead)) {
                    super.addSelectionInterval(lead, lead);
                } else {
                    super.removeSelectionInterval(lead, lead);
                }
                this.setAnchorSelectionIndex(anchor);
            }
        });
        this.list.setCellRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 7526471155622777L;
            {
                JaxoLooknFeel.registerComponent(this);
            }

            public Component getListCellRendererComponent(JList jlist, Object value, int index, boolean selected, boolean focused) {
                UIManager.LookAndFeelInfo l = (UIManager.LookAndFeelInfo)value;
                super.getListCellRendererComponent((JList<?>)jlist, l.getName(), index, selected, focused);
                this.setEnabled(jlist.isEnabled() && index != -1 && ((LookAndFeelListModel)jlist.getModel()).isSupported(index));
                return this;
            }
        });
        this.setUpUIManagerValue();
    }

    public final JComponent getRoot() {
        return this.root;
    }

    public String getValue() {
        if (this.list.getSelectedIndex() == -1) {
            return UIManager.getLookAndFeel().getClass().getName();
        }
        return ((UIManager.LookAndFeelInfo)this.list.getSelectedValue()).getClassName();
    }

    public void setValue(String value) {
        int selectedIndex = -1;
        for (int i = 0; i < this.lookAndFeels.getSize(); ++i) {
            if (!value.equals(this.lookAndFeels.getInfoAt(i).getClassName())) continue;
            selectedIndex = i;
            break;
        }
        if (selectedIndex == -1) {
            this.setToUIManagerValue();
        } else {
            this.list.setSelectedIndex(selectedIndex);
        }
    }

    public String getUIManagerValue() {
        return UIManager.getLookAndFeel().getClass().getName();
    }

    public void setToUIManagerValue() {
        this.setUpUIManagerValue();
    }

    private void setUpUIManagerValue() {
        String currentClassName = UIManager.getLookAndFeel().getClass().getName();
        int selectedIndex = -1;
        for (int i = 0; i < this.lookAndFeels.getSize(); ++i) {
            UIManager.LookAndFeelInfo l = this.lookAndFeels.getInfoAt(i);
            if (!currentClassName.equals(l.getClassName())) continue;
            selectedIndex = i;
            break;
        }
        if (selectedIndex == -1) {
            selectedIndex = this.lookAndFeels.getSize();
            this.lookAndFeels.add(new UIManager.LookAndFeelInfo(UIManager.getLookAndFeel().getName(), currentClassName), true);
        }
        this.list.setSelectedIndex(selectedIndex);
    }

    private static class LookAndFeelListModel
    extends AbstractListModel {
        private static final long serialVersionUID = 7526471155622776147L;
        private final List<Object> data = new ArrayList<Object>(16);

        LookAndFeelListModel() {
        }

        public int getSize() {
            return this.data.size() / 2;
        }

        public Object getElementAt(int index) {
            return this.data.get(index * 2);
        }

        public UIManager.LookAndFeelInfo getInfoAt(int index) {
            return (UIManager.LookAndFeelInfo)this.getElementAt(index);
        }

        public boolean isSupported(int index) {
            return this.data.get(index * 2 + 1).equals(Boolean.TRUE);
        }

        public void add(UIManager.LookAndFeelInfo l, boolean supported) {
            int index = this.getSize();
            this.data.add(l);
            this.data.add(supported);
            this.fireIntervalAdded(this, index, index);
        }
    }
}

