/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.gui.panel;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jaxodraw.gui.JaxoDialogs;
import net.sf.jaxodraw.gui.JaxoDrawingArea;
import net.sf.jaxodraw.util.JaxoDictionary;

public class JaxoMoveGraph {
    private final JaxoDictionary language = new JaxoDictionary(JaxoMoveGraph.class);
    private final JSpinner spinnerX = new JSpinner(new SpinnerNumberModel());
    private final JSpinner spinnerY = new JSpinner(new SpinnerNumberModel());
    private final JDialog dialog;
    private boolean hasChanged;
    private int lastX;
    private int lastY;
    private boolean adjusting;

    public JaxoMoveGraph(Component parent, final JaxoDrawingArea c) {
        final ChangeListener l = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (JaxoMoveGraph.this.adjusting) {
                    return;
                }
                int dx = ((Number)JaxoMoveGraph.this.spinnerX.getValue()).intValue();
                int dy = ((Number)JaxoMoveGraph.this.spinnerY.getValue()).intValue();
                JaxoMoveGraph.this.lastX += (dx -= JaxoMoveGraph.this.lastX);
                JaxoMoveGraph.this.lastY += (dy -= JaxoMoveGraph.this.lastY);
                c.moveGraph(dx, dy);
            }
        };
        this.spinnerX.addChangeListener(l);
        this.spinnerY.addChangeListener(l);
        JButton ok = new JButton(this.language.value("/OK"));
        JButton cancel = new JButton(this.language.value("/Cancel"));
        this.dialog = JaxoDialogs.newDialog(parent, JaxoDialogs.translatedWindowTitle(this.language.value("title")), true);
        this.dialog.setResizable(false);
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                l.stateChanged(null);
                JaxoMoveGraph.this.hasChanged = true;
                JaxoMoveGraph.this.dialog.setVisible(false);
            }
        });
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int dx = ((Number)JaxoMoveGraph.this.spinnerX.getValue()).intValue();
                int dy = ((Number)JaxoMoveGraph.this.spinnerY.getValue()).intValue();
                JaxoMoveGraph.this.hasChanged = false;
                c.moveGraph(-dx, -dy);
                JaxoMoveGraph.this.dialog.setVisible(false);
            }
        });
        JPanel p = new JPanel(new GridLayout(0, 2), false);
        p.add(new JLabel(this.language.label("dx"), 11));
        p.add(this.spinnerX);
        p.add(new JLabel(this.language.label("dy"), 11));
        p.add(this.spinnerY);
        this.dialog.getContentPane().add(p);
        JPanel buttons = new JPanel(false);
        buttons.add(ok);
        buttons.add(cancel);
        this.dialog.getContentPane().add((Component)buttons, "South");
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(parent);
    }

    public void show() {
        this.hasChanged = false;
        this.adjusting = true;
        this.lastX = 0;
        this.lastY = 0;
        this.spinnerX.setValue(0);
        this.spinnerY.setValue(0);
        this.adjusting = false;
        this.dialog.setVisible(true);
    }

    public final boolean hasChanged() {
        return this.hasChanged;
    }
}

