/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.gui.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jaxodraw.gui.JaxoDialogs;
import net.sf.jaxodraw.gui.panel.JaxoColorChooser;
import net.sf.jaxodraw.gui.panel.JaxoGridBar;
import net.sf.jaxodraw.gui.panel.JaxoLookAndFeelPanel;
import net.sf.jaxodraw.gui.panel.button.JaxoColorButton;
import net.sf.jaxodraw.gui.panel.edit.JaxoOptionsPanel;
import net.sf.jaxodraw.gui.swing.JaxoFontStyleRenderer;
import net.sf.jaxodraw.gui.swing.JaxoTitledBorder;
import net.sf.jaxodraw.gui.swing.spinner.JaxoFixedJSpinner;
import net.sf.jaxodraw.gui.swing.spinner.JaxoSpinnerComboBox;
import net.sf.jaxodraw.gui.swing.spinner.JaxoSpinnerIntModel;
import net.sf.jaxodraw.gui.swing.spinner.JaxoSpinnerRotationModel;
import net.sf.jaxodraw.object.text.JaxoPSText;
import net.sf.jaxodraw.util.JaxoColor;
import net.sf.jaxodraw.util.JaxoConstants;
import net.sf.jaxodraw.util.JaxoInfo;
import net.sf.jaxodraw.util.JaxoLanguage;
import net.sf.jaxodraw.util.JaxoPrefs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JaxoPrefsPanel
extends JDialog
implements ItemListener {
    private static final long serialVersionUID = 7526471155622776147L;
    private static final List<String> SYSTEM_FONTS = Collections.unmodifiableList(Arrays.asList(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()));
    private List<String> knownLanguages;
    private String[] gridTypes;
    private final Dimension screenSize = JaxoInfo.SCREEN_SIZE;
    private JTextField htmlTextField;
    private JTextField editorTextField;
    private JTextField psTextField;
    private JTextField latexPathTextField;
    private JTextField dvipsPathTextField;
    private JaxoLookAndFeelPanel lookAndFeelPanel;
    private JComboBox chooseLanguage;
    private SpinnerNumberModel modelXin;
    private SpinnerNumberModel modelYin;
    private JCheckBox splashCheckBox;
    private JCheckBox toolBarCheckBox;
    private JCheckBox gridBarCheckBox;
    private JCheckBox statusBarCheckBox;
    private JCheckBox antialiasCheckBox;
    private JCheckBox gridCheckBox;
    private JCheckBox snapCheckBox;
    private JComboBox chooseGridType;
    private JComboBox chooseGridStyle;
    private JaxoColorButton gridColorButton;
    private JaxoColorButton canvasBackgroundButton;
    private JaxoSpinnerIntModel modelgrid;
    private JaxoColorButton colorButton;
    private SpinnerNumberModel modelwidth;
    private JCheckBox arrowCheckBox;
    private SpinnerNumberModel modelsep;
    private SpinnerNumberModel modelvert;
    private SpinnerNumberModel modelamp;
    private JSpinner arsppos;
    private JSpinner arsplength;
    private JSpinner arspwidth;
    private JSpinner arspinset;
    private JCheckBox arlockcb;
    private SpinnerNumberModel modelArPosition;
    private SpinnerNumberModel modelArLength;
    private SpinnerNumberModel modelArWidth;
    private SpinnerNumberModel modelArInset;
    private float arlwRatio;
    private boolean aradjusting;
    private JaxoColorButton textColorButton;
    private JComboBox chooseTextFamily;
    private JSpinner chooseTextSize;
    private JComboBox chooseTextStyle;
    private JaxoSpinnerRotationModel modelTextRotation;
    private JaxoSpinnerRotationModel modelTeXRotation;
    private JComboBox chooseTeXAlignment;
    private JComboBox chooseTeXSize;
    private JComboBox chooseDefaultMode;
    private SpinnerNumberModel modelundo;
    private JComboBox chooseCSpaceType;
    private final JaxoColorChooser colorChooser;

    public JaxoPrefsPanel(Frame owner) {
        super(owner, true);
        this.setDefaultCloseOperation(1);
        this.setKnownLanguages();
        this.setGridTypes();
        this.colorChooser = new JaxoColorChooser(this);
        this.colorChooser.setPermanent(true);
        JPanel fPreview = this.getFPreviewPanel();
        JPanel fAppearance = this.getFAppearancePanel();
        JTabbedPane fBehaviorPanel = new JTabbedPane();
        fBehaviorPanel.setTabPlacement(fBehaviorPanel.getComponentOrientation().isLeftToRight() ? 2 : 4);
        fBehaviorPanel.add(JaxoLanguage.translate("JaxoPrefsPanel.gridTab"), this.getBGridCont());
        fBehaviorPanel.add(JaxoLanguage.translate("JaxoPrefsPanel.objectTab"), this.getBObjectCont());
        fBehaviorPanel.add(JaxoLanguage.translate("JaxoPrefsPanel.textTab"), this.getBTextCont());
        fBehaviorPanel.add(JaxoLanguage.translate("JaxoPrefsPanel.miscTab"), this.getBMiscCont());
        JTabbedPane jtb = new JTabbedPane();
        jtb.add(JaxoLanguage.translate("JaxoPrefsPanel.generalTab"), fPreview);
        jtb.add(JaxoLanguage.translate("JaxoPrefsPanel.appearanceTab"), fAppearance);
        jtb.add(JaxoLanguage.translate("JaxoPrefsPanel.behaviorTab"), fBehaviorPanel);
        this.setTitle(JaxoDialogs.windowTitle("JaxoPrefsPanel.title"));
        this.getContentPane().add((Component)jtb, "Center");
        this.getContentPane().add((Component)this.createOptionContainer(), "Last");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    public static List<String> getSystemFonts() {
        return SYSTEM_FONTS;
    }

    public void setFromPrefs() {
        this.psTextField.setText(JaxoPrefs.getStringPref("prefPSVIEWER"));
        this.htmlTextField.setText(JaxoPrefs.getStringPref("prefBROWSER"));
        this.editorTextField.setText(JaxoPrefs.getStringPref("prefEDITOR"));
        this.latexPathTextField.setText(JaxoPrefs.getStringPref("prefLATEXPATH"));
        this.dvipsPathTextField.setText(JaxoPrefs.getStringPref("prefDVIPSPATH"));
        this.lookAndFeelPanel.setValue(JaxoPrefs.getStringPref("prefLOOKNFEEL"));
        int selected = 0;
        for (int i = 0; i < this.knownLanguages.size(); ++i) {
            if (!this.knownLanguages.get(i).equals(JaxoPrefs.getStringPref("prefLANGUAGE"))) continue;
            selected = i;
        }
        this.chooseLanguage.setSelectedIndex(selected);
        int selectedg = 0;
        for (int i = 0; i < this.gridTypes.length; ++i) {
            if (!this.gridTypes[i].equals(JaxoPrefs.getStringPref("prefGRIDTYPE"))) continue;
            selectedg = i;
        }
        this.chooseCSpaceType.setSelectedIndex(JaxoPrefs.getIntPref("prefCOLORSPACE") - 1);
        this.splashCheckBox.setSelected(JaxoPrefs.getBooleanPref("prefSHOWSPLASHWINDOW"));
        this.gridCheckBox.setSelected(JaxoPrefs.getBooleanPref("prefGRIDONOFF"));
        this.snapCheckBox.setSelected(JaxoPrefs.getBooleanPref("prefSNAPONOFF"));
        this.chooseGridType.setSelectedIndex(selectedg);
        this.chooseGridStyle.setSelectedIndex(JaxoPrefs.getIntPref("prefGRIDSTYLE"));
        this.colorButton.setColor(JaxoColor.getColor(JaxoPrefs.getStringPref("prefCOLOR"), JaxoPrefs.getIntPref("prefCOLORSPACE")));
        this.textColorButton.setColor(JaxoColor.getColor(JaxoPrefs.getStringPref("prefTEXTCOLOR"), JaxoPrefs.getIntPref("prefCOLORSPACE")));
        this.gridColorButton.setColor(JaxoColor.getColor(JaxoPrefs.getStringPref("prefGRIDCOLOR"), 2));
        this.canvasBackgroundButton.setColor(JaxoColor.getColor(JaxoPrefs.getStringPref("prefCANVASBACKGROUND"), 2));
        int fontIndex = SYSTEM_FONTS.indexOf(JaxoPrefs.getStringPref("prefPSFAMILY"));
        this.chooseTextFamily.setSelectedIndex(fontIndex == -1 ? 0 : fontIndex);
        this.chooseTextStyle.setSelectedItem(JaxoPrefs.getIntPref("prefPSSTYLE"));
        this.chooseTextSize.setValue(JaxoPrefs.getIntPref("prefPSSIZE"));
        this.chooseTeXAlignment.setSelectedIndex(JaxoPrefs.getIntPref("prefTEXALIGN"));
        this.chooseTeXSize.setSelectedIndex(JaxoPrefs.getIntPref("prefTEXSIZE"));
        this.modelTextRotation.setRotationValue(-JaxoPrefs.getIntPref("prefPSROTANGLE"));
        this.modelTeXRotation.setRotationValue(-JaxoPrefs.getIntPref("prefTEXROTANGLE"));
        this.setDefIndex(JaxoPrefs.getIntPref("prefDEFAULTACTION"));
        float prefLINEWIDTH = JaxoPrefs.getFloatPref("prefLINEWIDTH");
        int prefAMPLITUDE = JaxoPrefs.getIntPref("prefAMPLITUDE");
        float prefDLSEP = JaxoPrefs.getFloatPref("prefDLSEP");
        int prefVERTEXSIZE = JaxoPrefs.getIntPref("prefVERTEXSIZE");
        boolean prefSHOWTOOL = JaxoPrefs.getBooleanPref("prefSHOWTOOL");
        boolean prefSHOWSTATUS = JaxoPrefs.getBooleanPref("prefSHOWSTATUS");
        boolean prefSHOWGRIDBAR = JaxoPrefs.getBooleanPref("prefSHOWGRIDBAR");
        boolean prefANTIALIASON = JaxoPrefs.getBooleanPref("prefANTIALIAS");
        boolean prefARROW = JaxoPrefs.getBooleanPref("prefARROW");
        this.modelgrid.setIntValue(JaxoPrefs.getIntPref("prefGRIDSIZE"));
        this.modelwidth.setValue(prefLINEWIDTH);
        this.modelamp.setValue(prefAMPLITUDE);
        this.modelXin.setValue(JaxoPrefs.getIntPref("prefSCREENSIZEX"));
        this.modelYin.setValue(JaxoPrefs.getIntPref("prefSCREENSIZEY"));
        this.modelsep.setValue(prefDLSEP);
        this.modelvert.setValue(prefVERTEXSIZE);
        this.modelundo.setValue(JaxoPrefs.getIntPref("prefUNDODEPTH"));
        this.toolBarCheckBox.setSelected(prefSHOWTOOL);
        this.statusBarCheckBox.setSelected(prefSHOWSTATUS);
        this.gridBarCheckBox.setSelected(prefSHOWGRIDBAR);
        this.antialiasCheckBox.setSelected(prefANTIALIASON);
        this.arrowCheckBox.setSelected(prefARROW);
        this.arsppos.setValue(Float.valueOf(JaxoPrefs.getFloatPref("prefARROWPOSITION")));
        this.arsplength.setValue(Float.valueOf(JaxoPrefs.getFloatPref("prefARROWLENGTH")));
        this.arspwidth.setValue(Float.valueOf(JaxoPrefs.getFloatPref("prefARROWWIDTH")));
        this.arspinset.setValue(Float.valueOf(JaxoPrefs.getFloatPref("prefARROWINSET")));
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() != 1) {
            return;
        }
        Object source = e.getSource();
        if (source.equals(this.chooseCSpaceType)) {
            this.colorButton.setChooserMode(this.chooseCSpaceType.getSelectedIndex() + 1);
            this.textColorButton.setChooserMode(this.chooseCSpaceType.getSelectedIndex() + 1);
        } else if (source.equals(this.chooseGridType)) {
            if (this.chooseGridType.getSelectedItem().equals(JaxoLanguage.translate("Rectangular"))) {
                if (this.chooseGridStyle.getItemCount() == 4) {
                    this.chooseGridStyle.removeItemAt(3);
                }
                this.modelgrid.setIntStepSize(1);
            } else {
                if (this.chooseGridStyle.getItemCount() < 4) {
                    this.chooseGridStyle.insertItemAt(JaxoLanguage.translate("Honeycomb"), 3);
                }
                this.modelgrid.setIntStepSize(2);
            }
        }
    }

    private void clearButtonClicked() {
        this.psTextField.setText("");
        this.htmlTextField.setText("");
        this.editorTextField.setText("");
        this.latexPathTextField.setText("");
        this.dvipsPathTextField.setText("");
    }

    private void saveButtonClicked() {
        Map<String, Object> state = JaxoPrefs.getState();
        this.pushPrefs();
        JaxoPrefs.savePrefs();
        JaxoPrefs.setState(state);
    }

    private void okButtonClicked() {
        this.pushPrefs();
        this.setVisible(false);
    }

    private void cancelButtonClicked() {
        this.setVisible(false);
    }

    private void resetButtonClicked() {
        this.setFromPrefs();
    }

    private void setDefIndex(int defaultMode) {
        int i = 0;
        if (JaxoConstants.isDefaultMode(defaultMode)) {
            i = this.getDefIndex(defaultMode);
        }
        this.chooseDefaultMode.setSelectedIndex(i);
    }

    private int getDefIndex(int value) {
        int nofDefaults = JaxoConstants.defaultModes().length;
        int j = nofDefaults + 1;
        for (int jj = 0; jj < nofDefaults; ++jj) {
            if (value != JaxoConstants.defaultModes()[jj]) continue;
            j = jj;
            break;
        }
        return j;
    }

    private void pushPrefs() {
        int screenSizeX = this.modelXin.getNumber().intValue();
        int screenSizeY = this.modelYin.getNumber().intValue();
        float lineWidth = this.modelwidth.getNumber().floatValue();
        float dlSep = this.modelsep.getNumber().floatValue();
        float arrowPosition = this.modelArPosition.getNumber().floatValue();
        float arrowLength = this.modelArLength.getNumber().floatValue();
        float arrowWidth = this.modelArWidth.getNumber().floatValue();
        float arrowInset = this.modelArInset.getNumber().floatValue();
        int vertexSize = this.modelvert.getNumber().intValue();
        int amp = this.modelamp.getNumber().intValue();
        String lang = this.knownLanguages.get(this.chooseLanguage.getSelectedIndex());
        String gridType = this.gridTypes[this.chooseGridType.getSelectedIndex()];
        String col = JaxoColor.getColorName(this.colorButton.getColor(), this.chooseCSpaceType.getSelectedIndex() + 1);
        String colT = JaxoColor.getColorName(this.textColorButton.getColor(), this.chooseCSpaceType.getSelectedIndex() + 1);
        String colG = JaxoColor.getColorName(this.gridColorButton.getColor(), 2);
        JaxoPrefs.setStringPref("prefBROWSER", this.htmlTextField.getText());
        JaxoPrefs.setStringPref("prefEDITOR", this.editorTextField.getText());
        JaxoPrefs.setStringPref("prefPSVIEWER", this.psTextField.getText());
        JaxoPrefs.setStringPref("prefLOOKNFEEL", this.lookAndFeelPanel.getValue());
        JaxoPrefs.setStringPref("prefCANVASBACKGROUND", JaxoColor.getColorName(this.canvasBackgroundButton.getColor(), 2));
        JaxoPrefs.setStringPref("prefGRIDTYPE", gridType);
        JaxoPrefs.setIntPref("prefCOLORSPACE", this.chooseCSpaceType.getSelectedIndex() + 1);
        JaxoPrefs.setStringPref("prefCOLOR", col);
        JaxoPrefs.setStringPref("prefPSFAMILY", (String)this.chooseTextFamily.getSelectedItem());
        JaxoPrefs.setStringPref("prefTEXTCOLOR", colT);
        JaxoPrefs.setStringPref("prefLATEXPATH", this.latexPathTextField.getText());
        JaxoPrefs.setStringPref("prefDVIPSPATH", this.dvipsPathTextField.getText());
        JaxoPrefs.setStringPref("prefGRIDCOLOR", colG);
        JaxoPrefs.setIntPref("prefSCREENSIZEX", screenSizeX);
        JaxoPrefs.setIntPref("prefSCREENSIZEY", screenSizeY);
        JaxoPrefs.setIntPref("prefGRIDSIZE", this.modelgrid.getIntValue());
        JaxoPrefs.setIntPref("prefGRIDSTYLE", this.chooseGridStyle.getSelectedIndex());
        JaxoPrefs.setIntPref("prefAMPLITUDE", amp);
        JaxoPrefs.setIntPref("prefPSSTYLE", (Integer)this.chooseTextStyle.getSelectedItem());
        JaxoPrefs.setIntPref("prefPSSIZE", (Integer)this.chooseTextSize.getValue());
        JaxoPrefs.setIntPref("prefTEXSIZE", this.chooseTeXSize.getSelectedIndex());
        JaxoPrefs.setIntPref("prefTEXALIGN", this.chooseTeXAlignment.getSelectedIndex());
        JaxoPrefs.setFloatPref("prefLINEWIDTH", lineWidth);
        JaxoPrefs.setFloatPref("prefDLSEP", dlSep);
        JaxoPrefs.setFloatPref("prefARROWPOSITION", arrowPosition);
        JaxoPrefs.setFloatPref("prefARROWLENGTH", arrowLength);
        JaxoPrefs.setFloatPref("prefARROWWIDTH", arrowWidth);
        JaxoPrefs.setFloatPref("prefARROWINSET", arrowInset);
        JaxoPrefs.setIntPref("prefVERTEXSIZE", vertexSize);
        JaxoPrefs.setIntPref("prefPSROTANGLE", this.modelTextRotation.getRotationValue());
        JaxoPrefs.setIntPref("prefTEXROTANGLE", this.modelTeXRotation.getRotationValue());
        JaxoPrefs.setIntPref("prefUNDODEPTH", this.modelundo.getNumber().intValue());
        JaxoPrefs.setStringPref("prefLANGUAGE", lang);
        JaxoPrefs.setBooleanPref("prefSHOWTOOL", this.toolBarCheckBox.isSelected());
        JaxoPrefs.setBooleanPref("prefSHOWSTATUS", this.statusBarCheckBox.isSelected());
        JaxoPrefs.setBooleanPref("prefSHOWGRIDBAR", this.gridBarCheckBox.isSelected());
        JaxoPrefs.setBooleanPref("prefANTIALIAS", this.antialiasCheckBox.isSelected());
        JaxoPrefs.setBooleanPref("prefARROW", this.arrowCheckBox.isSelected());
        JaxoPrefs.setBooleanPref("prefGRIDONOFF", this.gridCheckBox.isSelected());
        JaxoPrefs.setBooleanPref("prefSNAPONOFF", this.snapCheckBox.isSelected());
        JaxoPrefs.setBooleanPref("prefSHOWSPLASHWINDOW", this.splashCheckBox.isSelected());
        JaxoPrefs.setIntPref("prefDEFAULTACTION", JaxoConstants.defaultModes()[this.chooseDefaultMode.getSelectedIndex()]);
    }

    private JPanel createOptionContainer() {
        JButton okBt = new JButton(JaxoLanguage.translate("JaxoPrefsPanel.buttons.OK"));
        okBt.setToolTipText(JaxoLanguage.translate("JaxoPrefsPanel.buttons.OK.toolTip"));
        okBt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JaxoPrefsPanel.this.okButtonClicked();
            }
        });
        this.getRootPane().setDefaultButton(okBt);
        JButton saveBt = new JButton(JaxoLanguage.translate("JaxoPrefsPanel.buttons.save"));
        saveBt.setToolTipText(JaxoLanguage.translate("JaxoPrefsPanel.buttons.save.toolTip"));
        saveBt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JaxoPrefsPanel.this.saveButtonClicked();
            }
        });
        JButton resetBt = new JButton(JaxoLanguage.translate("JaxoPrefsPanel.buttons.reset"));
        resetBt.setToolTipText(JaxoLanguage.translate("JaxoPrefsPanel.buttons.reset.toolTip"));
        resetBt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JaxoPrefsPanel.this.resetButtonClicked();
            }
        });
        JButton cancelBt = new JButton(JaxoLanguage.translate("JaxoPrefsPanel.buttons.cancel"));
        cancelBt.setToolTipText(JaxoLanguage.translate("JaxoPrefsPanel.buttons.cancel.toolTip"));
        cancelBt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JaxoPrefsPanel.this.cancelButtonClicked();
            }
        });
        JPanel btPanel = new JPanel(new GridBagLayout(), false);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        c.gridy = 0;
        btPanel.add((Component)saveBt, c);
        c.weightx = 1.0;
        btPanel.add(Box.createHorizontalGlue(), c);
        c.weightx = 0.0;
        btPanel.add((Component)okBt, c);
        btPanel.add((Component)resetBt, c);
        btPanel.add((Component)cancelBt, c);
        return btPanel;
    }

    private JPanel getLanguagePanel() {
        String[] i18nKnownLanguages = new String[]{JaxoLanguage.translate("JaxoLanguage.english"), JaxoLanguage.translate("JaxoLanguage.german"), JaxoLanguage.translate("JaxoLanguage.french"), JaxoLanguage.translate("JaxoLanguage.spanish"), JaxoLanguage.translate("JaxoLanguage.italian")};
        this.chooseLanguage = new JComboBox<String>(i18nKnownLanguages);
        JPanel languagePanel = JaxoDialogs.newTitledFlowLayoutPanel("JaxoPrefsPanel.language.title");
        JLabel languageLabel = new JLabel(JaxoLanguage.label("JaxoPrefsPanel.language"));
        languagePanel.add(languageLabel);
        languagePanel.add(this.chooseLanguage);
        return languagePanel;
    }

    private void setKnownLanguages() {
        this.knownLanguages = new ArrayList<String>(Arrays.asList(JaxoLanguage.knownLanguages()));
    }

    private void setGridTypes() {
        this.gridTypes = new String[2];
        this.gridTypes[0] = "rectangular";
        this.gridTypes[1] = "hexagonal";
    }

    private JPanel getLookNFeelPanel() {
        JPanel lookNFeelPanel = JaxoDialogs.newTitledFlowLayoutPanel("Look_and_Feel");
        this.lookAndFeelPanel = new JaxoLookAndFeelPanel();
        lookNFeelPanel.add(this.lookAndFeelPanel.getRoot());
        return lookNFeelPanel;
    }

    private JPanel getLafPanel() {
        JPanel lafPanel = new JPanel(false);
        lafPanel.add(this.getLookNFeelPanel());
        lafPanel.add(this.getLanguagePanel());
        return lafPanel;
    }

    private JPanel getFAppearancePanel() {
        JPanel fAppearancePanel = JaxoDialogs.newPageBoxLayoutPanel();
        fAppearancePanel.add(this.getLafPanel());
        fAppearancePanel.add(this.getStartUpPanel());
        fAppearancePanel.add(this.getCheckBoxPanel());
        return fAppearancePanel;
    }

    private JPanel getCheckBoxPanel() {
        JPanel checkBoxPanel = JaxoDialogs.newTitledLayoutPanel("Other_options", new GridLayout(2, 2));
        this.toolBarCheckBox = new JCheckBox(JaxoLanguage.translate("Show_toolbar"));
        checkBoxPanel.add(this.toolBarCheckBox);
        this.statusBarCheckBox = new JCheckBox(JaxoLanguage.translate("Show_status_bar"));
        checkBoxPanel.add(this.statusBarCheckBox);
        this.gridBarCheckBox = new JCheckBox(JaxoLanguage.translate("Show_Gridbar"));
        checkBoxPanel.add(this.gridBarCheckBox);
        this.antialiasCheckBox = new JCheckBox(JaxoLanguage.translate("Antialias_on"));
        checkBoxPanel.add(this.antialiasCheckBox);
        return checkBoxPanel;
    }

    private JPanel getStartUpPanel() {
        JPanel gridPanel = new JPanel(false);
        gridPanel.add(this.getSplashWindowPanel());
        gridPanel.add(this.getInitScreenPanel());
        JPanel bGrid = JaxoDialogs.newPageBoxLayoutPanel();
        bGrid.add(gridPanel);
        return bGrid;
    }

    private JPanel getInitScreenPanel() {
        JPanel pxin = new JPanel(false);
        this.modelXin = new SpinnerNumberModel(0, 0, this.screenSize.width, 1);
        JLabel xin = new JLabel(JaxoLanguage.label("JaxoPrefsPanel.canvas.preferredWidth"), 11);
        pxin.add(xin);
        JaxoFixedJSpinner spxin = new JaxoFixedJSpinner(this.modelXin);
        pxin.add(spxin);
        JPanel pyin = new JPanel(false);
        this.modelYin = new SpinnerNumberModel(0, 0, this.screenSize.height, 1);
        JLabel yin = new JLabel(JaxoLanguage.label("JaxoPrefsPanel.canvas.preferredHeight"), 11);
        pyin.add(yin);
        JaxoFixedJSpinner spyin = new JaxoFixedJSpinner(this.modelYin);
        pyin.add(spyin);
        JPanel dimSPanel = new JPanel(new GridBagLayout());
        GridBagConstraints sc = new GridBagConstraints();
        sc.gridx = 0;
        sc.gridy = 0;
        sc.insets = new Insets(0, 0, 5, 0);
        dimSPanel.add((Component)pxin, sc);
        sc.gridx = 1;
        sc.gridy = 0;
        sc.insets = new Insets(0, 0, 5, 5);
        dimSPanel.add((Component)pyin, sc);
        JPanel initScreenPanel = JaxoDialogs.newTitledFlowLayoutPanel("Initial_screen_size");
        initScreenPanel.add(dimSPanel);
        return initScreenPanel;
    }

    private JPanel getPreviewPanel() {
        JPanel previewPanel = JaxoDialogs.newTitledLayoutPanel("Preview_options", new GridBagLayout());
        JLabel htmlLabel = new JLabel(JaxoLanguage.label("JaxoPrefsPanel.path.HTMLViewer"), 11);
        this.htmlTextField = new JTextField("", 25);
        JLabel editorLabel = new JLabel(JaxoLanguage.label("JaxoPrefsPanel.path.textEditor"), 11);
        this.editorTextField = new JTextField("", 25);
        JLabel psLabel = new JLabel(JaxoLanguage.label("JaxoPrefsPanel.path.postScriptViewer"), 11);
        this.psTextField = new JTextField("", 25);
        GridBagConstraints con = new GridBagConstraints();
        con.gridx = 0;
        JaxoDialogs.newTitledFlowLayoutPanel("Look_and_Feel");
        this.lookAndFeelPanel = new JaxoLookAndFeelPanel();
        con.gridy = 0;
        con.fill = 2;
        previewPanel.add((Component)htmlLabel, con);
        con.gridx = 0;
        con.gridy = 1;
        previewPanel.add((Component)editorLabel, con);
        con.gridx = 0;
        con.gridy = 2;
        previewPanel.add((Component)psLabel, con);
        con.gridx = 1;
        con.gridy = 0;
        previewPanel.add((Component)this.htmlTextField, con);
        con.gridx = 1;
        con.gridy = 1;
        previewPanel.add((Component)this.editorTextField, con);
        con.gridx = 1;
        con.gridy = 2;
        previewPanel.add((Component)this.psTextField, con);
        return previewPanel;
    }

    private JPanel getPathPanel() {
        JPanel pathPanel = JaxoDialogs.newTitledLayoutPanel("Paths", new GridBagLayout());
        JLabel latexPathLabel = new JLabel(JaxoLanguage.label("JaxoPrefsPanel.path.LaTeX"), 11);
        this.latexPathTextField = new JTextField("", 25);
        JLabel dvipsPathLabel = new JLabel(JaxoLanguage.label("JaxoPrefsPanel.path.dvips"), 11);
        this.dvipsPathTextField = new JTextField("", 25);
        GridBagConstraints con1 = new GridBagConstraints();
        con1.gridx = 0;
        con1.gridy = 0;
        con1.fill = 2;
        pathPanel.add((Component)latexPathLabel, con1);
        con1.gridx = 0;
        con1.gridy = 1;
        pathPanel.add((Component)dvipsPathLabel, con1);
        con1.gridx = 1;
        con1.gridy = 0;
        pathPanel.add((Component)this.latexPathTextField, con1);
        con1.gridx = 1;
        con1.gridy = 1;
        pathPanel.add((Component)this.dvipsPathTextField, con1);
        return pathPanel;
    }

    private JPanel getFPreviewPanel() {
        JPanel fPreviewPanel = JaxoDialogs.newPageBoxLayoutPanel();
        fPreviewPanel.add(this.getPreviewPanel());
        fPreviewPanel.add(this.getPathPanel());
        JButton clearBt = new JButton(JaxoLanguage.translate("Clear"));
        clearBt.setAlignmentX(0.5f);
        clearBt.setToolTipText(JaxoLanguage.translate("Clear_all_the_text_fields"));
        clearBt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JaxoPrefsPanel.this.clearButtonClicked();
            }
        });
        fPreviewPanel.add(clearBt);
        return fPreviewPanel;
    }

    private JPanel getSplashWindowPanel() {
        JPanel splashCheckBoxPanel = JaxoDialogs.newTitledFlowLayoutPanel("JaxoPrefsPanel.splash_window");
        this.splashCheckBox = new JCheckBox(JaxoLanguage.translate("JaxoPrefsPanel.splash_on"));
        splashCheckBoxPanel.add(this.splashCheckBox);
        return splashCheckBoxPanel;
    }

    private JPanel getGridOnOffPanel() {
        JPanel gridCheckBoxPanel = JaxoDialogs.newTitledFlowLayoutPanel("Grid_on_off");
        this.gridCheckBox = new JCheckBox(JaxoLanguage.translate("Grid_on"));
        gridCheckBoxPanel.add(this.gridCheckBox);
        return gridCheckBoxPanel;
    }

    private JPanel getSnapOnOffPanel() {
        JPanel snapCheckBoxPanel = JaxoDialogs.newTitledFlowLayoutPanel("Snap_on_off");
        this.snapCheckBox = new JCheckBox(JaxoLanguage.translate("Snap_on"));
        snapCheckBoxPanel.add(this.snapCheckBox);
        return snapCheckBoxPanel;
    }

    private JPanel getGridTypePanel() {
        String[] gridCombTypes = new String[]{JaxoLanguage.translate("Rectangular"), JaxoLanguage.translate("Hexagonal")};
        this.chooseGridType = new JComboBox<String>(gridCombTypes);
        this.chooseGridType.setSelectedIndex(1);
        this.chooseGridType.addItemListener(this);
        JPanel gridTypePanel = JaxoDialogs.newTitledFlowLayoutPanel("Grid_type");
        JLabel gridTypeLabel = new JLabel(JaxoLanguage.label("JaxoPrefsPanel.grid.type"));
        gridTypePanel.add(gridTypeLabel);
        gridTypePanel.add(this.chooseGridType);
        return gridTypePanel;
    }

    private JPanel getGridStylePanel() {
        ArrayList<String> gridCombStyles = new ArrayList<String>(4);
        gridCombStyles.add(JaxoLanguage.translate("Dot"));
        gridCombStyles.add(JaxoLanguage.translate("Cross"));
        gridCombStyles.add(JaxoLanguage.translate("Line"));
        gridCombStyles.add(JaxoLanguage.translate("Honeycomb"));
        this.chooseGridStyle = new JComboBox<Object>(gridCombStyles.toArray());
        int width = -1;
        int widestIndex = -1;
        for (int i = 0; i < gridCombStyles.size(); ++i) {
            this.chooseGridStyle.setPrototypeDisplayValue(gridCombStyles.get(i));
            int currentWidth = this.chooseGridStyle.getPreferredSize().width;
            if (currentWidth <= width) continue;
            width = currentWidth;
            widestIndex = i;
        }
        this.chooseGridStyle.setPrototypeDisplayValue(gridCombStyles.get(widestIndex));
        JPanel gridStylePanel = JaxoDialogs.newTitledFlowLayoutPanel("Grid_style");
        JLabel gridStyleLabel = new JLabel(JaxoLanguage.label("JaxoPrefsPanel.grid.style"));
        gridStylePanel.add(gridStyleLabel);
        gridStylePanel.add(this.chooseGridStyle);
        return gridStylePanel;
    }

    private JPanel getGridColorPanel() {
        JPanel gridColorPanel = JaxoDialogs.newTitledFlowLayoutPanel("Grid_color");
        this.gridColorButton = new JaxoColorButton();
        this.gridColorButton.setChooser(this.colorChooser);
        this.gridColorButton.setChooserMode(2);
        JLabel gridColorLabel = new JLabel(JaxoLanguage.label("JaxoPrefsPanel.grid.color"), 11);
        gridColorPanel.add(gridColorLabel);
        gridColorPanel.add(this.gridColorButton);
        return gridColorPanel;
    }

    private JPanel getCanvasBackgroundPanel() {
        JPanel canvasBackgroundPanel = JaxoDialogs.newTitledFlowLayoutPanel("JaxoPrefsPanel.canvas.background.title");
        this.canvasBackgroundButton = new JaxoColorButton();
        this.canvasBackgroundButton.setChooser(this.colorChooser);
        this.canvasBackgroundButton.setChooserMode(2);
        JLabel canvasBackgroundLabel = new JLabel(JaxoLanguage.label("JaxoPrefsPanel.canvas.background.label"), 11);
        canvasBackgroundPanel.add(canvasBackgroundLabel);
        canvasBackgroundPanel.add(this.canvasBackgroundButton);
        return canvasBackgroundPanel;
    }

    private JPanel getColorSpacePanel() {
        String[] cspaceCombTypes = new String[]{JaxoLanguage.translate("JaxoPrefsPanel.colorSpace.type.colordvi"), JaxoLanguage.translate("JaxoPrefsPanel.colorSpace.type.full")};
        this.chooseCSpaceType = new JComboBox<String>(cspaceCombTypes);
        this.chooseCSpaceType.addItemListener(this);
        JPanel cspaceTypePanel = JaxoDialogs.newTitledFlowLayoutPanel("JaxoPrefsPanel.colorSpace.title");
        JLabel cspaceTypeLabel = new JLabel(JaxoLanguage.label("JaxoPrefsPanel.colorSpace.type"));
        cspaceTypePanel.add(cspaceTypeLabel);
        cspaceTypePanel.add(this.chooseCSpaceType);
        return cspaceTypePanel;
    }

    private JPanel getGridSizePanel() {
        JPanel pgrid = new JPanel();
        JLabel lgrid = new JLabel(JaxoLanguage.label("JaxoPrefsPanel.grid.size"), 11);
        pgrid.add(lgrid);
        this.modelgrid = new JaxoSpinnerIntModel(1, 76, 2, 0);
        JaxoFixedJSpinner spgrid = new JaxoFixedJSpinner(this.modelgrid);
        pgrid.add(new JaxoSpinnerComboBox(spgrid, JaxoGridBar.getGridSizeDefaults()));
        JPanel gridSizePanel = JaxoDialogs.newTitledFlowLayoutPanel("Grid_size");
        gridSizePanel.add(pgrid);
        return gridSizePanel;
    }

    private JPanel getColorPanel() {
        this.colorButton = new JaxoColorButton();
        this.colorButton.setChooserMode(1);
        this.colorButton.setChooser(this.colorChooser);
        JPanel colorPanel = JaxoDialogs.newTitledFlowLayoutPanel("JaxoPrefsPanel.line.color.title");
        colorPanel.add(this.colorButton);
        return colorPanel;
    }

    private JPanel getLineWidthPanel() {
        JPanel pwidth = new JPanel(false);
        this.modelwidth = new SpinnerNumberModel(0.2, 0.2, 100.0, 0.1);
        JLabel lwidth = new JLabel(JaxoLanguage.label("JaxoPrefsPanel.line.width"), 11);
        pwidth.add(lwidth);
        JaxoFixedJSpinner spwidth = new JaxoFixedJSpinner(this.modelwidth);
        pwidth.add(spwidth);
        JPanel lineWidthPanel = JaxoDialogs.newTitledFlowLayoutPanel("JaxoPrefsPanel.line.width.title");
        lineWidthPanel.add(pwidth);
        return lineWidthPanel;
    }

    private JPanel getArrowPositionPanel() {
        JPanel arPosPanel = new JPanel();
        GridLayout layout = new GridLayout(0, 2);
        arPosPanel.setLayout(layout);
        JLabel arjpos = new JLabel(JaxoLanguage.label("JaxoArrowPositionEditPanel.position"), 11);
        arPosPanel.add(arjpos);
        this.modelArPosition = new SpinnerNumberModel(Float.valueOf(JaxoPrefs.getFloatPref("prefARROWPOSITION")), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.005f));
        this.arsppos = new JaxoFixedJSpinner(this.modelArPosition);
        this.arsppos.setName("sppos");
        arPosPanel.add(this.arsppos);
        JPanel arrowPositionPanel = JaxoDialogs.newTitledFlowLayoutPanel("JaxoArrowPositionEditPanel.title");
        arrowPositionPanel.add(arPosPanel);
        return arrowPositionPanel;
    }

    private JPanel getArrowOptionsPanel() {
        float length = JaxoPrefs.getFloatPref("prefARROWLENGTH");
        float width = JaxoPrefs.getFloatPref("prefARROWWIDTH");
        this.arlwRatio = length / width;
        this.arrowCheckBox = new JCheckBox(JaxoLanguage.translate("Arrows"));
        JPanel arrowPanel = new JPanel();
        Dimension size = new Dimension(120, 20);
        JPanel arplength = this.getArrowLengthPanel();
        JPanel arpwidth = this.getArrowWidthPanel();
        JPanel arpinset = this.getArrowInsetPanel();
        JPanel arplockar = this.getLockArrowPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints sc = new GridBagConstraints();
        arrowPanel.setLayout(gb);
        sc.gridx = 0;
        sc.gridy = 1;
        arrowPanel.add((Component)this.arrowCheckBox, sc);
        sc.gridx = 1;
        sc.gridy = 0;
        arplength.setPreferredSize(size);
        arrowPanel.add((Component)arplength, sc);
        sc.gridx = 1;
        sc.gridy = 1;
        sc.insets = new Insets(5, 0, 5, 0);
        arpwidth.setPreferredSize(size);
        arrowPanel.add((Component)arpwidth, sc);
        sc.gridx = 1;
        sc.gridy = 3;
        sc.insets = new Insets(0, 0, 5, 0);
        arpinset.setPreferredSize(size);
        arrowPanel.add((Component)arpinset, sc);
        sc.gridx = 2;
        sc.gridy = 0;
        sc.gridheight = 2;
        sc.insets = new Insets(0, 10, 5, 0);
        arrowPanel.add((Component)arplockar, sc);
        JaxoTitledBorder arrowTitle = new JaxoTitledBorder(JaxoLanguage.translate("JaxoArrowOptionsEditPanel.title"));
        arrowPanel.setBorder(arrowTitle);
        return arrowPanel;
    }

    private JPanel getArrowLengthPanel() {
        JPanel arplength = new JPanel();
        GridLayout layout = new GridLayout(0, 2);
        arplength.setLayout(layout);
        JLabel jarlength = new JLabel(JaxoLanguage.label("JaxoArrowOptionsEditPanel.length"), 11);
        arplength.add(jarlength);
        this.modelArLength = new SpinnerNumberModel(Float.valueOf(JaxoPrefs.getFloatPref("prefARROWLENGTH")), Float.valueOf(0.0f), null, Float.valueOf(1.0f));
        this.arsplength = new JaxoFixedJSpinner(this.modelArLength);
        this.arsplength.setName("splen");
        this.arsplength.addChangeListener(new ChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void stateChanged(ChangeEvent e) {
                if (JaxoPrefsPanel.this.aradjusting) {
                    return;
                }
                if (JaxoPrefsPanel.this.arlockcb.isSelected()) {
                    JaxoPrefsPanel.this.aradjusting = true;
                    try {
                        float len = ((Number)JaxoPrefsPanel.this.arsplength.getValue()).floatValue();
                        JaxoPrefsPanel.this.arspwidth.setValue(len / JaxoPrefsPanel.this.arlwRatio);
                    }
                    finally {
                        JaxoPrefsPanel.this.aradjusting = false;
                    }
                }
            }
        });
        arplength.add(this.arsplength);
        return arplength;
    }

    private JPanel getArrowWidthPanel() {
        JPanel arpwidth = new JPanel();
        GridLayout layout = new GridLayout(0, 2);
        arpwidth.setLayout(layout);
        JLabel arjwidth = new JLabel(JaxoLanguage.label("JaxoArrowOptionsEditPanel.width"), 11);
        arpwidth.add(arjwidth);
        this.modelArWidth = new SpinnerNumberModel(Float.valueOf(JaxoPrefs.getFloatPref("prefARROWWIDTH")), Float.valueOf(0.0f), null, Float.valueOf(1.0f));
        this.arspwidth = new JaxoFixedJSpinner(this.modelArWidth);
        this.arspwidth.setName("spwid");
        this.arspwidth.addChangeListener(new ChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void stateChanged(ChangeEvent e) {
                if (JaxoPrefsPanel.this.aradjusting) {
                    return;
                }
                if (JaxoPrefsPanel.this.arlockcb.isSelected()) {
                    JaxoPrefsPanel.this.aradjusting = true;
                    try {
                        float wid = ((Number)JaxoPrefsPanel.this.arspwidth.getValue()).floatValue();
                        float len = JaxoPrefsPanel.this.arlwRatio * wid;
                        JaxoPrefsPanel.this.arsplength.setValue(len);
                    }
                    finally {
                        JaxoPrefsPanel.this.aradjusting = false;
                    }
                }
            }
        });
        arpwidth.add(this.arspwidth);
        return arpwidth;
    }

    private JPanel getArrowInsetPanel() {
        JPanel arpinset = new JPanel();
        GridLayout layout = new GridLayout(0, 2);
        arpinset.setLayout(layout);
        JLabel arjinset = new JLabel(JaxoLanguage.label("JaxoArrowOptionsEditPanel.inset"), 11);
        arpinset.add(arjinset);
        this.modelArInset = new SpinnerNumberModel(Float.valueOf(JaxoPrefs.getFloatPref("prefARROWINSET")), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.05f));
        this.arspinset = new JaxoFixedJSpinner(this.modelArInset);
        this.arspinset.setName("spinset");
        arpinset.add(this.arspinset);
        return arpinset;
    }

    private JPanel getLockArrowPanel() {
        JPanel arplockar = new JPanel();
        GridLayout layout = new GridLayout(0, 2);
        arplockar.setLayout(layout);
        this.arlockcb = new JCheckBox(JaxoLanguage.translate("JaxoArrowOptionsEditPanel.lockar"));
        this.arlockcb.setName("lockar");
        this.arlockcb.setEnabled(true);
        this.arlockcb.setSelected(true);
        this.arlockcb.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (JaxoPrefsPanel.this.arlockcb.isSelected()) {
                    float len = ((Number)JaxoPrefsPanel.this.arsplength.getValue()).floatValue();
                    float wid = ((Number)JaxoPrefsPanel.this.arspwidth.getValue()).floatValue();
                    JaxoPrefsPanel.this.arlwRatio = len / wid;
                }
            }
        });
        arplockar.add(this.arlockcb);
        return arplockar;
    }

    private JPanel getSepPanel() {
        JPanel psep = new JPanel(false);
        this.modelsep = new SpinnerNumberModel(0.2, 0.2, 100.0, 0.5);
        JLabel lsep = new JLabel(JaxoLanguage.label("JaxoPrefsPanel.line.separation"), 11);
        psep.add(lsep);
        JaxoFixedJSpinner spsep = new JaxoFixedJSpinner(this.modelsep);
        psep.add(spsep);
        JPanel sepPanel = JaxoDialogs.newTitledFlowLayoutPanel("JaxoPrefsPanel.line.separation.title");
        sepPanel.add(psep);
        return sepPanel;
    }

    private JPanel getDefVertexPanel() {
        this.modelvert = new SpinnerNumberModel(0, 0, 50, 1);
        JPanel vert = new JPanel(false);
        vert.add(new JLabel(JaxoLanguage.label("JaxoPrefsPanel.vertex.size"), 11));
        vert.add(new JaxoFixedJSpinner(this.modelvert));
        JPanel vertexSizePanel = JaxoDialogs.newTitledFlowLayoutPanel("JaxoPrefsPanel.vertex.size.title");
        vertexSizePanel.add(vert);
        return vertexSizePanel;
    }

    private JPanel getAmpPanel() {
        JPanel pamp = new JPanel(false);
        this.modelamp = new SpinnerNumberModel(0, -500, 500, 1);
        JLabel lamp = new JLabel(JaxoLanguage.label("JaxoPrefsPanel.line.amplitude"), 11);
        pamp.add(lamp);
        JaxoFixedJSpinner spamp = new JaxoFixedJSpinner(this.modelamp);
        pamp.add(spamp);
        JPanel ampPanel = JaxoDialogs.newTitledFlowLayoutPanel("JaxoPrefsPanel.line.amplitude.title");
        ampPanel.add(pamp);
        return ampPanel;
    }

    private JPanel getColorTPanel() {
        this.textColorButton = new JaxoColorButton();
        this.textColorButton.setChooser(this.colorChooser);
        this.textColorButton.setChooserMode(1);
        JPanel colorTPanel = JaxoDialogs.newTitledFlowLayoutPanel("Text_color");
        colorTPanel.add(this.textColorButton);
        return colorTPanel;
    }

    private JPanel getTextFinalFontPanel() {
        JPanel textFamilyPanel = new JPanel(false);
        JLabel textFamilyLabel = new JLabel(JaxoLanguage.label("JaxoPrefsPanel.font.family"), 11);
        this.chooseTextFamily = new JComboBox<Object>(SYSTEM_FONTS.toArray());
        textFamilyPanel.add(textFamilyLabel);
        textFamilyPanel.add(this.chooseTextFamily);
        JPanel textSizePanel = new JPanel(false);
        JLabel textSizeLabel = new JLabel(JaxoLanguage.label("JaxoPrefsPanel.font.size"), 11);
        this.chooseTextSize = new JaxoFixedJSpinner(new SpinnerNumberModel(1, 1, 300, 1));
        textSizePanel.add(textSizeLabel);
        textSizePanel.add(new JaxoSpinnerComboBox(this.chooseTextSize, JaxoPSText.getFontSizeDefaults()));
        JPanel textStylePanel = new JPanel(false);
        JLabel textStyleLabel = new JLabel(JaxoLanguage.label("JaxoPrefsPanel.font.style"), 11);
        this.chooseTextStyle = new JComboBox<Object>(JaxoPSText.getFontStyles().toArray());
        this.chooseTextStyle.setRenderer(new JaxoFontStyleRenderer());
        textStylePanel.add(textStyleLabel);
        textStylePanel.add(this.chooseTextStyle);
        JPanel textFinalFontPanel = JaxoDialogs.newTitledBorderLayoutPanel("JaxoPrefsPanel.font.title");
        textFinalFontPanel.add("Before", textFamilyPanel);
        textFinalFontPanel.add("Center", textSizePanel);
        textFinalFontPanel.add("After", textStylePanel);
        return textFinalFontPanel;
    }

    private JPanel getFinalRotSPanel() {
        JPanel result = JaxoDialogs.newTitledLayoutPanel("Rotation", new GridBagLayout());
        this.modelTextRotation = new JaxoSpinnerRotationModel();
        JLabel psLabel = new JLabel(JaxoLanguage.label("JaxoPrefsPanel.font.postScript.rotationAngle"), 11);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.insets = new Insets(5, 5, 2, 0);
        result.add((Component)psLabel, c);
        c.gridx = 1;
        c.gridy = 0;
        c.insets = new Insets(5, 0, 2, 5);
        result.add((Component)new JaxoSpinnerComboBox(this.modelTextRotation.newSpinner(), JaxoOptionsPanel.getRotationAngleDefaults()), c);
        this.modelTeXRotation = new JaxoSpinnerRotationModel();
        JLabel texLabel = new JLabel(JaxoLanguage.label("JaxoPrefsPanel.font.TeX.rotationAngle"), 11);
        c.gridx = 0;
        c.gridy = 1;
        c.insets = new Insets(2, 5, 5, 0);
        result.add((Component)texLabel, c);
        c.gridx = 1;
        c.gridy = 1;
        c.insets = new Insets(2, 0, 5, 5);
        result.add((Component)new JaxoSpinnerComboBox(this.modelTeXRotation.newSpinner(), JaxoOptionsPanel.getRotationAngleDefaults()), c);
        return result;
    }

    private JPanel getAlignmentPanel() {
        String[] possible = new String[]{JaxoLanguage.translate("Left-Top"), JaxoLanguage.translate("Left-Center"), JaxoLanguage.translate("Left-Bottom"), JaxoLanguage.translate("Center-Top"), JaxoLanguage.translate("Center-Center"), JaxoLanguage.translate("Center-Bottom"), JaxoLanguage.translate("Right-Top"), JaxoLanguage.translate("Right-Center"), JaxoLanguage.translate("Right-Bottom")};
        this.chooseTeXAlignment = new JComboBox<String>(possible);
        JPanel alignmentPanel = JaxoDialogs.newTitledFlowLayoutPanel("TeX_alignment");
        alignmentPanel.add(this.chooseTeXAlignment);
        return alignmentPanel;
    }

    private JPanel getFsPanel() {
        String[] allowed = new String[]{"tiny", "scriptsize", "footnotesize", "small", "normalsize", "large", "Large", "LARGE", "huge", "Huge"};
        this.chooseTeXSize = new JComboBox<String>(allowed);
        JPanel fsPanel = JaxoDialogs.newTitledFlowLayoutPanel("TeX_font_size");
        fsPanel.add(this.chooseTeXSize);
        return fsPanel;
    }

    private JPanel getBGridCont() {
        JPanel gridPanel = new JPanel(false);
        gridPanel.add(this.getGridOnOffPanel());
        gridPanel.add(this.getGridSizePanel());
        gridPanel.add(this.getSnapOnOffPanel());
        JPanel gridPanel1 = new JPanel(false);
        gridPanel1.add(this.getGridTypePanel());
        gridPanel1.add(this.getGridStylePanel());
        gridPanel1.add(this.getGridColorPanel());
        gridPanel1.add(this.getCanvasBackgroundPanel());
        JPanel bGrid = JaxoDialogs.newPageBoxLayoutPanel();
        bGrid.add(gridPanel);
        bGrid.add(gridPanel1);
        return bGrid;
    }

    private JPanel getBObjectCont() {
        JPanel objectPanel = new JPanel(false);
        objectPanel.add(this.getColorPanel());
        objectPanel.add(this.getLineWidthPanel());
        objectPanel.add(this.getSepPanel());
        JPanel objectPanel1 = new JPanel(false);
        objectPanel1.add(this.getArrowPositionPanel());
        objectPanel1.add(this.getArrowOptionsPanel());
        JPanel objectPanel2 = new JPanel(false);
        objectPanel2.add(this.getDefVertexPanel());
        objectPanel2.add(this.getAmpPanel());
        JPanel bObject = JaxoDialogs.newPageBoxLayoutPanel();
        bObject.add(objectPanel);
        bObject.add(objectPanel1);
        bObject.add(objectPanel2);
        return bObject;
    }

    private JPanel getBTextCont() {
        JPanel textPanel = new JPanel(false);
        textPanel.add(this.getColorTPanel());
        textPanel.add(this.getTextFinalFontPanel());
        JPanel textPanel1 = new JPanel();
        textPanel1.add(this.getFinalRotSPanel());
        textPanel1.add(this.getAlignmentPanel());
        textPanel1.add(this.getFsPanel());
        JPanel bText = JaxoDialogs.newPageBoxLayoutPanel();
        bText.add(textPanel);
        bText.add(textPanel1);
        return bText;
    }

    private JPanel getBMiscCont() {
        JPanel miscPanel = new JPanel(true);
        miscPanel.add(this.getDefPanel());
        JPanel miscPanel1 = new JPanel(false);
        miscPanel1.add(this.getDepthPanel());
        JPanel miscPanel2 = new JPanel(false);
        miscPanel2.add(this.getColorSpacePanel());
        JPanel bMisc = JaxoDialogs.newPageBoxLayoutPanel();
        bMisc.add(miscPanel);
        bMisc.add(miscPanel1);
        bMisc.add(miscPanel2);
        return bMisc;
    }

    private JPanel getDefPanel() {
        int nofDefaults = JaxoConstants.defaultModes().length;
        String[] defaults = new String[nofDefaults];
        for (int jj = 0; jj < nofDefaults; ++jj) {
            defaults[jj] = JaxoLanguage.translate(JaxoConstants.defaultActionKeys()[jj]);
        }
        this.chooseDefaultMode = new JComboBox<String>(defaults);
        JPanel defPanel = JaxoDialogs.newTitledFlowLayoutPanel("JaxoPrefsPanel.defaultAction.title");
        defPanel.setPreferredSize(new Dimension(200, 65));
        defPanel.add(this.chooseDefaultMode);
        return defPanel;
    }

    private JPanel getDepthPanel() {
        this.modelundo = new SpinnerNumberModel(2, 2, 10000, 10);
        JLabel undo = new JLabel(JaxoLanguage.label("JaxoPrefsPanel.undoDepth"), 11);
        JaxoFixedJSpinner spundo = new JaxoFixedJSpinner(this.modelundo);
        JPanel depthPanel = JaxoDialogs.newTitledFlowLayoutPanel("JaxoPrefsPanel.undoDepth.title");
        depthPanel.add(undo);
        depthPanel.add(spundo);
        depthPanel.setPreferredSize(new Dimension(300, 65));
        return depthPanel;
    }
}

