/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.gui.panel;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import net.sf.jaxodraw.util.JaxoConstants;
import net.sf.jaxodraw.util.JaxoLanguage;
import net.sf.jaxodraw.util.JaxoLocalized;
import net.sf.jaxodraw.util.JaxoUtils;

public class JaxoToolBar
extends JToolBar
implements PropertyChangeListener,
JaxoLocalized {
    private static final long serialVersionUID = 7526471155622776147L;
    private static final ButtonInfo[] BUTTON_INFOS = new ButtonInfo[]{new ButtonInfo("filenew.png", "filenewro.png", 570, "New", null, KeyStroke.getKeyStroke(78, 128)), new ButtonInfo("folderclose.png", "folderopen.png", 571, "Open", null, KeyStroke.getKeyStroke(79, 128)), new ButtonInfo("closecb.png", "closecbro.png", 578, "Close", null, KeyStroke.getKeyStroke(88, 192)), new ButtonInfo("filesave.png", "filesavero.png", 572, "Save", null, KeyStroke.getKeyStroke(83, 128)), new ButtonInfo("filesaveas.png", "filesaveasro.png", 573, "Save_as", null, KeyStroke.getKeyStroke(83, 192)), new ButtonInfo("fileimport.png", "fileimportro.png", 581, "Import", null, KeyStroke.getKeyStroke(82, 128)), new ButtonInfo("fileexport.png", "fileexportro.png", 575, "Export", null, KeyStroke.getKeyStroke(82, 192)), new ButtonInfo("fileprint.png", "fileprintro.png", 576, "Print", null, KeyStroke.getKeyStroke(80, 128)), new ButtonInfo("texpreview.png", "texpreviewro.png", 1108, "Latex_Preview", null, KeyStroke.getKeyStroke(39, 512)), new ButtonInfo("watchModeOff.png", "watchModeRo.png", 1109, "Watch_file_mode", "watchModeOn.png"), new ButtonInfo("paste.png", "pastero.png", 1105, "Paste", null, KeyStroke.getKeyStroke(86, 128)), new ButtonInfo("prefs.png", "prefsro.png", 5188, "Preferences", null, KeyStroke.getKeyStroke(85, 128)), new ButtonInfo(2), new ButtonInfo("info.png", "inforo.png", 2152, "User_guide", null, KeyStroke.getKeyStroke(71, 64))};
    private static final int WATCH_MODE_INDEX = 9;
    private final AbstractButton[] toolBarButtons;
    private final JToggleButton watchModeButton;

    public JaxoToolBar(ActionListener listener) {
        this.setFloatable(false);
        this.setRollover(true);
        this.setBorder(BorderFactory.createEtchedBorder(0));
        this.toolBarButtons = new AbstractButton[BUTTON_INFOS.length];
        block5: for (int i = 0; i < BUTTON_INFOS.length; ++i) {
            switch (BUTTON_INFOS[i].getType()) {
                case 2: {
                    this.add(Box.createHorizontalGlue());
                    continue block5;
                }
                case 1: {
                    this.addSeparator();
                    continue block5;
                }
                case 0: {
                    this.toolBarButtons[i] = BUTTON_INFOS[i].getSelectedIcon() == null ? new JButton() : new JToggleButton();
                    this.toolBarButtons[i].setIcon(JaxoUtils.newImageIcon(BUTTON_INFOS[i].getIcon()));
                    this.toolBarButtons[i].setRolloverIcon(JaxoUtils.newImageIcon(BUTTON_INFOS[i].getRolloverIcon()));
                    this.toolBarButtons[i].setPressedIcon(this.toolBarButtons[i].getRolloverIcon());
                    if (BUTTON_INFOS[i].getSelectedIcon() != null) {
                        this.toolBarButtons[i].setSelectedIcon(JaxoUtils.newImageIcon(BUTTON_INFOS[i].getSelectedIcon()));
                        this.toolBarButtons[i].setRolloverSelectedIcon(this.toolBarButtons[i].getRolloverIcon());
                    }
                    this.toolBarButtons[i].setActionCommand(JaxoConstants.getModeAsString(BUTTON_INFOS[i].getMode()));
                    if (BUTTON_INFOS[i].getKeyStroke() != null) {
                        InputMap inputMap = this.toolBarButtons[i].getInputMap(2);
                        inputMap.put(BUTTON_INFOS[i].getKeyStroke(), BUTTON_INFOS[i].getToolTipKey());
                        this.toolBarButtons[i].getActionMap().put(BUTTON_INFOS[i].getToolTipKey(), new ClickAction(this.toolBarButtons[i]));
                    }
                    Insets n = this.toolBarButtons[i].getMargin();
                    int l = Math.max(n.top, n.bottom);
                    this.toolBarButtons[i].setMargin(new Insets(n.top, l, n.bottom, l));
                    this.toolBarButtons[i].setBorderPainted(false);
                    this.toolBarButtons[i].setRolloverEnabled(true);
                    this.toolBarButtons[i].setFocusPainted(false);
                    this.toolBarButtons[i].setContentAreaFilled(false);
                    this.add(this.toolBarButtons[i]);
                    continue block5;
                }
            }
        }
        this.watchModeButton = (JToggleButton)this.toolBarButtons[9];
        this.updateLanguage();
        this.setWatchMode(false);
        this.addActionListener(listener);
    }

    public void propertyChange(PropertyChangeEvent e) {
        this.setWatchMode(Boolean.TRUE.equals(e.getNewValue()));
    }

    private void addActionListener(ActionListener l) {
        for (int i = 0; i < BUTTON_INFOS.length; ++i) {
            if (BUTTON_INFOS[i].getType() != 0) continue;
            this.toolBarButtons[i].addActionListener(l);
        }
    }

    private void setWatchMode(boolean value) {
        this.watchModeButton.setSelected(value);
    }

    public final void updateLanguage() {
        for (int i = 0; i < BUTTON_INFOS.length; ++i) {
            if (this.toolBarButtons[i] == null) continue;
            this.toolBarButtons[i].setToolTipText(JaxoLanguage.translate(BUTTON_INFOS[i].getToolTipKey()));
        }
    }

    private static class ButtonInfo {
        public static final int BUTTON = 0;
        public static final int SEPARATOR = 1;
        public static final int GLUE = 2;
        private final int type;
        private final String icon;
        private final String rolloverIcon;
        private final int mode;
        private final String toolTipKey;
        private final String selectedIcon;
        private final KeyStroke keyStroke;

        ButtonInfo(int newType) {
            if (newType != 1 && newType != 2) {
                throw new IllegalArgumentException("Wrong ButtonInfo type!");
            }
            this.type = newType;
            this.icon = null;
            this.rolloverIcon = null;
            this.mode = -1;
            this.toolTipKey = null;
            this.selectedIcon = null;
            this.keyStroke = null;
        }

        ButtonInfo(String newIcon, String newRolloverIcon, int newMode, String newToolTipKey) {
            this(newIcon, newRolloverIcon, newMode, newToolTipKey, null);
        }

        ButtonInfo(String newIcon, String newRolloverIcon, int newMode, String newToolTipKey, String newSelectedIcon) {
            this(newIcon, newRolloverIcon, newMode, newToolTipKey, newSelectedIcon, null);
        }

        ButtonInfo(String newIcon, String newRolloverIcon, int newMode, String newToolTipKey, String newSelectedIcon, KeyStroke newKeyStroke) {
            this.type = 0;
            this.icon = newIcon;
            this.rolloverIcon = newRolloverIcon;
            this.mode = newMode;
            this.toolTipKey = newToolTipKey;
            this.selectedIcon = newSelectedIcon;
            this.keyStroke = newKeyStroke;
        }

        public int getType() {
            return this.type;
        }

        public String getIcon() {
            return this.icon;
        }

        public String getRolloverIcon() {
            return this.rolloverIcon;
        }

        public int getMode() {
            return this.mode;
        }

        public String getToolTipKey() {
            return this.toolTipKey;
        }

        public String getSelectedIcon() {
            return this.selectedIcon;
        }

        public KeyStroke getKeyStroke() {
            return this.keyStroke;
        }
    }

    private static class ClickAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private final AbstractButton button;

        ClickAction(AbstractButton abutton) {
            this.button = abutton;
        }

        public void actionPerformed(ActionEvent e) {
            this.button.doClick();
        }
    }
}

